<?php
/*
	Controller for Office
*/

Class Office extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('cost_center');
		$this->load->model('contractareas');
		$this->load->model('offices');

		$this->load->library('session');
		$this->load->library('pagination');
		if( $this->session->userdata('type') == "" )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('/');
		}

	}

	function htmlAccount()
	{
		$this->session->unset_userdata('login_id');
		$this->session->unset_userdata('office_id');
		$this->session->unset_userdata('contractarea_id');
		$this->session->unset_userdata('type');
		session_destroy();
		$this->deleteDirectory($this->session->userdata('audioPath'));
		$this->load->view('report/suspendAccount');
	}

	function index()
	{

		//debug($_SESSION,1);
			$this->load->model('users');
			$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}

		//$this->load->view('report/suspendAccount');
		if( $this->session->userdata("user_read") != "1" ){
				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i> &nbsp;lwpsupport@orbisprotect.com</span> </div></div></body></html>';
				exit;

		}
		//debug($_SESSION);

		$this->load->view('office/user_list');
	   //}
	}

	function add_user()
	{
		$this->load->model('users');
		//debug( $_SESSION,1 );

		$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}



		//echo '===='.$this->uri->segment('3'); exit;
		if( $this->session->userdata('user_read') == 0 || $this->session->userdata('user_write') == 0 ){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i> &nbsp;lwpsupport@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}

		// config for PDO
    $conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

    // get CostCentre

    $CostCentre = "select linkacc.linkno , linkacc.name from linkacc, webusers where linkacc.parent = 20 and webusers.agctype = 4 and linkacc.linkno = webusers.agcno";
		$CostCentreQuery   = $conexion->prepare($CostCentre);
		$CostCentreQuery->execute();
		$CostCentreResponse = $CostCentreQuery->fetchAll(PDO::FETCH_ASSOC);
    if(!empty($CostCentreResponse)){
      for( $j=0; $j<count($CostCentreResponse); $j++ )
      {
        //$CostCentreResponse[$j]['NAME'] = trim(str_replace('CC', '', $CostCentreResponse[$j]['NAME']));
        $CostCentreResponse[$j]['NAME'] = trim(substr($CostCentreResponse[$j]['NAME'], 3));
      }

      foreach ($CostCentreResponse as $key => $row) {
          // replace 0 with the field's index/key
          $dates[$key]["NAME"]  = $row["NAME"];
          //$dates1[$key]["NAME"]  = $row["NAME"];
      }

       array_multisort($dates, SORT_ASC, $CostCentreResponse);
    }
    else{
      $CostCentreResponse = array();
    }
		$data['CostCentreList'] = $CostCentreResponse;

		if(  $this->uri->segment('3') != '' ){
			if( $_SESSION['user_id'] != $this->uri->segment('3') )
			{
				redirect('/office');
			}
		}
		else {
			$this->load->view('office/office_list',$data);
		}

	}

	function edit_user($id)
	{
		$this->load->model('users');
		if( $this->session->userdata('user_read') == 0 || $this->session->userdata('user_write') == 0){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i> &nbsp;lwpsupport@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}

		if( $id != null )
		{
			$id = base64_decode($id);
			$data['user_data'] = $this->users->get_user_data($id);
			$this->load->view('office/office_list', $data);
		}
	}

	function deleteDirectory($dir) {
	    if (!file_exists($dir)) {
	        return true;
	    }

	    if (!is_dir($dir)) {
	        return unlink($dir);
	    }

	    foreach (scandir($dir) as $item) {
	        if ($item == '.' || $item == '..') {
	            continue;
	        }

	        if (!$this->deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
	            return false;
	        }

	    }

		return rmdir($dir);
	}

	function myaccount($id)
	{

		if( base64_decode($id) != $this->session->userdata('user_id') )
		{
			$redirectTo = base_url().'user/dashboard/'.$this->session->userdata('linkAccountFirstGroupID');
			redirect($redirectTo);
		}

		$this->load->model('users');
		if( $id != null )
		{
			$id = base64_decode($id);
			$data['user_data'] = $this->users->get_user_data($id);
			$this->load->view('office/myaccount', $data);
		}
	}

	function get_office_by_contract($id)
	{
		$this->offices->contractarea_id = $id;
		$filter_office_list = $this->offices->filter_office_list();
		if( !empty($filter_office_list) )
		{
			echo json_encode($filter_office_list);
		}
		else
		{
			$data['LINDEX'] = '0';
			$data['DESCRIPTION'] = ' No row found';
			echo json_encode($data);
		}
	}

	function get_contract_area($costcenterid) {
		$contractarea = $this->offices->contract_area_list($costcenterid);
		if($contractarea){
		        echo json_encode($contractarea);
		}else
		{
			$data['msg'] = 'fail';
			echo json_encode($data);
		}
	}


	function add_Office()
	{
		//debug( $this->input->post() );

		if( !empty(trim($this->input->post('office_id'))) )
		{
			$this->offices->office_id = trim($this->input->post('office_id', true));
			$this->offices->office_name = trim($this->input->post('office_name', true));
			echo $add_offices = $this->offices->office_edit();
		}
		else
		{
			$this->offices->costcenter_id = trim($this->input->post('costcenter', true));
			$this->offices->contractarea_id = trim($this->input->post('contractarea', true));
			$this->offices->office_name = trim($this->input->post('office_name', true));
			echo $add_offices = $this->offices->add_offices();
		}



	}

	function edit_offce()
	{
		$this->offices->office_id = $this->input->post('officeID', true);
		$this->offices->office_name = $this->input->post('office_name', true);
		$this->offices->admin_name = $this->input->post('admin_name', true);
		$this->offices->email_address = $this->input->post('email_address', true);
		$this->offices->contact_number = $this->input->post('contact_number', true);
		$this->offices->password = $this->input->post('password', true);
		$this->offices->password = $this->input->post('cpassword', true);
		$add_offices = $this->offices->office_edit();
		if($add_offices)
		{
			echo 'update';
		}
	}

	function change_status()
	{
		$this->offices->office_id = $this->input->post('id',true);
		$this->offices->status = $this->input->post('status', true);
		echo $office_status = $this->offices->office_status();
	}

	function get_office_edit($id)
	{
		$get_edit_office = $this->offices->get_edit_office($id);
		$get_contract_area_office = $this->offices->get_contract_area_office($get_edit_office['parent']);
		$get_edit_office['contractarea_name'] = $get_contract_area_office['description'] ;

		$get_costcentre_office = $this->offices->get_costcentre_office($get_contract_area_office['parent']);
		$get_edit_office['costcentre_name'] = $get_costcentre_office['description'];
		echo json_encode($get_edit_office);
	}

	// new design

	function get_office_list($officesListId)
	{

		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		$sql = "select linkno , name from linkacc where parent =".$officesListId;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		//debug($resultTotal);
		if( !empty($resultTotal) ){

			$dates = array();
			for( $j=0; $j<count($resultTotal); $j++ )
				{
					//$resultTotal[$j]['NAME'] = trim(str_replace('OF', '', $resultTotal[$j]['NAME']));
					$resultTotal[$j]['NAME'] = trim(substr($resultTotal[$j]['NAME'], 3));
				}

				foreach ($resultTotal as $key => $row) {
				    // replace 0 with the field's index/key
				    $dates[$key]["NAME"]  = $row["NAME"];
				    //$dates1[$key]["NAME"]  = $row["NAME"];
				}

				 array_multisort($dates, SORT_ASC, $resultTotal);

			echo json_encode([ 'error' => 0, 'officesList' => $resultTotal ]);
		}else{
			echo json_encode(['error' => 1, 'message' => 'No result found']);
		}
	}

	function edit_myaccount(){
		$this->load->model('users');

		//check token
		if( !checkToken('myaccountGeneralToken',$this->input->post('myaccountGeneralToken') ) ){
			echo 'fail';
			exit;
		}

			$data['username'] = $this->input->post('username');
			$data['first_name'] = $this->input->post('first_name');
			$data['sur_name'] = $this->input->post('sur_name');
			$data['telephone'] = $this->input->post('telephone');

			$updateMyAccount = $this->users->updateMyAccount($data,$this->input->post('edit_user_id'));

			if($updateMyAccount > 0)
			{

				echo 'done';
			}
			else {
				echo 'fail';
			}

	}


	// Get Office List
  function getOfficeList($id)
  {

			$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

      if( !empty($id) ){
        $OfficeList = "select linkno , name from linkacc where parent =".$id;
        $OfficeListRequest   = $conexion->prepare($OfficeList);
        $OfficeListRequest->execute();
        $OfficeListResponse = $OfficeListRequest->fetchAll(PDO::FETCH_ASSOC);
        if( !empty($OfficeListResponse) ){

    			$dates = array();
    			for( $j=0; $j<count($OfficeListResponse); $j++ )
    				{
    					//$OfficeListResponse[$j]['NAME'] = trim(str_replace('OF', '', $OfficeListResponse[$j]['NAME']));
    					$OfficeListResponse[$j]['NAME'] = trim(substr($OfficeListResponse[$j]['NAME'], 3));
    				}

    				foreach ($OfficeListResponse as $key => $row) {
    				    // replace 0 with the field's index/key
    				    $dates[$key]["NAME"]  = $row["NAME"];
    				    //$dates1[$key]["NAME"]  = $row["NAME"];
    				}

    				 array_multisort($dates, SORT_ASC, $OfficeListResponse);

						  echo json_encode(['status'=>"0",'data'=>$OfficeListResponse,'message'=>'record found']); exit;
    		}
        else{
						echo json_encode(['status'=>'1','data'=>[],'message'=>'no records found']); exit;
        }
      }
      else{
					echo json_encode(['status'=>'1','data'=>[],'message'=>'contract area id is not valid']); exit;
      }
  }

	function getUsersbyID(){
		$this->load->model('users');
		$row = array();
		$data = $this->users->get_system_users_list($this->input->get('id'),$this->input->get('type'),$this->session->userdata('user_id'));
		//debug($data,1);
		if( !empty($data) )
		{
			for( $j=0; $j<count($data); $j++ )
			{
				if( $this->session->userdata('user_write') == 1  )
					{
						//debug($data);
						$data[$j]['permission_write'] = '1';
						$data[$j]['redirect_url'] =  base_url().'office/edit_user/'.base64_encode($data[$j]['user_id']);
					}
					else {
						$data[$j]['permission_write'] = '1';
						$data[$j]['redirect_url'] = '';
					}
			}

			echo json_encode([ 'error' => 0, 'data' => $data]);
		}
		else {
			echo json_encode([ 'error' => 1, 'data' => [], 'msg' => 'no records']);
		}
	}
	function userlocation(){
		$this->load->view('office/userlocation');
	}

}
