<?php
/*--- Model class for Office ---*/

Class Offices extends CI_Model
{
	private $mysql;
	public $contractarea_id;
	public $office_name;
	public $admin_name;
	public $contact_number;
	public $password;
	public $email_address;
	public $office_id;
	public $status;

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
	}


	function get_user_login($email,$password)
	{
		$this->load->helpers('encrypt');
			$this->mysql = $this->load->database('mysql', true);
			$get_user_login = $this->mysql->select('*')->from('user')->where(['username' => $email, 'password' => encrypt_string($password), 'user_status' => '1'])->get()->first_row();
			
			if( !empty($get_user_login->user_id) )
			{
				//write permission
				if( $get_user_login->user_type != 'superadmin' ){
					$path = getcwd().'/assets/'.$get_user_login->first_name;
					mkdir($path);
					chmod($path, 0777);
					if( is_dir($path) )
					{
						$this->session->set_userdata('audioPath',$path);
					}
					$this->session->set_userdata('lone_write', $get_user_login->lone_write);

					$this->session->set_userdata('lone_read', $get_user_login->lone_read);

					$this->session->set_userdata('decommission_write', $get_user_login->decommission_write);
					$this->session->set_userdata('decommission_read', $get_user_login->decommission_read);


					$this->session->set_userdata('user_write', $get_user_login->user_write);
					$this->session->set_userdata('user_read', $get_user_login->user_read);

					$this->session->set_userdata('user_read', $get_user_login->user_read);


					$this->session->set_userdata('manage_lone_read', $get_user_login->manage_lone_read);
					$this->session->set_userdata('manage_lone_write', $get_user_login->manage_lone_write);

					$this->session->set_userdata('user_activity_read', $get_user_login->user_activity_read);
					$this->session->set_userdata('user_activity_write', $get_user_login->user_activity_write);

					$this->session->set_userdata('event_detail_read', $get_user_login->event_detail_read);
					$this->session->set_userdata('event_detail_write', $get_user_login->event_detail_write);

					$this->session->set_userdata('alarm_activation_read', $get_user_login->alarm_activation_read);
					$this->session->set_userdata('alarm_activation_write', $get_user_login->alarm_activation_write);


					$this->session->set_userdata('user_escalation_read', $get_user_login->user_escalation_read);
					$this->session->set_userdata('user_escalation_write', $get_user_login->user_escalation_write);

					$this->session->set_userdata('system_schedule_read', $get_user_login->system_schedule_read	);
					$this->session->set_userdata('system_schedule_write', $get_user_login->system_schedule_write);

					$this->session->set_userdata('login_name', $get_user_login->first_name);
					$this->session->set_userdata('username', $get_user_login->username);

					$this->session->set_userdata('blockStatus', $get_user_login->user_block);

					$this->session->set_userdata('sentinel_username', $get_user_login->sentinel_username);
					$this->session->set_userdata('sentinel_password', $get_user_login->sentinel_password);

					$this->session->set_userdata('costcenterID', $get_user_login->costcenterID);
					$this->session->set_userdata('costcentrename', $get_user_login->costcentrename);

					$this->session->set_userdata('contractareaID', $get_user_login->contractareaID);
					$this->session->set_userdata('contractareaname', $get_user_login->contractareaname);

					$this->session->set_userdata('officeID', $get_user_login->officeID);
					$this->session->set_userdata('officename', $get_user_login->officename);

					$this->session->set_userdata('login_email',$get_user_login->email);

					$this->session->set_userdata('link_account', $get_user_login->agency_name);
					$this->session->set_userdata('login_id', 1);
					$this->session->set_userdata('user_id', $get_user_login->user_id);
					$this->session->set_userdata('type', $get_user_login->user_type);
					
					// OTA & Broadcast message //
					$this->session->set_userdata('ota_read', $get_user_login->ota_read);
					$this->session->set_userdata('ota_write', $get_user_login->ota_write);
					
					$this->session->set_userdata('broadcast_message_read', $get_user_login->broadcast_message_read);
					$this->session->set_userdata('broadcast_message_write', $get_user_login->broadcast_message_write);
					
					// OTA & Broadcast message //

					// Storage Status //
					 $this->session->set_userdata('storage_status', $get_user_login->storage_status);
					// Storage Status // 
					
					
					// LMS Status //
					 $this->session->set_userdata('lms_status', $get_user_login->lms_status);
					// LMS Status // 
					
					$this->session->set_userdata('amber_alert_utilisation_read', $get_user_login->amber_alert_utilisation_read);
					$this->session->set_userdata('auto_reporting_read', $get_user_login->auto_reporting_read);
					
					
					$this->session->set_userdata('global_escalations_read', $get_user_login->global_escalations_read);
					$this->session->set_userdata('global_escalations_write', $get_user_login->global_escalations_write);
					$this->session->set_userdata('elearning_read', $get_user_login->elearning_read);
					$this->session->set_userdata('user_guides_read', $get_user_login->user_guides_read);
					$this->session->set_userdata('user_videos_read', $get_user_login->user_videos_read);
					$this->session->set_userdata('services_statushub_read', $get_user_login->services_statushub_read);
					$this->session->set_userdata('app_users_report', $get_user_login->app_users_report);
					
					
					
					
					$query = $this->mysql->select('*')->from('login_attempt')->where([ 'ip' => $_SERVER['REMOTE_ADDR']  ])->get()->first_row('array');
					if( !empty($query) )
					{
						$data['attempt'] = 0;
						$data['updated_date'] = date( 'Y-m-d H:i:s' );
						$this->session->set_userdata('attempt', 0);
						$this->mysql->where('id',$query['id'])->update('login_attempt',$data);
					}
					return $get_user_login;
				}
				if( $get_user_login->user_type == 'superadmin' )
				{
					$path = getcwd().'/assets/'.$get_user_login->first_name;
					mkdir($path);
					chmod($path, 0777);
					if( is_dir($path) )
					{
						$this->session->set_userdata('audioPath',$path);
					}
					$this->session->set_userdata('type', 'superadmin');
					$this->session->set_userdata('login_id', 1);
					$this->session->set_userdata('user_id', $get_user_login->user_id);
					$this->session->set_userdata('login_name', $get_user_login->first_name);
					$this->session->set_userdata('office_id', '23');
					
					$this->session->set_userdata('sentinel_username', $get_user_login->sentinel_username);
					$this->session->set_userdata('sentinel_password', $get_user_login->sentinel_password);
					$this->session->set_userdata('manage_lone_write', 1); // To remove the check from manage lone workers admin
					$this->session->set_userdata('username', $get_user_login->username);
					
					
					return $get_user_login;

				}
			}
			else {
			
				return false;
			}

	}

	function office_list()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newoffices')->where(['logintype' => 'office'])->get()->result_array();
	}

	function get_all_offices(){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newoffices')->get()->result_array();
	}

	function filter_office_list() {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newoffices')->where(['parent' => $this->contractarea_id])->get()->result_array();
		//return $this->odbc->query("select LINDEX, DESCRIPTION from NEWOFFICES where PARENT = '".$this->contractarea_id."' order by description")->result_array();
	}

	function office_filter_lwd_list($officeid) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newoffices')->where(['parent' => $officeid])->get()->result_array();
		//echo $this->mysql->last_query();
	}

	function contract_area_list($costcenterid)
	{
		//return $this->odbc->query("select LINDEX, DESCRIPTION from NEWCONTRACTAREAS where PARENT = '".$costcenterid."' order by description")->result_array();
		//return $costcenterid;
	}

	function get_contract()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $query = $this->mysql->select('*')->from('newcontractareas')->where([ 'lindex' => $this->contractarea_id ])->get()->result_array();
	}

	function get_costcenter()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newcostcentres')->where([ 'lindex' => $this->costcenterid ])->get()->result_array();
	}

	function contract_costcenter()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newcostcentres')->join('newcontractareas', 'newcontractareas.parent = newcostcentres.lindex')->get()->result_array();
	}

	function add_offices()
	{

		/*$insert_id2 = $this->odbc->query("select * from WEB_ADDNEWOFFICE('".$this->session->userdata('ref_id')."', '".$this->contractarea_id."', '".$this->office_name."')")->result_array();
		if($insert_id2[0]['LINDEX'] > 0 )
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}*/

		echo 'done';

		/*$data2['parent'] = $this->contractarea_id;
		$data2['description'] = ucwords($this->office_name);
		$data2['email'] = $this->email_address;
		$data2['office_name'] = $this->office_name;
		$data2['admin_name'] = $this->admin_name;
		$data2['contact_no'] = $this->contact_number;
		$data2['password'] = $this->password;
		$data2['create_date'] = date('Y-m-d H:i:s');
		$this->mysql->insert('newoffices', $data2);
		$insert_id2 = $this->mysql->insert_id();
		if($insert_id2 > 0 )
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}*/
	}

	function office_edit()
	{
		/*$insert_id2 = $this->odbc->query("select * from WEB_UPDATEOFFICE('".$this->session->userdata('ref_id')."', '".$this->office_id."', '".$this->office_name."')")->result_array();
		if($insert_id2[0]['RES'] == 1 )
		{
			echo 'update';
		}
		else
		{
			return $this->mysql->error();
		}*/
		echo 'update';
	}


	function office_status()
	{
		$this->mysql = $this->load->database('mysql', true);
		$data['status'] = $this->status;
		$query = $this->mysql->where([ 'lindex' => $this->office_id ])->update('newoffices', $data);
		if($query)
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}
	}

	function get_edit_office($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newoffices')->where('lindex', $id)->get()->first_row('array');
	}

	function get_contract_area_office($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newcontractareas')->where('lindex', $id)->get()->first_row('array');
	}

	function get_costcentre_office($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('newcostcentres')->where('lindex', $id)->get()->first_row('array');
	}

	function saveOfficeArea($data)
	{
		//debug($row);
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert('officeArea', $data);
	}


	// event logo
	function event_log()
	{
		$this->mysql = $this->load->database('mysql', true);
		$data['log_name'] = "login";
		$data['user_type'] = "1";
		return $this->mysql->insert('logs',$data);
	}

}
