<?php

Class Report extends CI_Controller
{
	
	public $current_loggedin_user_linkAccountAdentifier ;
	
	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		if( $this->session->userdata('type') == "" )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('user/index');
		}
		
		if(  $this->session->has_userdata('officeID')  && $this->session->userdata('officeID') != 0 ){
			$this->current_loggedin_user_linkAccountAdentifier = $this->session->userdata('officeID')  ;
		} elseif(  $this->session->has_userdata('contractareaID')  && $this->session->userdata('contractareaID') != 0 ) {
			$this->current_loggedin_user_linkAccountAdentifier = $this->session->userdata('contractareaID')  ;
		} else {
			$this->current_loggedin_user_linkAccountAdentifier = $this->session->userdata('costcenterID')  ;
		}
		
	}

	function index()
	{
		$this->load->view('report/reportList');
	}

	function create()
	{
		$this->load->view('report/listreport');

	}
	function schedule()
	{
		$this->load->model('users');
		$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}


		if( $this->session->userdata("system_schedule_read") != "1" ){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i> &nbsp;lwpsupport@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}

		$current_time = date('H:i:s',strtotime('+1hours'));
		$fromDate = date('Y-m-d',strtotime('-5year'));
		$toDate = date('Y-m-d');

		$ListReportSchedulesUrl = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListReportSchedules';
		$ListReportSchedulesXml = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"
                                               xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS"
                                               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
  <soap:Header/>
  <soap:Body>
     <cls:ListReportSchedules>
        <!--Optional:-->
        <cls:listReportSchedulesRequestKey>

           <!--Optional:-->
					 <cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
					 <!--Optional:-->
					 <cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
           <!--Optional:-->
           <cls:AgencyOverride xsi:type="cls:LinkAccountAgencyOverride">
				<cls:LinkAccountIdentifier>'.$this->current_loggedin_user_linkAccountAdentifier.'</cls:LinkAccountIdentifier>
		   </cls:AgencyOverride> 
           <cls:ReportScheduleFilter>
              <!--Optional:-->
              <cls:FilterList>
                 <!--Zero or more repetitions:-->
                 <cls:ReportScheduleFilterListItem>
                    <!--Optional:-->
                    <cls:FilterAttribute xsi:type="cls:CreatedDateRangeReportScheduleFilterAttribute"/>
                    <!--Optional:-->
                    <cls:FilterOperator xsi:type="cls:EqualityReportScheduleFilterOperator"/>
                    <!--Optional:-->
                    <cls:FilterValue xsi:type="cls:ReportScheduleFilterComparisonDateRange">
                             <cls:FromValue>'.$fromDate.'T00:00:00</cls:FromValue>
                             <cls:ToValue>'.$toDate.'T'.$current_time.'</cls:ToValue>
                    </cls:FilterValue>

                 </cls:ReportScheduleFilterListItem>
              </cls:FilterList>

              <cls:MaxRowCount>10</cls:MaxRowCount>
           </cls:ReportScheduleFilter>
        </cls:listReportSchedulesRequestKey>
     </cls:ListReportSchedules>
  </soap:Body>
</soap:Envelope>';
	$request = $this->curl->curl_send($ListReportSchedulesXml, $ListReportSchedulesUrl);
	$data = array();
	$response = $this->curl->xmlParse($request);
	$responseCollection = $response['soap:Body']['ListReportSchedulesResponse']['ListReportSchedulesResult'];
	if( !array_key_exists('Errors',$responseCollection) ){
		if( empty($responseCollection['ReportScheduleList']['ReportScheduleListItem']['Identifier']) )
		{
			$data['scheduleReport'] = $response['soap:Body']['ListReportSchedulesResponse']['ListReportSchedulesResult']['ReportScheduleList']['ReportScheduleListItem'];
		}
		else
		{
			$data['scheduleReport'][] = $response['soap:Body']['ListReportSchedulesResponse']['ListReportSchedulesResult']['ReportScheduleList']['ReportScheduleListItem'];
		}
	}
	else{
			$data['scheduleReport'] = array();
	}


	$this->load->view('report/schedulereport',$data);
	}


	function alarm_activation(){
		//echo 'hi'; exit;
		$this->load->view('report/alarm_activation');
	}

	function getReportOutput($id, $fileName= "filename"){

		/*new code for file name*/
			if($fileName != "filename") {
				$fileName = urldecode($fileName) ;
			}
			$fileName = $fileName.'_'.date('His');
		/*new code for file name*/
		if( empty($id) ){
				echo '<h2>Invalid Request</h2>';
				exit;
		}

		$getReportOutputUrl = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/GetReportOutput';
		$getReportOutputXml = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS"  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

   <soap:Header/>

   <soap:Body>

      <cls:GetReportOutput>

         <!--Optional:-->

         <cls:getReportOutputRequestKey>

            <!--Optional:-->

						<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
            <!--Optional:-->
            <cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>

            <!--Optional:-->
			<cls:AgencyOverride xsi:type="cls:LinkAccountAgencyOverride">
				<cls:LinkAccountIdentifier>'.$this->current_loggedin_user_linkAccountAdentifier.'</cls:LinkAccountIdentifier>
		   </cls:AgencyOverride>
            <cls:ReportOutputIdentifier>'.$id.'</cls:ReportOutputIdentifier>

         </cls:getReportOutputRequestKey>

      </cls:GetReportOutput>

   </soap:Body>

</soap:Envelope>';
	$request = $this->curl->curl_send($getReportOutputXml, $getReportOutputUrl);
	$data = array();
	$response = $this->curl->xmlParse($request);
	//debug($response,1);
	$getFile = $response['soap:Body']['GetReportOutputResponse']['GetReportOutputResult']['ReportOutputInformation']['Data'];
	$extension = $response['soap:Body']['GetReportOutputResponse']['GetReportOutputResult']['ReportOutputInformation']['FileExtension'];
	$fileData=base64_decode($getFile);
	if($extension == "XLSX")
	{
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header("Content-Disposition: attachment;filename=\"$fileName.xlsx\"");
	}
	else if ($extension == "PDF")
	{
		header('Content-type: application/'.$extension);
		//header("Content-Disposition: attachment;filename=\"$fileName.pdf\"");
	}
	echo $fileData;

	}

	function ListReportOutputs(){
		$ListReportOutputsUrl = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListReportOutputs';
		$ListReportOutputsXml = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"

                                                xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS"

                                                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

   <soap:Header/>

   <soap:Body>

      <cls:ListReportOutputs>

         <!--Optional:-->

         <cls:listReportOutputsRequestKey>

             <!--Optional:-->

						 <cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
             <!--Optional:-->
             <cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
            <!--Optional:-->
			<cls:AgencyOverride xsi:type="cls:LinkAccountAgencyOverride">
				<cls:LinkAccountIdentifier>'.$this->current_loggedin_user_linkAccountAdentifier.'</cls:LinkAccountIdentifier>
		   </cls:AgencyOverride>
            <cls:ReportOutputFilter>

               <!--Optional:-->

               <cls:FilterList>

                  <!--Zero or more repetitions:-->

                  <cls:ReportOutputFilterListItem>

                    <cls:FilterAttribute xsi:type="cls:ReportScheduleIdentifierReportOutputFilterAttribute"/>

                        <!--Optional:-->

                        <cls:FilterOperator xsi:type="cls:EqualityReportOutputFilterOperator"/>

                        <!--Optional:-->

                        <cls:FilterValue xsi:type="cls:ReportOutputFilterComparisonInteger">

                            <cls:Value>'.$this->input->post('outputIdentifier').'</cls:Value>

                        </cls:FilterValue>

                  </cls:ReportOutputFilterListItem>

               </cls:FilterList>

               <!--cls:MaxRowCount>10</cls:MaxRowCount-->

            </cls:ReportOutputFilter>

         </cls:listReportOutputsRequestKey>

      </cls:ListReportOutputs>

   </soap:Body>

</soap:Envelope>';
$request = $this->curl->curl_send($ListReportOutputsXml, $ListReportOutputsUrl);
$data = array();
$collectResponse = array();
$response = $this->curl->xmlParse($request);
$data = $response['soap:Body']['ListReportOutputsResponse']['ListReportOutputsResult']['ReportOutputList']['ReportOutputListItem'];
if( !empty($data) ){
	if( empty($data['Identifier'])  )
	{
		$collectResponse = $data;
	}
	else{
		$collectResponse[] = $data;
	}
		for( $i=0; $i<count($collectResponse);$i++ ){
			//Convert the date string into a unix timestamp.
			$unixTimestamp = strtotime($collectResponse[$i]['Created']);

			//Get the day of the week using PHP's date function.
			//$collectResponse[$i]['Created'] =  $dayOfWeek = date("l d M Y H:i:s", $unixTimestamp);
			$collectResponse[$i]['sort'] =  $dayOfWeek = date("y-m-d H:i:s", $unixTimestamp);
			//$collectResponse['Identifier'] = base_url().'report/getReportOutput'
		}

		foreach ($collectResponse as $key => $row)
				{
					$date[$key] = $row['sort'];
				} // Get all column list
				array_multisort($date, $collectResponse);// order by the rows by date array
			//print_r($collectResponse);

			for( $m=0; $m<count($collectResponse);$m++ ){
				//Convert the date string into a unix timestamp.
				$unixTimestamp = strtotime($collectResponse[$m]['Created']);

				//Get the day of the week using PHP's date function.
				$collectResponse[$m]['Created'] =  $dayOfWeek = date("d M Y H:i:s", $unixTimestamp);
				$collectResponse[$m]['sort'] =  $dayOfWeek = date("y-m-d H:i:s", $unixTimestamp);
				//$collectResponse['Identifier'] = base_url().'report/getReportOutput'
			}

			//debug($collectResponse,1);
		echo json_encode(['error' => 0, 'data'=> $collectResponse]);
}else{
	echo json_encode(['error' => 1, 'message'=> 'No data available']);
}

	}

	function test_issue(){
		$conexion = new PDO("informix:host=sentinelrss.orbisportect.com; service=1526;
	   database=ol_omsdb3; server=omsdb3; protocol=onsoctcp;
	   EnableScrollableCursors=1", "ReadOnly", "nowriting");

		 $sql    = "SELECT count(*) FROM   customer";
    $prep   = $conexion->prepatest_issuere($sql);
    $prep->execute();
    $result = $prep->fetchAll(PDO::FETCH_ASSOC);

    var_dump($result);

	}
	function bulkImport(){
		//~ echo encrypt_string($this->session->userdata('sentinel_username'),'d') ;
		//~ echo "<br />" ;
		//~ echo encrypt_string($this->session->userdata('sentinel_password'),'d') ;
		//~ echo "<br />" ;
		//~ echo encrypt_string('demo@orbisprotect.com');
		//~ echo "<br />" ;
		//~ echo encrypt_string('Pass2121!');
		//~ echo "<pre>";
			//~ print_r($_SESSION) ;
		//~ echo "</pre>";
		//~ die;
		$this->load->helper('url');
		if( $this->session->userdata('type') != 'superadmin' )
		{
			 redirect('/', 'refresh');
			 die;
		}
		$this->load->view('report/bulkimport');
	}


	public function appliedSettings()
	{
		if( $this->session->userdata('type') != 'superadmin' )
		{
			 redirect('/', 'refresh');
			 die;
		}
		
		
		
		$this->load->view('report/applysetting');
	}
	
	
	public function getTemplates() {
		$this->load->model('users');
		$getTemplates = $this->users->getTemplates() ;
		
		if ( $getTemplates ) {
		
			for( $i = 0; $i<count($getTemplates); $i++ )
			{
				if(!$getTemplates[$i]['loginname']) {
				
					$getTemplates[$i]['loginname'] = "-";
				}
				
				if(!$getTemplates[$i]['device_settings_name']) {
				
					$getTemplates[$i]['device_settings_name'] = "-";
				}
				
				
				
			}
			
			echo json_encode(['error' => 0, 'message' =>  'have data.', 'data' => $getTemplates]) ;
		
		} else {
			echo json_encode(['error' => 1, 'message' =>  'have no data.', 'data' => $getTemplates]) ;
		}
		

	}
	
	
	
	public function deleteUserSavedTemplates() {
		
		$this->load->model('users');
		
		
		$templateId = $this->input->post('templateId') ;
		
		if ( $templateId ) {
			
			$deleteSingleTemplate = $this->users->deleteSingleUserTemplate($templateId) ;
			
			if ($deleteSingleTemplate) {
				echo json_encode(['error' => 0, 'message' => 'Setting deleted successfully']) ;
			} else {
				echo json_encode(['error' => 1, 'message' => 'Database error']) ;
			}
			
		} else {
			echo json_encode(['error' => 1, 'message' => 'Missing required fields']) ;
		}
	
   }

	function appProfile(){
		$this->load->view('report/appprofile');
	}

	public function uploadBulkImportFile() {
		//$bulkUploadPath = '/var/www/html/orbis_lwp_portal/assets/bulkuploadfile/' ;
		$bulkUploadPath = $this->config->item('directoryPath') . 'bulkuploadfile/' ;
		$uniqueId		= time().'-'.mt_rand();
		if(isset($_FILES["fileUpload"]["name"]))
           {
			    $new_name = $uniqueId.$_FILES["fileUpload"]['name'];
				$config['file_name'] = $new_name;
                $config['upload_path'] = $bulkUploadPath ;
                $config['allowed_types'] = 'xlsx|xls';
                $this->load->library('upload', $config);
                if(!$this->upload->do_upload('fileUpload'))
                {
                     echo json_encode(['error' => 1, 'message' =>  strip_tags($this->upload->display_errors())]) ;
                }
                else
                {
					 $fileNamePath = $bulkUploadPath . $new_name ;
                     $data = $this->upload->data();
                     chmod($fileName,0777); // CHMOD file
                     echo json_encode(['error' => 0, 'message' =>  'File uploaded successfully.', 'fileName' => $data['file_name']]) ;
                }
           }
	}

	public function validateFileDate(){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		//$bulkUploadPath = '/var/www/html/orbis_lwp_portal/assets/bulkuploadfile/' ;
		$bulkUploadPath = $this->config->item('directoryPath') . 'bulkuploadfile/' ;
		$fileName		= $this->input->post('excelFileName') ;
		$file 			= $bulkUploadPath . $fileName;
		if ( !file_exists($file) ){
			echo json_encode(['error' => 1, 'message' => "No such file exists"]);
			die;
		}
		//load the excel library
		$this->load->library('excel');

		//read file from path
		$objPHPExcel = PHPExcel_IOFactory::load($file);
		/* Best Way Starts */
		$worksheet 		= $objPHPExcel->getActiveSheet() ;
		$highestRow 	= $worksheet->getHighestDataRow();
		$highestColumn  = $worksheet->getHighestDataColumn(1);
		$colNumber 		= PHPExcel_Cell::columnIndexFromString($highestColumn); // to get the highest data column as integer value

		// check if the headings are correct upto notes starts

		$rowDataForHeading = $worksheet->rangeToArray('A1:M1',NULL,TRUE,FALSE);

		if ( trim($rowDataForHeading[0][0]) != 'Name' || trim($rowDataForHeading[0][1]) != 'Address Line Number 1' || trim($rowDataForHeading[0][2]) != 'Address Line Number 2' || trim($rowDataForHeading[0][3]) != 'Phone Number' || trim($rowDataForHeading[0][4]) != 'Link Account Name' || trim($rowDataForHeading[0][5]) != 'Link Account Number' || trim($rowDataForHeading[0][6]) != 'Template Serial Number' || trim($rowDataForHeading[0][7]) != 'Password' || trim($rowDataForHeading[0][8]) != 'Duress Code' || trim($rowDataForHeading[0][9]) != 'User Reference' || trim($rowDataForHeading[0][10]) != 'Billing reference' || trim($rowDataForHeading[0][11]) != 'Contract Number' || trim($rowDataForHeading[0][12]) != 'Notes') {

			echo json_encode(['error' => 1, 'message' => "You have uploaded an Invalid file. Please upload again."]);
			die;

		}
		// check if the headings are correct upto notes ends
		//~ echo $highestColumn ;
		//~ echo "<br />" ;
		//~ echo $colNumber ;
		$arr_data 		= [];
		$counter = 0 ;
		for ($row = 1; $row <= $highestRow; $row++){
			$rowData = $worksheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
			if($this->isEmptyRow(reset($rowData))) { continue; } // skip empty row
			if ($row == 1) {
				continue;
			}
			foreach ($rowData as $value){
				$count = count($value) ;
				$escalationDetail 		= array_slice($value, 13, $count) ;
				$escalationDetailChunk 	= array_chunk($escalationDetail, 5) ;
				$arr_data[$counter]['name'] 				= strval($value[0]) ;
				$arr_data[$counter]['addressLine1'] 		= strval($value[1]) ;
				$arr_data[$counter]['addressLine2'] 		= strval($value[2]) ;
				$arr_data[$counter]['phoneNumber'] 			= strval($value[3]) ;
				$arr_data[$counter]['linkAccountName'] 		= strval($value[4]) ;
				$arr_data[$counter]['linkAccountNumber'] 	= strval($value[5]) ;
				$arr_data[$counter]['tempSerialNumber'] 	= strval($value[6]) ;
				$arr_data[$counter]['password'] 			= strval($value[7]) ;
				$arr_data[$counter]['duressCode'] 			= strval($value[8]);
				$arr_data[$counter]['userRef'] 				= strval($value[9]) ;
				$arr_data[$counter]['bilRef'] 				= strval($value[10]) ;
				$arr_data[$counter]['contractNumber'] 		= strval($value[11]) ;
				$arr_data[$counter]['notes'] 				= strval($value[12]);
				$arr_data[$counter]['escalationDetails']    = $escalationDetailChunk ;
				if ( !empty($escalationDetailChunk) ) {
					$newCounterString = 0 ;
					foreach( $escalationDetailChunk as $dataEsc ) {

						$escalationDetailChunkString[$newCounterString]['escName']     = strval($dataEsc[0]);
						$escalationDetailChunkString[$newCounterString]['escEmail']    = strval($dataEsc[1]);
						$escalationDetailChunkString[$newCounterString]['escPhoneNo']  = strval($dataEsc[2]);
						$escalationDetailChunkString[$newCounterString]['escWorkNo']   = strval($dataEsc[3]);
						$escalationDetailChunkString[$newCounterString]['escMobileNo'] = strval($dataEsc[4]);
						$newCounterString++ ;
					}
					$arr_data[$counter]['escalationDetails']    = $escalationDetailChunkString ;
				}
				$counter++ ;

			}
		}
	    /*Best Way ends */
		$data['values'] 	= $arr_data;
		$data['totalCount']	= count($arr_data) ;
		$loopEscalationHeadings = ( $colNumber - 13 ) ;
		if ( $loopEscalationHeadings != 0 ) {
			$loopEscalationHeadings = ( $loopEscalationHeadings / 5 ) ;
		}
		echo json_encode(['error' => 0, 'message' => "File Exist", 'data' => $data, 'loopEscalationHeadings' => $loopEscalationHeadings,'highestRow' =>  $highestRow, 'highestColumn' => $highestColumn]) ;
	}

	public function getFileDataForCreatingSite(){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		$fileName		= $this->input->post('excelFileName') ; // need to make this dynamic
		//$bulkUploadPath = '/var/www/html/orbis_lwp_portal/assets/bulkuploadfile/' ;
		$bulkUploadPath = $this->config->item('directoryPath') . 'bulkuploadfile/' ;
		$file 			= $bulkUploadPath . $fileName;
		if ( !file_exists($file) ){
			echo json_encode(['error' => 1, 'message' => "No such file exists"]);
			die;
		}
		//load the excel library
		$this->load->library('excel');

		//read file from path
		$objPHPExcel = PHPExcel_IOFactory::load($file);
		/* Best Way Starts */
		$worksheet 		= $objPHPExcel->getActiveSheet() ;
		$row			= $this->input->post('currentDataRow') ;
		$highestColumn  = $this->input->post('highestDataColumn') ;
		$rowData		= $worksheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
		$arr_data 		= [];
		$counter = 0 ;
		if($this->isEmptyRow(reset($rowData))) {
			// continue;
		} // skip empty row
		else {
			foreach ($rowData as $value){
				$count = count($value) ;
				$escalationDetail 		= array_slice($value, 13, $count) ;
				$escalationDetailChunk 	= array_chunk($escalationDetail, 5) ;
				$arr_data[$counter]['name'] 				= trim(strval($value[0])) ;
				$arr_data[$counter]['addressLine1'] 		= strval($value[1]) ;
				$arr_data[$counter]['addressLine2'] 		= strval($value[2]) ;
				$arr_data[$counter]['phoneNumber'] 			= strval($value[3]) ;
				$arr_data[$counter]['linkAccountName'] 		= strval($value[4]) ;
				$arr_data[$counter]['linkAccountNumber'] 	= strval($value[5]) ;
				$arr_data[$counter]['tempSerialNumber'] 	= strval($value[6]) ;
				$arr_data[$counter]['password'] 			= strval($value[7]) ;
				$arr_data[$counter]['duressCode'] 			= strval($value[8]);
				$arr_data[$counter]['userRef'] 				= strval($value[9]) ;
				$arr_data[$counter]['bilRef'] 				= strval($value[10]) ;
				$arr_data[$counter]['contractNumber'] 		= strval($value[11]) ;
				$arr_data[$counter]['notes'] 				= strval($value[12]);
				$arr_data[$counter]['escalationDetails']    = $escalationDetailChunk ;
				if ( !empty($escalationDetailChunk) ) {
					$newCounterString 			 = 0 ;
					$escalationDetailChunkString = [] ;
					foreach( $escalationDetailChunk as $dataEsc ) {
						if ( $dataEsc[0] ) {
							$escalationDetailChunkString[$newCounterString]['escName'] 		= trim(strval($dataEsc[0]));
							$escalationDetailChunkString[$newCounterString]['escEmail'] 	= strval($dataEsc[1]);
							$escalationDetailChunkString[$newCounterString]['escPhoneNo'] 	= strval($dataEsc[2]);
							$escalationDetailChunkString[$newCounterString]['escWorkNo'] 	= strval($dataEsc[3]);
							$escalationDetailChunkString[$newCounterString]['escMobileNo']  = strval($dataEsc[4]);
							$newCounterString++ ;
						}
					}
					$arr_data[$counter]['escalationDetails']    = $escalationDetailChunkString ;
				}
				$counter++ ;

			}
		}
	    /*Best Way ends */
		$data['values'] 	= $arr_data;
		echo json_encode(['error' => 0, 'message' => "File Exist", 'data' => $data]) ;
	}





	public function isEmptyRow($row) {
		foreach($row as $cell){
			if (null !== $cell) return false;
		}
		return true;
	}

	function addLoneWorkerData(){
		$mainData = $this->input->post('dataAddLoneWorker')  ;

		$name1 	     		  		= $mainData['name'] ;
		$address1  	  		  		= $mainData['addressLine1'] ;
		$address2             		= $mainData['addressLine2'] ;
		$number1  	  		  		= $mainData['phoneNumber'] ;
		$linkAccountName  	  		= $mainData['linkAccountName'] ;
		$linkAccountNumber    		= $mainData['linkAccountNumber'] ;
		$templateSerialNumber  	  	= $mainData['tempSerialNumber'] ;
		$password1    		  		= $mainData['password'] ;
		$duresscode1  		 		= $mainData['duressCode'] ;
		$userRefrence  		 		= $mainData['userRef'] ;
		$billingRefrence  		 	= $mainData['bilRef'] ;
		$contractNumber  	  		= $mainData['contractNumber'] ;
		$notes1  	 		  		= $mainData['notes'] ;
		$sentinel_username			= 'MzNsd1J1RiswR1RnLzNUMHdsZXlqUT09'; //need to made this dynamic
		//$sentinel_password			=  'a25BczMyWThDeWVkZ2NmTzBsMERiQT09'; //need to made this dynamic
		$sentinel_password			=  'dVdoNXZQQjNibU5RRU9Ec0RXVzVNdz09'; //need to made this dynamic
		$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/CreateSite";
		$xml = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
				<soapenv:Header/>
					<soapenv:Body>
						<CreateSite xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
							<createSiteRequestKey>
								<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
								<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
								<TemplateSerialNumber>' . $templateSerialNumber . '</TemplateSerialNumber>
								<SetSiteDetails>
									<ContractNumber>'.$contractNumber.'</ContractNumber>
									<Name>'.$name1.'</Name>
									<PhoneNumber>'.$number1.'</PhoneNumber>
									<BranchName>Branch 1</BranchName>
									<InstallerName>Orbis Protect (Lone Worker)</InstallerName>
									<LinkAccountNumber>'.$linkAccountNumber.'</LinkAccountNumber>
									<PremiseTypeName>Commercial</PremiseTypeName>
									<Notes>'.$notes1.'</Notes>
									<UserReference>'.$userRefrence.'</UserReference>
									<BillingReference>'.$billingRefrence.'</BillingReference>
									<DuressCode>'.$duresscode1.'</DuressCode>
									<Password>'.$password1.'</Password>
									<SiteAddress>
										<AddressLine1>'.$address1.'</AddressLine1>
										<AddressLine2>'.$address2.'</AddressLine2>
									</SiteAddress>
								</SetSiteDetails>
						</createSiteRequestKey>
					 </CreateSite>
				  </soapenv:Body>
		</soapenv:Envelope>';
		$curl_request = $this->curl->curl_send($xml, $url);
		$curl_request_array = $this->curl->xmlToArray($curl_request);
		$msg = array();
		$response_error = $curl_request_array['CreateSiteResponse']['CreateSiteResult']['Errors'];
		$serialNumber = '' ;
		if( !empty($response_error) )
		{
			if( empty($response_error['Message']['MessageText']) )
			{
				for($err=0; $err<count($response_error['Message']); $err++)
				{
					$error = 1;
					$msg = $response_error['Message'][$err]['MessageText'];
				}
			}
			else
			{
				$error = 1;
				$msg = $response_error['Message']['MessageText'];
			}
		} elseif( isset($curl_request_array['CreateSiteResponse']['CreateSiteResult']['SiteDetails']['SerialNumber']) && !empty($curl_request_array['CreateSiteResponse']['CreateSiteResult']['SiteDetails']['SerialNumber']) ) {
			$error = 0;
			$msg = 'User Created Successfully' ;
			$serialNumber = $curl_request_array['CreateSiteResponse']['CreateSiteResult']['SiteDetails']['SerialNumber'] ;
			$this->commissionSiteApi($serialNumber);
		} else {
			$error = 1;
			$msg = 'No data returned form the API' ;
		}

		echo json_encode([ 'error' => $error, 'html' => $msg, 'serialNumber' => $serialNumber, 'phoneNumber' => $number1  ]) ;
		//debug($curl_request_array,1);
	}

	public function commissionSiteApi($serialNumber){
		$sentinel_username			= 'MzNsd1J1RiswR1RnLzNUMHdsZXlqUT09'; //need to made this dynamic
		//$sentinel_password			=  'a25BczMyWThDeWVkZ2NmTzBsMERiQT09'; //need to made this dynamic
		$sentinel_password			=  'dVdoNXZQQjNibU5RRU9Ec0RXVzVNdz09'; //need to made this dynamic
		$url = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/CommissionSite' ;
		$xml = '<?xml version="1.0" encoding="utf-8"?>
					<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
							xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
						<soapenv:Header/>
							<soapenv:Body>
								<CommissionSite xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
									<commissionSiteRequestKey>
										<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
										<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
										<SerialNumber>' . $serialNumber . '</SerialNumber>
									</commissionSiteRequestKey>
								</CommissionSite>
							</soapenv:Body>
						</soapenv:Envelope>';
		$curl_request = $this->curl->curl_send($xml, $url);
		$curl_request_array = $this->curl->xmlToArray($curl_request);
	}


	public function updateTransmitterApi(){
		$sentinel_username			= 'MzNsd1J1RiswR1RnLzNUMHdsZXlqUT09'; //need to made this dynamic
		//$sentinel_password			=  'a25BczMyWThDeWVkZ2NmTzBsMERiQT09'; //need to made this dynamic
		$sentinel_password			=  'dVdoNXZQQjNibU5RRU9Ec0RXVzVNdz09'; //need to made this dynamic
		$createSiteSerialNumber   = $this->input->post('createSiteSerialNumber') ;
		$createSitePhoneNumber    = $this->input->post('createSitePhoneNumber') ;
		$url = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/UpdateTransmitter' ;
		$xml = '<?xml version="1.0" encoding="utf-8"?>
					<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
							xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
						<soapenv:Header/>
							<soapenv:Body>
								<cls:UpdateTransmitter>
									<cls:updateTransmitterRequestKey>
										<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
										<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
										<cls:SerialNumber>'.$createSiteSerialNumber.'</cls:SerialNumber>
										<cls:TransmitterIdentifier>1</cls:TransmitterIdentifier>
										<cls:TransmitterDetails>
											<cls:NetworkAddress>'.$createSitePhoneNumber.'</cls:NetworkAddress>
											<cls:NetworkAddress2>'.$createSitePhoneNumber.'</cls:NetworkAddress2>
										</cls:TransmitterDetails>
									</cls:updateTransmitterRequestKey>
								</cls:UpdateTransmitter>
							</soapenv:Body>
						</soapenv:Envelope>';
		$curl_request = $this->curl->curl_send($xml, $url);
		$curl_request_array = $this->curl->xmlToArray($curl_request);

		$this->updateTransmitterApi2($createSiteSerialNumber, $createSitePhoneNumber);

		echo json_encode([ 'error' => 0, 'html' => 'Transmitter Updated Successfully.']) ;

	}

	public function updateTransmitterApi2($createSiteSerialNumber, $createSitePhoneNumber){
		$sentinel_username			= 'MzNsd1J1RiswR1RnLzNUMHdsZXlqUT09'; //need to made this dynamic
		//$sentinel_password			=  'a25BczMyWThDeWVkZ2NmTzBsMERiQT09'; //need to made this dynamic
		$sentinel_password			=  'dVdoNXZQQjNibU5RRU9Ec0RXVzVNdz09'; //need to made this dynamic

		$url = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/UpdateTransmitter' ;
		$xml = '<?xml version="1.0" encoding="utf-8"?>
					<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
							xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
						<soapenv:Header/>
							<soapenv:Body>
								<cls:UpdateTransmitter>
									<cls:updateTransmitterRequestKey>
										<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
										<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
										<cls:SerialNumber>'.$createSiteSerialNumber.'</cls:SerialNumber>
										<cls:TransmitterIdentifier>2</cls:TransmitterIdentifier>
										<cls:TransmitterDetails>
											<cls:NetworkAddress>'.$createSitePhoneNumber.'</cls:NetworkAddress>
										</cls:TransmitterDetails>
									</cls:updateTransmitterRequestKey>
								</cls:UpdateTransmitter>
							</soapenv:Body>
						</soapenv:Envelope>';
		$curl_request = $this->curl->curl_send($xml, $url);
		$curl_request_array = $this->curl->xmlToArray($curl_request);
	}



	public function isEmptyRowNamePhoneEscalation($row) {
		$valuedRows = 0 ;
		$newNamePhoneEscalationArray = [] ;
		$counter = 0 ;
		foreach($row as $cell){
			if ($cell[0] && $cell[1]) {
				$valuedRows++ ;
				$newNamePhoneEscalationArray[$counter]['name'] = $cell[0];
				$newNamePhoneEscalationArray[$counter]['phone'] = $cell[1];
				$counter++;
			}
		}
		$data['valuedRows'] 	 = $valuedRows ;
		$data['namePhoneValues'] = $newNamePhoneEscalationArray ;
		return $data;
	}

	function createCustomerContactAPI()
	{
		$currentAccordian 	 	    =  $this->input->post('currentAccordian') ;
		$userSerialNumber 		    =  $this->input->post('userSerialNumber') ;
		$namePhoneEscalationArray   =  $this->input->post('dataAddLoneWorker')  ;
		$customerContactGroup 		= [] ;
		$sentinel_username			= 'MzNsd1J1RiswR1RnLzNUMHdsZXlqUT09'; //need to made this dynamic
		//$sentinel_password			=  'a25BczMyWThDeWVkZ2NmTzBsMERiQT09'; //need to made this dynamic
		$sentinel_password			=  'dVdoNXZQQjNibU5RRU9Ec0RXVzVNdz09'; //need to made this dynamic
		if ( isset($namePhoneEscalationArray['escalationDetails']) && !empty($namePhoneEscalationArray['escalationDetails']) ) {
				$namePhoneEscalationDetails	=  $namePhoneEscalationArray['escalationDetails']  ;
				//$checkIfArrayIsNull         =  $this->isEmptyRowNamePhoneEscalation($namePhoneEscalationDetails) ;
				//if ( $checkIfArrayIsNull['valuedRows'] > 0 ){
					//$dataArray =  $checkIfArrayIsNull['namePhoneValues']  ;
					foreach($namePhoneEscalationDetails as $dataToAPI) {
						$url_create = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/CreateCustomerContact";
						// list site (lone worker)
							$xml_create = '<?xml version="1.0" encoding="utf-8"?>
							<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
								 <soap:Body>
									<CreateCustomerContact xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
										<createCustomerContactRequestKey>
										<UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
										<Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
										<SerialNumber>'.$userSerialNumber.'</SerialNumber>
										<CustomerContactDetails>
												<Name>' . $dataToAPI['escName'] . '</Name>
												<PhoneNumber>' . $dataToAPI['escPhoneNo'] . '</PhoneNumber>
												<WorkNumber>' . $dataToAPI['escWorkNo'] . '</WorkNumber>
												<MobileNumber>' . $dataToAPI['escMobileNo'] . '</MobileNumber>
												<EmailAddress>' . $dataToAPI['escEmail'] . '</EmailAddress>
												<IsKeyHolder>true</IsKeyHolder>
												<CanCancelAlarms>true</CanCancelAlarms>
												<CanEditKeyHolders>true</CanEditKeyHolders>
												<CanEditSchedules>true</CanEditSchedules>
												<CanEditSiteData>true</CanEditSiteData>
										</CustomerContactDetails>
										</createCustomerContactRequestKey>
									</CreateCustomerContact>
									 </soap:Body>
								</soap:Envelope>';
								$curl_request_create = $this->curl->curl_send($xml_create, $url_create);
								// convert xml into array
								$convertToArray_create = $this->curl->xmlToArray($curl_request_create);
								//debug($convertToArray_create, 1) ;
								$response_error = $convertToArray_create['CreateCustomerContactResponse']['CreateCustomerContactResult']['Errors'];
								if( !empty($response_error) )
								{

									$msg = $response_error['Message']['MessageText'];
									echo json_encode([ 'error' => 1, 'html' => $msg  ]); die() ;
								}



								$response = $convertToArray_create['CreateCustomerContactResponse']['CreateCustomerContactResult']['CustomerContactIdentifier'];
								//debug($convertToArray_create,1);
								if( !empty($response) )
								{
									//die('inside');

									$ListCustomerContactsInGroup = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListCustomerContactsInGroup";
									$ListCustomerContactsInGroup_xml = '<?xml version="1.0" encoding="utf-8"?>
									<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
										 <soap:Body>
											<ListCustomerContactsInGroup xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
												<listCustomerContactsRequestKey>
												<UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
												<Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
												<SerialNumber>'.$userSerialNumber.'</SerialNumber>
												<GroupNumber>1</GroupNumber>
												</listCustomerContactsRequestKey>
											</ListCustomerContactsInGroup>
											 </soap:Body>
										</soap:Envelope>';
										$ListCustomerContactsInGroup_xml;

										// get curl response
										$curl_request = $this->curl->curl_send($ListCustomerContactsInGroup_xml, $ListCustomerContactsInGroup);

										// convert xml into array
										$xmlToArray_request = $this->curl->xmlToArray($curl_request);
										//debug($xmlToArray_request,1);

										$response_error2 = $xmlToArray_request['ListCustomerContactsInGroupResponse']['ListCustomerContactsInGroupResult']['Errors'];
										if( !empty($response_error2) )
										{
											$msg = $response_error2['Message']['MessageText'];
											echo json_encode([ 'error' => 1, 'html' => $msg  ]); die() ;
										}

										$ContactsInGroup = $xmlToArray_request['ListCustomerContactsInGroupResponse']['ListCustomerContactsInGroupResult']['ListOfContacts']['CustomerContactListItem'];
										//debug($ContactsInGroup,1);
										if( empty($ContactsInGroup['Name']) )
										{
												$xml_create1 = '';
												for( $var=0; $var<count($ContactsInGroup); $var++ )
												{
													 //debug($explode);
													 $xml_create1 .= '<CustomerContactListItem><Identifier>'.$ContactsInGroup[$var]['Identifier'].'</Identifier><SerialNumber>'.$ContactsInGroup[$var]['SerialNumber'].'</SerialNumber></CustomerContactListItem>';
												}
												$xml_create1 .= '<CustomerContactListItem><Identifier>'.$response.'</Identifier><SerialNumber>'.$userSerialNumber.'</SerialNumber></CustomerContactListItem>';
												$url_create = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/SetCustomerContactGroupList";
													$xml_create = '<?xml version="1.0" encoding="utf-8"?>
													<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
														 <soap:Body>
															<SetCustomerContactGroupList xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
																<setCustomerContactGroupRequestKey>
																<UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
																<Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
																<SerialNumber>'.$userSerialNumber.'</SerialNumber>
																<GroupNumber>1</GroupNumber>
																<ListOfCustomerContacts>';
																	$xml_create .= $xml_create1;
																$xml_create .='</ListOfCustomerContacts>
																</setCustomerContactGroupRequestKey>
															</SetCustomerContactGroupList>
															 </soap:Body>
														</soap:Envelope>';
														$xml_create;

														$curl_request_create = $this->curl->curl_send($xml_create, $url_create);
														// convert xml into array
														$convertToArray_create = $this->curl->xmlToArray($curl_request_create);
														//debug($convertToArray_create) ;
										 }
										 else{
												$xml_create1 = '';
												// for( $var=0; $var<count($ContactsInGroup); $var++ )
												// {
													 //debug($explode);
													 $xml_create1 .= '<CustomerContactListItem><Identifier>'.$ContactsInGroup['Identifier'].'</Identifier><SerialNumber>'.$ContactsInGroup['SerialNumber'].'</SerialNumber></CustomerContactListItem>';
												//}
												$xml_create1 .= '<CustomerContactListItem><Identifier>'.$response.'</Identifier><SerialNumber>'.$userSerialNumber.'</SerialNumber></CustomerContactListItem>';
												$url_create = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/SetCustomerContactGroupList";
												// list site (lone worker)
													$xml_create = '<?xml version="1.0" encoding="utf-8"?>
													<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
														 <soap:Body>
															<SetCustomerContactGroupList xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
																<setCustomerContactGroupRequestKey>
																<UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
																<Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
																<SerialNumber>'.$userSerialNumber.'</SerialNumber>
																<GroupNumber>1</GroupNumber>
																<ListOfCustomerContacts>';
																	$xml_create .= $xml_create1;
																$xml_create .='</ListOfCustomerContacts>
																</setCustomerContactGroupRequestKey>
															</SetCustomerContactGroupList>
															 </soap:Body>
														</soap:Envelope>';
														//echo $xml_create;

														$curl_request_create = $this->curl->curl_send($xml_create, $url_create);
														// convert xml into array
														$convertToArray_create = $this->curl->xmlToArray($curl_request_create);
										 }
										 //echo $response ;
										// $logMessage = 'Escalation contact added for user ['.ucfirst($this->session->userdata('selectedLoneWorkerName')).']';
										//$this->logger->trigger_log($this->session->userdata('username'),$logMessage);
									//echo json_encode(['error' => 0, 'CustomerContactIdentifier' => $response]);
								}else{
									//die($response . ' outside');
									echo json_encode(['error' => 1, 'html' => 'Customer Contact Identifier Not Found']); die;
								}
								$customerContactGroup[] = $response;

				   }  //end main for each loop
				   echo json_encode([ 'error' => 0, 'html' => 'Escalation added successfully', 'customerContactGroup' => $customerContactGroup,'currentAccordian' => ($currentAccordian + 1 ) ]) ;
				   die;

				//} else {
					//echo json_encode([ 'error' => 0, 'html' => 'There is no escalation data 1.', 'currentAccordian' => ($currentAccordian + 1 ) ]) ;
					//die;
				//}
		} else {
			echo json_encode([ 'error' => 0, 'html' => 'There is no escalation data 2.', 'currentAccordian' => ($currentAccordian + 1 ) ]) ;
			die;
	    }
	}
}
