<?php
require 'vendor/autoload.php';
use Aws\S3\S3Client;
use Aws\Exception\AwsException;
use Aws\Credentials\CredentialProvider;
use Aws\Credentials\Credentials;
use Aws\S3\MultipartUploader;
use Aws\Exception\MultipartUploadException;


Class Upload extends CI_Controller
{

	private $credentials ;
	private $bucket ;

	function __construct()
	{
		parent::__construct();
		$this->bucket = $this->config->item('s3')['bucket'];
		$this->credentials = new Credentials(encrypt_string($this->config->item('s3')['aws_access_key_id'],'d'), encrypt_string($this->config->item('s3')['aws_secret_access_key'],'d'));
	}

	// Function to create anew bucket
	function createBucket($s3Client, $bucketName)
	{
		die("Bucket already created.") ;
		try {
			$result = $s3Client->createBucket([
				'Bucket' => $bucketName
			]);
			return 'The bucket\'s location is: ' .
				$result['Location'] . '. ' .
				'The bucket\'s effective URI is: ' .
				$result['@metadata']['effectiveUri'];
		} catch (AwsException $e) {
			return 'Error: ' . $e->getAwsErrorMessage();
		}
	}


	function createTheBucket()
	{

		$s3Client = new S3Client([
			'version'     => 'latest',
			'region'      => 'us-west-2',
			'credentials' => $this->credentials
		]);

		echo $this->createBucket($s3Client, $this->bucket);
	}

	// Function to list all the buckets
	public function listBucket(){

		$s3Client = new S3Client([
			'region' => 'us-west-2',
			'version' => 'latest',
			'credentials' => $this->credentials
		]);

		//Listing all S3 Bucket
		$buckets = $s3Client->listBuckets();
		debug($buckets, 1) ;
		foreach ($buckets['Buckets'] as $bucket) {
			echo $bucket['Name'] . "\n";
		}
	}


	//List objects in a bucket

	public function listBucketObjects() {
		$s3Client = new S3Client([
			'region' => 'us-west-2',
			'version' => 'latest',
			'credentials' => $this->credentials
		]);

		$buckets = $s3Client->listObjectsV2(['Bucket' => $this->bucket,
						//"Prefix" => "uploads_new/test/",
						"Delimiter" => "/"
		]);
		debug($buckets, 1) ;
	}

	//List single object data from the  bucket

	public function singleBucketObjectData() {
		$s3Client = new S3Client([
			'region' => 'us-west-2',
			'version' => 'latest',
			'credentials' => $this->credentials
		]);
		try {
			$buckets = $s3Client->getObject(['Bucket' => $this->bucket,  'Key' => 'broadcastgrey12.png']);
			debug($buckets, 1) ;
		} catch (AwsException $e) {
			echo $e->getMessage() . PHP_EOL;
		}
	}



	public function multipartUpload() {
		$s3Client = new S3Client([
			'region' => 'us-west-2',
			'version' => 'latest',
			'credentials' => $this->credentials
		]);

		// Use multipart upload
		$source = '/var/www/html/orbis_aws_s3/img/broadcastgrey.png';
		$uploader = new MultipartUploader($s3Client, $source, [
			'bucket' => $this->bucket,
			'key' 	 => 'broadcastgrey12345.png',
			'ACL' 	 =>  'public-read'
		]);

		try {
			$result = $uploader->upload();
			echo "Upload complete: {$result['ObjectURL']}\n";
			//debug($result, 1) ;
		} catch (MultipartUploadException $e) {
			echo $e->getMessage() . "\n";
		}

	}

	// Ietrate through the bucket objects

	function listBucketObjectsIetration() {
		$s3Client = new S3Client([
			'region' => 'us-west-2',
			'version' => 'latest',
			'credentials' => $this->credentials
		]);

		$url =  $s3Client->getObjectUrl('sentry-orbis', 'uploads_new/test/new_test/1590494069-1888491031-Ecalation_Summary_Report121624.pdf') ;
		echo '<a href ="'.$url.'" download target="_blank">Download</a>' ;
		$objects = $s3Client->getIterator('ListObjects',  [
						'Bucket' => 'sentry-orbis'
		]) ;

		debug($objects, 1) ;

	}

	// function to upload the file firstly to local, then send it to AWS and unlink the file from local
	function upload_file_to_local_Aws()
	{
		$bulkUploadPath = $this->config->item('directoryPath') . 'AWS_S3/' ;
		$uniqueId		= time().'-'.mt_rand().'-';
		//debug($_FILES, 1) ;
		if(isset($_FILES["fileUpload"]["name"]))
        {
			    $new_name = $uniqueId.$_FILES["fileUpload"]['name'];
				$config['file_name'] = $new_name;
                $config['upload_path'] = $bulkUploadPath ;
                $config['allowed_types'] = 'pdf|doc|docx';
                $config['max_size']      = 30000;
                $this->load->library('upload', $config);
                if(!$this->upload->do_upload('fileUpload'))
                {
                     echo json_encode(['error' => 1, 'message' =>  strip_tags($this->upload->display_errors())]) ;
                }
                else
                {
					 $fileNamePath = $bulkUploadPath . $new_name ;
                     $data = $this->upload->data();
                     chmod($fileNamePath,0777); // CHMOD file

                     /***If file uploaded, upload it over the AWS-S3***/

                     $s3Client = new S3Client([
									'region' => 'us-west-2',
									'version' => 'latest',
									'credentials' => $this->credentials
								]);

					 // Use multipart upload
					 $source = $fileNamePath;
					 $uploader = new MultipartUploader($s3Client, $source, [
						'bucket' => $this->bucket,
						//'key' 	 => "uploads_new/test/new_test/{$new_name}",
						'key' 	 => "{$new_name}",
						'ACL' 	 =>  'public-read'
					 ]);

					 try {
						$result = $uploader->upload();
						echo json_encode(['error' => 0, 'message' =>  'File uploaded successfully.', 'url' => $result['ObjectURL']]) ;
					 } catch (MultipartUploadException $e) {
						echo json_encode(['error' => 1, 'message' =>  $e->getMessage()]) ;
					 }

                     /***If file uploaded, upload it over the AWS-S3***/
                }
       }  else {
				echo json_encode(['error' => 1, 'message' =>  'File is required.']) ;
	   }

	}

	function upload_file_to_base64_Aws()
	{

		$files 		= $this->input->post('files') ;
		if ($files) {

			$folderName = $this->input->post('folderName') ;

			if ( $folderName == "__mainRootFolder") {
				$toUpload = "" ;
			} else {
				$toUpload = $folderName ;
			}

			$s3Client   = new S3Client([
				'region' => 'us-west-2',
				'version' => 'latest',
				'credentials' => $this->credentials
			]);

			$alertMessageBox = "" ;
			foreach($files as $dataFiles) {
				if ($dataFiles) {
					//$uniqueId		= time().'-'.mt_rand().'-';

					$dataDecode 	= json_decode($dataFiles) ;

					/***previous file name
					$uniqueId		= time().'-';
					$filename   	= $toUpload.$uniqueId.$dataDecode->name;
					/***previous file name***/


					/***new file name***/
					$uniqueId			= 	'-'.time();
					$path_parts 	    = 	pathinfo($dataDecode->name);
					$exactFileExtension	=	'.'.strtolower($path_parts['extension']);
					$exactFileName		=	$path_parts['filename'];

					$filename   		= $toUpload.$exactFileName.$uniqueId.$exactFileExtension;
					/***new file name***/

					//$imageData = base64_decode(end(explode(",", $data->data)));
					$fileData  		= base64_decode($dataDecode->data);

					try {
						$upload    		= $s3Client->upload($this->bucket, $filename, $fileData, 'public-read');
						if ( $upload->get('ObjectURL') ) {
							$alertMessageBox .= $dataDecode->name . ": Uploaded successfully\n"  ;
						} else {
							$alertMessageBox .= $dataDecode->name . ": Not Uploaded\n"  ;
						}
					 } catch (AwsException $e) {
						 $alertMessageBox .= $dataDecode->name . ": Not Uploaded\n"  ;
					 }

				}
			}

			echo json_encode(['error' => 0, 'message' =>  $alertMessageBox, 'folderName' => $folderName]) ;
		} else {
			echo json_encode(['error' => 1, 'message' =>  'File is required.']) ;
		}
	}



	//List objects in a bucket

	public function listBucketObjectsAjaxTest() {

		$s3Client = new S3Client([
			'region' => 'us-west-2',
			'version' => 'latest',
			'credentials' => $this->credentials
		]);

		$results = $s3Client->getPaginator('ListObjectsV2', [
			'Bucket' => $this->bucket,
			//"Prefix" => "uploads_new/test/",
			"Delimiter" => "/"
		]);
		//debug($results ) ;
		$newArray 		= [] ;
		$newArrayPrefix = [] ;
		foreach ($results as $result) {
			foreach ($result['Contents'] as $object) {
				//echo $object['Key'] . "\n";
				$newArray[] = $object ;
				echo "<br />";
			}
		}
		debug($newArray) ;
		echo "<br />";

		foreach ($results as $result) {
			foreach ($result['CommonPrefixes'] as $object) {
				//echo $object['Prefix'] . "\n";
				$newArrayPrefix[] = $object ;
				echo "<br />";
			}
		}
		debug($newArrayPrefix) ;
		//~ $buckets = $s3Client->listObjectsV2(['Bucket' => $this->bucket,
						//~ "Delimiter" => "/"
		//~ ]);


	}

	public function listBucketObjectsAjax() {

		$s3Client = new S3Client([
			'region' => 'us-west-2',
			'version' => 'latest',
			'credentials' => $this->credentials
		]);


		try {
			$results = $s3Client->getPaginator('ListObjectsV2', [
				'Bucket' => $this->bucket,
				"Delimiter" => "/"
			]);
			$rightSideContent = '' ;
			$treeStructureContent = '' ;
			$folderArray = [] ;
			$counter1 = 1 ;
			$counter2 = 1 ;
			foreach ($results as $result) {
				if ( isset($result['Contents']) && $result['Contents'] ) {
					// Content like files on root that need to be displayed on the right side of view.
					foreach ($result['Contents'] as $object) {
						$ext = pathinfo($object['Key'], PATHINFO_EXTENSION);
						if ( strtolower($ext) == "pdf" ) {
							$imageName = "pdf.svg" ;
						} elseif( strtolower($ext) == "doc" ||  strtolower($ext) == "docx" ) {
							$imageName = "excel.svg" ;
						} elseif( strtolower($ext) == "xlsx" ||  strtolower($ext) == "xls" ) {
								$imageName = "mp3.svg" ;
						} elseif( strtolower($ext) == "pptx" ||  strtolower($ext) == "pptm" ||  strtolower($ext) == "ppt"  ) {
							$imageName = "ppt.svg" ;
						} else{
							$imageName = "filedefault.svg" ;
						}

						$rightSideContent .= '	<tr data-uniquekey="'.$object['Key'].'" data-url="'.$s3Client->getObjectUrl($this->bucket, $object['Key']).'" data-name="'.$object['Key'].'">
                     <td>
                        <div class="custom-control custom-checkbox">
                           <input type="checkbox" name="check" class="custom-control-input" id="customCheck'.$counter1.'">
                           <label class="custom-control-label" for="customCheck'.$counter1.'"><img src="' . base_url() . 'img/directory_icon/'.$imageName.'" alt=""> <span class="__folderName">'.$object['Key'].'</span> </label>

                           <span class="__OPenShareBtn">
                              <div class="btn-group">
                                 <span class="dropdown-toggle-share" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                 <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
                                 </span>
                                 <div class="dropdown-menu open-right">


                                    <a class="__downloadAdmin" href="'.$s3Client->getObjectUrl($this->bucket, $object['Key']).'" download>Download</a>
                                    <button class="dropdown-item" type="button" id="__singleDelete">Delete</button>
                                    <button id="__renameObject" class="dropdown-item" type="button">Rename</button>
                                    <button id="__moveObject" class="dropdown-item" type="button">Move</button>
                                 </div>
                              </div>

                           </span>
                        </div>
                     </td>
                     <td>'.date('d/m/Y H:i', strtotime($object['LastModified']->format(\DateTime::ISO8601))).'</td>
                     <td>3 Customers</td>
                     <td class="__OPenShareBtn text-center">
                        <div class="btn-group">
                           <span class="dropdown-toggle-share" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                           <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
                           </span>
                           <div class="dropdown-menu open-right">


                              <a class="__downloadAdmin" href="'.$s3Client->getObjectUrl($this->bucket, $object['Key']).'" download>Download</a>
                              <button class="dropdown-item" type="button"  id="__singleDelete">Delete</button>
                              <button id="__renameObject" class="dropdown-item" type="button">Rename</button>
                              <button id="__moveObject" class="dropdown-item" type="button">Move</button>
                           </div>
                        </div>

                     </td>
                  </tr>' ;
					  $counter1++;
					}
				}

				// Content like folders on root that need to be displayed as the tree structure.
				if ( isset($result['CommonPrefixes']) && $result['CommonPrefixes'] ) {
					$lastClass= "" ;
					$count = count($result['CommonPrefixes']) ;
					foreach ($result['CommonPrefixes'] as $object) {
						if ( $counter2 ==  $count ) {
							$lastClass = "jstree-last" ;
						}
						$removeDelimeter = str_replace("/","", $object['Prefix']) ;
						$folderArray[] 	 = $removeDelimeter ;
						$treeStructureContent .= ' <li class="jstree-node  jstree-leaf '.$lastClass.'" data-delimeter="'.$object['Prefix'].'" data-name="'.$removeDelimeter.'">
					  <i class="jstree-icon jstree-ocl" role="presentation"></i>
					  <a class="jstree-anchor" href="javascript:void(0)">
						  <i class="jstree-icon jstree-themeicon feather icon-folder jstree-themeicon-custom" role="presentation"></i>
							'.$removeDelimeter.'
						</a>
						<span class="__renameFolderInput" style="display:none"><i class="jstree-icon jstree-themeicon feather icon-folder jstree-themeicon-custom" role="presentation"></i><input  class="__renameFolderInputText" type="text" value="'.$removeDelimeter.'"  /></span>
						<span class="__jstreeicon_social"><a  data-toggle="tooltip" data-placement="top" title="Delete folder" href="javascript:void(0)" id ="__deleteFolderSide"><img class="_icon_storage_social" src="'. base_url() .'img/directory_icon/delete.svg" alt=""></a><a href="javascript:void(0)"  data-toggle="tooltip" data-placement="top" title="Rename folder" class="__renameFolderButton"> <img class="_icon_storage_social" src="'. base_url() .'img/directory_icon/edit.svg" alt=""></a> <a href="javascript:void(0)" class ="__shareFolderSide" data-shareposition ="side"  data-toggle="tooltip" data-placement="top" title="Share folder"><img class="_icon_storage_social" src="'. base_url() .'img/directory_icon/share.svg" alt=""></a></span>
					</li>';
						$counter2++ ;
					}
				}


			}
			$error = 0 ;
			$message = "In try field";
		} catch (AwsException $e) {
			//echo $e->getMessage() . PHP_EOL;
			$error = 1 ;
			$message = "Network error, pleasetry again later.";
		}


		echo json_encode(['error' => $error, 'message' =>$message, 'rightSideContent' => $rightSideContent, 'treeStructureContent' => $treeStructureContent, 'folderArray' => $folderArray]) ;

	}

	// Get files for folders
	public function listBucketObjectsAjaxPrefixes() {
		$prefix = $this->input->post('prefix') ;

		if ($prefix) {
				$s3Client = new S3Client([
					'region' => 'us-west-2',
					'version' => 'latest',
					'credentials' => $this->credentials
				]);


				try {
					if ( $prefix == "getRootDataFiles" ) {

						$results = $s3Client->getPaginator('ListObjectsV2', [
							'Bucket' => $this->bucket,
							"Delimiter" => "/"
						]);

					} else {

						$results = $s3Client->getPaginator('ListObjectsV2', [
							'Bucket' => $this->bucket,
							"Prefix" => $prefix
						]);

					}
					$rightSideContent = '' ;
					$counter1 = 1 ;
					foreach ($results as $result) {
						if ( isset($result['Contents']) && $result['Contents'] ) {
							// Content like files on root that need to be displayed on the right side of view.
							foreach ($result['Contents'] as $object) {
								$ext = pathinfo($object['Key'], PATHINFO_EXTENSION);
								if ( strtolower($ext) == "pdf" ) {
									$imageName = "pdf.svg" ;
								} elseif( strtolower($ext) == "doc" ||  strtolower($ext) == "docx" ) {
									$imageName = "excel.svg" ;
								} elseif( strtolower($ext) == "xlsx" ||  strtolower($ext) == "xls" ) {
									$imageName = "mp3.svg" ;
								} elseif( strtolower($ext) == "pptx" ||  strtolower($ext) == "pptm" ||  strtolower($ext) == "ppt"  ) {
									$imageName = "ppt.svg" ;
								} else{
									$imageName = "filedefault.svg" ;
								}
								/*To continue if the file is used for folder creation*/

									if ( $object['Key'] == $prefix."do-not-delete.txt" || $ext == "txt") {
										continue ;
									}

								/*To continue if the file is used for folder creation*/
								$objectName = explode('/', $object['Key']) ;
								$objectName = end($objectName) ;

								$rightSideContent .= '	<tr data-uniquekey="'.$object['Key'].'" data-url="'.$s3Client->getObjectUrl($this->bucket, $object['Key']).'" data-name="'.$objectName.'">
							 <td>
								<div class="custom-control custom-checkbox">
								   <input type="checkbox" name="check" class="custom-control-input" id="customCheck'.$counter1.'">
								   <label class="custom-control-label" for="customCheck'.$counter1.'"><img src="' . base_url() . 'img/directory_icon/'.$imageName.'" alt=""> <span class="__folderName">'.$objectName.'</span> </label>

								   <span class="__OPenShareBtn">
									  <div class="btn-group">
										 <span class="dropdown-toggle-share" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										 <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
										 </span>
										 <div class="dropdown-menu open-left arrow">


											<a class="__downloadAdmin" href="'.$s3Client->getObjectUrl($this->bucket, $object['Key']).'" download>Download</a>
											<button class="dropdown-item" type="button" id="__singleDelete">Delete</button>
											<button id="__renameObject" class="dropdown-item" type="button">Rename</button>
											<button id="__moveObject" class="dropdown-item" type="button">Move</button>
										 </div>
									  </div>

								   </span>
								</div>
							 </td>
							 <td>'.date('d/m/Y H:i', strtotime($object['LastModified']->format(\DateTime::ISO8601))).'</td>
							 <td>3 Customers</td>
							 <td class="__OPenShareBtn text-center">
								<div class="btn-group">
								   <span class="dropdown-toggle-share" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								   <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
								   </span>
								   <div class="dropdown-menu open-right">
									  <a class="__downloadAdmin" href="'.$s3Client->getObjectUrl($this->bucket, $object['Key']).'" download>Download</a>
									  <button class="dropdown-item" type="button"  id="__singleDelete">Delete</button>
									  <button id="__renameObject" class="dropdown-item" type="button">Rename</button>
									  <button id="__moveObject" class="dropdown-item" type="button">Move</button>
								   </div>
								</div>

							 </td>
						  </tr>' ;
							  $counter1++;
							}
						}

					}
					$error = 0 ;
					$message = "In try field";
				} catch (AwsException $e) {
					//echo $e->getMessage() . PHP_EOL;
					$error = 1 ;
					$message = "Network error, pleasetry again later.";
				}


				echo json_encode(['error' => $error, 'message' =>$message, 'rightSideContent' => $rightSideContent]) ;
		} else {
				$error = 1 ;
				$message = "Prefix is required";
				echo json_encode(['error' => $error, 'message' =>$message]) ;
		}

	}

	public function deleteSingleObject() {

		$keyname 	= $this->input->post('key');
		$folderName = $this->input->post('folderName') ;

		if($keyname){
			$s3Client = new S3Client([
				'region' => 'us-west-2',
				'version' => 'latest',
				'credentials' => $this->credentials
			]);

			try
			{
				$result = $s3Client->deleteObject([
					'Bucket' => $this->bucket,
					'Key'    => $keyname
				]);
				/*
				if ($result['DeleteMarker'])
				{
					$error = 0 ;
					$message =  $keyname . ' was deleted.';
				} else {
					$error = 1 ;
					$message = 'Error: ' . $keyname . ' was not deleted.' ;
				}*/
				$error = 0 ;
				//$message =  $keyname . ' was deleted.';
				$message =  'File(s) deleted';
			}
			catch (AwsException $e) {
				$error = 1 ;
				$message = 'Error: ' . $e->getAwsErrorMessage() ;
			}

		} else {
			$error = 1 ;
			$message = "Object key is required.";
		}

		echo json_encode(['error' => $error, 'message' =>$message, 'folderName' => $folderName]) ;
	}


	public function deleteMultipleObjects() {
		$keyname 	= json_decode($this->input->post('key'));
		$folderName = $this->input->post('folderName') ;

		if ($keyname) {

				$deleted 	= false;
				$notDeleted = false;

				$s3Client = new S3Client([
					'region' => 'us-west-2',
					'version' => 'latest',
					'credentials' => $this->credentials
				]);
				foreach ($keyname as $data)
				{
					$result = $s3Client->deleteObjects([
						'Bucket'  => $this->bucket,

						'Delete' => [
							'Objects' => [
								[
									'Key' => $data,
								]
							]

						]
					]);

					if (isset($result['Deleted']))
					{
						$deleted = true;
					}

					if (isset($result['Errors']))
					{
						$notDeleted = true;
					}
				}

				$error 	 = 0 ;
				$message = "" ;
				if ($deleted && !$notDeleted) {
					$message = "File(s) deleted" ;
				} elseif ($deleted && $notDeleted) {
					$message = "File(s) deleted.\n However, some files are not deleted." ;
				} elseif (!$deleted && !$notDeleted) {
					$message = "No Files Deleted." ;
				}


		} else {
			$error 	 = 1 ;
			$message = "Object key is required.";
		}

		echo json_encode(['error' => $error, 'message' =>$message, 'folderName' => $folderName]) ;
	}


	public function createAwsFolderWithEmptyFile() {
		$folderName 	= $this->input->post('newfolderName') ;
		$filePath	    = $this->config->item('directoryPath') . 'AWS_S3/do-not-delete.txt' ;
		$fileName		= "do-not-delete.txt" ;

		if ( !file_exists($filePath) ) {
			echo json_encode(['error' => 1, 'message' =>  'File does not exists.']) ;
			exit;
		}

		if($folderName)
        {
			 $s3Client = new S3Client([
							'region' => 'us-west-2',
							'version' => 'latest',
							'credentials' => $this->credentials
			  ]);

			 $source = $filePath;
			 $uploader = new MultipartUploader($s3Client, $source, [
				'bucket' => $this->bucket,
				'key' 	 => "{$folderName}/{$fileName}",
				'ACL' 	 =>  'public-read'
			 ]);


			 try {
				$result = $uploader->upload();
				echo json_encode(['error' => 0, 'message' =>  'Folder created successfully.', 'url' => $result['ObjectURL'], 'folderName'=>$folderName ]) ;
			 } catch (MultipartUploadException $e) {
				echo json_encode(['error' => 1, 'message' =>  $e->getMessage()]) ;
			 }

			 /***If file uploaded, upload it over the AWS-S3***/

       }  else {
				echo json_encode(['error' => 1, 'message' =>  'Folder name is required.']) ;
	   }


	}

	public function deleteSelectedFolder() {
		$folderName 	= $this->input->post('folderName') ;
		$this->load->model('users') ;

		if($folderName)
        {
			 $s3Client = new S3Client([
							'region' => 'us-west-2',
							'version' => 'latest',
							'credentials' => $this->credentials
			  ]);

			 try {

				$result = $s3Client->deleteMatchingObjects($this->bucket, $folderName);
				$deleteSharedUsers = $this->users->delete_shared_users($folderName) ;

				echo json_encode(['error' => 0, 'message' =>  'Folder deleted successfully.']) ;
			 } catch (AwsException $e) {
				echo json_encode(['error' => 1, 'message' =>  $e->getMessage()]) ;
			 }

			 /***If file uploaded, upload it over the AWS-S3***/

       }  else {
				echo json_encode(['error' => 1, 'message' =>  'Prefix is required.']) ;
	   }


	}

	public function renameFileName() {

		//$uniqueId	= time().'-';
		$uniqueId	= '-'.time();

		$folderName  = $this->input->post('folderName') ;
		$oldName 	 = $this->input->post('previousFileNameValue') ;
		$newFileName = $this->input->post('newFileName') ;

		$ext 		= pathinfo($oldName, PATHINFO_EXTENSION);

		if ( $folderName == "__mainRootFolder") {
			$name = $newFileName.$uniqueId.'.'.$ext ;
		} else {
			$name = $folderName.$newFileName.$uniqueId.'.'.$ext ;
		}


		$s3Client = new S3Client([
					'region' => 'us-west-2',
					'version' => 'latest',
					'credentials' => $this->credentials
		]);
		 try {
			$result = $s3Client->copyObject(array(
					'ACL' 	 =>  'public-read',
					// Bucket is required
					'Bucket' => $this->bucket,
					// CopySource is required
					'CopySource' =>  "{$this->bucket}/{$oldName }",
					// Key is required
					'Key' => $name,
					'MetadataDirective' => 'REPLACE'
			));
			if ($result['ObjectURL']) {
				$s3Client->registerStreamWrapper();
				unlink("s3://{$this->bucket}/{$oldName}");

			}

			$error = 0 ;
			$message = "File renamed successfully.";
		} catch (AwsException $e) {
			$error = 0 ;
			$message = $e->getMessage();
		}

		echo json_encode(['error' => $error, 'message' =>  $message, 'folderName'=> $folderName ]) ;
	}


	public function moveFile() {
		//debug($_POST, 1) ;

		$fromFolderName  = $this->input->post('fromFolderName') ; // tree structure selected folder
		$objectKeyName 	 = $this->input->post('objectKeyName') ; // Object key to copy
		$toFolderName 	 = $this->input->post('toFolderName') ;  // Modal selected folder

		if ( $fromFolderName == "__mainRootFolder") {
			$name = $toFolderName.$objectKeyName ;  // New key name
		} else {
			$explode = explode("/", $objectKeyName) ;

			$name = $toFolderName.end($explode) ;  // New key name
		}

		$s3Client = new S3Client([
					'region' => 'us-west-2',
					'version' => 'latest',
					'credentials' => $this->credentials
		]);
		 try {
			$result = $s3Client->copyObject(array(
					'ACL' 	 =>  'public-read',
					// Bucket is required
					'Bucket' => $this->bucket,
					// CopySource is required
					'CopySource' =>  "{$this->bucket}/{$objectKeyName }",
					// Key is required
					'Key' => $name,
					'MetadataDirective' => 'REPLACE'
			));
			if ($result['ObjectURL']) {
				$s3Client->registerStreamWrapper();
				unlink("s3://{$this->bucket}/{$objectKeyName}");

			}

			$error = 0 ;
			$message = "File moved successfully.";
		} catch (AwsException $e) {
			$error = 1 ;
			$message = $e->getMessage();
		}

		echo json_encode(['error' => $error, 'message' =>  $message, 'folderName'=> $fromFolderName ]) ;
	}


	public function getCostCenterUsers() {
		$this->load->model('users');

		$selectedFolderDelimeter = $this->input->post('selectedFolderDelimeter') ;

		//$getCostCenterUsers 	 = $this->users->getCostCenterUsers();
		
		/*
		// config for PDO
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		// get CostCentre

		$CostCentre = "select unique linkacc.linkno , linkacc.name from linkacc, webusers where linkacc.parent = 20 and webusers.agctype = 4 and linkacc.linkno = webusers.agcno";


		$CostCentreQuery   = $conexion->prepare($CostCentre);
		$CostCentreQuery->execute();
		$CostCentreResponse = $CostCentreQuery->fetchAll(PDO::FETCH_ASSOC);
		//debug($CostCentreResponse,1);
		if(!empty($CostCentreResponse)){
		  for( $j=0; $j<count($CostCentreResponse); $j++ )
		  {
			//$CostCentreResponse[$j]['NAME'] = trim(str_replace('CC', '', $CostCentreResponse[$j]['NAME']));
			$CostCentreResponse[$j]['NAME'] = trim(substr($CostCentreResponse[$j]['NAME'], 3));
		  }

		  foreach ($CostCentreResponse as $key => $row) {
			  // replace 0 with the field's index/key
			  $dates[$key]["NAME"]  = $row["NAME"];
			  //$dates1[$key]["NAME"]  = $row["NAME"];
		  }

		   array_multisort($dates, SORT_ASC, $CostCentreResponse);
		}
		else{
		  $CostCentreResponse = array();
		}
		*/
		
		$CostCentreResponse = $this->curl->curlHelperGetCostCentreAPI() ;

		$getAlreadySharedUsers	 = $this->users->getSharedFolderUsers($selectedFolderDelimeter);

		$contentSelectBox = '';
		//debug($CostCentreResponse, 1) ;
		$sharedUsers = [] ;

		if ($getAlreadySharedUsers) {
			foreach($getAlreadySharedUsers as $data) {
				$sharedUsers[] = $data['cost_center_id'] ;
			}
		}

		$isShared  = 'notShared' ;
		if ( $CostCentreResponse ) {
			$error   = 0 ;
			$message = "Cost Center Level Users Found.";

			foreach($CostCentreResponse as $data) {
				$selected = "";
				if(in_array($data['LINKNO'], $sharedUsers)){
					$isShared  = 'isShared' ;
					$selected = 'selected="selected"' ;
				}
				$contentSelectBox .= '<option value="'.$data['LINKNO'].'" data-costcenterid="'.$data['LINKNO'].'" data-costcentername="'.$data['NAME'].'"'.$selected.'>'.$data['NAME'].'</option>' ;
			}
		} else {
			$error   = 1 ;
			$message = "No Users Found.";
		}

		echo json_encode(['error' => $error, 'content' => $contentSelectBox, 'message' => $message, 'isShared' => $isShared]) ;

	}

	public function add_delete_shared_folder_users() {

		$this->load->model('users');

		$dataToInsert 		 		= json_decode($this->input->post('dataToInsert'));
		$selectedUsersLength 		= $this->input->post('selectedUsersLength') ;
		$folderToshareNameDelimeter = $this->input->post('folderToshareNameDelimeter') ;

		//debug($dataToInsert, 1) ;

		if ( $selectedUsersLength > 0 ) {
			$addSharedUsers = $this->users->add_shared_users($dataToInsert,$folderToshareNameDelimeter) ;
			if ( $addSharedUsers > 0 ) {
				$error = 0 ;
				$message = "Shared successfully" ;
			} else {
				$error = 1 ;
				$message = "Network error, please try again later." ;
			}
		} else {
			$deleteSharedUsers = $this->users->delete_shared_users($folderToshareNameDelimeter) ;
			if ( $deleteSharedUsers > 0 ) {
				$error = 0 ;
				$message = "Shared successfully" ;
			} else {
				$error = 1 ;
				$message = "Network error, please try again later." ;
			}
		}

		echo json_encode(['error' => $error, 'message' => $message]) ;
	}


	public function renameFolder() {

		//debug($_POST, 1);

		$currentDelimeter 		= $this->input->post('currentDelimeter') ;
		$newDelimeter 			= $this->input->post('newDelimeter') ;
		$failedCopyObject 		= false;

		if ( $currentDelimeter && $newDelimeter) {
			$s3Client = new S3Client([
					'region' => 'us-west-2',
					'version' => 'latest',
					'credentials' => $this->credentials
				]);


				try {

						$results = $s3Client->getPaginator('ListObjectsV2', [
							'Bucket' => $this->bucket,
							"Prefix" => $currentDelimeter
						]);

						foreach ($results as $result) {
							if ( isset($result['Contents']) && $result['Contents'] ) {

								foreach ($result['Contents'] as $object) {
									$explodeKey = explode('/', $object['Key']) ;
									$name 		= $newDelimeter.end($explodeKey);
									try {

										$resultCopy = $s3Client->copyObject(array(
												'ACL' 	 =>  'public-read',
												// Bucket is required
												'Bucket' => $this->bucket,
												// CopySource is required
												'CopySource' =>  "{$this->bucket}/{$object['Key'] }",
												// Key is required
												'Key' => $name,
												'MetadataDirective' => 'REPLACE'
										));
										if ($resultCopy['ObjectURL']) {
											$s3Client->registerStreamWrapper();
											unlink("s3://{$this->bucket}/{$object['Key']}");

										}
									} catch (AwsException $e) {
										$failedCopy = true;
									}
								}
							}
						}

						$error = 0 ;
						$message = "Folder renamed successfully.";

				} catch (AwsException $e) {
					$error = 1 ;
					$message = $e->getMessage();
				}
		} else{
			$error = 1;
			$message = "New and previous, both folder names are required." ;
		}

		echo json_encode(['error' => $error, 'message' => $message, 'failedCopyObject' => $failedCopyObject]) ;
	}


	/**************User Shared Folders Part Starts Here*******************/

	public function listBucketObjectsAjax_Users() {
		$this->load->model('users');
		$costCentreID 		  = $this->input->post('costCentreID') ;
		$getUserSharedFolders = $this->users->get_shared_folder_loggedin_user($costCentreID);

		$rightSideContent = '' ;
		$treeStructureContent = '' ;
		$folderArray = [] ;

		if ($getUserSharedFolders) {

			$prefix = $getUserSharedFolders[0]['folder_name'] ;

			$s3Client = new S3Client([
				'region' => 'us-west-2',
				'version' => 'latest',
				'credentials' => $this->credentials
			]);


			try {
				$results = $s3Client->getPaginator('ListObjectsV2', [
					'Bucket' => $this->bucket,
					"Prefix" => $prefix
				]);

				$counter1 = 1 ;
				$counter2 = 1 ;
				foreach ($results as $result) {
					if ( isset($result['Contents']) && $result['Contents'] ) {
						// Content like files on root that need to be displayed on the right side of view.
						foreach ($result['Contents'] as $object) {
							$ext = pathinfo($object['Key'], PATHINFO_EXTENSION);
							if ( strtolower($ext) == "pdf" ) {
								$imageName = "pdf.svg" ;
							} elseif( strtolower($ext) == "doc" ||  strtolower($ext) == "docx" ) {
								$imageName = "excel.svg" ;
							} elseif( strtolower($ext) == "xlsx" ||  strtolower($ext) == "xls" ) {
								$imageName = "mp3.svg" ;
							} elseif( strtolower($ext) == "pptx" ||  strtolower($ext) == "pptm" ||  strtolower($ext) == "ppt"  ) {
								$imageName = "ppt.svg" ;
							} else{
								$imageName = "filedefault.svg" ;
							}

							/*To continue if the file is used for folder creation*/

								if ( $object['Key'] == $prefix."do-not-delete.txt" || $ext == "txt") {
									continue ;
								}

							/*To continue if the file is used for folder creation*/

							$objectName = explode('/', $object['Key']) ;
							$objectName = end($objectName) ;

							$rightSideContent .= '	<tr data-uniquekey="'.$object['Key'].'" data-url="'.$s3Client->getObjectUrl($this->bucket, $object['Key']).'" data-name="'.$objectName.'">
						 <td>
							<div class="custom-checkbox">
							   <label class="custom-control-label" for="customCheck'.$counter1.'"><img src="' . base_url() . 'img/directory_icon/'.$imageName.'" alt=""> <span class="__folderName">'.$objectName.'</span> </label>

							   <span class="__OPenShareBtn">
								  <div class="btn-group">
									 <span class="dropdown-toggle-share" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									 <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
									 </span>
									 <div class="dropdown-menu open-right">
										<button class="dropdown-item __downloadObjectFile" type="button">Download</button>
									 </div>
								  </div>

							   </span>
							</div>
						 </td>
						 <td>'.date('d/m/Y H:i', strtotime($object['LastModified']->format(\DateTime::ISO8601))).'</td>
						 <td>3 Customers</td>
						 <td class="__OPenShareBtn text-center">
							<div class="btn-group">
							   <span class="dropdown-toggle-share" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							   <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
							   </span>
							   <div class="dropdown-menu open-right">
								  <button class="dropdown-item __downloadObjectFile" type="button">Download</button>
							   </div>
							</div>

						 </td>
					  </tr>' ;
						  $counter1++;
						}
					}
				}

				// Content like folders on root that need to be displayed as the tree structure.
				if ( isset($getUserSharedFolders) && $getUserSharedFolders ) {
					$lastClass 	= "" ;
					$count 		= count($getUserSharedFolders) ;
					foreach ($getUserSharedFolders as $object) {
						if ( $counter2 ==  $count ) {
							$lastClass = "jstree-last" ;
						}
						$removeDelimeter = str_replace("/","", $object['folder_name']) ;
						$folderArray[] 	 = $removeDelimeter ;
						$treeStructureContent .= ' <li class="jstree-node  jstree-leaf '.$lastClass.'" data-delimeter="'.$object['folder_name'].'" data-name="'.$removeDelimeter.'">
					  <i class="jstree-icon jstree-ocl" role="presentation"></i>
					  <a class="jstree-anchor '.( $counter2 == "1" ? "currentAnchorSelected":"" ).'" href="javascript:void(0)">
						  <i class="jstree-icon jstree-themeicon feather icon-folder jstree-themeicon-custom" role="presentation"></i>
							'.$removeDelimeter.'
						</a>
					</li>';
						$counter2++ ;
					}
				}




				$error = 0 ;
				$message = "In try field";
			} catch (AwsException $e) {
				//echo $e->getMessage() . PHP_EOL;
				$error = 1 ;
				$message = "Network error, please try again later.";
			}

		} else {
			$error = 1 ;
			$message = "nothing_shared_yet";
		}

		echo json_encode(['error' => $error, 'message' =>$message, 'rightSideContent' => $rightSideContent, 'treeStructureContent' => $treeStructureContent, 'folderArray' => $folderArray]) ;

	}



	// Get files for folders
	public function listBucketObjectsAjaxPrefixes_Users() {

		$this->load->model('users');

		$prefix 		= $this->input->post('prefix') ;
		$costCentreID 	= $this->input->post('costCentreID') ;

		//check if the folder is still shared or has been deleted
		$currentlySharedStatus = $this->users->currentlySharedStatus($prefix, $costCentreID);
		if (!$currentlySharedStatus) {
			$error = 1 ;
			$message = "Network error occured,  please reload the page.";
			echo json_encode(['error' => $error, 'message' =>$message]) ;
			exit ;
		}

		if ($prefix) {
				$s3Client = new S3Client([
					'region' => 'us-west-2',
					'version' => 'latest',
					'credentials' => $this->credentials
				]);


				try {

					$results = $s3Client->getPaginator('ListObjectsV2', [
						'Bucket' => $this->bucket,
						"Prefix" => $prefix
					]);

					$rightSideContent = '' ;
					$counter1 = 1 ;
					foreach ($results as $result) {
						if ( isset($result['Contents']) && $result['Contents'] ) {
							// Content like files on root that need to be displayed on the right side of view.
							foreach ($result['Contents'] as $object) {
								$ext = pathinfo($object['Key'], PATHINFO_EXTENSION);
								if ( strtolower($ext) == "pdf" ) {
									$imageName = "pdf.svg" ;
								} elseif( strtolower($ext) == "doc" ||  strtolower($ext) == "docx" ) {
									$imageName = "excel.svg" ;
								} elseif( strtolower($ext) == "xlsx" ||  strtolower($ext) == "xls" ) {
									$imageName = "mp3.svg" ;
								} elseif( strtolower($ext) == "pptx" ||  strtolower($ext) == "pptm" ||  strtolower($ext) == "ppt"  ) {
									$imageName = "ppt.svg" ;
								} else{
									$imageName = "filedefault.svg" ;
								}
								/*To continue if the file is used for folder creation*/

									if ( $object['Key'] == $prefix."do-not-delete.txt" || $ext == "txt") {
										continue ;
									}

								/*To continue if the file is used for folder creation*/
								$objectName = explode('/', $object['Key']) ;
								$objectName = end($objectName) ;

								$rightSideContent .= '	<tr data-uniquekey="'.$object['Key'].'" data-url="'.$s3Client->getObjectUrl($this->bucket, $object['Key']).'" data-name="'.$objectName.'">
							 <td>
								<div class="custom-checkbox">
								   <label class="custom-control-label" for="customCheck'.$counter1.'"><img src="' . base_url() . 'img/directory_icon/'.$imageName.'" alt=""> <span class="__folderName">'.$objectName.'</span> </label>

								   <span class="__OPenShareBtn">
									  <div class="btn-group">
										 <span class="dropdown-toggle-share" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										 <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
										 </span>
										 <div class="dropdown-menu open-left arrow">

											<button class="dropdown-item __downloadObjectFile" type="button">Download</button>

										 </div>
									  </div>

								   </span>
								</div>
							 </td>
							 <td>'.date('d/m/Y H:i', strtotime($object['LastModified']->format(\DateTime::ISO8601))).'</td>
							 <td>3 Customers</td>
							 <td class="__OPenShareBtn text-center">
								<div class="btn-group">
								   <span class="dropdown-toggle-share" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								   <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
								   </span>
								   <div class="dropdown-menu open-right">

									  <button class="dropdown-item __downloadObjectFile" type="button">Download</button>

								   </div>
								</div>

							 </td>
						  </tr>' ;
							  $counter1++;
							}
						}

					}
					$error = 0 ;
					$message = "In try field";
				} catch (AwsException $e) {
					//echo $e->getMessage() . PHP_EOL;
					$error = 1 ;
					$message = "Network error, pleasetry again later.";
				}


				echo json_encode(['error' => $error, 'message' =>$message, 'rightSideContent' => $rightSideContent]) ;
		} else {
				$error = 1 ;
				$message = "Prefix is required";
				echo json_encode(['error' => $error, 'message' =>$message]) ;
		}

	}


	public function checkCurrentDownloadedObject(){
		$this->load->model('users');

		$objectKey 		= $this->input->post('objectKey') ;
		$costCentreID 	= $this->input->post('costCenter') ;
		$selectedFolder = $this->input->post('selectedFolder') ;

		//check if the folder is still shared or has been deleted
		$currentlySharedStatus = $this->users->currentlySharedStatus($selectedFolder, $costCentreID) ;

		if (!$currentlySharedStatus) {
			$error = 1 ;
			$message = "Network error occured,  please reload the page.";
			echo json_encode(['error' => $error, 'message' =>$message]) ;
			exit ;
		} else {
			$s3Client = new S3Client([
				'region' => 'us-west-2',
				'version' => 'latest',
				'credentials' => $this->credentials
			]);

			try {
				$buckets = $s3Client->getObject(['Bucket' => $this->bucket,  'Key' => $objectKey]);
				$error = 0 ;
				$message = "You can download the file.";
			} catch (AwsException $e) {
				$error = 1 ;
				$message = "Network error occured,  please reload the page.";
				//echo $e->getMessage() . PHP_EOL;
			}

			echo json_encode(['error' => $error, 'message' =>$message]) ;
		}
	}

	/**************User Shared Folders Part Starts Here*******************/

}
