<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Voice\V1\ConnectionPolicy;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

class ConnectionPolicyTargetContext extends InstanceContext {
    /**
     * Initialize the ConnectionPolicyTargetContext
     *
     * @param Version $version Version that contains the resource
     * @param string $connectionPolicySid The SID of the Connection Policy that
     *                                    owns the Target
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, $connectionPolicySid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['connectionPolicySid' => $connectionPolicySid, 'sid' => $sid, ];

        $this->uri = '/ConnectionPolicies/' . \rawurlencode($connectionPolicySid) . '/Targets/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch the ConnectionPolicyTargetInstance
     *
     * @return ConnectionPolicyTargetInstance Fetched ConnectionPolicyTargetInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ConnectionPolicyTargetInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new ConnectionPolicyTargetInstance(
            $this->version,
            $payload,
            $this->solution['connectionPolicySid'],
            $this->solution['sid']
        );
    }

    /**
     * Update the ConnectionPolicyTargetInstance
     *
     * @param array|Options $options Optional Arguments
     * @return ConnectionPolicyTargetInstance Updated ConnectionPolicyTargetInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): ConnectionPolicyTargetInstance {
        $options = new Values($options);

        $data = Values::of([
            'FriendlyName' => $options['friendlyName'],
            'Target' => $options['target'],
            'Priority' => $options['priority'],
            'Weight' => $options['weight'],
            'Enabled' => Serialize::booleanToString($options['enabled']),
        ]);

        $payload = $this->version->update('POST', $this->uri, [], $data);

        return new ConnectionPolicyTargetInstance(
            $this->version,
            $payload,
            $this->solution['connectionPolicySid'],
            $this->solution['sid']
        );
    }

    /**
     * Delete the ConnectionPolicyTargetInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Voice.V1.ConnectionPolicyTargetContext ' . \implode(' ', $context) . ']';
    }
}