<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller  
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('users');
		$this->load->library('jwt');
		$this->load->library('jres');
		$this->load->library('sms');
		$this->load->model('signal');
		$this->load->library('curl');
	}

	function index()
	{
		$this->login();
	}

	function login_asm()
	{
		$number = $this->input->get('number', true);

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( !isset($number) || $number=="" )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$otp_code = rand(0000,9999);

			$this->users->number = $number;
			$this->users->otp = $otp_code;

			$login = $this->users->get_login_asm();


			if( $login[0]['STATUS'] <> 0 )
			{

				//$msg_id = $this->sms->send_sms($number,$otp_code);
				$msg_id = $this->sms->send_sms('918968163577',$otp_code);
				$msg_report = $this->sms->check_sms_report($msg_id);
			}

			header('content-type:application/json');
			echo json_encode($login);
		}
	}

	function new_login()
	{
		$number = $this->input->get('number', true);

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( !isset($number) || $number=="" )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$otp_code = rand(0000,9999);


			$this->users->number = $number;
			$this->users->otp = $otp_code;

			$login = $this->users->get_login_asm();

			if( $login[0]['STATUS'] <> 0 )
			{
				$msg_id = $this->sms->send_sms($number,$otp_code);
				$msg_report = $this->sms->check_sms_report($msg_id);
			}

			header('content-type:application/json');
			echo json_encode($login);
		}
	}

	function login()
	{
		$number 	= $this->input->get('number', true);
		$KeyHash 	= $this->input->get('KeyHash', true);
		$firstStr =  substr($number, 0, 1);
		$mainNumber = $number ;

		if( $firstStr == '0' )
		{
			$number = '44'.substr($number, 1);
		}

		//if( $number == "447599804885" || $number == "918826622177" )
		if( $number == "447599804885")
		{
			$otp_code = "3456";
			$msg_report = "Sent";
			$this->jres->successotp($otp_code, $msg_report);
		}
		else
		{
			if( !isset($number) || $number=="" )
				{
					$msg= 'number cant be empty';
		 			$this->jres->failure($msg);
					exit;
				}
				else
				{
					$this->users->number = $mainNumber;
					$login = $this->users->get_login();
					if(empty($login))
						{
							$msg = 'Wrong Phone Number';
				 			$this->jres->failure($msg);
						}
						else
						{
							//echo '1';
							$otp_code = rand(1111,9999);
							//update otp to database
							$this->users->otp = $otp_code ;
		 					$this->users->ref = $login['ref'];
							$update_otp = $this->users->update_otp();
							//
							//debug($otp_code);
							$msg_id = $this->sms->send_sms($number,$otp_code,$KeyHash);
							$msg_report = $this->sms->check_sms_report($msg_id);
		 					//sleep(1);
		 					$this->jres->successotp($otp_code);
							//sleep(2);
							// Sending OTP
		 				}
				}
		}

	}



	function verify_otp_asm()
	{
		$number = $this->input->post('number', true);
		$device_type = $this->input->post('device_type', true);
		$device_token = $this->input->post('device_token', true);
		$app_type = $this->input->post('app_type', true);
		$device_id = $this->input->post('device_id', true);
		$otp = $this->input->post('otp', true);


		if( !isset($number) || $number=="" )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else if( !isset($otp) || $otp=="" )
		{
			$msg= 'otp cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->number = $number;
			$this->users->otp = $otp;
			$this->users->device_type = $device_type;
			$this->users->device_token = $device_token;
			$this->users->device_id = $device_id;
			$this->users->app_type = $app_type;
			$verified_otp = $this->users->verified_otp_asm();
			//debug($verified_otp[0],1);
			header('content-type:application/json');
			echo json_encode($verified_otp[0]);

		}
	}


	function verify_otp()
	{
		$number = $this->input->post('number', true);
		$device_type = $this->input->post('device_type', true);
		$device_token = $this->input->post('device_token', true); //fcm device token
		$app_type = $this->input->post('app_type', true); // ios or android
		$device_id = $this->input->post('device_id', true);
		$imei_no = $this->input->post('imei_no', true);
		$otp = $this->input->post('otp', true);
		//$serial_number = $this->input->post('serial_number', true);
		$carrier = $this->input->post('carrier', true);
		$model = $this->input->post('model', true);
		$version = $this->input->post('version', true);
		$app_version = $this->input->post('app_version', true);
		$app_name = $this->input->post('app_name', true);

		$this->users->number = $number;
		$this->users->otp = $otp;
		$this->users->device_type = $device_type;
		$this->users->device_token = $device_token;
		$this->users->device_id = $device_id;
		$this->users->app_type = $app_type;
		$this->users->imei_no = $imei_no;
		//$this->users->serial_number = $serial_number;
		$this->users->carrier = $carrier;
		$this->users->model = $model;
		$this->users->version = $version;
		$this->users->app_version = $app_version;
		$this->users->app_name = $app_name;

		$mainNumber = $number ;

		if( !isset($device_id) || $device_id=="" )
			{
				$device_id = '0';
			}

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( $otp == "12-3456-QWERtyuiopxcvfrtgg" )
		{
			//echo "1";
			//$this->users->number = $number;

			$verified_login = $this->users->get_login();
			$this->users->ref = $verified_login['ref'];
			$updateUserDetails = $this->users->update_user_device_token_type_imei();
			//debug($verified_login,1);
			$this->jres->success($verified_login,'otp verified');
		}
		else
		{
			//echo "2";
			if( !isset($number) || $number=="" )
			{
				$msg= 'number cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else if( !isset($otp) || $otp=="" )
			{
				$msg= 'otp cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else
			{
				//echo "3";
				$this->users->number = $mainNumber;
				$login = $this->users->get_login();

				if(empty($login))
					{
						//echo "4";
						$msg = 'Wrong Phone Number11';
			 			$this->jres->failure($msg);
					}
					else
					{
						//~ $this->users->number = $number;
						//~ $this->users->otp = $otp;
						//~ $this->users->device_type = $device_type;
						//~ $this->users->device_token = $device_token;
						//~ $this->users->device_id = $device_id;
						//~ $this->users->app_type = $app_type;
						//~ $this->users->imei_no = $imei_no;
						$verified_otp = $this->users->verified_otp();
						////debug($verified_otp,1);

						if( !empty($verified_otp) || $otp == "3456" )
						{
							$this->users->ref = $login['ref'];
							$this->users->token = $token = $this->jwt->encode($login);
							$update_user_token = $this->users->update_user_token();
							if( !empty($update_user_token) )
							{

								$verified_login = $this->users->get_login();
								$updateUserDetails = $this->users->update_user_device_token_type_imei();
								//Response back to app

								$datTosend = [] ;
								$datTosend['ref'] 			= $verified_login['ref'];
								$datTosend['lindex'] 		= $verified_login['lindex'];
								$datTosend['fullname'] 		= $verified_login['fullname'];
								$datTosend['number'] 		= $verified_login['number'];
								$datTosend['emailaddress']  = $verified_login['emailaddress'];

								$getUserTemplateData		=  $this->users->get_user_template_settings($verified_login['number']);

								if ($getUserTemplateData) {
									$datTosend['updateTemplateSettings']	 = '1' ;
									$datTosend['triggerSos'] 				= $getUserTemplateData['trigger_sos'];
									$datTosend['presslabel'] 				= $getUserTemplateData['sos_press_level'];
									$datTosend['ripAlarm'] 					= $getUserTemplateData['rip_alarm'];
									$datTosend['fallDetect'] 				= $getUserTemplateData['fall_detect'];
									$datTosend['fallSenstivity'] 			= $getUserTemplateData['fall_detect_senstivity'];
									$datTosend['minmandowntimerminutes'] 	= $getUserTemplateData['min_man_down_timer_minutes'];
									$datTosend['minmandowntimerseconds'] 	= $getUserTemplateData['min_man_down_timer_seconds'];
									$datTosend['maxmandowntimerminutes'] 	= $getUserTemplateData['max_man_down_timer_minutes'];
									$datTosend['maxmandowntimerseconds'] 	= $getUserTemplateData['max_man_down_timer_seconds'];
									$datTosend['minambertimerhours'] 		= $getUserTemplateData['min_amber_timer_hours'];
									$datTosend['minambertimerminutes'] 		= $getUserTemplateData['min_amber_timer_minutes'];
									$datTosend['maxambertimerhours'] 		= $getUserTemplateData['max_amber_timer_hours'];
									$datTosend['maxambertimerminutes'] 		= $getUserTemplateData['max_amber_timer_minutes'];
									$datTosend['gpsfrequencyupdate'] 		= $getUserTemplateData['gps_update_frequ_minutes'];
									$datTosend['settings'] 					= $getUserTemplateData['settings'];
									$datTosend['gpsposcriteria'] 			= $getUserTemplateData['gps_pos_criteria'];
									$datTosend['settingName'] 				= $getUserTemplateData['device_settings_name'];
									$datTosend['settingId'] 				= $getUserTemplateData['id'];
									$datTosend['sms'] 						= $getUserTemplateData['sms'];
									$datTosend['finger_print_lock'] 		= $getUserTemplateData['finger_print_lock'];
									$datTosend['calendar'] 					= $getUserTemplateData['calendar'];
									$datTosend['activity_based_locations'] 	= $getUserTemplateData['activity_based_locations'];
									$datTosend['coorrdinates_refresh_rate'] = $getUserTemplateData['coorrdinates_refresh_rate'];
									$datTosend['escalation_status'] 		= $getUserTemplateData['escalation_status'];
								} else {
									$datTosend['updateTemplateSettings'] = '0' ;
								}
								
								$getUserUnreadMessages		=  $this->users->get_status_unread_messages_login($verified_login['number']);
								
								if ($getUserUnreadMessages > 0) {
									$datTosend['unread_messages'] = '1' ; //Some messages are unread.
								} else {
									$datTosend['unread_messages'] = '0' ;
								}
								
								
								//To check if geofencing is set or not
								
								$getUserGeofenceSettings =  $this->users->get_user_geofence_settings($verified_login['lindex']);
								
								if ($getUserGeofenceSettings) {
									$datTosend['geofence_settings'] 		= '1' ;
									$datTosend['geofence_latitude'] 		= $getUserGeofenceSettings['latitude'];
									$datTosend['geofence_longitude'] 		= $getUserGeofenceSettings['longitude'];
									$datTosend['geofence_radius'] 			= $getUserGeofenceSettings['radius'];
									$datTosend['geofence_name'] 			= $getUserGeofenceSettings['homesafe_name'];
								} else {
									$datTosend['geofence_settings'] 		= '0' ;
								}
								
								//To check if geofencing is set or not
								
								
								
								//Response back to app

								//var_dump($verified_login);
								$this->jres->success($datTosend,'otp verified');
							}
							else
							{
								$this->jres->failure('wrong otp detail');
							}
						}
						else
						{
							$this->jres->failure('wrong otp');
						}

					}
			}
		}


	}


	function logout()
	{
		$ref = $this->input->get('ref',true);
		if( !isset($ref) || $ref=="" )
		{
			$msg= 'login id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $ref;
			$logout = $this->users->user_logout();
			if( !empty($logout) )
				{
					$this->jres->successotp('','logout');
				}
				else
				{
					$this->jres->failure('invalid login id');
				}
		}
	}

	function location_update()
	{
		//echo json_encode([ 'msg' => 'asm' ]);exit;
		$ref_id = $this->input->post('ref_id',true);
		//$ref_id = '004862';
		$lat = $this->input->post('lat',true);
		$long = $this->input->post('long',true);
		$DateTime = $this->input->post('datetime', true);
		$IMEI = $this->input->post('imei', true);
		$number = $this->input->post('number', true);
		$messageType = $this->input->post('messageType', true);
		$posdatatime = $this->input->post('posdatatime', true);
		$postype = $this->input->post('postype', true);
		$status = $this->input->post('status', true);
		$interval = $this->input->post('interval', true);
		$speed = $this->input->post('speed', true);
		$serialNumber = $this->input->post('serialNumber', true);

		if( !isset($lat) || $lat=="" )
		{
			// $msg= 'lat cant be empty';
 		// 	$this->jres->failure($msg);
			// exit;
			$lat = '0.0000000';
		}
		if( !isset($long) || $long=="" )
		{
			// $msg= 'long cant be empty';
 		// 	$this->jres->failure($msg);
			// exit;
			$long = '0.0000000';
		}


		if( !isset($ref_id) || $ref_id=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			/*$this->signal->number = $number;
			$get_device_type = $this->signal->get_device_type();

			if($get_device_type['device_type'] == 'android' || $get_device_type['device_type'] == 'Android'){*/
			$checkNumberBlock = $this->signal->checkNumberBlock($number);
			if( empty($checkNumberBlock->id) ){
				
				/* Functionality for GPS WOX*/
				
				if ( $number == "07900162308" || $number == "07920360697" || $number == "07920504038" || $number == "07385400530" || $number == "003197027756192" || $number == "003197021924410" || $number == "003197020584630" || $number == "07794297734" || $number == "07972743991" || $number == "07974950352" || $number == "07972743786" || $number == "07971058990" || $number == "07773647664" || $number == "07794268750" ){  

					if ( $lat && $long ) {
					
						$mt 			  = explode(' ', microtime());
						$currentTimeStamp = ((int)$mt[1]) * 1000 + ((int)round($mt[0] * 1000));
					
						$url = 'http://165.232.32.11/insert.php?uniqueId='.$number.'&protocol=PRT&altitude=45000&course=150&latitude='.$lat.'&longitude='.$long.'&speed=1&fixTime='.$currentTimeStamp.'&attributes={"batterylevel":"1","name":"steve"}';
						
						$crl = curl_init();

						curl_setopt($crl, CURLOPT_URL, $url);
						curl_setopt($crl, CURLOPT_FRESH_CONNECT, true);
						curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
						$response = curl_exec($crl);


						curl_close($crl);
						
						
					
					}


				}
				
				if($serialNumber) {
					
					$checkUserAddedForGeofence = $this->users->checkUserAddedForGeofence($serialNumber);
					
					if ($checkUserAddedForGeofence) {
					
						
						if ( $lat && $long ) {
					
							$mt 			  = explode(' ', microtime());
							$currentTimeStamp = ((int)$mt[1]) * 1000 + ((int)round($mt[0] * 1000));
						
							$url = 'http://165.232.32.11/insert.php?uniqueId='.$checkUserAddedForGeofence['unique_value_gpswox'].'&protocol=PRT&altitude=45000&course=150&latitude='.$lat.'&longitude='.$long.'&speed=1&fixTime='.$currentTimeStamp.'&attributes={"batterylevel":"1","name":"steve"}';
							
							$crl = curl_init();

							curl_setopt($crl, CURLOPT_URL, $url);
							curl_setopt($crl, CURLOPT_FRESH_CONNECT, true);
							curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
							$response = curl_exec($crl);


							curl_close($crl);
						
						
					
						}
					
					}
					
				}

				/* Functionality for GPS WOX*/
				
				
				
				if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    //die("Couldn't create socket: [$errorcode] $errormsg \n");
						    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
						    exit;
						}

						if(!socket_connect($sock , 'mobileapps.orbisprotect.com' , 5055))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);
							if( $errormsg == 'Connection timed out' )
						    {
						    	socket_close($sock);
						    }
						    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
						    exit;
						}else{

						$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

						$checksum = md5($signals);

						$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;

						//Send the message to the server
						if( ! socket_send ( $sock , $message , strlen($message) , 0))
						 {
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    $data['error_msg'] = "Could not send data: [$errorcode] $errormsg";
						    $socket_log = $this->signal->socket_log($data);
						   // die("Could not send data: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
						    exit;
						}
						else
						{
							$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
							$data['DateTime'] = $DateTime;
							$data['IMEI'] = $IMEI;
							$data['number'] = $number;
							$data['messageType'] = $messageType;
							$data['lat'] = $lat;
							$data['long'] = $long;
							$data['posdatatime'] = $posdatatime;
							$data['postype'] = $postype;
							$data['status'] = $status;
							$data['interval'] = $interval;
							$data['speed'] = $speed;
							$data['checksum'] = $checksum;
							$report_trigger = $this->signal->asm_trigger($data);
						}
						$this->jres->success_message('Signals send successfully');
						socket_close($sock);

					//}

					$this->users->ref_id = $ref_id;
					$this->users->lat = $lat;
					$this->users->long = $long;
					$this->users->status = $status;
					$update_location = $this->users->update_location();
					if( $update_location > 0)
					{
						$this->jres->success_message('Signals and location updated');
					}
					else
					{
						$this->jres->failure('','location updated fail');
					}
				}
			}
		}

	}

	function new_location_update()
	{
		//echo json_encode([ 'msg' => 'sentinel' ]);exit;
		$ref_id = $this->input->post('ref_id',true);
		$lat = $this->input->post('lat',true);
		$long = $this->input->post('long',true);
		$DateTime = $this->input->post('datetime', true);
		$IMEI = $this->input->post('imei', true);
		$number = $this->input->post('number', true);
		$messageType = $this->input->post('messageType', true);
		$posdatatime = $this->input->post('posdatatime', true);
		$postype = $this->input->post('postype', true);
		$status = $this->input->post('status', true);
		$interval = $this->input->post('interval', true);
		$speed = $this->input->post('speed', true);

		if( !isset($ref_id) || $ref_id=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}elseif( !isset($lat) || $lat=="" )
		{
			$msg= 'lat cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($long) || $long=="" )
		{
			$msg= 'long cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			/*$this->signal->number = $number;
			$get_device_type = $this->signal->get_device_type();

			if($get_device_type['device_type'] == 'android' || $get_device_type['device_type'] == 'Android'){*/

				if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    //die("Couldn't create socket: [$errorcode] $errormsg \n");
						    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
						    exit;
						}

						if(!socket_connect($sock , '81.142.251.60' , 8731))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    //die("Could not connect: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
						    exit;
						}
						$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

						$checksum = md5($signals);

						$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;

						//Send the message to the server
						if( ! socket_send ( $sock , $message , strlen($message) , 0))
						 {
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						   // die("Could not send data: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
						    exit;
						}else
						{
							$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
							$data['DateTime'] = $DateTime;
							$data['IMEI'] = $IMEI;
							$data['number'] = $number;
							$data['messageType'] = $messageType;
							$data['lat'] = $lat;
							$data['long'] = $long;
							$data['posdatatime'] = $posdatatime;
							$data['postype'] = $postype;
							$data['status'] = $status;
							$data['interval'] = $interval;
							$data['speed'] = $speed;
							$data['checksum'] = $checksum;
							$report_trigger = $this->signal->asm_trigger($data);
						}
						//$this->jres->success_message('Signals send successfully');
						socket_close($sock);

					//}

					$this->users->ref_id = $ref_id;
					$this->users->lat = $lat;
					$this->users->long = $long;
					$this->users->status = $status;
					$update_location = $this->users->update_location();
					if( $update_location > 0)
					{
						$this->jres->success_message('Signals and location updated');
					}
					else
					{
						$this->jres->failure('','location updated fail');
					}
		}

	}

	function get_setting_lwd()
	{
		$refID = $this->input->get('ref');

		if( !isset($refID) || $refID=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $refID;
			$get_lwd_setting = $this->users->get_lwd_setting();
			if($get_lwd_setting)
			{
				$this->jres->success( $get_lwd_setting );
			}
			else
			{
				$this->jres->failure('no row found');
			}
		}
	}

	function check_signal()
	{
		$refID = $this->input->get('ref');

		if( !isset($refID) || $refID=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $refID;
			$get_signal_status = $this->users->get_signal_status();
			if($get_signal_status)
			{
				if($get_signal_status['signal_kill'] == '0')
				{
					$get_signal_status['signal_kill'] = 'signal on';
				}
				if($get_signal_status['signal_kill'] == '1')
				{
					$get_signal_status['signal_kill'] = 'signal off';
				}
				$this->jres->success( $get_signal_status );
			}
			else
			{
				$this->jres->failure('no row found');
			}
		}
	}

	function sms_test()
	{
		echo $msg_id = $this->sms->send_sms('918826622177','1111');
		echo '------<br>';
		echo $this->sms->check_sms_report($msg_id);
	}

	function new_detail(){
		$response = $this->users->get_detail();
		debug($response);
	}

	function new_operators(){
		$escalation = $this->users->escalation();
		debug($escalation);
	}

	function verify_otp_operators()
	{
		$number = $this->input->post('number', true);
		$device_type = $this->input->post('device_type', true);
		$device_token = $this->input->post('device_token', true);
		$app_type = $this->input->post('app_type', true);
		$device_id = $this->input->post('device_id', true);
		$otp = $this->input->post('otp', true);
		if( !isset($device_id) || $device_id=="" )
			{
				$device_id = '0';
			}

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( $otp == "3456" )
		{
			//echo "1";
			$this->users->number = $number;
			$verified_login = $this->users->get_login();
			//debug($verified_login,1);
			// $get_operator_lindex = $this->users->get_operator_lindex($number);
			if( empty($verified_login['lindex']) || $verified_login['lindex'] == '0'  )
			{
				$verified_login['lindex'] = "58238578";
			}
			$this->jres->success($verified_login,'otp verified');
		}
		else
		{
			//echo "2";
			if( !isset($number) || $number=="" )
			{
				$msg= 'number cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else if( !isset($otp) || $otp=="" )
			{
				$msg= 'otp cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else
			{
				//echo "3";
				$this->users->number = $number;
				$login = $this->users->get_login();

				if(empty($login))
					{
						//echo "4";
						$msg = 'Wrong Phone Number11';
			 			$this->jres->failure($msg);
					}
					else
					{
						$this->users->number = $number;
						$this->users->otp = $otp;
						$this->users->device_type = $device_type;
						$this->users->device_token = $device_token;
						$this->users->device_id = $device_id;
						$this->users->app_type = $app_type;
						$verified_otp = $this->users->verified_otp();
						////debug($verified_otp,1);
						if( !empty($verified_otp) )
						{
							$this->users->ref = $login['ref'];
							$this->users->token = $token = $this->jwt->encode($login);
							$update_user_token = $this->users->update_user_token();
							if( !empty($update_user_token) )
							{
								$verified_login = $this->users->get_login();
								if( empty($verified_login['lindex']) || $verified_login['lindex'] == '0'  )
								{
									$verified_login['lindex'] = "58238578";
								}

								//var_dump($verified_login);
								$this->jres->success($verified_login,'otp verified');
							}
							else
							{
								$this->jres->failure('wrong otp detail');
							}
						}
						else
						{
							$this->jres->failure('wrong otp');
						}

					}
			}
		}


	} // verify otp operator

	function get_escalation(){
		$lindex = $this->input->post('lindex');
		if( !isset($lindex) || $lindex=="" )
		{
			$lindex= 'Lindex is empty';
 			$this->jres->failure($lindex);
			exit;
		}
		else
		{
			$escalation_detail = $this->users->escalation_detail($lindex);
			if(!empty($escalation_detail))
			{
				for( $i=0; $i<count( $escalation_detail ); $i++ )
				{
					if( $escalation_detail[$i]['OTHER'] == '' || empty($escalation_detail[$i]['OTHER']) )
					{
						$escalation_detail[$i]['OTHER'] = '0';
					}
					if( $escalation_detail[$i]['PAGER'] == '' || empty($escalation_detail[$i]['PAGER']) )
					{
						$escalation_detail[$i]['PAGER'] = '0';
					}
					if( $escalation_detail[$i]['EMAIL'] == '' || empty($escalation_detail[$i]['EMAIL']) )
					{
						$escalation_detail[$i]['EMAIL'] = '0';
					}
					if( $escalation_detail[$i]['HOMETELEPHONE'] == '' || empty($escalation_detail[$i]['HOMETELEPHONE']) )
					{
						$escalation_detail[$i]['HOMETELEPHONE'] = '0';
					}
					if( $escalation_detail[$i]['MOBILE'] == '' || empty($escalation_detail[$i]['MOBILE']) )
					{
						$escalation_detail[$i]['MOBILE'] = '0';
					}

					if( $escalation_detail[$i]['SITEINDEX'] == '' || empty($escalation_detail[$i]['SITEINDEX']) )
					{
						$escalation_detail[$i]['SITEINDEX'] = '0';
					}
					if( $escalation_detail[$i]['CONTACTINDEX'] == '' || empty($escalation_detail[$i]['CONTACTINDEX']) )
					{
						$escalation_detail[$i]['CONTACTINDEX'] = '0';
					}
					if( $escalation_detail[$i]['PRIORITY'] == '' || empty($escalation_detail[$i]['PRIORITY']) )
					{
						$escalation_detail[$i]['PRIORITY'] = '0';
					}
					if( $escalation_detail[$i]['FULLNAME'] == '' || empty($escalation_detail[$i]['FULLNAME']) )
					{
						$escalation_detail[$i]['FULLNAME'] = '0';
					}
					if( $escalation_detail[$i]['CTYPE'] == '' || empty($escalation_detail[$i]['CTYPE']) )
					{
						$escalation_detail[$i]['CTYPE'] = '0';
					}
					if( $escalation_detail[$i]['DESCRIPTION'] == '' || empty($escalation_detail[$i]['DESCRIPTION']) )
					{
						$escalation_detail[$i]['DESCRIPTION'] = '0';
					}
					if( $escalation_detail[$i]['BUSINESSTELEPHONE'] == '' || empty($escalation_detail[$i]['BUSINESSTELEPHONE']) )
					{
						$escalation_detail[$i]['BUSINESSTELEPHONE'] = '0';
					}

				}
				$this->jres->success($escalation_detail);
			}
			else
			{
				$this->jres->failure('no data available');
			}
		}
	}

	function escalation_mail()
	{

		$subject = $this->input->post('subject');

		if(!empty($subject)){

		//$escalation_detail = json_decode($this->input->post('parameter',true),true);
		$escalation_detail = json_decode($this->input->post('parameter'),true);
		//debug($escalation_detail,1);
		//$escalation_detail = $this->input->post('parameter');
		//debug($escalation_detail,1);
		//print_r($escalation_detail); exit;
		//debug($this->input->post('parameter')); exit;

    $lindex = '';
    $username = '';
    $number = '';
    for( $m=0; $m<count($escalation_detail); $m++ )
		{
			 $lindex = $escalation_detail[0]['SITEINDEX'];
		}

    //get phone number of operator
    // if( !empty($lindex) ){
		  // $get_phone_number = $this->users->get_phone_number($lindex);
    // }else{
      // $this->jres->failure('lindex or siteindex is not defined');
      // exit;
    // }
	  //debug($get_detail,1);

    //get username and phone number
    if(!empty($lindex)){
      $get_detail = $this->users->get_operator_detail($lindex);
	  //debug($get_detail,1);
        if(!empty($get_detail))
        {
          $username = $get_detail->loginname;
          $number = $get_detail->number;
        }
    }else{
      $this->jres->failure('wrong phone number or data not available');
      exit;
    }

		//$escalation_detail = $this->users->escalation_detail($lindex);
		//$get_operator_lindex = $this->users->get_operator_lindex($lindex);
			//debug($escalation_detail);
		$array = '<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
	<head>
		<!-- NAME: 1 COLUMN -->
		<!--[if gte mso 15]>
		<xml>
			<o:OfficeDocumentSettings>
			<o:AllowPNG/>
			<o:PixelsPerInch>96</o:PixelsPerInch>
			</o:OfficeDocumentSettings>
		</xml>
		<![endif]-->
		<meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
		<title>*HS2 Escalation Change Request *CUSTOMER_NAME* *PHONE* *</title>

    <style type="text/css">
		p{
			margin:10px 0;
			padding:0;
		}
		table{
			border-collapse:collapse;
		}
		h1,h2,h3,h4,h5,h6{
			display:block;
			margin:0;
			padding:0;
		}
		img,a img{
			border:0;
			height:auto;
			outline:none;
			text-decoration:none;
		}
		body,#bodyTable,#bodyCell{
			height:100%;
			margin:0;
			padding:0;
			width:100%;
		}
		.mcnPreviewText{
			display:none !important;
		}
		#outlook a{
			padding:0;
		}
		img{
			-ms-interpolation-mode:bicubic;
		}
		table{
			mso-table-lspace:0pt;
			mso-table-rspace:0pt;
		}
		.ReadMsgBody{
			width:100%;
		}
		.ExternalClass{
			width:100%;
		}
		p,a,li,td,blockquote{
			mso-line-height-rule:exactly;
		}
		a[href^=tel],a[href^=sms]{
			color:inherit;
			cursor:default;
			text-decoration:none;
		}
		p,a,li,td,body,table,blockquote{
			-ms-text-size-adjust:100%;
			-webkit-text-size-adjust:100%;
		}
		.ExternalClass,.ExternalClass p,.ExternalClass td,.ExternalClass div,.ExternalClass span,.ExternalClass font{
			line-height:100%;
		}
		a[x-apple-data-detectors]{
			color:inherit !important;
			text-decoration:none !important;
			font-size:inherit !important;
			font-family:inherit !important;
			font-weight:inherit !important;
			line-height:inherit !important;
		}
		#bodyCell{
			padding:10px;
		}
		.templateContainer{
			max-width:600px !important;
		}
		.ul_li li { list-style: none }
		a.mcnButton{
			display:block;
		}
		.mcnImage,.mcnRetinaImage{
			vertical-align:bottom;
		}
		.mcnTextContent{
			word-break:break-word;
		}
		.mcnTextContent img{
			height:auto !important;
		}
		.mcnDividerBlock{
			table-layout:fixed !important;
		}
		body,#bodyTable{
			/*@editable*/background-color:#FAFAFA;
		}

		#bodyCell{
			/*@editable*/border-top:0;
		}
	/*
	@tab Page
	@section Email Border
	@tip Set the border for your email.
	*/
		.templateContainer{
			/*@editable*/border:0;
		}
	/*
	@tab Page
	@section Heading 1
	@tip Set the styling for all first-level headings in your emails. These should be the largest of your headings.
	@style heading 1
	*/
		h1{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:26px;
			/*@editable*/font-style:normal;
			/*@editable*/font-weight:bold;
			/*@editable*/line-height:125%;
			/*@editable*/letter-spacing:normal;
			/*@editable*/text-align:left;
		}
	/*
	@tab Page
	@section Heading 2
	@tip Set the styling for all second-level headings in your emails.
	@style heading 2
	*/
		h2{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:22px;
			/*@editable*/font-style:normal;
			/*@editable*/font-weight:bold;
			/*@editable*/line-height:125%;
			/*@editable*/letter-spacing:normal;
			/*@editable*/text-align:left;
		}
	/*
	@tab Page
	@section Heading 3
	@tip Set the styling for all third-level headings in your emails.
	@style heading 3
	*/
		h3{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:20px;
			/*@editable*/font-style:normal;
			/*@editable*/font-weight:bold;
			/*@editable*/line-height:125%;
			/*@editable*/letter-spacing:normal;
			/*@editable*/text-align:left;
		}
	/*
	@tab Page
	@section Heading 4
	@tip Set the styling for all fourth-level headings in your emails. These should be the smallest of your headings.
	@style heading 4
	*/
		h4{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:18px;
			/*@editable*/font-style:normal;
			/*@editable*/font-weight:bold;
			/*@editable*/line-height:125%;
			/*@editable*/letter-spacing:normal;
			/*@editable*/text-align:left;
		}

		#templatePreheader{
			/*@editable*/background-color:#FAFAFA;
			/*@editable*/background-image:none;
			/*@editable*/background-repeat:no-repeat;
			/*@editable*/background-position:center;
			/*@editable*/background-size:cover;
			/*@editable*/border-top:0;
			/*@editable*/border-bottom:0;
			/*@editable*/padding-top:9px;
			/*@editable*/padding-bottom:9px;
		}

		#templatePreheader .mcnTextContent,#templatePreheader .mcnTextContent p{
			/*@editable*/color:#656565;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:12px;
			/*@editable*/line-height:150%;
			/*@editable*/text-align:left;
		}

		#templatePreheader .mcnTextContent a,#templatePreheader .mcnTextContent p a{
			/*@editable*/color:#656565;
			/*@editable*/font-weight:normal;
			/*@editable*/text-decoration:underline;
		}

		#templateHeader{
			/*@editable*/background-color:#FFFFFF;
			/*@editable*/background-image:none;
			/*@editable*/background-repeat:no-repeat;
			/*@editable*/background-position:center;
			/*@editable*/background-size:cover;
			/*@editable*/border-top:0;
			/*@editable*/border-bottom:0;
			/*@editable*/padding-top:9px;
			/*@editable*/padding-bottom:0;
		}

		#templateHeader .mcnTextContent,#templateHeader .mcnTextContent p{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:16px;
			/*@editable*/line-height:150%;
			/*@editable*/text-align:left;
		}

		#templateHeader .mcnTextContent a,#templateHeader .mcnTextContent p a{
			/*@editable*/color:#2BAADF;
			/*@editable*/font-weight:normal;
			/*@editable*/text-decoration:underline;
		}

		#templateBody{
			/*@editable*/background-color:#FFFFFF;
			/*@editable*/background-image:none;
			/*@editable*/background-repeat:no-repeat;
			/*@editable*/background-position:center;
			/*@editable*/background-size:cover;
			/*@editable*/border-top:0;
			/*@editable*/border-bottom:2px solid #EAEAEA;
			/*@editable*/padding-top:0;
			/*@editable*/padding-bottom:9px;
		}

		#templateBody .mcnTextContent,#templateBody .mcnTextContent p{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:16px;
			/*@editable*/line-height:150%;
			/*@editable*/text-align:left;
		}

		#templateBody .mcnTextContent a,#templateBody .mcnTextContent p a{
			/*@editable*/color:#2BAADF;
			/*@editable*/font-weight:normal;
			/*@editable*/text-decoration:underline;
		}

		#templateFooter{
			/*@editable*/background-color:#fafafa;
			/*@editable*/background-image:url("https://gallery.mailchimp.com/63ca19c645f0b2816eaff297d/images/e4b05e3d-72a1-4e86-ae58-9d0200e63a44.png");
			/*@editable*/background-repeat:no-repeat;
			/*@editable*/background-position:center;
			/*@editable*/background-size:auto;
			/*@editable*/border-top:0;
			/*@editable*/border-bottom:0;
			/*@editable*/padding-top:10px;
			/*@editable*/padding-bottom:10px;
		}
		#templateFooter .mcnTextContent,#templateFooter .mcnTextContent p{
			/*@editable*/color:#656565;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:12px;
			/*@editable*/line-height:150%;
			/*@editable*/text-align:center;
		}

		#templateFooter .mcnTextContent a,#templateFooter .mcnTextContent p a{
			/*@editable*/color:#0909a7;
			/*@editable*/font-weight:normal;
			/*@editable*/text-decoration:underline;
		}
	@media only screen and (min-width:768px){
		.templateContainer{
			width:600px !important;
		}

}	@media only screen and (max-width: 480px){
		body,table,td,p,a,li,blockquote{
			-webkit-text-size-adjust:none !important;
		}

}	@media only screen and (max-width: 480px){
		body{
			width:100% !important;
			min-width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		#bodyCell{
			padding-top:10px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnRetinaImage{
			max-width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImage{
			width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnCartContainer,.mcnCaptionTopContent,.mcnRecContentContainer,.mcnCaptionBottomContent,.mcnTextContentContainer,.mcnBoxedTextContentContainer,.mcnImageGroupContentContainer,.mcnCaptionLeftTextContentContainer,.mcnCaptionRightTextContentContainer,.mcnCaptionLeftImageContentContainer,.mcnCaptionRightImageContentContainer,.mcnImageCardLeftTextContentContainer,.mcnImageCardRightTextContentContainer,.mcnImageCardLeftImageContentContainer,.mcnImageCardRightImageContentContainer{
			max-width:100% !important;
			width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnBoxedTextContentContainer{
			min-width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageGroupContent{
			padding:9px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnCaptionLeftContentOuter .mcnTextContent,.mcnCaptionRightContentOuter .mcnTextContent{
			padding-top:9px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageCardTopImageContent,.mcnCaptionBottomContent:last-child .mcnCaptionBottomImageContent,.mcnCaptionBlockInner .mcnCaptionTopContent:last-child .mcnTextContent{
			padding-top:18px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageCardBottomImageContent{
			padding-bottom:9px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageGroupBlockInner{
			padding-top:0 !important;
			padding-bottom:0 !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageGroupBlockOuter{
			padding-top:9px !important;
			padding-bottom:9px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnTextContent,.mcnBoxedTextContentColumn{
			padding-right:18px !important;
			padding-left:18px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageCardLeftImageContent,.mcnImageCardRightImageContent{
			padding-right:18px !important;
			padding-bottom:0 !important;
			padding-left:18px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcpreview-image-uploader{
			display:none !important;
			width:100% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Heading 1
	@tip Make the first-level headings larger in size for better readability on small screens.
	*/
		h1{
			/*@editable*/font-size:22px !important;
			/*@editable*/line-height:125% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Heading 2
	@tip Make the second-level headings larger in size for better readability on small screens.
	*/
		h2{
			/*@editable*/font-size:20px !important;
			/*@editable*/line-height:125% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Heading 3
	@tip Make the third-level headings larger in size for better readability on small screens.
	*/
		h3{
			/*@editable*/font-size:18px !important;
			/*@editable*/line-height:125% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Heading 4
	@tip Make the fourth-level headings larger in size for better readability on small screens.
	*/
		h4{
			/*@editable*/font-size:16px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Boxed Text
	@tip Make the boxed text larger in size for better readability on small screens. We recommend a font size of at least 16px.
	*/
		.mcnBoxedTextContentContainer .mcnTextContent,.mcnBoxedTextContentContainer .mcnTextContent p{
			/*@editable*/font-size:14px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){

		#templatePreheader{
			/*@editable*/display:block !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Preheader Text
	@tip Make the preheader text larger in size for better readability on small screens.
	*/
		#templatePreheader .mcnTextContent,#templatePreheader .mcnTextContent p{
			/*@editable*/font-size:14px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Header Text
	@tip Make the header text larger in size for better readability on small screens.
	*/
		#templateHeader .mcnTextContent,#templateHeader .mcnTextContent p{
			/*@editable*/font-size:16px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Body Text
	@tip Make the body text larger in size for better readability on small screens. We recommend a font size of at least 16px.
	*/
		#templateBody .mcnTextContent,#templateBody .mcnTextContent p{
			/*@editable*/font-size:16px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Footer Text
	@tip Make the footer content text larger in size for better readability on small screens.
	*/
		#templateFooter .mcnTextContent,#templateFooter .mcnTextContent p{
			/*@editable*/font-size:14px !important;
			/*@editable*/line-height:150% !important;
		}

}</style></head>
    <body>
		<!--*|IF:MC_PREVIEW_TEXT|*-->
		<!--[if !gte mso 9]><!----><span class="mcnPreviewText" style="display:none; font-size:0px; line-height:0px; max-height:0px; max-width:0px; opacity:0; overflow:hidden; visibility:hidden; mso-hide:all;">*|MC_PREVIEW_TEXT|*</span><!--<![endif]-->
		<!--*|END:IF|*-->
        <center>
            <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable">
                <tr>
                    <td align="center" valign="top" id="bodyCell">
                        <!-- BEGIN TEMPLATE // -->
						<!--[if (gte mso 9)|(IE)]>
						<table align="center" border="0" cellspacing="0" cellpadding="0" width="600" style="width:600px;">
						<tr>
						<td align="center" valign="top" width="600" style="width:600px;">
						<![endif]-->
                        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="templateContainer">
                            <tr>
                                <td valign="top" id="templatePreheader"><table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnTextBlock" style="min-width:100%;">
    <tbody class="mcnTextBlockOuter">
        <tr>
            <td valign="top" class="mcnTextBlockInner" style="padding-top:9px;">
              	<!--[if mso]>
				<table align="left" border="0" cellspacing="0" cellpadding="0" width="100%" style="width:100%;">
				<tr>
				<![endif]-->

				<!--[if mso]>
				<td valign="top" width="600" style="width:600px;">
				<![endif]-->
                <table align="left" border="0" cellpadding="0" cellspacing="0" style="max-width:100%; min-width:100%;" width="100%" class="mcnTextContentContainer">
                    <tbody><tr>

                        <td valign="top" class="mcnTextContent" style="padding: 0px 18px 9px; text-align: center;">

                            <a href="*|ARCHIVE|*" target="_blank">View this email in your browser</a>
                        </td>
                    </tr>
                </tbody></table>
				<!--[if mso]>
				</td>
				<![endif]-->

				<!--[if mso]>
				</tr>
				</table>
				<![endif]-->
            </td>
        </tr>
    </tbody>
</table></td>
                            </tr>
                            <tr>
                                <td valign="top" id="templateHeader"><table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnImageBlock" style="min-width:100%;">
    <tbody class="mcnImageBlockOuter">
            <tr>
                <td valign="top" style="padding:0px" class="mcnImageBlockInner">
                    <table align="left" width="100%" border="0" cellpadding="0" cellspacing="0" class="mcnImageContentContainer" style="min-width:100%;">
                        <tbody><tr>
                            <td class="mcnImageContent" valign="top" style="padding-right: 0px; padding-left: 0px; padding-top: 0; padding-bottom: 0; text-align:center;">





                            </td>
                        </tr>
                    </tbody></table>
                </td>
            </tr>
    </tbody>
</table></td>
                            </tr>
                            <tr>
                                <td valign="top" id="templateBody"><table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnTextBlock" style="min-width:100%;">
    <tbody class="mcnTextBlockOuter">
        <tr>
            <td valign="top" class="mcnTextBlockInner" style="padding-top:9px;">
              	<!--[if mso]>
				<table align="left" border="0" cellspacing="0" cellpadding="0" width="100%" style="width:100%;">
				<tr>
				<![endif]-->

				<!--[if mso]>
				<td valign="top" width="600" style="width:600px;">
				<![endif]-->
                <table align="left" border="0" cellpadding="0" cellspacing="0" style="max-width:100%; min-width:100%;" width="100%" class="mcnTextContentContainer">
                    <tbody><tr>

                        <td valign="top" class="mcnTextContent" style="padding-top:0; padding-right:18px; padding-bottom:9px; padding-left:18px;">

                            <br>
Hello,<br>
<br>
 '.$username.' with Phone Number '.$number.' has requested to change their escalation details. Following are the requested changes:
<ol class="ul_li">';
for( $i = 0; $i<count($escalation_detail); $i++ )
{
	$array .= '<li> FULLNAME: '.$escalation_detail[$i]['FULLNAME'].'</li>';
	$array .= '<li> EMAIL: '.$escalation_detail[$i]['EMAIL'].'</li>';
	$array .= '<li> MOBILE: '.$escalation_detail[$i]['MOBILE'].'</li>';
	$array .= '<li> BUSINESSTELEPHONE: '.$escalation_detail[$i]['BUSINESSTELEPHONE'].'</li>';
	$array .= '<li> HOMETELEPHONE: '.$escalation_detail[$i]['HOMETELEPHONE'].'</li>';
	$array .= '<li> PRIORITY: '.$escalation_detail[$i]['PRIORITY'].'</li>';
	$array .= '<br>';
}

		// $array .= '<li>'.$escalation_detail['HOMETELEPHONE'].'</li>';
		// $array .= '<li>'.$escalation_detail['SITEINDEX'].'</li>';
		// $array .= '<li>'.$escalation_detail['EMAIL'].'</li>';
		// $array .= '<li>'.$escalation_detail['FULLNAME'].'</li>';
		// $array .= '<li>'.$escalation_detail['BUSINESSTELEPHONE'].'</li>';
		// $array .= '<li>'.$escalation_detail['MOBILE'].'</li>';
$array .= '</ol>
Thanks,<br>
	Escalation Automailer.&nbsp;
                        </td>
                    </tr>
                </tbody></table>
				<!--[if mso]>
				</td>
				<![endif]-->

				<!--[if mso]>
				</tr>
				</table>
				<![endif]-->
            </td>
        </tr>
    </tbody>
</table></td>
                            </tr>
                            <tr>
                                <td valign="top" id="templateFooter"><table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnTextBlock" style="min-width:100%;">
    <tbody class="mcnTextBlockOuter">
        <tr>
            <td valign="top" class="mcnTextBlockInner" style="padding-top:9px;">
              	<!--[if mso]>
				<table align="left" border="0" cellspacing="0" cellpadding="0" width="100%" style="width:100%;">
				<tr>
				<![endif]-->

				<!--[if mso]>
				<td valign="top" width="600" style="width:600px;">
				<![endif]-->
                <table align="left" border="0" cellpadding="0" cellspacing="0" style="max-width:100%; min-width:100%;" width="100%" class="mcnTextContentContainer">
                    <tbody><tr>

                        <td valign="top" class="mcnTextContent" style="padding-top:0; padding-right:18px; padding-bottom:9px; padding-left:18px;">

                            <br>
<span style="color:#F0FFFF"><em>Copyright © *|CURRENT_YEAR|* *|LIST:COMPANY|*, All rights reserved.</em></span><br>
<br>
<span style="color:#FFFFFF">Want to change how you receive these emails?</span><br>
<span style="color:#FFFFFF">You can </span><a href="*|UPDATE_PROFILE|*"><span style="color:#000080">update your preferences</span></a><span style="color:#000080"> </span><span style="color:#FFFFFF">or</span><span style="color:#000080"> </span><a href="*|UNSUB|*"><span style="color:#000080">unsubscribe from this list</span></a><span style="color:#000080">.</span><br>
&nbsp;
                        </td>
                    </tr>
                </tbody></table>
				<!--[if mso]>
				</td>
				<![endif]-->

				<!--[if mso]>
				</tr>
				</table>
				<![endif]-->
            </td>
        </tr>
    </tbody>
</table></td>
                            </tr>
                        </table>
						<!--[if (gte mso 9)|(IE)]>
						</td>
						</tr>
						</table>
						<![endif]-->
                        <!-- // END TEMPLATE -->
                    </td>
                </tr>
            </table>
        </center>
    </body>
</html>';
// Always set content-type when sending HTML email
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

		// if( !empty($escalation_detail) ){
		// // send email
		// 	mail("jack@iivo.co.uk",$subject,$array,$headers);
		// 	if(mail("lwpsupport@orbisprotect.com",$subject,$array,$headers))
		// 	//if(mail("jack@iivo.co.uk",$subject,$array,$headers))
		// 	{
		// 		//mail("sunil@iivo.io",$subject,$array,$headers);
		// 		$this->jres->success([],'mail send');
		// 	}
		// 	else{
		// 		$this->jres->failure('mail send fail');
		// 	}
		// }else
		// {
		// 	$this->jres->failure('no data available');
		// }

		if( !empty($escalation_detail) ){
			$this->load->library('email');
            //$this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
            $this->email->from('no-reply@orbisprotect.com', 'Escalation Emailer');
            $this->email->to('jack@iivo.co.uk');
			$this->email->to('jatin@iivo.io');
            $this->email->to('arcadmin@orbisprotect.com');
            //$this->email->to('arcadmin@orbisprotect.com');
            $this->email->subject($subject);
            $this->email->message($array);
            //$send_mail = $this->email->send();
            if($this->email->send())
			{
				//mail("sunil@iivo.io",$subject,$array,$headers);
				$this->jres->success([],'mail send');
			}
			else{
				$this->jres->failure('mail send fail');
			}
        }
        else
		{
			$this->jres->failure('no data available');
		}
	}else{
		$this->jres->failure('subject empty');
	}

	}

	function test_mail(){
			$this->load->library('email');
            //$this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
            $this->email->from('no-reply@iivo.io', 'Eversmart');
            //$this->email->to($this->input->post('email'));
            $this->email->to('jatin@iivo.io');
            $this->email->subject('Signup Confirmation');
            $this->email->message("thanks");
            $this->email->send();
	}

	function location_update_sentinal(){
			//echo json_encode([ 'msg' => 'asm' ]);exit;
		$ref_id = $this->input->post('ref_id',true);
		$lat = $this->input->post('lat',true);
		$long = $this->input->post('long',true);
		$DateTime = $this->input->post('datetime', true);
		$IMEI = $this->input->post('imei', true);
		$number = $this->input->post('number', true);
		$messageType = $this->input->post('messageType', true);
		$posdatatime = $this->input->post('posdatatime', true);
		$postype = $this->input->post('postype', true);
		$status = $this->input->post('status', true);
		$interval = $this->input->post('interval', true);
		$speed = $this->input->post('speed', true);

		if( !isset($ref_id) || $ref_id=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}elseif( !isset($lat) || $lat=="" )
		{
			$msg= 'lat cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($long) || $long=="" )
		{
			$msg= 'long cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			/*$this->signal->number = $number;
			$get_device_type = $this->signal->get_device_type();

			if($get_device_type['device_type'] == 'android' || $get_device_type['device_type'] == 'Android'){*/
			$checkNumberBlock = $this->signal->checkNumberBlock($number);
			if( empty($checkNumberBlock->id) ){

				if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    //die("Couldn't create socket: [$errorcode] $errormsg \n");
						    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
						    exit;
						}

						if(!socket_connect($sock , '89.197.154.25' , 5051))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);
							if( $errormsg == 'Connection timed out' )
						    {
						    	socket_close($sock);
						    }
						    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
						    exit;
						}else{

						$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

						$checksum = md5($signals);

						$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;

						//Send the message to the server
						if( ! socket_send ( $sock , $message , strlen($message) , 0))
						 {
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    $data['error_msg'] = "Could not send data: [$errorcode] $errormsg";
						    $socket_log = $this->signal->socket_log($data);
						   // die("Could not send data: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
						    exit;
						}
						else
						{
							$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
							$data['DateTime'] = $DateTime;
							$data['IMEI'] = $IMEI;
							$data['number'] = $number;
							$data['messageType'] = $messageType;
							$data['lat'] = $lat;
							$data['long'] = $long;
							$data['posdatatime'] = $posdatatime;
							$data['postype'] = $postype;
							$data['status'] = $status;
							$data['interval'] = $interval;
							$data['speed'] = $speed;
							$data['checksum'] = $checksum;
							$report_trigger = $this->signal->asm_trigger($data);
						}
						$this->jres->success_message('Signals send successfully');
						socket_close($sock);

					//}

					$this->users->ref_id = $ref_id;
					$this->users->lat = $lat;
					$this->users->long = $long;
					$this->users->status = $status;
					$update_location = $this->users->update_location();
					if( $update_location > 0)
					{
						$this->jres->success_message('Signals and location updated');
					}
					else
					{
						$this->jres->failure('','location updated fail');
					}
				}
			}
		}
	}
	//ravi work starts
	public function logout_user(){
		$number = $this->input->post('number',true);
		if( !isset($number) || $number=="" )
		{
			$msg= 'Number can not be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->number = $number;
			$logout = $this->users->logout_user();
			if( !empty($logout) )
				{
					$this->jres->successotp('','logout');
				}
				else
				{
					$this->jres->failure('Invalid Number.', ['status' => 0]);
				}
		}
	}

	public function getAppSettingsResponse() {

	   $dataFromApp = $this->input->post() ;

	   if ( ( isset($dataFromApp['unique_id']) && !empty($dataFromApp['unique_id']) ) &&  ( isset($dataFromApp['phone_no']) && !empty($dataFromApp['phone_no']) ) )	{

		   $data['triggerSos']   				= ( isset($dataFromApp['trigger_sos']) ? $dataFromApp['trigger_sos'] : '');
		   $data['presslabel']   			    = ( isset($dataFromApp['trigger_level']) ? $dataFromApp['trigger_level'] : '');
		   $data['ripAlarm']  					= ( isset($dataFromApp['rip_alarm']) ? $dataFromApp['rip_alarm'] : '');
		// $data['fallDetect']   				= ( isset($dataFromApp['fall_detect']) ? $dataFromApp['fall_detect'] : '');
		// $data['fallSenstivity']   			= ( isset($dataFromApp['fall_detect_sensitivity']) ? $dataFromApp['fall_detect_sensitivity'] : '');
		   $data['minmandowntimerminutes']   	= ( isset($dataFromApp['minmandowntimerminutes']) ? $dataFromApp['minmandowntimerminutes'] : '');
		   $data['minmandowntimerseconds']   	= ( isset($dataFromApp['minmandowntimerseconds']) ? $dataFromApp['minmandowntimerseconds'] : '');
		   $data['maxmandowntimerminutes']   	= ( isset($dataFromApp['maxmandowntimerminutes']) ? $dataFromApp['maxmandowntimerminutes'] : '');
		   $data['maxmandowntimerseconds']   	= ( isset($dataFromApp['maxmandowntimerseconds']) ? $dataFromApp['maxmandowntimerseconds'] : '');
		   $data['minambertimerhours']   		= ( isset($dataFromApp['minambertimerhours']) ? $dataFromApp['minambertimerhours'] : '');
		   $data['minambertimerminutes']   		= ( isset($dataFromApp['minambertimerminutes']) ? $dataFromApp['minambertimerminutes'] : '');
		   $data['maxambertimerhours']   		= ( isset($dataFromApp['maxambertimerhours']) ? $dataFromApp['maxambertimerhours'] : '');
		   $data['maxambertimerminutes']   		= ( isset($dataFromApp['maxambertimerminutes']) ? $dataFromApp['maxambertimerminutes'] : '');
		   $data['gpsfrequencyupdate']   		= ( isset($dataFromApp['gps_frequency']) ? $dataFromApp['gps_frequency'] : '');
		   $data['settings']   					= ( isset($dataFromApp['settings_access']) ? $dataFromApp['settings_access'] : '');
		   $data['gpsposcriteria']   			= ( isset($dataFromApp['gps_position_criteria']) ? $dataFromApp['gps_position_criteria'] : '');
		   $data['calendar']  					= ( isset($dataFromApp['calendar']) ? $dataFromApp['calendar'] : '');
		   $data['finger_print_lock']   		= ( isset($dataFromApp['finger_print_lock']) ? $dataFromApp['finger_print_lock'] : '');
		   $data['settings_name']   			= ( isset($dataFromApp['setting_name']) ? $dataFromApp['setting_name'] : '');
		   $data['settings_id']   				= ( isset($dataFromApp['setting_id']) ? $dataFromApp['setting_id'] : '');
		   $data['gps_lat']  					= ( isset($dataFromApp['gps_lat']) ? $dataFromApp['gps_lat'] : '');
		   $data['gps_lng']   					= ( isset($dataFromApp['gps_lng']) ? $dataFromApp['gps_lng'] : '');
		   //new fields
		   $data['sms']   						= ( isset($dataFromApp['sms']) ? $dataFromApp['sms'] : '-');
		   $data['imei_no']   					= ( isset($dataFromApp['imei_no']) && $dataFromApp['imei_no'] ? $dataFromApp['imei_no'] : '-');
		   //$data['serial_number_phone']   		= ( isset($dataFromApp['serial_number']) ? $dataFromApp['serial_number'] : '-');
		   $data['carrier']   					= ( isset($dataFromApp['carrier']) ? $dataFromApp['carrier'] : '-');
		   $data['model']   					= ( isset($dataFromApp['model']) ? $dataFromApp['model'] : '-');
		   $data['version']   					= ( isset($dataFromApp['version']) ? $dataFromApp['version'] : '-');
		   $data['device_id']   				= ( isset($dataFromApp['device_id']) ? $dataFromApp['device_id'] : '-');
		   $data['app_version']   				= ( isset($dataFromApp['app_version']) ? $dataFromApp['app_version'] : '-');
		   $data['app_name']   					= ( isset($dataFromApp['device_id']) ? $dataFromApp['app_name'] : '-');
		   $data['activity_based_locations']   	= ( isset($dataFromApp['activity_based_locations']) ? $dataFromApp['activity_based_locations'] : '-');
		   $data['is_device_on_mdm']   			= ( isset($dataFromApp['is_device_on_mdm']) ? $dataFromApp['is_device_on_mdm'] : 'no');
		   $data['coorrdinates_refresh_rate']   = ( isset($dataFromApp['coorrdinates_refresh_rate']) && $dataFromApp['coorrdinates_refresh_rate']  ? $dataFromApp['coorrdinates_refresh_rate'] : '-');
		   $data['escalation_status']   		= ( isset($dataFromApp['escalation_status']) && $dataFromApp['escalation_status']  ? $dataFromApp['escalation_status'] : '-');
		   
		   $data['amber_timer_pre_alert_minutes']   		= ( isset($dataFromApp['amber_timer_pre_alerts_minutes']) ? $dataFromApp['amber_timer_pre_alerts_minutes'] : '-');
		    $data['amber_timer_pre_alert_seconds']   		= ( isset($dataFromApp['amber_timer_pre_alerts_seconds']) ? $dataFromApp['amber_timer_pre_alerts_seconds'] : '-');
		   
		  if ( $this->users->updateAppSettingsGetConfiguration($dataFromApp['unique_id'], $dataFromApp['phone_no'], $data) ) {
				$error = 0;
				$message = "Data updated successfully.";
		   } else {
				$error = 1;
				$message = "Data not updated.";
		   }


	   } else {
			   $error = 1;
			   $message = "Number/Unique can not be empty";
	   }

	   echo json_encode([ 'error' => $error, 'message' => $message ]) ;
	}


	public function get_all_titles_by_number() {
		$data = [] ;
		$requestData   = $this->input->post('number') ;
		if ($requestData) {
			$notificationData = $this->users->get_user_sent_notifications_by_title($requestData) ;
			if ($notificationData){
				$counter   =   0  ;
				foreach($notificationData as $row) {
					$data[$counter]['message_compose_id']       =  $row['compose_id'];
					$data[$counter]['message_broadcast_id']   	=  $row['id'];
					$data[$counter]['message_title']  		    =  $row['title'];
					if (strlen($row['message']) >50) {
					  $message =  substr($row['message'], 0, 50) . '...';
					} else {
					  $message =  $row['message'];
					}

					$data[$counter]['message_mainmessage'] 	=  $message;
					$data[$counter]['read_status'] 	=  $row['read_status'];
					$counter++;
				}
			}
			$error = 0;
			$message = "Number sent from app.";
		} else {
			 $error = 1;
			 $message = "Number can not be empty.";
		}
		echo json_encode([ 'error' => $error, 'message' => $message, 'data' => $data ]) ;
	}

	public function get_message_body() {
		$data = [] ;
		$message_compose_id     = $this->input->post('message_compose_id') ;
		$message_broadcast_id   = $this->input->post('message_broadcast_id') ;
		if ($message_compose_id && $message_broadcast_id) {
			$notificationData = $this->users->get_message_body($message_compose_id, $message_broadcast_id) ;
			if ($notificationData){
				$data['message_compose_id'] 	=  $notificationData['id'];
				$data['message_broadcast_id'] 	=  $message_broadcast_id;
				$data['message_title']  		=  $notificationData['title'];
				$data['message_mainmessage'] 	=  $notificationData['message'];
				$data['message_from'] 		    =  $notificationData['from_message'];

			}
			$error = 0;
			$message = "Compose & broadcast  ID found.";
		} else {
			 $error = 1;
			 $message = "Compose & broadcast ID can not be empty.";
		}

		echo json_encode([ 'error' => $error, 'message' => $message, 'data' => $data ]) ;

	}
	
	
	public function delete_user_notifications() {
		$number  				=   $this->input->post('number') ;
		$message_broadcast_id   =   $this->input->post('message_broadcast_id') ;
		
		if ($number || $message_broadcast_id) {
			if ($number) {
				$type = "all";
				$deleteData = $this->users->delete_user_notifications($type, $number) ;
			} else {
				$type = "single";
				$deleteData = $this->users->delete_user_notifications($type, $message_broadcast_id) ;
			}
			if ($deleteData) {
				$error = 0;
				$message = "Messages deleted successfully.";
			} else {
				$error = 0;
				$message = "Error while deleting messages.";
			}
		} else {
			 $error = 1;
			 $message = "Number or broadcast ID can not be empty.";
		}
		echo json_encode([ 'error' => $error, 'message' => $message ]) ;
	}
	
	
	/* Function to save the applied settiings when notification is received and opened by the ios user*/
	
	
	public function otaSettingsAppliedIos() {
		$templateId  				=   $this->input->post('templateId') ;
		$phone   					=   $this->input->post('phone') ;
		$gps_pos_criteria   		=   $this->input->post('gps_pos_criteria') ;
		$loginName   				=   $this->input->post('loginName') ;
		
		/*New parameters*/
		
		$deviceInfo['device_model_number']			=   $this->input->post('deviceModelNumber') ;
		$deviceInfo['device_version'] 				=   $this->input->post('deviceVersion') ;
		$deviceInfo['device_carrier_name'] 			=	$this->input->post('deviceCarrierName') ;
		$deviceInfo['device_app_version'] 			=   $this->input->post('deviceAppVersion') ;
		$deviceInfo['device_app_name']				=   $this->input->post('deviceAppName') ;
		
		/*New parameters*/
		
		if ($templateId && $phone && $gps_pos_criteria && $loginName) {
			
			$resultData  = $this->users->saveUserTemplateSettings($templateId, $phone, $gps_pos_criteria, $loginName, $deviceInfo) ;
			
			if ($resultData) {
				$error = 0;
				$message = "Data inserted";
			} else {
				 $error = 1;
				 $message = "Internal server error.";
			}
			
		} else {
			 $error = 1;
			 $message = "Missing required parameters.";
		}
		echo json_encode([ 'error' => $error, 'message' => $message ]) ;
	}
	
	function get_user_global_escalation()
	{
			
		$serialNumber = $this->input->post('serialNumber');
		//$serialNumber = '158295';
		
		if ($serialNumber) {
					// config for PDO
					$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

					// get global escalations

					$sql = 'SELECT linkacc.name as main_name, -- Link account contacts
					contkey.name,
					contkey.mobile,
					contkey.work1,
					contkey.phone,
					contkey.pager,
					contkey.email,
					contkey.address_line1,
					contkey.address_line2,
					contkey.address_line3,
					contkey.address_town,
					contkey.address_county,
					contkey.address_postcode
					FROM linkacc,
					contkeylinkacc,
					contkey
					WHERE linkacc.linkno IN (SELECT linkno
					FROM linkacc START WITH linkacc.linkno IN (select linkno from customer where serialno = "'.$serialNumber.'")
					CONNECT BY PRIOR linkacc.parent = linkacc.linkno)
					AND linkacc.linkno = contkeylinkacc.linkno
					AND contkeylinkacc.keyserialno = contkey.keyserialno
					';


					$sql   = $conexion->prepare($sql);
					$sql->execute();
					$getGlobalEscalations = $sql->fetchAll(PDO::FETCH_ASSOC);
					
					$mainDataArray   = [];
					
					if ( $getGlobalEscalations ) {
						$error    = 0;
						$counter  = 0 ;
						$message  = 'data found' ; 
						
						foreach(array_reverse($getGlobalEscalations) as $value) {

							$mainDataArray[$counter]['name'] 				   = $value['NAME'];
							$mainDataArray[$counter]['phoneNumber'] 			   = $value['PHONE'];
							$mainDataArray[$counter]['emailAddress']			   = $value['EMAIL'];
							$mainDataArray[$counter]['workNumber'] 				   = $value['WORK1'];
							$mainDataArray[$counter]['mobileNumber'] 			   = $value['MOBILE'];
							//$mainDataArray[$counter]['CustomerContactIdentifier']  = '';
							$counter++ ;
						}
					} else {
						$error = 1;
						$message  = 'no data found' ; 
					}
					echo json_encode([ 'error' => $error, 'data'=> $mainDataArray, 'msg' => $message ]);
		} else{
			echo json_encode([ 'error' => '1', 'data'=> '', 'msg' => 'missing required parameter serial number' ]);
		}
	}
	
	
	function get_user_escalation()
	{
		$serialNumber = $this->input->post('serialNumber');
		$dataToSendError = [] ;
		//$serialNumber = '158295';
		
		if ($serialNumber) {
				$lone_worker_url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListGroups";

				// list site (lone worker)
				$lone_worker = '<?xml version="1.0" encoding="utf-8"?>
				<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
					 <soap:Body>
						<ListGroups xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
							<listGroupsRequestKey>
							<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
							<Password>'.$this->config->item('sentry_master')['password'].'</Password>
							<ServiceVersion>Version_1_104_1</ServiceVersion>
								<GroupFilter>
									<FilterList>
										<GroupFilterListItem>
												<FilterAttribute xsi:type="SerialNumberGroupFilterAttribute"/>
												<FilterOperator xsi:type="EqualityGroupFilterOperator"/>
												<FilterValue xsi:type="GroupFilterComparisonInteger">
												<Value>'.$serialNumber.'</Value>
												</FilterValue>
										</GroupFilterListItem>
									</FilterList>
								</GroupFilter>
							</listGroupsRequestKey>
						</ListGroups>
						 </soap:Body>
					</soap:Envelope>';
					
				$curl_send = $this->curl->curl_send($lone_worker, $lone_worker_url);
				$xmlToArray = $this->curl->xmlToArray($curl_send);
				//debug($xmlToArray);
				
				$GroupListItem = ( isset($xmlToArray['ListGroupsResponse']['ListGroupsResult']['ListOfGroups']['GroupListItem']) ? $xmlToArray['ListGroupsResponse']['ListGroupsResult']['ListOfGroups']['GroupListItem'] : '' );
				//debug($GroupListItem) ;
				
				$group_id = "" ;
				
				if( isset($GroupListItem['Identifier']) && !empty($GroupListItem['Identifier']) )
				{
					$group_id = $GroupListItem['Identifier'];
				}
				elseif ( isset($GroupListItem[0]['Identifier']) && !empty($GroupListItem[0]['Identifier']) )
				{
					$group_id = $GroupListItem[0]['Identifier'] ;
				}
				
				
				if ($GroupListItem && $group_id) {
					$ListCustomerContactsInGroup = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListCustomerContactsInGroup";
					// list site (lone worker)
					$ListCustomerContactsInGroup_xml = '<?xml version="1.0" encoding="utf-8"?>
					<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
						 <soap:Body>
							<ListCustomerContactsInGroup xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
								<listCustomerContactsRequestKey>
								<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
								<Password>'.$this->config->item('sentry_master')['password'].'</Password>
								<SerialNumber>'.$serialNumber.'</SerialNumber>
								<GroupNumber>'.$group_id.'</GroupNumber>
								</listCustomerContactsRequestKey>
							</ListCustomerContactsInGroup>
							 </soap:Body>
						</soap:Envelope>';
						
						$curl_request = $this->curl->curl_send($ListCustomerContactsInGroup_xml, $ListCustomerContactsInGroup);
						$xmlToArray_request = $this->curl->xmlToArray($curl_request);
						//debug($xmlToArray_request);
						
						$ContactsInGroup = $xmlToArray_request['ListCustomerContactsInGroupResponse']['ListCustomerContactsInGroupResult']['ListOfContacts']['CustomerContactListItem'];
						$count_response = $xmlToArray_request['ListCustomerContactsInGroupResponse']['ListCustomerContactsInGroupResult']['ListOfContacts'];
						
						if( !empty($count_response) ){
							
							if( empty($count_response['CustomerContactListItem']['Name']) ){
								
								$user_detail = array();
								for( $i=0; $i<count($count_response['CustomerContactListItem']); $i++ )
								{
										$ListCustomerContactsDetail = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/GetCustomerContact";
										
										$ListCustomerContactsDetail_xml = '<?xml version="1.0" encoding="utf-8"?>
										<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
											 <soap:Body>
												<GetCustomerContact xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
													<getCustomerContactRequestKey>
													<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
													<Password>'.$this->config->item('sentry_master')['password'].'</Password>
													<SerialNumber>'.$serialNumber.'</SerialNumber>
													<CustomerContactIdentifier>'.$count_response['CustomerContactListItem'][$i]['Identifier'].'</CustomerContactIdentifier>
													</getCustomerContactRequestKey>
												</GetCustomerContact>
												 </soap:Body>
											</soap:Envelope>';
											$ListCustomerContactsDetail_curl_request = $this->curl->curl_send($ListCustomerContactsDetail_xml, $ListCustomerContactsDetail);
											// convert xml into array
											$xmlToArray_request_detail = $this->curl->xmlToArray($ListCustomerContactsDetail_curl_request);
											$user_detail[] = $xmlToArray_request_detail['GetCustomerContactResponse']['GetCustomerContactResult']['CustomerContactInformation'];
								}
								
								for( $k=0; $k<count($user_detail); $k++ ){
									if( empty($user_detail[$k]['Name']) )
									{
										$user_detail[$k]['Name'] = '';
									}
									if( empty($user_detail[$k]['PhoneNumber']) )
									{
										$user_detail[$k]['PhoneNumber'] = '';
									}
									if( empty($user_detail[$k]['EmailAddress']) )
									{
										$user_detail[$k]['EmailAddress'] = '';
									}
									if( empty($user_detail[$k]['WorkNumber']) )
									{
										$user_detail[$k]['WorkNumber'] = '';
									}
									if( empty($user_detail[$k]['MobileNumber']) )
									{
										$user_detail[$k]['MobileNumber'] = '';
									}
									
									if( empty($user_detail[$k]['CustomerContactIdentifier']) )
									{
										$user_detail[$k]['CustomerContactIdentifier'] = '';
									}

									

								}
								//debug($user_detail,1);
								if(!empty($user_detail)){
									echo json_encode([ 'error' => '0', 'data'=> $user_detail, 'msg' => 'data found', 'groupId' => $group_id ]);
								}else{
									echo json_encode([ 'error' => '1', 'data'=> $dataToSendError, 'msg' => 'no data found' ]);
								}
							}
							else
							{
										$user_detail = array();
										$ListCustomerContactsDetail = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/GetCustomerContact";
										
										$ListCustomerContactsDetail_xml = '<?xml version="1.0" encoding="utf-8"?>
										<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
											 <soap:Body>
												<GetCustomerContact xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
													<getCustomerContactRequestKey>
													<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
													<Password>'.$this->config->item('sentry_master')['password'].'</Password>
													<SerialNumber>'.$serialNumber.'</SerialNumber>
													<CustomerContactIdentifier>'.$ContactsInGroup['Identifier'].'</CustomerContactIdentifier>
													</getCustomerContactRequestKey>
												</GetCustomerContact>
												 </soap:Body>
											</soap:Envelope>';
											$ListCustomerContactsDetail_curl_request = $this->curl->curl_send($ListCustomerContactsDetail_xml, $ListCustomerContactsDetail);
											// convert xml into array
											$xmlToArray_request_detail = $this->curl->xmlToArray($ListCustomerContactsDetail_curl_request);
											$user_detail[] = $xmlToArray_request_detail['GetCustomerContactResponse']['GetCustomerContactResult']['CustomerContactInformation'];
								
								for( $k=0; $k<count($user_detail); $k++ ){
									
									if( empty($user_detail[$k]['Name']) )
									{
										$user_detail[$k]['Name'] = '';
									}
									if( empty($user_detail[$k]['PhoneNumber']) )
									{
										$user_detail[$k]['PhoneNumber'] = '';
									}
									if( empty($user_detail[$k]['EmailAddress']) )
									{
										$user_detail[$k]['EmailAddress'] = '';
									}
									if( empty($user_detail[$k]['WorkNumber']) )
									{
										$user_detail[$k]['WorkNumber'] = '';
									}
									if( empty($user_detail[$k]['MobileNumber']) )
									{
										$user_detail[$k]['MobileNumber'] = '';
									}
									if( empty($user_detail[$k]['MobileNumber']) )
									{
										$user_detail[$k]['MobileNumber'] = '';
									}
									if( empty($user_detail[$k]['CustomerContactIdentifier']) )
									{
										$user_detail[$k]['CustomerContactIdentifier'] = '';
									}

								}
								//debug($user_detail,1);
								if(!empty($user_detail)){
									echo json_encode([ 'error' => '0', 'data'=> $user_detail, 'msg' => 'data found', 'groupId' => $group_id ]);
								}else{
									echo json_encode([ 'error' => '1', 'data'=> $dataToSendError, 'msg' => 'no data found' ]);
								}
							}
							
						} else {
							echo json_encode([ 'error' => '1', 'data'=> $dataToSendError, 'msg' => 'no data found' ]);
						}
						
						
				} else {
					echo json_encode([ 'error' => '1', 'data'=> $dataToSendError, 'msg' => 'no data found' ]);
				}
				
				
				
				
				
		} else {
			echo json_encode([ 'error' => '1', 'data'=> $dataToSendError, 'msg' => 'missing required parameter serial number' ]);
		}
			
	}
	
	
	public function addUserEscalation() {
		
		
		$serialNumber = $this->input->post('serialNumber');
		$first_name   = $this->input->post('name') ;
		$Office_No    = $this->input->post('officeNo') ;
		$telephone    = $this->input->post('telephone') ;
		$Mobile 	  = $this->input->post('mobile') ;
		$email 		  = $this->input->post('email') ;
		$groupId 	  = $this->input->post('groupId') ;
		
		$errorMessage = "" ;
		$errorValue	  = false ;
		
		
		if (!$serialNumber)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter serial number', 'CustomerContactIdentifier' => '' ]);
			exit ;
		}
		
		if (!$first_name)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter name', 'CustomerContactIdentifier' => '' ]);
			exit ;
		}
		
		
		if (!$groupId)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter group id', 'CustomerContactIdentifier' => '' ]);
			exit ;
		}
		
		
		/***Validation check***/
		
		if( strlen($first_name) > 35 ){
			$errorMessage .= "Name can not be greater then 35 characters" ;
			$errorValue	   = true ;
		} 
		
		if( $Office_No && ( strlen($Office_No) > 20 ||  strlen($Office_No) < 7 ) ){
			$errorMessage .= " Office number length(min 7 and max 20)" ;
			$errorValue	   = true ;
		} 
		
		
		if( $telephone && ( strlen($telephone) > 20 ||  strlen($telephone) < 7 ) ){
			$errorMessage .= " Home number length(min 7 and max 20)" ;
			$errorValue	   = true ;
		} 
		
		
		if( $Mobile && ( strlen($Mobile) > 20 ||  strlen($Mobile) < 7 ) ){
			$errorMessage .= " Mobile number length(min 7 and max 20)" ;
			$errorValue	   = true ;
		} 
		
		
		if( strlen($email) > 50 ){
			$errorMessage .= " Email can not be greater then 50 characters" ;
			$errorValue	   = true ;
		} 
		
		
		if ( $errorValue )  {
			echo json_encode([ 'error' => '1',  'msg' => $errorMessage, 'CustomerContactIdentifier' => '' ]);
			exit ;
		}
		
		/***Validation check***/
		
		//~ echo "here" ;
		//~ echo $this->config->item('sentry_master')['username'] ;
		//~ echo $this->config->item('sentry_master')['password'] ;
		
		//~ exit ;
		
		if( $first_name =='' )
		{
			$first_name = '-';
		}
		
		if( $Office_No =='' )
		{
			$Office_No = '';
		}
		
		if($telephone =='' )
		{
			$telephone = '';
		}
		

		if( $Mobile =='' )
		{
			$Mobile = '';
		}
		

		if( $email =='' )
		{
			$email = '';
		}
		
		//create contract
		$url_create = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/CreateCustomerContact";
		// list site (lone worker)
		$xml_create = '<?xml version="1.0" encoding="utf-8"?>
		<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
			 <soap:Body>
				<CreateCustomerContact xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
					<createCustomerContactRequestKey>
					<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
					<Password>'.$this->config->item('sentry_master')['password'].'</Password>
					<SerialNumber>'.$serialNumber.'</SerialNumber>
					<CustomerContactDetails>
							<Name>'.$first_name.'</Name>
							<PhoneNumber>'.$telephone.'</PhoneNumber>
							<WorkNumber>'.$Office_No.'</WorkNumber>
							<MobileNumber>'.$Mobile.'</MobileNumber>
							<EmailAddress>'.$email.'</EmailAddress>
							<IsKeyHolder>true</IsKeyHolder>
							<CanCancelAlarms>true</CanCancelAlarms>
							<CanEditKeyHolders>true</CanEditKeyHolders>
							<CanEditSchedules>true</CanEditSchedules>
							<CanEditSiteData>true</CanEditSiteData>
					</CustomerContactDetails>
					</createCustomerContactRequestKey>
				</CreateCustomerContact>
				 </soap:Body>
			</soap:Envelope>';
			//echo $xml_create;
			//echo "<br>---<br>";
			$curl_request_create = $this->curl->curl_send($xml_create, $url_create);
			// convert xml into array
			$convertToArray_create = $this->curl->xmlToArray($curl_request_create);

			$response_error = $convertToArray_create['CreateCustomerContactResponse']['CreateCustomerContactResult']['Errors'];
			if( !empty($response_error) )
			{
				$msg = $response_error['Message']['MessageText'];
				echo json_encode([ 'error' => '1', 'msg' => $msg, 'CustomerContactIdentifier' => ''  ]); exit;
			}



			$response = $convertToArray_create['CreateCustomerContactResponse']['CreateCustomerContactResult']['CustomerContactIdentifier'];
			if( !empty($response) )
			{

				$ListCustomerContactsInGroup = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListCustomerContactsInGroup";
				// list site (lone worker)
				$ListCustomerContactsInGroup_xml = '<?xml version="1.0" encoding="utf-8"?>
				<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
					 <soap:Body>
						<ListCustomerContactsInGroup xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
							<listCustomerContactsRequestKey>
							<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
							<Password>'.$this->config->item('sentry_master')['password'].'</Password>
							<SerialNumber>'.$serialNumber.'</SerialNumber>
							<GroupNumber>'.$groupId.'</GroupNumber>
							</listCustomerContactsRequestKey>
						</ListCustomerContactsInGroup>
						 </soap:Body>
					</soap:Envelope>';
					$ListCustomerContactsInGroup_xml;

					// get curl response
					$curl_request = $this->curl->curl_send($ListCustomerContactsInGroup_xml, $ListCustomerContactsInGroup);
					//echo $curl_request;

					// convert xml into array
					$xmlToArray_request = $this->curl->xmlToArray($curl_request);
					//debug($xmlToArray_request,1);

					$response_error2 = $xmlToArray_request['ListCustomerContactsInGroupResponse']['ListCustomerContactsInGroupResult']['Errors'];
					if( !empty($response_error2) )
					{
						$msg = $response_error2['Message']['MessageText'];
						echo json_encode([ 'error' => '1', 'msg' => $msg, 'CustomerContactIdentifier' => ''  ]); exit;
					}

					$ContactsInGroup = $xmlToArray_request['ListCustomerContactsInGroupResponse']['ListCustomerContactsInGroupResult']['ListOfContacts']['CustomerContactListItem'];
					//debug($ContactsInGroup,1);
					if( empty($ContactsInGroup['Name']) )
					{
							$xml_create1 = '';
							for( $var=0; $var<count($ContactsInGroup); $var++ )
							{
								 //debug($explode);
								 $xml_create1 .= '<CustomerContactListItem><Identifier>'.$ContactsInGroup[$var]['Identifier'].'</Identifier><SerialNumber>'.$ContactsInGroup[$var]['SerialNumber'].'</SerialNumber></CustomerContactListItem>';
							}
							$xml_create1 .= '<CustomerContactListItem><Identifier>'.$response.'</Identifier><SerialNumber>'.$serialNumber.'</SerialNumber></CustomerContactListItem>';
							$url_create = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/SetCustomerContactGroupList";
							// list site (lone worker)
								$xml_create = '<?xml version="1.0" encoding="utf-8"?>
								<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
									 <soap:Body>
										<SetCustomerContactGroupList xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
											<setCustomerContactGroupRequestKey>
											<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
											<Password>'.$this->config->item('sentry_master')['password'].'</Password>
											<SerialNumber>'.$serialNumber.'</SerialNumber>
											<GroupNumber>'.$groupId.'</GroupNumber>
											<ListOfCustomerContacts>';
												$xml_create .= $xml_create1;
											$xml_create .='</ListOfCustomerContacts>
											</setCustomerContactGroupRequestKey>
										</SetCustomerContactGroupList>
										 </soap:Body>
									</soap:Envelope>';
									$xml_create;

									$curl_request_create = $this->curl->curl_send($xml_create, $url_create);
									// convert xml into array
									$convertToArray_create = $this->curl->xmlToArray($curl_request_create);
					 }
					 else{
							$xml_create1 = '';
							// for( $var=0; $var<count($ContactsInGroup); $var++ )
							// {
								 //debug($explode);
								 $xml_create1 .= '<CustomerContactListItem><Identifier>'.$ContactsInGroup['Identifier'].'</Identifier><SerialNumber>'.$ContactsInGroup['SerialNumber'].'</SerialNumber></CustomerContactListItem>';
							//}
							$xml_create1 .= '<CustomerContactListItem><Identifier>'.$response.'</Identifier><SerialNumber>'.$serialNumber.'</SerialNumber></CustomerContactListItem>';
							$url_create = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/SetCustomerContactGroupList";
							// list site (lone worker)
								$xml_create = '<?xml version="1.0" encoding="utf-8"?>
								<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
									 <soap:Body>
										<SetCustomerContactGroupList xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
											<setCustomerContactGroupRequestKey>
											<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
											<Password>'.$this->config->item('sentry_master')['password'].'</Password>
											<SerialNumber>'.$serialNumber.'</SerialNumber>
											<GroupNumber>'.$groupId.'</GroupNumber>
											<ListOfCustomerContacts>';
												$xml_create .= $xml_create1;
											$xml_create .='</ListOfCustomerContacts>
											</setCustomerContactGroupRequestKey>
										</SetCustomerContactGroupList>
										 </soap:Body>
									</soap:Envelope>';
									//echo $xml_create;

									$curl_request_create = $this->curl->curl_send($xml_create, $url_create);
									// convert xml into array
									$convertToArray_create = $this->curl->xmlToArray($curl_request_create);
					 }
				echo json_encode(['error' => '0', 'msg' => 'user escalation created', 'CustomerContactIdentifier' => $response]);
			}else{
				echo json_encode(['error' => '1', 'msg' => 'User escalation not created', 'CustomerContactIdentifier' => '']);
			}
	}
	
	
	public function updateUserEscalation() {
	
	
		$serialNumber = $this->input->post('serialNumber');
		$first_name   = $this->input->post('name') ;
		$Office_No    = $this->input->post('officeNo') ;
		$telephone    = $this->input->post('telephone') ;
		$Mobile 	  = $this->input->post('mobile') ;
		$email 		  = $this->input->post('email') ;
		$identifier   = $this->input->post('identifier') ;
		
		$errorMessage = "" ;
		$errorValue	  = false ;
		
		
		if (!$serialNumber)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter serial number' ]);
			exit ;
		}
		
		if (!$first_name)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter name' ]);
			exit ;
		}
		
		
		if (!$identifier)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter identifier' ]);
			exit ;
		}
		
		
		/***Validation check***/
		
		if( strlen($first_name) > 35 ){
			$errorMessage .= "Name can not be greater then 35 characters" ;
			$errorValue	   = true ;
		} 
		
		if( $Office_No && ( strlen($Office_No) > 20 ||  strlen($Office_No) < 7 ) ){
			$errorMessage .= " Office number length(min 7 and max 20)" ;
			$errorValue	   = true ;
		} 
		
		
		if( $telephone && ( strlen($telephone) > 20 ||  strlen($telephone) < 7 ) ){
			$errorMessage .= " Home number length(min 7 and max 20)" ;
			$errorValue	   = true ;
		} 
		
		
		if( $Mobile && ( strlen($Mobile) > 20 ||  strlen($Mobile) < 7 ) ){
			$errorMessage .= " Mobile number length(min 7 and max 20)" ;
			$errorValue	   = true ;
		} 
		
		
		if( strlen($email) > 50 ){
			$errorMessage .= " Email can not be greater then 50 characters" ;
			$errorValue	   = true ;
		} 
		
		
		if ( $errorValue )  {
			echo json_encode([ 'error' => '1',  'msg' => $errorMessage ]);
			exit ;
		}
		
		/***Validation check***/
		
		//~ echo "here" ;
		//~ echo $this->config->item('sentry_master')['username'] ;
		//~ echo $this->config->item('sentry_master')['password'] ;
		
		//~ exit ;
		
		if( $first_name =='' )
		{
			$first_name = '-';
		}
		
		if( $Office_No =='' )
		{
			$Office_No = '';
		}
		
		if($telephone =='' )
		{
			$telephone = '';
		}
		

		if( $Mobile =='' )
		{
			$Mobile = '';
		}
		

		if( $email =='' )
		{
			$email = '';
		}
		
	
		$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/UpdateCustomerContact";
			// list site (lone worker)
			$xml = '<?xml version="1.0" encoding="utf-8"?>
			<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
				 <soap:Body>
					<UpdateCustomerContact xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
						<updateCustomerContactRequestKey>
						<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
						<Password>'.$this->config->item('sentry_master')['password'].'</Password>
						<SerialNumber>'.$serialNumber.'</SerialNumber>
						<CustomerContactIdentifier>'.$identifier.'</CustomerContactIdentifier>
						<CustomerContactDetails>

								<Name>'.$first_name.'</Name>
								<PhoneNumber>'.$telephone.'</PhoneNumber>
								<WorkNumber>'.$Office_No.'</WorkNumber>
								<MobileNumber>'.$Mobile.'</MobileNumber>
								<EmailAddress>'.$email.'</EmailAddress>
								<IsKeyHolder>true</IsKeyHolder>
								<CanCancelAlarms>true</CanCancelAlarms>
								<CanEditKeyHolders>true</CanEditKeyHolders>
								<CanEditSchedules>true</CanEditSchedules>
								<CanEditSiteData>true</CanEditSiteData>

						</CustomerContactDetails>
						</updateCustomerContactRequestKey>
					</UpdateCustomerContact>
					 </soap:Body>
				</soap:Envelope>';
				$xml;
				$curl_request = $this->curl->curl_send($xml, $url);
				// convert xml into array
				$convertToArray = $this->curl->xmlToArray($curl_request);
					//debug($convertToArray);

				$response_error = $convertToArray['UpdateCustomerContactResponse']['UpdateCustomerContactResult']['Errors'];
				if( !empty($response_error) )
				{
					$msg = $response_error['Message']['MessageText'];
					echo json_encode([ 'error' => '1', 'msg' => $msg  ]); exit;
				}

				$response = $convertToArray['UpdateCustomerContactResponse']['UpdateCustomerContactResult'];
				
				echo json_encode(['error' => '0', 'msg' => 'User escalation updated successfully' ]);
				
	}
	
	public function deleteEscalationContact() {
	
		
		$serialNumber = $this->input->post('serialNumber');
		$identifier   = $this->input->post('identifier') ;
		
		
		if (!$serialNumber)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter serial number' ]);
			exit ;
		}
		
		if (!$identifier)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter identifier' ]);
			exit ;
		}
		
		
		
		$ListCustomerContactsInGroup = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/DeleteCustomerContact";

		$ListCustomerContactsInGroup_xml = '<?xml version="1.0" encoding="utf-8"?>
		<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
			 <soap:Body>
				<DeleteCustomerContact xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
					<deleteCustomerContactRequestKey>
					<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
					<Password>'.$this->config->item('sentry_master')['password'].'</Password>
					<SerialNumber>'.$serialNumber.'</SerialNumber>
					<CustomerContactIdentifier>'.$identifier.'</CustomerContactIdentifier>
					</deleteCustomerContactRequestKey>
				</DeleteCustomerContact>
				 </soap:Body>
			</soap:Envelope>';

		$curl_request = $this->curl->curl_send($ListCustomerContactsInGroup_xml, $ListCustomerContactsInGroup);

		$xmlToArray_request = $this->curl->xmlToArray($curl_request);
		
		if ( isset($xmlToArray_request['DeleteCustomerContactResponse']['DeleteCustomerContactResult']['Errors']) ) {

			echo json_encode(['error'=> 1, 'msg' => $xmlToArray_request['DeleteCustomerContactResponse']['DeleteCustomerContactResult']['Errors']['Message']['MessageText'] ]);

		} else {

			echo json_encode(['error'=> 0, 'msg' => 'Escalation deleted successfully' ]);

		}

	}
	
	public function updateEscalationPositionDetail(){
		
		$items 		= $this->input->post('item');
		$groupId 	= $this->input->post('groupId') ;
		
		if (!$items)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter items' ]);
			exit ;
		}
		
		if (!$groupId)  {
			echo json_encode([ 'error' => '1',  'msg' => 'missing required parameter group id' ]);
			exit ;
		}
		
		
		for( $var=0; $var<count($this->input->post('item')); $var++ )
		{
			 $explode = explode(',',$this->input->post('item')[$var]);
			 $serialNumber = $explode[1];
			 
			 $xml_create1 .= '<CustomerContactListItem><Name>'.$explode[0].'</Name><Identifier>'.$explode[2].'</Identifier><SerialNumber>'.$explode[1].'</SerialNumber></CustomerContactListItem>';
		}
		
		$url_create = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/SetCustomerContactGroupList";
		// list site (lone worker)
			$xml_create = '<?xml version="1.0" encoding="utf-8"?>
			<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
				 <soap:Body>
					<SetCustomerContactGroupList xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
						<setCustomerContactGroupRequestKey>
						<UserName>'.$this->config->item('sentry_master')['username'].'</UserName>
						<Password>'.$this->config->item('sentry_master')['password'].'</Password>
						<SerialNumber>'.$serialNumber.'</SerialNumber>
						<GroupNumber>'.$groupId.'</GroupNumber>
						<ListOfCustomerContacts>';
							$xml_create .= $xml_create1;
						$xml_create .='</ListOfCustomerContacts>
						</setCustomerContactGroupRequestKey>
					</SetCustomerContactGroupList>
					 </soap:Body>
				</soap:Envelope>';
				
				$curl_request_create = $this->curl->curl_send($xml_create, $url_create);
				// convert xml into array
				$response_error = $convertToArray_create['SetCustomerContactGroupListResponse']['SetCustomerContactGroupListResult']['Errors'];
				
				if(empty($convertToArray_create['SetCustomerContactGroupListResponse']['SetCustomerContactGroupListResult'])){
					echo json_encode(['error'=> 0, 'msg' => 'Priority updated successfully']);
					exit ;
				}
				if( !empty($response_error) )
				{
					$msg = $response_error['Message']['MessageText'];
					echo json_encode(['error'=> 1, 'msg' => $msg]); exit;
				}
		
		
		
		
	}
	
	
	//Function to update the homesafe_geofencing_user_details details table when geofence is set from the app
	
	public function geofenceSettingsFromApp() {
		
		$user_name    	 = $this->input->post('user_name') ;
		$phone    	  	 = $this->input->post('phone') ;
		$serialNumber 	 = $this->input->post('serial_number');
		$latitude     	 = $this->input->post('latitude') ;
		$longitude 	  	 = $this->input->post('longitude') ;
		$radius 		 = $this->input->post('radius') ;
		$homesafe_name   = $this->input->post('homesafe_name') ;
		$device_type   	 = $this->input->post('device_type') ;
	
	
		if ( !$serialNumber || !$latitude || !$longitude || !$radius || !$homesafe_name ) {
		
			echo json_encode(['error'=> 1, 'msg' => 'Missing required parameters']); 
			exit;
		
		}
		
		if ( !$this->validateLatLong($latitude, $longitude) ) {
			echo json_encode(['error'=> 1, 'msg' => 'Ivalid latitude/longitude']); 
			exit;
		}
		
		$data['name'] 		    = $user_name ;
		$data['phone'] 			= $phone ;
		$data['serial_number']  = $serialNumber ;
		$data['latitude']       = $latitude ;
		$data['longitude']      = $longitude ;
		$data['radius'] 		= $radius ;
		$data['homesafe_name']  = $homesafe_name ;
		$data['device_type']    = $device_type ;
		$data['created_from']   = "app" ;
	
		$saveInfo = $this->users->saveInfoHomesafeGeofnece($data) ;
		
		
		if($saveInfo) {
			echo json_encode(['error'=> 0, 'msg' => 'Success']); 
			exit;
		} else {
			echo json_encode(['error'=> 1, 'msg' => 'Database Error']); 
			exit;
		}
	
	} 
	
	
	
	function validateLatLong($lat, $long) {
		return preg_match('/^[-]?(([0-8]?[0-9])\.(\d+))|(90(\.0+)?),[-]?((((1[0-7][0-9])|([0-9]?[0-9]))\.(\d+))|180(\.0+)?)$/', $lat.','.$long);
	}
	
	public function deleteGeofenceSettingsFromApp() {
	
		$serialNumber 	 = $this->input->post('serial_number');
		
		if ( !$serialNumber ) {
			echo json_encode(['error'=> 1, 'msg' => 'Missing required parameters']); 
			exit;
		}
		
		$deleteGeofence = $this->users->deleteHomesafeGeofnece($serialNumber) ;
		
		if($deleteGeofence) {
			echo json_encode(['error'=> 0, 'msg' => 'Success']); 
			exit;
		} else {
			echo json_encode(['error'=> 1, 'msg' => 'Database Error']); 
			exit;
		}
		
	
	}
	
}
