<?php

namespace uncanny_learndash_groups;

/**
 * [uo_groups_buy_courses]'s template
 */

?>

<form id="uo-groups-buy-courses" class="buy-courses-form" method="POST">

	<?php if ( ( isset( $_GET['_wpnonce'] ) && wp_verify_nonce( $_GET['_wpnonce'], Utilities::get_plugin_name() ) ) && isset( $_GET['group-id'] ) && is_numeric( $_GET['group-id'] ) ) { ?>
		<input type="hidden" value="yes" name="modify_license"/>
		<input type="hidden" value="<?php echo intval( $_GET['group-id'] ) ?>" name="group_id"/>
	<?php } ?>

	<?php if ( ( isset( $_GET['_wpnonce'] ) && wp_verify_nonce( $_GET['_wpnonce'], Utilities::get_plugin_name() ) ) && isset( $_GET['group-id'] ) && is_numeric( $_GET['modify-license'] ) ) { ?>
		<input type="hidden" value="<?php echo intval( $_GET['modify-license'] ) ?>" name="product_id"/>
	<?php } ?>

	<?php wp_nonce_field( Utilities::get_plugin_name(), '_custom_buy_courses' ); ?>

	<?php
	$logic              = true;
	$group_name         = '';
	$existing_courses   = array();
	$is_course_addition = false;

	if ( ( isset( $_GET['_wpnonce'] ) && wp_verify_nonce( $_GET['_wpnonce'], Utilities::get_plugin_name() ) ) && isset( $_GET['modify-license'] ) && is_user_logged_in() ) {

		$user_id   = wp_get_current_user()->ID;
		$group_ids = learndash_get_administrators_group_ids( $user_id );

		if ( ! learndash_is_group_leader_user( $user_id ) && ! in_array( intval( $_GET['group-id'] ), $group_ids ) ) {

			$error = __( 'You do not have permission to manage this group.', 'uncanny-learndash-groups' );
			$logic = false;

		} else {

			$group_post = get_post( intval( $_GET['group-id'] ) );

			if ( ! empty( $group_post ) && 'groups' === $group_post->post_type ) {

				$group_name   = $group_post->post_title;
				$group_admins = learndash_get_groups_administrators( $_GET['group-id'], true );

				if ( ! empty( $group_admins ) ) {

					$group_users = array();

					foreach ( $group_admins as $group_admin ) {
						$group_users[ $group_admin->ID ] = $group_admin->ID;
					}

				}

				if ( ! in_array( $user_id, $group_users ) ) {

					$error = __( 'You do not have permission to manage this group.', 'uncanny-learndash-groups' );
					$logic = false;

				}

			} else {

				$error = __( 'Invalid group.', 'uncanny-learndash-groups' );
				$logic = false;

			}
		}

		$product_post = get_post( intval( $_GET['modify-license'] ) );

		if ( empty( $product_post ) || 'product' !== $product_post->post_type ) {

			$error = __( 'Invalid license.', 'uncanny-learndash-groups' );
			$logic = false;

		} else {

			$existing_courses   = get_post_meta( $product_post->ID, SharedFunctions::$license_meta_field, true );
			$is_course_addition = true;

		}
	}

	$total = 0;
	if ( $logic ) :

		?>

		<?php

		$products = get_posts( array(
			'post_type'      => 'product',
			'orderby'        => 'title',
			'order'          => 'ASC',
			'posts_per_page' => 8888,
			'tax_query'      => array(
				array(
					'taxonomy' => 'product_type',
					'field'    => 'slug',
					'terms'    => 'courses',
				),
			),
		) );

		if ( $products ) {

			?>

			<!-- Group data -->
			<div id="uo-groups-buy--group-data" class="uo-groups-section">
				<div id="uo-groups-buy-courses-data" class="uo-row">
					<div class="uo-groups-section-header">
						<h3><?php _e( 'Group', 'uncanny-learndash-groups' ); ?></h3>
					</div>

					<?php

					$bulk_discounts           = get_option( SharedFunctions::$bulk_discount_options, [] );
					$number_of_bulk_discounts = key_exists( 'discounts', $bulk_discounts ) ? count( $bulk_discounts['discounts'] ) : 0;

					if ( key_exists( 'enabled', $bulk_discounts ) && 'yes' === $bulk_discounts['enabled'] && $number_of_bulk_discounts > 0 ) {
						$has_bulk_discounts = $bulk_discounts['enabled'];
					} else {
						$has_bulk_discounts = false;
					}

					$uo_section_class = ! $has_bulk_discounts ? 'uo-groups--bulk-discount-disabled' : '';

					$learn_dash_labels = new \LearnDash_Custom_Label();
					$course_label      = $learn_dash_labels::get_label( 'courses' );

					$uo_groups_buy_totals_classes = array();

					if ( $has_bulk_discounts ) {
						$uo_groups_buy_totals_classes[] = 'uo-groups-buy__totals--has-bulk-discounts';
					}

					if ( $is_course_addition ) {
						$uo_groups_buy_totals_classes[] = 'uo-groups-buy__totals--has-course-additions';
					}

					?>

					<div class="uo-groups-section-content <?php echo $uo_section_class; ?>">

						<div class="uo-groups--group-data">
							<!-- Group name -->
							<div class="uo-groups--group-name">
								<div class="uo-groups-form-row">
									<div class="uo-groups-form-row--title">
										<?php _e( 'Group name', 'uncanny-learndash-groups' ); ?>
									</div>
									<div class="uo-groups-form-row--element">
										<input class="uo-input" type="text" value="<?php if ( ! empty( $group_name ) ) {
											echo $group_name;
										} ?>" name="_custom_group_name" <?php if ( ! empty( $group_name ) ) { ?> disabled="disabled" <?php } ?> required="required">
									</div>
									<div class="uo-groups-form-row--comment">
										<?php printf( __( 'The name of the group for which you are purchasing the %s.', 'uncanny-learndash-groups' ), strtolower( $course_label ) ); ?>
									</div>
								</div>
							</div>

							<!-- Seats -->
							<div class="uo-groups--group-seats">
								<div class="uo-groups-form-row">
									<div class="uo-groups-form-row--title">
										<?php echo ucfirst( __( get_option( 'ulgm_per_seat_text_plural', 'Seats' ), 'uncanny-learndash-groups' ) ); ?>
									</div>
									<div class="uo-groups-form-row--element">
										<input class="uo-input" type="number" value="<?php if ( $is_course_addition ) {
											echo get_post_meta( absint( $_GET['group-id'] ), '_ulgm_total_seats', true );
										} else {
											echo '1';
										} ?>" name="_custom_qty" id="uo-groups-quantity" min="1" required="required" <?php if ( $is_course_addition ) { ?> readonly="readonly" disabled="disabled" <?php } ?>>
									</div>
									<div class="uo-groups-form-row--comment">
										<?php printf( __( 'The number of users who require access.', 'uncanny-learndash-groups' ), strtolower( $course_label ) ); ?>
									</div>
								</div>
							</div>
						</div>

						<?php if ( $has_bulk_discounts ) { ?>

							<div class="uo-groups--bulk-discount">
								<div class="uo-groups-box">
									<div class="uo-groups--bulk-discount-title">
										<?php

										if ( $number_of_bulk_discounts == 1 ) {
											_e( 'Bulk Discount', 'uncanny-learndash-groups' );
										} else {
											_e( 'Bulk Discounts', 'uncanny-learndash-groups' );
										}

										?>
									</div>

									<div class="uo-groups-table">

										<div class="uo-groups-table-content">

											<?php for ( $i = 1; $i < 11; $i ++ ) { ?>
												<?php if ( key_exists( 'discounts', $bulk_discounts ) && key_exists( $i, $bulk_discounts['discounts'] ) ) { ?>
													<?php

													$next = '+';

													if ( $i < 11 ) {
														if ( key_exists( $i + 1, $bulk_discounts['discounts'] ) ) {
															$next = $bulk_discounts['discounts'][ $i + 1 ]['qty'] - 1;
														}
													}

													?>

													<div class="uo-groups-table-row">
														<div class="uo-groups-table-cell">

															<?php

															$text = ! is_numeric( $next ) ? '+' : '';
															$text .= $bulk_discounts['discounts'][ $i ]['qty'];
															$text = is_numeric( $next ) ? $text . ' ' . __( 'to', 'uncanny-learndash-groups' ) . ' ' . $next : $text;
															$text .= ' ' . strtolower( __( get_option( 'ulgm_per_seat_text_plural', 'Seats' ), 'uncanny-learndash-groups' ) );

															echo $text;

															?>

															<input type="hidden" id="bulk-discount-<?php echo $i ?>" name="bulk-discount-<?php echo $i ?>" value="<?php echo $bulk_discounts['discounts'][ $i ]['percent'] ?>" data-qty="<?php echo $bulk_discounts['discounts'][ $i ]['qty']; ?>"/>

														</div>
														<div class="uo-groups-table-cell">
															- <?php echo $bulk_discounts['discounts'][ $i ]['percent'] ?>
															%
														</div>
													</div>

												<?php } ?>
											<?php } ?>

										</div>
									</div>
								</div>
							</div>

						<?php } ?>

					</div>
				</div>
			</div>

			<!-- Select courses -->
			<div id="uo-groups-buy--courses" class="uo-groups-section">
				<div id="uo-groups-buy-courses-select" class="uo-row">
					<div class="uo-groups-section-header">
						<h3>
							<?php
							echo esc_html( $course_label );
							?>
						</h3>
					</div>
					<div class="uo-groups-section-content">
						<div class="uo-groups--courses">
							<div class="uo-groups-box">
								<div class="uo-groups-table">
									<div class="uo-groups-table-header">
										<?php _e( 'Price', 'uncanny-learndash-groups' ); ?>
									</div>
									<div class="uo-groups-table-content">

										<?php

										foreach ( $products as $product ) {
											$product_id = $product->ID;
											$_product   = new \WC_Product( $product_id );

											?>

											<div class="uo-groups-table-row">

												<div class="uo-groups-table-cell uo-groups-table-name checkbox-required">
													<?php

													if ( in_array( $_product->get_id(), $existing_courses ) ) {
														$total += wc_get_price_excluding_tax( $_product );

														?>

														<label class="uo-checkbox">
															<input type="checkbox" data-price="<?php echo wc_get_price_excluding_tax( $_product ); ?>" name="_custom_already_selected_courses[]" disabled="disabled" checked="checked" value="<?php echo $product_id ?>"/>
															<div class="uo-checkmark"></div>
															<span class="uo-label">
																			<?php echo esc_html( $product->post_title ); ?>
																		</span>
														</label>

														<?php

													} else { ?>

														<label class="uo-checkbox">
															<input type="checkbox" data-price="<?php echo wc_get_price_excluding_tax( $_product ); ?>" name="_custom_selected_courses[]" value="<?php echo $product_id ?>"/>
															<div class="uo-checkmark"></div>
															<span class="uo-label">
																			<?php echo esc_html( $product->post_title ); ?>
																		</span>
														</label>

													<?php } ?>

												</div>

												<div class="uo-groups-table-cell uo-groups-table-price">
													<?php echo $_product->get_price_html(); ?>
												</div>

											</div>

											<?php
										}

										$currency_symbol = get_woocommerce_currency_symbol( get_woocommerce_currency() );
										$currency_pos    = get_option( 'woocommerce_currency_pos', 'left' );
										$num_decimals    = get_option( 'woocommerce_price_num_decimals', '2' );

										?>
									</div>

									<?php if ( $is_course_addition ) { ?>
										<input type="hidden" value="<?php echo $total; ?>" id="prevorder"/>
									<?php } ?>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Total -->
			<div id="uo-groups-buy--totals" class="uo-groups-section <?php echo implode( ' ', $uo_groups_buy_totals_classes ); ?>">
				<div id="uo-groups-buy-courses-total" class="uo-row">
					<div class="uo-groups-section-content">
						<div class="uo-groups--totals">
							<div class="uo-groups-box">
								<div class="uo-groups-table">
									<div class="uo-groups-table-content">
										<!-- Subtotal -->
										<div class="uo-groups-table-row uo-groups-table-row--subtotal">
											<div class="uo-groups-table-cell uo-groups-table-name">
												<h5><?php _e( 'Cart Total', 'uncanny-learndash-groups' ); ?></h5></div>
										</div>
										<?php if ( $has_bulk_discounts || $is_course_addition ) { ?>

											<!-- Subtotal -->
											<div class="uo-groups-table-row uo-groups-table-row--subtotal">
												<div class="uo-groups-table-cell uo-groups-table-name"><?php _e( 'Subtotal', 'uncanny-learndash-groups' ); ?></div>
												<div class="uo-groups-table-cell uo-groups-table-price">
													<div class="uo-groups-subtotal">
														<?php

														switch ( $currency_pos ) {

															case 'right':

																?>

																<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>
																<span><?php echo $currency_symbol ?></span>

																<?php
																break;

															case 'left_space':

																?>

																<span><?php echo $currency_symbol ?>&nbsp;</span>
																<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>

																<?php
																break;

															case 'right_space':

																?>

																<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>
																<span>&nbsp;<?php echo $currency_symbol ?></span>

																<?php
																break;

															case 'left':
															default:

																?>

																<span><?php echo $currency_symbol ?></span>
																<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>

																<?php
																break;
														}

														?>
													</div>
												</div>
											</div>

										<?php } ?>

										<?php if ( $has_bulk_discounts ) { ?>

											<!-- Bulk Discount -->
											<div class="uo-groups-table-row uo-groups-table-row--bulk-discount">
												<div class="uo-groups-table-cell uo-groups-table-name">
													<?php _e( 'Bulk Discount', 'uncanny-learndash-groups' ) ?>
												</div>
												<div class="uo-groups-table-cell uo-groups-table-price">
													<div class="uo-groups-discount">
														<?php

														switch ( $currency_pos ) {

															case 'right':

																?>

																<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>
																<span><?php echo $currency_symbol ?></span>

																<?php
																break;

															case 'left_space':

																?>

																<span><?php echo $currency_symbol ?>&nbsp;</span>
																<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>

																<?php
																break;

															case 'right_space':

																?>

																<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>
																<span>&nbsp;<?php echo $currency_symbol ?></span>

																<?php
																break;

															case 'left':
															default:

																?>

																<span><?php echo $currency_symbol ?></span>
																<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>

																<?php
																break;
														}

														?>
													</div>
												</div>
											</div>

										<?php } ?>

										<!-- Course Additions -->
										<?php if ( $is_course_addition ) { ?>

											<!--<div class="uo-groups-table-row uo-groups-table-row--course-additions">
												<div class="uo-groups-table-cell uo-groups-table-name">
													<?php
											/*
																								$seats = strtolower( get_option( 'ulgm_per_seat_text_plural', __( 'Seats', 'uncanny-learndash-groups' ) ) );
																								_e( sprintf( 'Credit for existing %s', $seats ), 'uncanny-learndash-groups' );

																								*/ ?>
												</div>
												<div class="uo-groups-table-cell uo-groups-table-price">
													<div class="uo-groups-prevorder">
														<?php
											/*
																									switch ( $currency_pos ) {

																										case 'right':

																											*/ ?>

																<span class="digits"><?php /*echo number_format_i18n( 0, $num_decimals ); */ ?></span>
																<span><?php /*echo $currency_symbol */ ?></span>

																<?php
											/*																break;

																										case 'left_space':

																											*/ ?>

																<span><?php /*echo $currency_symbol */ ?>&nbsp;</span>
																<span class="digits"><?php /*echo number_format_i18n( 0, $num_decimals ); */ ?></span>

																<?php
											/*																break;

																										case 'right_space':

																											*/ ?>

																<span class="digits"><?php /*echo number_format_i18n( 0, $num_decimals ); */ ?></span>
																<span>&nbsp;<?php /*echo $currency_symbol */ ?></span>

																<?php
											/*																break;

																										case 'left':
																										default:

																											*/ ?>

																<span><?php /*echo $currency_symbol */ ?></span>
																<span class="digits"><?php /*echo number_format_i18n( 0, $num_decimals ); */ ?></span>

																<?php
											/*																break;
																									}

																									*/ ?>
													</div>
												</div>
											</div>-->

										<?php } ?>

										<!-- Total -->
										<div class="uo-groups-table-row uo-groups-table-row--total">
											<div class="uo-groups-table-cell uo-groups-table-name"><?php _e( 'Total', 'uncanny-learndash-groups' ); ?></div>
											<div class="uo-groups-table-cell uo-groups-table-price">
												<div class="uo-groups-total">
													<?php

													switch ( $currency_pos ) {

														case 'right':

															?>

															<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>
															<span><?php echo $currency_symbol ?></span>

															<?php
															break;

														case 'left_space':

															?>

															<span><?php echo $currency_symbol ?>&nbsp;</span>
															<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>

															<?php
															break;

														case 'right_space':

															?>

															<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>
															<span>&nbsp;<?php echo $currency_symbol ?></span>

															<?php
															break;

														case 'left':
														default:

															?>

															<span><?php echo $currency_symbol ?></span>
															<span class="digits"><?php echo number_format_i18n( 0, $num_decimals ); ?></span>

															<?php
															break;
													}

													?>
												</div>
											</div>
										</div>

									</div>
								</div>

								<?php if ( get_option( 'woocommerce_calc_taxes', 'no' ) === 'yes' ) { ?>
									<div class="uo-groups-table--note">
										<?php _e( 'Taxes will be calculated at checkout.', 'uncanny-learndash-groups' ); ?>
									</div>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Maybe change this class? -->
			<div class="uo_groups_error"></div>

		<?php } ?>

		<!-- Add to cart -->
		<div id="uo-groups-buy--add-to-cart" class="uo-groups-section">
			<div class="uo-row">

				<?php if ( $products ) { ?>

					<button type="submit" id="submit" class="uo-btn"><?php _e( 'Add to Cart', 'uncanny-learndash-groups' ); ?></button>

				<?php } else { ?>

					<?php _e( 'Sorry, there are currently no courses available for purchase.', 'uncanny-learndash-groups' ); ?>

				<?php } ?>

			</div>
		</div>

	<?php else: ?>

		<h3><?php echo $error; ?></h3>

	<?php endif; ?>
</form>

<script>

  jQuery(function ($) {
    $(document).ready(function () {
      UO_Groups_Buy.init()
      setTimeout(function () {
        UO_Groups_Buy.update_totals(UO_Groups_Buy.get_totals())
      }, 1000)
    })

    var UO_Groups_Buy = {
      form: null,
      elements: {
        error_box: null,
        quantity_input: null,
        course_checkbox: null,
        course_checkbox_checked: null,
        prevorder_input: null,
        totals: {
          subtotal: null,
          prevorder: null,
          discount: null,
          percent: null,
          total: null
        }
      },

      config: {
        is_course_addition: <?php echo json_encode( $is_course_addition ); ?>,
        has_bulk_discounts_enabled: <?php echo json_encode( $has_bulk_discounts ); ?>
      },

      init: function () {
        // Save DOM elements
        this.form = $('#uo-groups-buy-courses')
        this.elements.error_box = $('#uo-groups-buy-courses .uo_groups_error')
        this.elements.quantity_input = $('#uo-groups-buy-courses #uo-groups-quantity')
        this.elements.course_checkbox = $('#uo-groups-buy-courses #uo-groups-buy-courses-select input[type="checkbox"]')
        this.elements.prevorder_input = $('#uo-groups-buy-courses #prevorder')

        this.elements.totals.subtotal = $('#uo-groups-buy-courses .uo-groups-subtotal .digits')
        //this.elements.totals.prevorder = $('#uo-groups-buy-courses .uo-groups-prevorder .digits')
        this.elements.totals.discount = $('#uo-groups-buy-courses .uo-groups-discount .digits')
        this.elements.totals.total = $('#uo-groups-buy-courses .uo-groups-total .digits')
        this.elements.totals.percent = $('.uo-groups-table-row--bulk-discount .uo-groups-table-name')

        this.elements.course_checkbox_checked = $('#uo-groups-buy-courses #uo-groups-buy-courses-select :checked')

        // Bind submission
        this.form.submit(function (event) {
          // Validate form
          if (!UO_Groups_Buy.validate()) {
            // Prevent submit
            event.preventDefault()
          }
        })

        // Bind form changes to re-calculate totals
        this.elements.quantity_input.on('input', function () {
          UO_Groups_Buy.update_totals(UO_Groups_Buy.get_totals())
        })

        this.elements.course_checkbox.change(function () {
          UO_Groups_Buy.elements.course_checkbox_checked = $('#uo-groups-buy-courses #uo-groups-buy-courses-select :checked')

          UO_Groups_Buy.select_course_row($(this))
          UO_Groups_Buy.update_totals(UO_Groups_Buy.get_totals())
        })
      },

      validate: function () {
        // Check if the user selected at least one course

        let response = false

        if (this.elements.course_checkbox_checked.length > 0) {
          this.elements.error_box.html('').hide()
          response = true
        } else {
          this.elements.error_box.html('<?php echo __( 'Please select at least one course to continue.', 'uncanny-learndash-groups' ); ?>').show()
          response = false
        }

        return response
      },

      select_course_row: function (checkbox) {
        let is_checked = checkbox.is(':checked')

        let $row = checkbox.closest('.uo-groups-table-row')

        if (is_checked) {
          $row.addClass('uo-groups-table-row--selected')
        } else {
          $row.removeClass('uo-groups-table-row--selected')
        }
      },

      update_totals: function (data) {
        // Update totals, needs the get_totals object

        if (this.config.is_course_addition) {
          //ui_update_total(this.elements.totals.prevorder, data.prevorder)
        }

        ui_update_total(this.elements.totals.subtotal, data.subtotal)
        ui_update_total(this.elements.totals.discount, data.discount)
        ui_update_total(this.elements.totals.total, data.total)
        ui_update_total(this.elements.totals.percent, data.percent)

        function ui_update_total (element, content) {
          element.fadeOut(50).html(content).fadeIn(150)
        }
      },

      get_totals: function () {
        // Returns an object with the current subtotal, discount and total

        let discount = 0,
          subtotal = 0,
          quantity = 0,
          prevorder = 0,
          decimal_points = <?php echo get_option( 'woocommerce_price_num_decimals', '2' ); ?>;

        let total = 0

        // Selected courses
        this.elements.course_checkbox_checked.each(function () {
          subtotal = parseFloat(subtotal) + parseFloat($(this).data('price'))
        })

        // Quantity
        quantity = this.elements.quantity_input.val()

        if (this.config.is_course_addition) {
          prevorder = this.elements.prevorder_input.val()
          prevorder = prevorder * quantity
        }

        subtotal = subtotal * quantity
        if (this.config.has_bulk_discounts_enabled) {
          var coefficient = this.get_coefficient(quantity)
          total = (subtotal - prevorder) * coefficient
          discount = -Math.abs(subtotal - prevorder - ((subtotal - prevorder) * coefficient))
        } else {
          total = subtotal
        }
        if (this.config.is_course_addition) {
           total = total - prevorder
        }

        total = total < 0 ? 0 : total
        let display = subtotal - prevorder
        let display_coeff = 1 == coefficient ? '' : Math.abs((1 - coefficient) * 100).toFixed(0) + '%  '
        return {
          subtotal: display.toFixed(decimal_points),
          discount: discount.toFixed(decimal_points),
          prevorder: (prevorder * -1).toFixed(2),
          total: total.toFixed(decimal_points),
          percent: display_coeff + '<?php _e( 'Bulk Discount', 'uncanny-learndash-groups' ) ?>'
        }
      },

      get_coefficient: function (quantity) {
        let q = [0.0],
          d = [0.0],
          coeff = 1,
          bulk_discount = <?php echo wp_json_encode( get_option( SharedFunctions::$bulk_discount_options, array() ) ); ?>;
        if (Object.keys(bulk_discount).length > 0) {
          if ('yes' == bulk_discount['enabled']) {
            var available_discounts = bulk_discount['discounts']
            for (let i = 1; i <= 10; i++) {
              if (i in available_discounts) {
                q.push(available_discounts[i]['qty'])
                d.push(available_discounts[i]['percent'] ? available_discounts[i]['percent'] : 0.0)

                if (parseInt(quantity) >= parseInt(q[i]) && parseInt(q[i]) > parseInt(q[0])) {
                  q[0] = parseInt(q[i])
                  d[0] = d[i]
                }
              }
            }
            coeff = Math.min(1.0, Math.max(0, (100.0 - Math.round(d[0], 2)) / 100.0))
          }
        }

        return coeff
      }
    }
  })
</script>