<?php

namespace uncanny_learndash_groups;
?>

<?php

/* Col width based on display situations */

if ( ! $remove_user_button && ! $key_column ) {

	// [ ] Select user | [ ✓ ] Content | [ ] Key

	$col_width   = array( 0, '2', '2', '4', '2', 0 );
	$table_class = '__content';
} elseif ( $remove_user_button && ! $key_column ) {

	// [ ✓ ] Select user | [ ✓ ] Content | [ ] Key

	$col_width   = array( '0_5', '2', '2', '3_5', '2', 0 );
	$table_class = '__select_content';
} elseif ( ! $remove_user_button && $key_column ) {

	// [ ] Select user | [ ✓ ] Content | [ ✓ ] Key

	$col_width   = array( 0, '2', '1_5', '3_5', '1_5', '1_5' );
	$table_class = '__content_key';
} else {

	// [ ✓ ] Select user | [ ✓ ] Content | [ ✓ ] Key

	$col_width   = array( '0_5', '1_5', '1_5', '3_5', '1_5', '1_5' );
	$table_class = '__select_content_key';
}

?>

<!-- Table -->
<div class="uo-row uo-groups-table">
	<div class="uo-table uo-jplist <?php echo $table_class; ?>">
		<div id="user-table-header" class="uo-group-management-table uo-pseudo-table">
			<!-- Header -->
			<div class="uo-row uo-table-row uo-table-header">
				<header class="jplist-panel pseudo-table-header">
					<div class="uo-row" data-control-type="sort-buttons-group" data-control-name="header-sort-buttons" data-control-action="sort" data-mode="single" data-datetime-format="{month}/{day}/{year}">

						<?php

						/* Cols */

						$cell = array(
							'select-all' => array(
								'css-classes' => 'header-select-all',
								'cell-width'  => $col_width[0],
							),
							'first-name' => array(
								'css-classes' => 'header-first-name',
								'cell-width'  => $col_width[1],
								'show-sort'   => true
							),
							'last-name'  => array(
								'css-classes' => 'header-last-name',
								'cell-width'  => $col_width[2],
								'show-sort'   => true
							),
							'email'      => array(
								'css-classes' => 'header-email',
								'cell-width'  => $col_width[3],
								'show-sort'   => false
							),
							'status'     => array(
								'css-classes' => 'header-status',
								'cell-width'  => $col_width[4],
								'show-sort'   => true
							),
							'key'        => array(
								'css-classes' => 'header-key',
								'cell-width'  => $col_width[5],
								'show-sort'   => false
							)
						);

						$css_classes = $cell['select-all']['css-classes'];
						$cell_width  = $cell['select-all']['cell-width'];

						// Remove checkbox if the user decided to hide "Remove Users" button
						if ( ! $remove_user_button ) {
							unset( $cell['select-all'] );
						} else {

							?>

							<div class="header-column <?php echo $css_classes; ?> uo-table-cell uo-table-cell-<?php echo $cell_width; ?>">
								<label class="uo-checkbox">
									<input class="uo-checkbox-input" name="select-all-users" id="select-all-users" type="checkbox">
									<span class="uo-checkbox-checkmark"></span>
								</label>
							</div>

							<?php

						}

						?>

						<?php

						// Remove Key column
						if ( ! $key_column ) {
							unset( $cell['key'] );
						}

						foreach ( GroupManagementInterface::$ulgm_management_shortcode['table']['enrolled_users']['headers'] as $header ) {

							if ( isset( $cell [ $header['slug'] ] ) ) {

								$css_classes = $cell[ $header['slug'] ]['css-classes'];
								$cell_width  = $cell[ $header['slug'] ]['cell-width'];
								$show_sort   = $cell[ $header['slug'] ]['show-sort'];

								?>

								<div class="header-column <?php echo $css_classes; ?> uo-table-cell uo-table-cell-<?php echo $cell_width; ?>">
									<span class="uog_header header"><?php echo $header['title']; ?></span>

									<?php if ( $show_sort ) { ?>
										<span class="uo-table-sort-buttons sort-btns">
													<i class="uo-table-sort-btn uo-hidden fa fa-angle-up" data-direction="up" data-path=".<?php echo $header['slug']; ?>" data-type="text" data-order="asc" title="Sort by <?php echo $header['title']; ?> Asc"></i>
													<i class="uo-table-sort-btn fa fa-angle-down" data-direction="down" data-path=".<?php echo $header['slug']; ?>" data-type="text" data-order="desc" title="Sort by <?php echo $header['title']; ?> Desc"></i>
												</span>
									<?php } ?>
								</div>

								<?php

							}
						}

						?>

					</div>
				</header>
			</div>

			<!-- Content & No results -->
			<div class="uo-row uo-table-content">
				<div class="pseudo-table-body">
					<?php

					$cell = array(
						'select'     => array(
							'css-classes' => 'content-select',
							'cell-width'  => $col_width[0],
							'clipboard'   => false
						),
						'first-name' => array(
							'css-classes' => 'content-first-name',
							'cell-width'  => $col_width[1],
							'clipboard'   => false
						),
						'last-name'  => array(
							'css-classes' => 'content-last-name',
							'cell-width'  => $col_width[2],
							'clipboard'   => false
						),
						'email'      => array(
							'css-classes' => 'content-email',
							'cell-width'  => $col_width[3],
							'clipboard'   => false
						),
						'status'     => array(
							'css-classes' => 'content-status',
							'cell-width'  => $col_width[4],
							'clipboard'   => false
						),
						'key'        => array(
							'css-classes' => 'content-key',
							'cell-width'  => $col_width[5],
							'clipboard'   => true
						)
					);

					// Remove Key column
					if ( ! $key_column ) {
						unset( $cell['key'] );
					}

					foreach ( GroupManagementInterface::$ulgm_enrolled_users_data as $user_id => $ulgm_enrolled_user_data_set ) {

						?>
						<div class="uo-row uo-jplist-row uo-table-content uo-tbl-item body-row">
							<?php

							$css_classes = isset( $cell['select'] ) ? $cell['select']['css-classes'] : '';
							$cell_width  = isset( $cell['select'] ) ? $cell['select']['cell-width'] : '';

							// Remove checkbox if the user decided to hide "Remove Users" button
							if ( ! $remove_user_button ) {
								unset( $cell['select'] );
							} else {

								?>

								<div class="<?php echo $css_classes; ?> uo-table-cell uo-table-cell-<?php echo $cell_width; ?>">
									<?php
									$user = new \WP_User( $user_id );
									if ( 'yes' === get_option( 'allow_to_remove_users_anytime', 'no' ) ) { ?>
										<label class="uo-checkbox">
											<input class="uo-checkbox-input select-user" name="user-id[]" value="<?php echo $user_id; ?>" type="checkbox">
											<span class="uo-checkbox-checkmark"></span>
										</label>
										<?php
									} elseif ( __( 'Not Started', 'uncanny-learndash-groups' ) === $ulgm_enrolled_user_data_set[3] || __( 'Not Enrolled', 'uncanny-learndash-groups' ) === $ulgm_enrolled_user_data_set[3] ) { ?>
										<label class="uo-checkbox">
											<input class="uo-checkbox-input select-user" name="user-id[]" value="<?php echo $user_id; ?>" type="checkbox">
											<span class="uo-checkbox-checkmark"></span>
										</label>
									<?php }
									?>
								</div>

								<?php

							}

							?>

							<?php

							foreach ( $ulgm_enrolled_user_data_set as $column => $ulgm_enrolled_user_data ) {
								$slug = GroupManagementInterface::$ulgm_management_shortcode['table']['enrolled_users']['headers'][ $column ]['slug'];

								if ( isset( $cell[ $slug ] ) ) {

									$css_classes       = $cell[ $slug ]['css-classes'];
									$cell_width        = $cell[ $slug ]['cell-width'];
									$copy_to_clipboard = $cell[ $slug ]['clipboard'];

									$key = $ulgm_enrolled_user_data;

									?>
									<div class="<?php echo $css_classes; ?> uo-table-cell uo-table-cell-<?php echo $cell_width; ?>">
										<span data-header="<?php echo GroupManagementInterface::$ulgm_management_shortcode['table']['enrolled_users']['headers'][ $column ]['title']; ?>" class="header-column-inline"></span>
										<?php if ( $copy_to_clipboard && ! empty( $key ) ): ?>
											<span class="<?php echo $slug; ?> uo-copy-to-clipboard">
													<span class="uo-looks-like-code">
														<input type="text" value="<?php echo $key; ?>" readonly>
													</span>
													<span class="uo-copy-to-clipboard-button">
														<i class="fa fa-clipboard" aria-hidden="true"></i>
													</span>
												</span>
										<?php else: ?>
											<span class="<?php echo $slug; ?>"><?php echo $key; ?></span>
										<?php endif; ?>
									</div>
									<?php
								}

							}
							?>
						</div>
						<?php
					}
					?>
				</div>

				<!-- No Results -->
				<div class="uo-table-no-results jplist-no-results">
					<?php _e( 'No results found', 'uncanny-learndash-groups' ); ?>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Pagination -->
<div class="uo-row uo-groups-pagination">
	<div class="jplist-panel box panel-bottom">
		<div class="uo-left">
			<div class="uo-select-jplist">
				<div class="jplist-drop-down" data-control-type="items-per-page-drop-down" data-control-name="paging" data-control-action="paging">
					<ul class="uo-hidden">
						<span class="uo-select-arrow"></span>
						<span class="uo-select-dropdown">
									<li><span data-number="1"><?php _e( '1 Per Page', 'uncanny-learndash-groups' ) ?></span></li>
									<li><span data-number="10"><?php _e( '10 Per Page', 'uncanny-learndash-groups' ) ?></span></li>
									<li class="active"><span data-number="20" data-default="true"><?php _e( '20 Per Page', 'uncanny-learndash-groups' ) ?></span></li>
									<li><span data-number="50"><?php _e( '50 Per Page', 'uncanny-learndash-groups' ) ?></span></li>
									<li><span data-number="100"><?php _e( '100 Per Page', 'uncanny-learndash-groups' ) ?></span></li>
									<li><span data-number="all"><?php _e( 'View All', 'uncanny-learndash-groups' ) ?></span></li>
								</span>
					</ul>
				</div>
			</div>
		</div>

		<div class="uo-center">
			<div class="jplist-pagination uo-inline-block" data-control-type="pagination" data-control-name="paging" data-control-action="paging" data-control-animate-to-top="true">
				<div class="jplist-pagingprev" data-type="pagingprev">
					<button type="button" class="jplist-first" data-number="0" data-type="first">«</button>
					<button type="button" class="jplist-prev" data-type="prev" data-number="0">‹</button>
				</div>
				<div class="jplist-pagingmid" data-type="pagingmid">
					<div class="jplist-pagesbox" data-type="pagesbox">
						<button type="button" data-type="page" class="jplist-current" data-active="true" data-number="0">
							<?php _e( '1', 'uncanny-learndash-groups' ) ?>
						</button>
						<button type="button" data-type="page" data-number="1"><?php _e( '2', 'uncanny-learndash-groups' ) ?></button>
						<button type="button" data-type="page" data-number="2"><?php _e( '3', 'uncanny-learndash-groups' ) ?></button>
						<button type="button" data-type="page" data-number="3"><?php _e( '4', 'uncanny-learndash-groups' ) ?></button>
					</div>
				</div>
				<div class="jplist-pagingnext" data-type="pagingnext">
					<button type="button" class="jplist-next" data-type="next" data-number="1">›</button>
					<button type="button" class="jplist-last" data-type="last" data-number="3">»</button>
				</div>
			</div>
		</div>

		<div class="uo-right">
			<div class="jplist-label uo-inline-block" data-type="<?php _e( '{start} - {end} of {all}', 'uncanny-learndash-groups' ) ?>" data-control-type="pagination-info" data-control-name="paging" data-control-action="paging"></div>
		</div>

		<!--
		<div class="pagination-container"></div>
		-->
	</div>
</div>
</div>
</section> <!-- #group-management-users -->