<?php

namespace uncanny_learndash_groups;

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<div class="wrap">
	<div class="ulgm">

		<?php

		// Add admin header and tabs
		$tab_active = 'uncanny-groups';
		include Utilities::get_template( 'admin-header.php' );

		?>

		<div class="ulgm-admin-content">
			<div class="uo-ulgm-admin form-table group-management-form">
				<input type="hidden" id="action" name="action" value="save-general-settings"/>

				<!-- Messages -->
				<?php if ( '' !== AdminPage::$ulgm_management_admin_page['text']['message'] ) {
					?>
					<div class="updated ulgm-custom-message" style="margin-bottom: 20px">
						<p><?php echo AdminPage::$ulgm_management_admin_page['text']['message']; ?></p>
					</div>
					<?php
				}
				?>

				<!-- Settings -->
				<div class="uo-admin-section uo-admin-section--first">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php echo AdminPage::$ulgm_management_admin_page['text']['page_settings']; ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">

							<!-- Per Seat Text - Singular -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_per_seat_text']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_per_seat_text" id="ulgm_per_seat_text" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_per_seat_text']; ?>"/>
							</div>

							<!-- Per Seat Text - Plural -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_per_seat_text_plural']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_per_seat_text_plural" id="ulgm_per_seat_text_plural" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_per_seat_text_plural']; ?>"/>
							</div>

							<!-- Separator -->
							<div class="uo-admin-field">
								<div class="uo-admin-separator"></div>
							</div>

							<!-- Allow Group Leaders to remove students at any time -->
							<div class="uo-admin-field">
								<label class="uo-checkbox">
									<input type="checkbox" name="allow_to_remove_users_anytime" id="allow_to_remove_users_anytime" value="yes"<?php if ( 'yes' === get_option( 'allow_to_remove_users_anytime', 'no' ) ) {
										echo 'checked="checked"';
									} ?> />
									<div class="uo-checkmark"></div>
									<span class="uo-label">
										<?php echo AdminPage::$ulgm_management_admin_page['text']['allow_to_remove_users_anytime']; ?>
									</span>
								</label>

								<div class="uo-admin-description">
									<?php _e( 'By default, Group Leaders cannot remove students from groups once the students have started course activities. Checking this box ignores this rule and allows Group Leaders to remove students at any time to free up seats.', 'uncanny-learndash-groups' ); ?>
								</div>
							</div>

							<!-- Allow Group Leaders to Manage Progress -->
							<div class="uo-admin-field">
								<label class="uo-checkbox">
									<input type="checkbox" name="allow_group_leaders_to_manage_progress" id="allow_group_leaders_to_manage_progress" value="yes"<?php if ( 'yes' === get_option( 'allow_group_leaders_to_manage_progress', 'no' ) ) {
										echo 'checked="checked"';
									} ?> />
									<div class="uo-checkmark"></div>
									<span class="uo-label">
										<?php echo AdminPage::$ulgm_management_admin_page['text']['allow_group_leaders_to_manage_progress']; ?>
									</span>
								</label>

								<div class="uo-admin-description">
									<?php _e( 'Group Leaders are allowed to view individual student progress when a page exists with the [uo_groups_manage_progress] shortcode. Check this box to also allow Group Leaders to override progress for learners.', 'uncanny-learndash-groups' ); ?>
								</div>
							</div>

							<!-- Group Leaders don't use seats -->
							<div class="uo-admin-field">
								<label class="uo-checkbox">
									<input type="checkbox" name="group_leaders_dont_use_seats" id="group_leaders_dont_use_seats" value="yes"<?php if ( 'yes' === get_option( 'group_leaders_dont_use_seats', 'no' ) ) {
										echo 'checked="checked"';
									} ?> />
									<div class="uo-checkmark"></div>
									<span class="uo-label">
										<?php echo AdminPage::$ulgm_management_admin_page['text']['group_leaders_dont_use_seats']; ?>
									</span>
								</label>

								<div class="uo-admin-description">
									<?php _e( 'Group Leaders added to the group as Group Members by a Group Leader have course access but will not use seats. Be careful with this option, as Group Leaders can exploit this to give unlimited students course access. Changing this setting will not affect current seat counts.', 'uncanny-learndash-groups' ); ?>
								</div>
							</div>

							<!-- Do not add Group Leaders as Group Members -->
							<div class="uo-admin-field">
								<label class="uo-checkbox">
									<input type="checkbox" name="do_not_add_group_leader_as_member" id="do_not_add_group_leader_as_member" value="yes"<?php if ( 'yes' === get_option( 'do_not_add_group_leader_as_member', 'no' ) ) {
										echo 'checked="checked"';
									} ?> />
									<div class="uo-checkmark"></div>
									<span class="uo-label">
										<?php echo AdminPage::$ulgm_management_admin_page['text']['do_not_add_group_leader_as_member']; ?>
									</span>
								</label>

								<div class="uo-admin-description">
									<?php _e( 'Group Leaders will not be added to groups as members, will not take a seat and will not have course access. Changing this setting will not affect any existing memberships.', 'uncanny-learndash-groups' ); ?>
								</div>
							</div>

							<!-- Automatically include Group Course products in Group License purchases -->
							<div class="uo-admin-field">
								<label class="uo-checkbox">
									<input type="checkbox" name="add_courses_as_part_of_license" id="add_courses_as_part_of_license" value="yes"<?php if ( 'yes' === get_option( 'add_courses_as_part_of_license', 'no' ) ) {
										echo 'checked="checked"';
									} ?> />
									<div class="uo-checkmark"></div>
									<span class="uo-label">
										<?php echo AdminPage::$ulgm_management_admin_page['text']['add_courses_as_part_of_license']; ?>
									</span>
								</label>

								<div class="uo-admin-description">
									<?php _e( 'Group Course products will be included as $0 line items when a user purchases a Group License.  Check this if you want to be able to trigger integrations with other plugins (e.g. Follow-Up Emails, WP Fusion, Memberium) based on the courses included in a license.', 'uncanny-learndash-groups' ); ?>
								</div>
							</div>
							<!-- Learndash Groups as woocommerece products -->
							<div class="uo-admin-field">
								<label class="uo-checkbox">
									<input type="checkbox" name="add_groups_as_woo_products" id="add_groups_as_woo_products" value="yes"<?php if ( 'yes' === get_option( 'add_groups_as_woo_products', 'no' ) ) {
										echo 'checked="checked"';
									} ?> />
									<div class="uo-checkmark"></div>
									<span class="uo-label">
										<?php echo AdminPage::$ulgm_management_admin_page['text']['add_groups_as_woo_products']; ?>
									</span>
								</label>

								<div class="uo-admin-description">
									<?php _e( 'LearnDash Groups will be displayed on the Edit Product screen. Selecting one or more groups and saving the product will associate that product with the selected group(s). Any user that purchases that product will then automatically be added to the associated group(s).', 'uncanny-learndash-groups' ); ?>
								</div>
							</div>
							<!-- Separator -->
							<div class="uo-admin-field">
								<div class="uo-admin-separator"></div>
							</div>

							<!-- Group Management Page -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_group_management_page']; ?></div>
								<?php wp_dropdown_pages(
									array(
										'selected'         => AdminPage::$ulgm_management_admin_page['ulgm_group_management_page'],
										'name'             => 'ulgm_group_management_page',
										'id'               => 'ulgm_group_management_page',
										'class'            => 'uo-admin-select',
										'show_option_none' => __( 'None', 'uncanny-learndash-groups' ),
									)
								); ?>
								<div class="uo-admin-description"><?php _e( 'Choose the page that includes the [uo_groups] shortcode. This page is created when the plugin is installed, but another page that includes the [uo_groups] shortcode can be selected instead.', 'uncanny-learndash-groups' ) ?></div>
							</div>


							<!-- Buy Courses Page -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_group_buy_courses_page']; ?></div>
								<?php wp_dropdown_pages(
									array(
										'selected'         => AdminPage::$ulgm_management_admin_page['ulgm_group_buy_courses_page'],
										'name'             => 'ulgm_group_buy_courses_page',
										'id'               => 'ulgm_group_buy_courses_page',
										'class'            => 'uo-admin-select',
										'show_option_none' => __( 'None', 'uncanny-learndash-groups' ),
									)
								); ?>
								<div class="uo-admin-description"><?php _e( 'Choose the page that includes the [uo_groups_buy_courses] shortcode. This page is created when the plugin is installed, but another page that includes the [uo_groups_buy_courses] shortcode can be selected instead.', 'uncanny-learndash-groups' ) ?></div>
							</div>

							<!-- Group Report Page -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_group_report_page']; ?></div>
								<?php wp_dropdown_pages(
									array(
										'selected'         => AdminPage::$ulgm_management_admin_page['ulgm_group_report_page'],
										'name'             => 'ulgm_group_report_page',
										'id'               => 'ulgm_group_report_page',
										'class'            => 'uo-admin-select',
										'show_option_none' => __( 'None', 'uncanny-learndash-groups' ),
									)
								); ?>
								<div class="uo-admin-description"><?php _e( 'Choose the page that includes the [uo_groups_course_report] shortcode. This page is created when the plugin is installed, but another page that includes the [uo_groups_course_report] shortcode can be selected instead.', 'uncanny-learndash-groups' ) ?></div>
							</div>

							<!-- Group Quiz Report Page -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_group_quiz_report_page']; ?></div>
								<?php wp_dropdown_pages(
									array(
										'selected'         => AdminPage::$ulgm_management_admin_page['ulgm_group_quiz_report_page'],
										'name'             => 'ulgm_group_quiz_report_page',
										'id'               => 'ulgm_group_quiz_report_page',
										'class'            => 'uo-admin-select',
										'show_option_none' => __( 'None', 'uncanny-learndash-groups' ),
									)
								); ?>
								<div class="uo-admin-description"><?php _e( 'Choose the page that includes the [uo_groups_quiz_report] shortcode. This page is created when the plugin is installed, but another page that includes the [uo_groups_quiz_report] shortcode can be selected instead.', 'uncanny-learndash-groups' ); ?></div>
							</div>

							<!-- Group Progress Management Report Page -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_group_manage_progress_page']; ?></div>
								<?php wp_dropdown_pages(
									array(
										'selected'         => AdminPage::$ulgm_management_admin_page['ulgm_group_manage_progress_page'],
										'name'             => 'ulgm_group_manage_progress_page',
										'id'               => 'ulgm_group_manage_progress_page',
										'class'            => 'uo-admin-select',
										'show_option_none' => __( 'None', 'uncanny-learndash-groups' ),
									)
								); ?>
								<div class="uo-admin-description"><?php _e( 'Choose the page that includes the [uo_groups_manage_progress] shortcode. This page is created when the plugin is installed, but another page that includes the [uo_groups_manage_progress] shortcode can be selected instead.', 'uncanny-learndash-groups' ); ?></div>
							</div>

							<!-- Group Assignment Report Page -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_group_assignment_report_page']; ?></div>
								<?php wp_dropdown_pages(
									array(
										'selected'         => AdminPage::$ulgm_management_admin_page['ulgm_group_assignment_report_page'],
										'name'             => 'ulgm_group_assignment_report_page',
										'id'               => 'ulgm_group_assignment_report_page',
										'class'            => 'uo-admin-select',
										'show_option_none' => __( 'None', 'uncanny-learndash-groups' ),
									)
								); ?>
								<div class="uo-admin-description"><?php _e( 'Choose the page that includes the [uo_groups_assignments] shortcode. This page is created when the plugin is installed, but another page that includes the [uo_groups_assignments] shortcode can be selected instead.', 'uncanny-learndash-groups' ); ?></div>
							</div>

							<!-- Group Essay Report Page -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_group_essay_report_page']; ?></div>
								<?php wp_dropdown_pages(
									array(
										'selected'         => AdminPage::$ulgm_management_admin_page['ulgm_group_essay_report_page'],
										'name'             => 'ulgm_group_essay_report_page',
										'id'               => 'ulgm_group_essay_report_page',
										'class'            => 'uo-admin-select',
										'show_option_none' => __( 'None', 'uncanny-learndash-groups' ),
									)
								); ?>
								<div class="uo-admin-description"><?php _e( 'Choose the page that includes the [uo_groups_essays] shortcode. This page is created when the plugin is installed, but another page that includes the [uo_groups_essays] shortcode can be selected instead.', 'uncanny-learndash-groups' ); ?></div>
							</div>

							<?php if ( Utilities::if_woocommerce_active() ) { ?>
								<!-- Assign license product to a Woo category -->
								<div class="uo-admin-field">
									<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_group_license_product_cat']; ?></div>
									<?php
									$terms    = get_terms( [
										'taxonomy'   => 'product_cat',
										'hide_empty' => false,
									] );
									$default  = get_option( 'ulgm_group_license_product_cat', '' );
									$selected = 'selected="selected"';
									$j        = 0;
									?>
									<select name="ulgm_group_license_product_cat" class="uo-admin-select" id="ulgm_group_license_product_cat">
										<option value="">None</option>
										<?php foreach ( $terms as $term ) { ?>
											<option class="level-<?php echo $j ?>" <?php echo absint( $default ) === absint( $term->term_id ) ? $selected : ''; ?> value="<?php echo $term->term_id ?>"><?php echo $term->name ?></option>
											<?php $j ++;
										} ?>
									</select>
									<div class="uo-admin-description"><?php _e( 'Automatically assign dynamically-generated group license products (created when users purchase group access from the Buy Courses page) to a category. Useful for integrating dynamic licenses with other functionality (e.g. create coupons that apply only to dynamic licenses).', 'uncanny-learndash-groups' ); ?></div>
								</div>
							<?php } ?>

							<!-- Main Color -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_main_color']; ?></div>

								<input type="text" name="ulgm_main_color" id="ulgm_main_color" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_main_color']; ?>"/>
							</div>

							<!-- Main Color -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_font_color']; ?></div>

								<input type="text" name="ulgm_font_color" id="ulgm_font_color" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_font_color']; ?>"/>
							</div>

							<!-- Woocommerce Add To Cart Message -->
							<?php if ( class_exists( 'Woocommerce' ) ) { ?>
								<div class="uo-admin-field">
									<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_add_to_cart_message']; ?></div>

									<input type="text" name="ulgm_add_to_cart_message" id="ulgm_add_to_cart_message" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_add_to_cart_message']; ?>"/>
									<div class="uo-admin-description"><?php _e( 'Customize the message shown to users when adding seats to their group. Use {{product}} to insert product name.', 'uncanny-learndash-groups' ); ?></div>
								</div>
							<?php } ?>
							<!-- Submit -->
							<div class="uo-admin-field uo-admin-extra-space">
								<button id="btn-save_template" class="uo-admin-form-submit submit-group-management-form"
								        data-end-point="save_general_settings"><?php echo AdminPage::$ulgm_management_admin_page['text']['save_changes']; ?></button>
							</div>
						</div>
					</div>
				</div>

				<!-- Upgrade LearnDash Groups -->
				<div class="uo-admin-section">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php _e( 'Terms & Conditions', 'uncanny-learndash-groups' ); ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">
							<!-- Start process description -->
							<div class="uo-admin-field">
								<div class="uo-admin-description"><?php _e( 'To enable a Terms & Conditions checkbox on the Group Registration Form, enter text for the checkbox below. Does not apply if you are using a Gravity Form for group registration.', 'uncanny-learndash-groups' ) ?></div>
							</div>

							<!-- Start process button -->
							<div class="uo-admin-field uo-admin-extra-space">
								<?php wp_editor( AdminPage::$ulgm_management_admin_page['ulgm_term_condition'], 'ulgm_term_condition', array( 'editor_height' => '120' ) ); ?>
							</div>

							<!-- Submit -->
							<div class="uo-admin-field uo-admin-extra-space">
								<button id="btn-save_template" class="uo-admin-form-submit submit-group-management-form"
								        data-end-point="save_general_settings"><?php echo AdminPage::$ulgm_management_admin_page['text']['save_changes']; ?></button>
							</div>
						</div>
					</div>
				</div>
				<!-- Upgrade LearnDash Groups -->
				<div class="uo-admin-section">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php _e( 'Upgrade LearnDash Groups', 'uncanny-learndash-groups' ); ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">
							<!-- Start process description -->
							<div class="uo-admin-field">
								<div class="uo-admin-description"><?php _e( 'Existing LearnDash Groups can be updated to include support for the Uncanny LearnDash Groups plugin by clicking the button below. Upgrading groups allows Group Leaders to access the Group Management page and oversee learners and learner activity in the front end.', 'uncanny-learndash-groups' ) ?></div>
							</div>

							<!-- Start process button -->
							<div class="uo-admin-field uo-admin-extra-space">
								<a href="<?php echo admin_url( 'admin.php?page=uncanny-groups&migrate=yes&wpnonce=' . wp_create_nonce( 'ulgm' ) ) ?>" onclick="return confirm('<?php _e( 'This action will update all of your existing LearnDash Groups to work with the Uncanny LearnDash Groups front end group management interface. This process will happen in the background and cannot be reversed. Do you want to continue?', 'uncanny-learndash-groups' ); ?>')" class="uo-admin-form-submit">
									<?php echo AdminPage::$ulgm_management_admin_page['text']['ulgm_migrate_old_groups_to_new']; ?>
								</a>
							</div>
						</div>
					</div>
				</div>

			</div>
		</div>

	</div>
</div>