<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class WoocommerceLicense
 * @package uncanny_learndash_groups
 */
class WoocommerceLicense {
	public $deduct_prices = false;

	function __construct() {
		if ( Utilities::if_woocommerce_active() ) {
			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ), 200 );
			add_action( 'plugins_loaded', array( $this, 'load_new_product_type' ), 1 );
			add_action( 'plugins_loaded', array( $this, 'woocommerce_order_again_button' ) );

			// Only Run if woocommerce is available
			add_action( 'admin_head', array( $this, 'woo_admin_head' ) );
			//add_action( 'wp_head', array( $this, 'add_hidden_field_css' ) );
			add_filter( 'product_type_selector', array( $this, 'add_license_product' ), 12 );
			//add_action( 'wp_enqueue_scripts', array( $this, 'modify_woo_cart_css' ), 999 );
			add_action( 'admin_enqueue_scripts', array( $this, 'license_custom_js' ), 999 );
			//add_action( 'pre_get_posts', array( $this, 'shop_filter_license_products' ) );
			//////
			add_action( 'woocommerce_thankyou', array( $this, 'woocommerce_redirect_to_group' ), 1 );

			add_action( 'delete_user', array( $this, 'reset_seat_for_deleted_user' ), 999 );
		}
	}

	function plugins_loaded() {
		add_filter( 'woocommerce_order_item_permalink', array( $this, 'woocommerce_order_item_permalink' ), 99, 3 );
		add_filter( 'woocommerce_product_data_tabs', array( $this, 'custom_product_tabs' ) );
		add_action( 'woocommerce_product_data_panels', array( $this, 'license_options_product_tab_content' ) );
		add_action( 'woocommerce_process_product_meta_license', array( $this, 'save_license_option_field' ) );
		add_action( 'woocommerce_process_product_meta_variable_license', array(
			$this,
			'save_license_option_field',
		) );
		add_filter( 'woocommerce_product_data_tabs', array( $this, 'hide_attributes_data_panel' ) );
		/************************************/

		add_action( 'woocommerce_before_calculate_totals', array( $this, 'woo_license_price_update' ), 20 );
		add_filter( 'woocommerce_get_price_html', array( $this, 'change_product_price_display' ), 99, 2 );
		add_filter( 'woocommerce_cart_item_price', array( $this, 'change_product_price_display' ), 99, 20 );
		add_filter( 'woocommerce_product_get_price', array( $this, 'return_custom_price' ), 1, 2 );

		add_action( 'woocommerce_order_status_completed', array(
			$this,
			'process_group_license_on_order_complete'
		), 99 );
		add_action( 'woocommerce_checkout_update_order_meta', array(
			$this,
			'group_checkout_field_update_order_meta',
		) );
		add_action( 'woocommerce_admin_order_data_after_billing_address', array(
			$this,
			'group_admin_order_data_after_billing_address',
		) );

		add_filter( 'woocommerce_add_cart_item_data', array( $this, 'woo_custom_add_to_cart' ), 1500, 3 );
		add_action( 'woocommerce_license_add_to_cart', 'woocommerce_simple_add_to_cart', 30 );
		$user_id       = wp_get_current_user()->ID;
		$get_transient = get_transient( '_ulgm_user_' . $user_id . '_order' );
		if ( ! $get_transient ) {
			add_action( 'woocommerce_after_order_notes', array( $this, 'create_group_related_fields' ), 1001 );
			add_action( 'woocommerce_checkout_process', array( $this, 'process_group_name' ) );
		}
		add_filter( 'woocommerce_cart_item_thumbnail', array(
			$this,
			'woocommerce_cart_item_thumbnail_func',
		), 99, 3 );

		add_filter( 'woocommerce_cart_item_permalink', array(
			$this,
			'woocommerce_cart_item_permalink_func',
		), 99, 3 );

		add_filter( 'woocommerce_cart_item_name', array(
			$this,
			'woocommerce_cart_item_name_func',
		), 99, 3 );

		add_filter( 'woocommerce_order_item_meta_end', array(
			$this,
			'woocommerce_order_item_meta_end_func',
		), 10, 3 );

		add_filter( 'post_row_actions', array( $this, 'remove_row_actions' ), 1010, 2 );
		/* New Functionality to add courses with licenses*/
		if ( 'yes' === get_option( 'add_courses_as_part_of_license', 'no' ) ) {
			add_action( 'woocommerce_add_to_cart', array( $this, 'woocommerce_add_to_cart_func' ), 999 );
			add_action( 'woocommerce_before_calculate_totals', array(
				$this,
				'deduct_courses_in_cart',
			), 29, 1 );
		}

		/*Message Filter*/
		add_filter( 'wc_add_to_cart_message_html', [ $this, 'custom_add_to_cart_message_html' ], 10, 3 );
		add_filter( 'woocommerce_get_price_excluding_tax', array( $this, 'woo_get_price_excluding_tax' ), 1001, 3 );

	}

	/**
	 * @param $message
	 * @param $products
	 * @param $show_qty
	 *
	 * @return string
	 */
	function custom_add_to_cart_message_html( $message, $products, $show_qty ) {
		$override = get_option( 'ulgm_add_to_cart_message', '' );
		if ( ! empty( $override ) && isset( $_GET['add-seats'] ) ) {
			$titles = array();
			$count  = 0;

			if ( ! is_array( $products ) ) {
				$products = array( $products => 1 );
				$show_qty = false;
			}

			if ( ! $show_qty ) {
				$products = array_fill_keys( array_keys( $products ), 1 );
			}
			$found_license = false;
			foreach ( $products as $product_id => $qty ) {
				/* translators: %s: product name */
				if ( wc_get_product( $product_id )->is_type( 'license' ) ) {
					$found_license = true;
					break;
				}
			}

			if ( ! $found_license ) {
				return $message;
			}

			foreach ( $products as $product_id => $qty ) {
				/* translators: %s: product name */
				$titles[] = ( $qty > 1 ? absint( $qty ) . ' &times; ' : '' ) . apply_filters( 'woocommerce_add_to_cart_item_name_in_quotes', sprintf( _x( '&ldquo;%s&rdquo;', 'Item name in quotes', 'woocommerce' ), strip_tags( get_the_title( $product_id ) ) ), $product_id );
				$count    += $qty;
			}

			$titles = array_filter( $titles );

			// The custom message is just below
			$added_text = sprintf( str_replace( '{{product}}', '%s', $override ), wc_format_list_of_items( $titles ) );

			// Output success messages
			if ( 'yes' === get_option( 'woocommerce_cart_redirect_after_add' ) ) {
				$return_to = apply_filters( 'woocommerce_continue_shopping_redirect', wc_get_raw_referer() ? wp_validate_redirect( wc_get_raw_referer(), false ) : wc_get_page_permalink( 'shop' ) );
				$message   = sprintf( '<a href="%s" class="button wc-forward">%s</a> %s', esc_url( $return_to ), esc_html__( 'Continue shopping', 'woocommerce' ), esc_html( $added_text ) );
			} else {
				$message = sprintf( '%s', esc_html( $added_text ) );
			}
		}

		return $message;
	}

	/**
	 *
	 */
	function woo_admin_head() {
		if ( isset( $_GET['post'] ) && ! empty( $_GET['post'] ) ) {
			if ( has_term( 'license', 'product_type', absint( $_GET['post'] ) ) ) {
				?>
				<style>
					#delete-action {
						display: none;
					}
				</style>
				<?php
			}
		}
	}

	/**
	 * @param $actions
	 *
	 * @return mixed
	 */
	function remove_row_actions( $actions, $post ) {
		//Utilities::log( $actions, '$actions', true, 'actions' );
		if ( 'product' === get_post_type() ) {
			if ( has_term( 'license', 'product_type', $post ) ) {
				unset( $actions['trash'] );
			}
		}

		return $actions;
	}

	/**
	 * @param $permalink
	 * @param $item
	 * @param $order
	 *
	 * @return string
	 */
	public function woocommerce_order_item_permalink( $permalink, $item, $order ) {

		$product = wc_get_product( $item['product_id'] );
		//Utilities::log( $product, '$product', true, 'permalink' );
		if ( strpos( $product->get_slug(), 'license' ) ) {
			return '';
		} else {
			return $permalink;
		}
	}

	/**
	 *
	 */
	public function woocommerce_order_again_button() {
		remove_action( 'woocommerce_order_details_after_order_table', 'woocommerce_order_again_button' );
	}

	/**
	 * @param $query
	 */
	/*public function shop_filter_license_products( $query ) {
		if ( 'no' === get_option( 'show_license_product_on_front', 'no' ) ) {
			if ( is_post_type_archive( 'product' ) ) {
				if ( ! is_admin() && $query->is_main_query() ) {
					$query->set( 'tax_query', array(
							array(
								'taxonomy' => 'product_type',
								'field'    => 'slug',
								'terms'    => 'license',
								'operator' => 'NOT IN',
							),
						)
					);
				}
			}
		}
	}*/

	/**
	 * @param $item_id
	 * @param $item
	 * @param \WC_Order $order
	 */
	public function woocommerce_order_item_meta_end_func( $item_id, $item, \WC_Order $order ) {
		$courses       = '';
		$added_courses = get_post_meta( $item['product_id'], SharedFunctions::$license_meta_field, true );
		$courses_new   = get_post_meta( $item['product_id'], SharedFunctions::$license_meta_field . '_new', true );
		if ( ! empty( $courses_new ) ) {
			foreach ( $courses_new as $new ) {
				$course_names[] = get_the_title( $new );
			}
		} elseif ( ! empty( $added_courses ) ) {
			foreach ( $added_courses as $c ) {
				$course_names[] = get_the_title( $c );
			}
		}
		if ( ! empty( $course_names ) ) {
			$learn_dash_labels = new \LearnDash_Custom_Label();
			$course_label      = $learn_dash_labels::get_label( 'courses' );
			$courses           = '<p class="coures-assigned-heading">' . $course_label . ':</p><ul class="courses-assigned">';
			foreach ( $course_names as $n ) {
				$courses .= '<li>' . $n . '</li>';
			}
			$courses .= '</ul>';

		}
		echo $courses;
	}

	/**
	 *
	 */
	public function modify_woo_cart_css() {
		if ( is_cart() || is_checkout() ) {
			wp_register_style( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.css' ), array(), Utilities::get_version() );
			$user_colors = Utilities::user_colors();
			wp_add_inline_style( 'ulgm-frontend', $user_colors );
			wp_enqueue_style( 'ulgm-frontend', $user_colors );
		}
	}

	/**
	 * @param $permalink
	 * @param $cart_item
	 * @param $cart_item_key
	 *
	 * @return bool
	 */
	public function woocommerce_cart_item_name_func( $title, $cart_item, $cart_item_key ) {
		if ( ! empty( $cart_item ) ) {
			$product = $cart_item['data'];
			if ( $product->is_type( 'license' ) ) {
				$courses      = '';
				$course_names = array();
				$courses      = get_post_meta( $cart_item['product_id'], SharedFunctions::$license_meta_field, true );
				$courses_new  = get_post_meta( $cart_item['product_id'], SharedFunctions::$license_meta_field . '_new', true );
				if ( ! empty( $courses_new ) ) {
					foreach ( $courses_new as $new ) {
						$course_names[] = get_the_title( $new );
					}
				} else {
					foreach ( $courses as $c ) {
						$course_names[] = get_the_title( $c );
					}
				}
				if ( ! empty( $course_names ) ) {
					$learn_dash_labels = new \LearnDash_Custom_Label();
					$course_label      = $learn_dash_labels::get_label( 'courses' );
					$courses           = '<p class="coures-assigned-heading">' . $course_label . ':</p><ul class="courses-assigned">';
					foreach ( $course_names as $n ) {
						$courses .= '<li>' . $n . '</li>';
					}
					$courses .= '</ul>';

				}

				return $title . $courses;
			}
		}

		return $title;
	}

	/**
	 * @param $permalink
	 * @param $cart_item
	 * @param $cart_item_key
	 *
	 * @return bool
	 */
	public function woocommerce_cart_item_permalink_func( $permalink, $cart_item, $cart_item_key ) {
		if ( ! empty( $cart_item ) ) {
			$product = $cart_item['data'];
			if ( $product->is_type( 'license' ) ) {
				return false;
			}
		}

		return $permalink;
	}

	/**
	 * @param $product_get_image
	 * @param $cart_item
	 * @param $cart_item_key
	 *
	 * @return bool
	 */
	public function woocommerce_cart_item_thumbnail_func( $product_get_image, $cart_item, $cart_item_key ) {
		if ( ! empty( $cart_item ) ) {
			$product = $cart_item['data'];
			if ( $product->is_type( 'license' ) ) {
				return false;
			}
		}

		return $product_get_image;
	}

	/**
	 *
	 */
	public function add_hidden_field_css() {
		if ( is_cart() ) {
			?>
			<style>
				.woocommerce table.shop_table th {
					padding: 5px 7.5px;
				}

				th.product-remove {
					width: 7%;
					min-width: 10%;
				}

				th.product-name {
					width: 46%;
					min-width: 10%;
				}

				th.product-price {
					width: 18%;
					min-width: 10%;

				}

				th.product-quantity {
					width: 15%;
					min-width: 10%;
				}

				th.product-subtotal {
					width: 15%;
					min-width: 10%;
				}

				th.product-thumbnail,
				td.product-thumbnail {
					display: none !important;
				}
			</style>
			<?php
		}
		if ( is_checkout() ) {
			?>
			<style>
				.form-uo-hidden {
					display: none !important;
				}
			</style>
			<?php
		}
	}

	/**
	 * @param $cart_item_data
	 * @param $product_id
	 * @param $variation_id
	 *
	 * @return mixed
	 */
	public function woo_custom_add_to_cart( $cart_item_data, $product_id, $variation_id ) {

		$product = wc_get_product( $product_id );
		//global $woocommerce;
		if ( $product->is_type( 'license' ) ) {
			$this->check_if_existing_license( $product_id );
			//$woocommerce->cart->empty_cart();
		}
		//$this->reset_license_on_cart_empty( $product_id );

		// Do nothing with the data and return
		return $cart_item_data;
	}

	/**
	 * @param $product_id
	 */
	public function check_if_existing_license( $product_id ) {
		$product = wc_get_product( $product_id );
		$cart    = WC()->cart->cart_contents;
		if ( $product ) {
			if ( $cart && $product->is_type( 'license' ) ) {
				foreach ( $cart as $cart_key => $cart_contents ) {
					//Utilities::log( $cart_key, '$cart_key', true, 'carttttt' );
					//Utilities::log( $cart_contents, '$cart_contents', true, 'carttttt' );
					$cart_product_id = $cart_contents['product_id'];
					$cart_product    = wc_get_product( $cart_product_id );
					$product_name    = get_the_title( $cart_product_id );
					if ( $product_id !== $cart_product_id && $cart_product->is_type( 'license' ) ) {
						$this->remove_related_courses( $cart_product_id );
						WC()->cart->remove_cart_item( $cart_key );
						wc_add_notice( sprintf( esc_html__( '%s removed from cart. Only one license is allowed.', 'uncanny-learndash-groups' ), $product_name ), 'error' );
					} elseif ( $product_id !== $cart_product_id && $cart_product->is_type( 'subscription' ) ) {
						$sub_license = new WoocommerceLicenseSubscription();
						if ( $sub_license->check_if_courses_in_subscription_items( $cart_product_id ) ) {
							WC()->cart->remove_cart_item( $cart_key );
							wc_add_notice( sprintf( esc_html__( '%s removed from cart. Only one license is allowed.', 'uncanny-learndash-groups' ), $product_name ), 'error' );
						}
					}
				}
			}
		}
	}

	/**
	 * @param $cart_product_id
	 */
	public function remove_related_courses( $cart_product_id ) {
		$cart    = WC()->cart->cart_contents;
		$courses = get_post_meta( $cart_product_id, SharedFunctions::$license_meta_field, true );
		if ( $cart && $courses ) {
			//Utilities::log( $courses, '$courses', true, 'carttttt' );
			foreach ( $cart as $cart_key => $cart_contents ) {
				$cart_product_id = $cart_contents['product_id'];
				if ( in_array( $cart_product_id, $courses ) ) {
					WC()->cart->remove_cart_item( $cart_key );
				}
			}
		}

	}
	/**
	 * @param $order_id
	 */
	/*public function order_completed_redirect( $order_id ) {
		if ( ! $order_id ) {
			return;
		}
		$redirect = false;

		$order = wc_get_order( $order_id );
		if ( 'completed' === $order->get_status() ) {
			//$order->update_status( 'completed', 'Updated by Uncanny LearnDash Groups.' );
			foreach ( $order->get_items() as $items ) {
				$product = wc_get_product( $items['product_id'] );
				if ( $product->is_type( 'license' ) ) {
					$redirect = true;
					break;
				}
			}
			if ( $redirect ) {
				$url = SharedFunctions::get_group_management_page_id( true );
				wp_safe_redirect( $url );
				exit;
			}
		}
	}*/

	/**
	 *
	 */
	public function add_front_scripts() {
		wp_enqueue_script( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.js' ), [ 'jquery' ], Utilities::get_version(), true );
	}

	/**
	 *
	 */
	public function load_new_product_type() {
		include_once( Utilities::get_include( 'wc_product_license.php' ) );
		$product_type = new \WC_Product_License( 'license' );
	}


	/**
	 * @param $types
	 *
	 * @return mixed
	 */
	public function add_license_product( $types ) {

		// Key should be exactly the same as in the class product_type parameter
		$types['license'] = __( 'LearnDash Group License' );

		return $types;

	}

	/**
	 * Show pricing fields for license product.
	 */
	function license_custom_js() {
		wp_enqueue_script( 'ulgm-backend', Utilities::get_asset( 'backend', 'bundle.min.js' ), array( 'jquery' ), Utilities::get_version(), true );
	}

	/**
	 * @param $tabs
	 *
	 * @return mixed
	 */
	function custom_product_tabs( $tabs ) {
		$tabs['license'] = [
			'label'    => __( 'License Course(s)', 'uncanny-learndash-groups' ),
			'target'   => 'license_options',
			'priority' => 100,
			'class'    => [ 'show_if_license', 'show_if_variable_license', 'show_if_subscription' ],
		];

		//$tabs = array_merge( $tabs, $new_tab );

		return $tabs;
	}


	/**
	 *
	 */
	function license_options_product_tab_content() {
		global $post;
		$license = $this->list_course_products();
		?>
		<div id='license_options' class='panel woocommerce_options_panel'>
		<style>
			.woocommerce_options_panel ._ulgm_license_field .description {
				display: block;
				width: 50%;
				clear: both
			}
		</style><?php
		?>
		<div class='options_group show_if_license show_if_subscription'><?php
			$this->woocommerce_wp_select_multiple( array(
				'id'          => SharedFunctions::$license_meta_field,
				'name'        => '_license[]',
				'label'       => __( 'Linked Courses', 'uncanny-learndash-groups' ),
				'description' => __( 'Hold down Ctrl (Command on Mac) and click to select multiple LearnDash Group Course products.  If the box above is empty, first create at least one LearnDash Group Course product and associate it with a LearnDash course, then return to this screen.', 'uncanny-learndash-groups' ),
				'options'     => $license,
			) );
			?></div>

		</div><?php
	}


	/**
	 * @param $post_id
	 */
	function save_license_option_field( $post_id ) {
		if ( isset( $_POST['_license'] ) ) {
			update_post_meta( $post_id, SharedFunctions::$license_meta_field, $_POST['_license'] );
		} else {
			delete_post_meta( $post_id, SharedFunctions::$license_meta_field );
		}
	}

	/**
	 * @return array
	 */
	function list_course_products() {
		$query_args = array(
			'post_type'      => 'product',
			'posts_per_page' => 999,
			'tax_query'      => array(
				array(
					'taxonomy' => 'product_type',
					'field'    => 'slug',
					'terms'    => 'courses',
				),
			),
		);
		$posts      = get_posts( $query_args );
		$license    = array();
		if ( $posts ) {
			foreach ( $posts as $post ) {
				$license[ $post->ID ] = get_the_title( $post->ID );
			}
		}

		return $license;
	}


	/**
	 * @param $tabs
	 *
	 * @return mixed
	 */
	function hide_attributes_data_panel( $tabs ) {
		// Other default values for 'attribute' are; general, inventory, shipping, linked_product, variations, advanced
		$tabs['attribute']['class'][]      = 'hide_if_license hide_if_variable_license';
		$tabs['linked_product']['class'][] = 'hide_if_license hide_if_variable_license';
		$tabs['variations']['class'][]     = 'hide_if_license hide_if_variable_license';
		$tabs['shipping']['class'][]       = 'hide_if_license hide_if_variable_license';

		return $tabs;

	}

	/**
	 * @param $field
	 */
	function woocommerce_wp_select_multiple( $field ) {
		global $thepostid, $post, $woocommerce;
		$thepostid              = empty( $thepostid ) ? $post->ID : $thepostid;
		$field['class']         = isset( $field['class'] ) ? $field['class'] : 'select short';
		$field['wrapper_class'] = isset( $field['wrapper_class'] ) ? $field['wrapper_class'] : '';
		$field['name']          = isset( $field['name'] ) ? $field['name'] : $field['id'];
		$field['value']         = isset( $field['value'] ) ? $field['value'] : ( get_post_meta( $thepostid, $field['id'], true ) ? get_post_meta( $thepostid, $field['id'], true ) : array() );

		echo '<p class="form-field ' . esc_attr( $field['id'] ) . '_field ' . esc_attr( $field['wrapper_class'] ) . '"><label for="' . esc_attr( $field['id'] ) . '">' . wp_kses_post( $field['label'] ) . '</label><select id="' . esc_attr( $field['id'] ) . '" name="' . esc_attr( $field['name'] ) . '" class="' . esc_attr( $field['class'] ) . '" multiple="multiple">';

		foreach ( $field['options'] as $key => $value ) {

			echo '<option value="' . esc_attr( $key ) . '" ' . ( in_array( $key, $field['value'] ) ? 'selected="selected"' : '' ) . '>' . esc_html( $value ) . '</option>';

		}

		echo '</select> ';

		if ( ! empty( $field['description'] ) ) {

			if ( isset( $field['desc_tip'] ) && false !== $field['desc_tip'] ) {
				echo '<img class="help_tip" data-tip="' . esc_attr( $field['description'] ) . '" src="' . esc_url( WC()->plugin_url() ) . '/assets/images/help.png" height="16" width="16" />';
			} else {
				echo '<span class="description">' . wp_kses_post( $field['description'] ) . '</span>';
			}
		}
		echo '</p>';
	}


	/**
	 *
	 * @param $order_id
	 */
	public function process_group_license_on_order_complete( $order_id ) {
		$order      = new \WC_Order( $order_id );
		$user_id    = $order->get_user_id();
		$user       = new \WP_User( $user_id );
		$transient  = get_transient( '_ulgm_user_' . $user_id . '_order' );
		$transient2 = get_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );
		$qty        = 0;
		$product_id = 0;
		$_quantity  = 0;
		$line_items = $order->get_items( 'line_item' );
		if ( ! class_exists( 'Database' ) ) {
			include_once( Utilities::get_include( 'database.php' ) );
		}
		if ( ! $transient && ! $transient2 ) {
			if ( ( $order ) && ( $order->has_status( 'completed' ) ) && $line_items ) {
				//Utilities::log( $line_items, 'Line Items', true, 'line-items' );
				$continue = false;
				foreach ( $line_items as $item_id => $item ) {
					$_product  = $item->get_product();
					$_quantity = $item->get_quantity();
					//Utilities::log( $_product, '$_product', true, 'line' );
					//Utilities::log( $_quantity, '$_quantity', true, 'line' );
					if ( $this->check_if_license_product_in_items( $item['product_id'] ) ) {
						$product_id = $item['product_id'];
						$continue   = true;
						break;
					}
				}
				//Utilities::log( $continue, 'Continue', true, 'line-items' );

				if ( $continue ) {
					if ( 'yes' === get_post_meta( $product_id, '_uo_custom_buy_product', true ) ) {
						wp_update_post( array(
							'ID'          => $product_id,
							'post_author' => $user->ID,
						) );
					}
					if ( ! in_array( 'group_leader', (array) $user->roles ) ) {
						$user->add_role( 'group_leader' );
					}
					$group_title   = get_post_meta( $order_id, SharedFunctions::$group_name_field, true );
					$ld_group_args = array(
						'post_type'    => 'groups',
						'post_status'  => 'publish',
						'post_title'   => $group_title,
						'post_content' => '',
						'post_author'  => $user_id,
					);

					//Utilities::log( $ld_group_args, 'LD Group Args', true, 'line-items' );
					$group_id = wp_insert_post( $ld_group_args );

					foreach ( $line_items as $line ) {
						//$qty            = $qty + $line['qty'];
						$courses_linked = get_post_meta( $line['product_id'], SharedFunctions::$license_meta_field, true );
						if ( $courses_linked ) {
							foreach ( $courses_linked as $course_product ) {
								//Utilities::log( $course_product, 'Course', true, 'license' );
								$course_id = get_post_meta( $course_product, '_ulgm_course', true );
								ld_update_course_group_access( (int) $course_id, (int) $group_id, false );
								$transient_key = 'learndash_course_groups_' . $course_id;
								delete_transient( $transient_key );
							}
						}
					}
					$qty = $_quantity;
					update_post_meta( $group_id, '_ulgm_total_seats', $qty );
					update_post_meta( $order_id, SharedFunctions::$linked_group_id_meta, $group_id );
					$attr          = array(
						'user_id'    => $user_id,
						'order_id'   => $order_id,
						'group_id'   => $group_id,
						'group_name' => $group_title,
						'qty'        => $qty,
					);
					$codes         = SharedFunctions::generate_random_codes( $qty );
					$code_group_id = Database::add_codes( $attr, $codes );

					update_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, $code_group_id );
					update_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, $code_group_id );
					if ( 'yes' === get_post_meta( $product_id, '_uo_custom_buy_product', true ) ) {
						update_post_meta( $group_id, '_uo_custom_group', 'yes' );
					}
					// This is user is the creator or the group and cannot be remove on the frontend group management only
					update_post_meta( $group_id, 'locked_admin_group_leader', $user->ID );
					ld_update_leader_group_access( $user->ID, $group_id );

					//Setting group leader as a member of the group & using 1 code / qty for it.
					if ( 'yes' !== get_option( 'do_not_add_group_leader_as_member', 'no' ) ) {
						$rest_api = new RestApiEndPoints();
						$rest_api->add_existing_user( array( 'user_email' => $user->user_email ), true, $group_id, $order_id, 'redeemed', false );
					}
					SharedFunctions::remove_transient_cache( 'all' );
					//sleep( 1 );
					if ( ! is_admin() ) {
						$url = SharedFunctions::get_group_management_page_id( true );
						//wp_safe_redirect( $url );
						//exit;
					}
				}
			}
		}
	}

	/**
	 * @param $order_id
	 */
	public function woocommerce_redirect_to_group( $order_id ) {
		$order      = new \WC_Order( $order_id );
		$user_id    = $order->get_user_id();
		$transient  = get_transient( '_ulgm_user_' . $user_id . '_order' );
		$transient2 = get_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );
		$line_items = $order->get_items( 'line_item' );

		if ( ! class_exists( 'Database' ) ) {
			include_once( Utilities::get_include( 'database.php' ) );
		}

		if ( ! $transient && ! $transient2 ) {
			if ( ( $order ) && ( $order->has_status( 'completed' ) ) && $line_items ) {
				$continue = false;
				foreach ( $line_items as $item_id => $item ) {
					if ( $this->check_if_license_product_in_items( $item['product_id'] ) ) {
						$continue = true;
						break;
					}
				}
				$continue = false; //Added to remove force redirect unless user overrides by following filter
				$continue = apply_filters( 'uo_redirect_after_checkout', $continue, $order_id );
				if ( true === $continue && ! is_admin() ) {
					$url = SharedFunctions::get_group_management_page_id( true );
					wp_safe_redirect( $url );
					exit;
				}
			}
		}
	}

	/**
	 * @param $cart_object
	 *
	 * @return mixed
	 */
	public function woo_license_price_update( $cart_object ) {
		$total    = 0;
		$products = $cart_object->cart_contents;
		if ( $products ) {
			foreach ( $products as $prod ) {
				$id      = $prod['product_id'];
				$product = wc_get_product( $id );
				if ( $product->is_type( 'license' ) ) {
					$linked_courses = get_post_meta( $id, SharedFunctions::$license_meta_field, true );
					if ( $linked_courses ) {
						foreach ( $linked_courses as $course ) {
							$course_product = wc_get_product( $course );
							if ( $course_product ) {
								$price = $course_product->get_price();
								$total = $total + $price;
							}
						}
					}
					$prod['data']->price = $total;
				}
			}
		}

		return $cart_object;
	}


	/**
	 * @param $price
	 * @param \WC_Product $product
	 *
	 * @return int
	 */
	public function return_custom_price( $price, \WC_Product $product ) {
		$id = $product->get_id();
		if ( empty( trim( $price ) ) ) {
			if ( $product->is_type( 'license' ) ) {
				$linked_courses = get_post_meta( $id, SharedFunctions::$license_meta_field, true );

				if ( $linked_courses ) {

					$price = 0;
					foreach ( $linked_courses as $course ) {
						if ( false !== get_post_status( $course ) ) {
							$course_product = wc_get_product( $course );

							if ( $course_product ) {
								$price = floatval( $price ) + floatval( $course_product->get_price() );
							}
						}
					}

					//return $price;
				}
			}
		}

		return $price;
	}

	/**
	 * @param $return_price
	 * @param $qty
	 * @param $product
	 *
	 * @return int
	 */
	public function woo_get_price_excluding_tax( $return_price, $qty, $product ) {
		if ( $product instanceof \WC_Product && $product->is_type( 'license' ) ) {
			$return_price = $this->return_custom_price( $return_price, $product );
		}

		return $return_price;
	}


	/**
	 * @param $price
	 * @param $product
	 *
	 * @return string
	 */
	public function change_product_price_display( $price, $product ) {
		//Utilities::log( $product, 'Product', true, 'cart' );
		if ( ! empty( $product ) ) {
			if ( is_array( $product ) ) {
				$product = $product['data'];
			}
			if ( $product->is_type( 'license' ) ) {

				// Value can be saved on settings page
				$per_seat_text = get_option( 'ulgm_per_seat_text', 'Seat' );

				$price .= " / $per_seat_text";
				$price = apply_filters( 'ulgm_per_seat_text', $price, $product, $per_seat_text );

			}
		}

		return $price;
	}

	/**
	 * @param $checkout
	 */
	public function create_group_related_fields( $checkout ) {
		$show_additional_fields = $this->check_if_license_product_in_cart();
		if ( true === $show_additional_fields['status'] ) {
			$group_name = get_post_meta( $show_additional_fields['product_id'], '_group_name', true );
			$custom_buy = get_post_meta( $show_additional_fields['product_id'], '_uo_custom_buy_product', true );
			if ( empty( $group_name ) ) {
				$group_name = '';
			}
			if ( 'yes' === $custom_buy ) {
				$classes = array( 'ulgm-woo-group-settings form-row-wide form-uo-hidden' );
				$class   = 'form-uo-hidden';
			} else {
				$classes = array( 'ulgm-woo-group-settings form-row-wide' );
				$class   = '';
			}

			echo '<div id="ulgm-checkout-heading" class="' . $class . '"><h3>' . esc_html__( 'Group Settings', 'uncanny-learndash-groups' ) . '</h3>';
			woocommerce_form_field( 'ulgm_group_name', array(
				'type'         => 'text',
				'class'        => $classes,
				'label'        => esc_html__( 'Group Name', 'uncanny-learndash-groups' ),
				//'placeholder'  => esc_html__( 'Meaningful Group Name', 'uncanny-learndash-groups' ),
				'maxlength'    => 80,
				'default'      => $group_name,
				'required'     => true,
				'autocomplete' => false,
			), $checkout->get_value( 'ulgm_group_name' ) );

			echo '</div>';
		}
	}

	/**
	 * @throws \Exception
	 */
	public function woocommerce_add_to_cart_func() {
		$user_id    = wp_get_current_user()->ID;
		$transient  = get_transient( '_ulgm_user_' . $user_id . '_order' );
		$transient2 = get_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );

		if ( ! $transient && ! $transient2 ) {
			$found      = false;
			$product_id = 0;
			if ( sizeof( \WC()->cart->get_cart() ) > 0 ) {
				foreach ( \WC()->cart->get_cart() as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->is_type( 'license' ) ) {
						$found      = true;
						$product_id = $_product->get_id();
					}
				}
			}
			if ( $found && $product_id > 0 ) {
				$courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field, true );
				if ( ! empty( $courses ) ) {
					foreach ( $courses as $course ) {
						if ( ! $this->woo_in_cart( $course ) ) {
							\WC()->cart->add_to_cart( $course, 1 );
							$this->deduct_prices = true;
						}
					}
				}
			} else {
				$this->deduct_prices = false;
			}
		} elseif ( $transient2 ) {
			$found      = false;
			$product_id = 0;
			if ( sizeof( \WC()->cart->get_cart() ) > 0 ) {
				foreach ( \WC()->cart->get_cart() as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->is_type( 'license' ) ) {
						$found      = true;
						$product_id = $_product->get_id();
					}
				}
			}
			if ( $found && $product_id > 0 ) {
				$courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new', true );
				//$courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field, true );
				if ( ! empty( $courses ) ) {
					foreach ( $courses as $course ) {
						if ( ! $this->woo_in_cart( $course ) ) {
							\WC()->cart->add_to_cart( $course, 1 );
							$this->deduct_prices = true;
						}
					}
				}
			} else {
				$this->deduct_prices = false;
			}
		}
	}

	/**
	 * @param \WC_Cart $cart
	 */
	public function deduct_courses_in_cart( \WC_Cart $cart ) {
		$user_id    = wp_get_current_user()->ID;
		$transient  = get_transient( '_ulgm_user_' . $user_id . '_order' );
		$transient2 = get_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );
		if ( ! $transient && ! $transient2 ) {
			$product_id = 0;
			$found      = false;
			if ( count( $cart->cart_contents ) > 0 ) {
				foreach ( $cart->cart_contents as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->is_type( 'license' ) ) {
						$product_id = $_product->get_id();
						$found      = true;
					}
				}
			}
			if ( $found && $product_id > 0 ) {
				$courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field, true );
				foreach ( $cart->cart_contents as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->is_type( 'courses' ) && in_array( $_product->get_id(), $courses ) ) {
						$_product->set_price( 0 );
					}
				}
			}
		} elseif ( $transient2 ) {
			$product_id = 0;
			$found      = false;
			if ( count( $cart->cart_contents ) > 0 ) {
				foreach ( $cart->cart_contents as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->is_type( 'license' ) ) {
						$product_id = $_product->get_id();
						$found      = true;
					}
				}
			}
			if ( $found && $product_id > 0 ) {
				$courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new', true );
				foreach ( $cart->cart_contents as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->is_type( 'courses' ) && is_array( $courses ) && in_array( $_product->get_id(), $courses ) ) {
						$_product->set_price( 0 );
					}
				}
			}
		}
	}

	/**
	 * @param $product_id
	 *
	 * @return bool
	 */
	public function woo_in_cart( $product_id ) {
		//global $woocommerce;

		foreach ( \WC()->cart->get_cart() as $key => $val ) {
			$_product = $val['data'];

			if ( absint( $product_id ) === absint( $_product->get_id() ) ) {
				return true;
			}
		}

		return false;
	}

	/**
	 *
	 */
	public function process_group_name() {
		$show_additional_fields = $this->check_if_license_product_in_cart();
		if ( true === $show_additional_fields['status'] && ! $_POST['ulgm_group_name'] ) {
			wc_add_notice( esc_html__( 'Please Enter Group Name.', 'uncanny-learndash-groups' ), 'error' );
		}
	}

	/**
	 * @param $order_id
	 */
	public function group_checkout_field_update_order_meta( $order_id ) {
		if ( isset( $_POST['ulgm_group_name'] ) ) {
			update_post_meta( $order_id, SharedFunctions::$group_name_field, sanitize_text_field( $_POST['ulgm_group_name'] ) );
		}
	}

	/**
	 * @param $order
	 */
	public function group_admin_order_data_after_billing_address( $order ) {
		echo '<p><strong>' . esc_html__( 'Group Name', 'uncanny-learndash-groups' ) . ':</strong> <br />' . get_post_meta( $order->id, SharedFunctions::$group_name_field, true ) . '</p>';
	}


	/**
	 * @return array
	 */
	private function check_if_license_product_in_cart() {
		$items = \WC()->cart->get_cart();
		if ( $items ) {
			foreach ( $items as $item ) {
				$product = $item['data'];
				//$product = wc_get_product( $pid );
				if ( $product->is_type( 'license' ) ) {
					return array( 'status' => true, 'product_id' => $product->get_id() );
					break;
				}
			}
		}

		return array( 'status' => false );
	}

	/**
	 * @param $product_id
	 *
	 * @return bool
	 */
	private function check_if_license_product_in_items( $product_id ) {
		$product = wc_get_product( $product_id );
		if ( $product->is_type( 'license' ) ) {
			return true;
		}

		return false;
	}

	/**
	 * @param $user_id
	 */
	public function reset_seat_for_deleted_user( $user_id ) {
		$learndash_groups = learndash_get_users_group_ids( $user_id, true );
		if ( $learndash_groups ) {
			foreach ( $learndash_groups as $group_id ) {
				$api = new RestApiEndPoints();
				$api->remove_user_from_group( $user_id, $group_id );
			}
		}
	}

}