<?php

namespace uncanny_learndash_groups;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class LearnDashMyCourses
 * @package uncanny_learndash_groups
 */
class LearnDashMyCourses {

	public static $testing = [];

	/**
	 * Class constructor
	 */
	public function __construct() {
		add_action( 'plugins_loaded', array( __CLASS__, 'run_frontend_hooks' ) );
	}

	/*
	 * Initialize frontend actions and filters
	 */
	public static function run_frontend_hooks() {

		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_scripts_func' ) );
		add_shortcode( 'uo_ajax_search', [ __CLASS__, 'handle_shortcode' ] );
		add_action( 'wp_ajax_uo_groups_search_user', array( __CLASS__, 'search_user' ), 33 );

		/* ADD FILTERS ACTIONS FUNCTION */
		add_shortcode( 'uo_groups_manage_progress', array( __CLASS__, 'uo_course_dashboard' ) );
		add_filter( 'uo-dashboard-template', array( __CLASS__, 'uo_dashboard_get_template' ) );
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'add_dashboard_style' ) );

		//register api class
		add_action( 'rest_api_init', array( __CLASS__, 'reporting_api' ) );
	}

	public static function reporting_api() {

		// Call get all courses and general user data
		register_rest_route( 'uncanny_group_course_management/v2', '/change_user_progress/', array(
			'methods'  => 'POST',
			'callback' => array( __CLASS__, 'change_user_progress' ),
			//'permission_callback' => array( __CLASS__, 'permissions' )
		) );
	}

	/**
	 * Collect general user course data and LearnDash Labels
	 *
	 * @return array
	 */
	public static function change_user_progress() {

		error_reporting( 0 );
		$mark_progress_incomplete = false;
		$json_return              = (object) [
			'course_id'       => null,
			'certificate_url' => null,
			'progress'        => (object) [
				'completed'                 => null,
				'total'                     => null,
				'percentage'                => null,
				'course_completed_children' => (object) [],
			],
			'success'         => false,
		];

		if ( isset( $_POST['user_id'] ) && isset( $_POST['course_id'] ) && isset( $_POST['post_id'] ) && isset( $_POST['type'] ) ) {
			// Check if the user can manage progress
			if ( self::can_manage_user_progress( $_POST['user_id'] ) ) {
				if ( ! empty( $_POST['type'] ) ) {

					$type      = sanitize_text_field( $_POST['type'] );
					$user_id   = absint( $_POST['user_id'] );
					$course_id = absint( $_POST['course_id'] );
					$post_id   = $step_id = absint( $_POST['post_id'] );

					// Set course ID For return object
					$json_return->course_id = $course_id;

					switch ( $type ) {
						case 'complete_course':
							$user_courses  = ld_get_mycourses( $user_id, [] );
							$quiz_attempts = self::get_all_quiz_attemps( $user_id );
							$courses       = self::set_up_course_object( $user_courses, $user_id, $quiz_attempts );

							if ( $courses && key_exists( $course_id, $courses ) ) {
								$course = $courses[ $course_id ];
								if ( $course ) {
									$lesson_ids = [];
									$quiz_ids   = [];
									foreach ( $course as $key => $val ) {
										foreach ( $val as $k => $lesson ) {
											$lesson_ids[] = $lesson->id;
											if ( key_exists( 'quizzes', $lesson ) ) {
												if ( ! empty( $lesson->has_quizzes ) && 1 === (int) $lesson->has_quizzes ) {
													foreach ( $lesson->quizzes as $quiz ) {
														$quiz_ids[] = $quiz->id;
													}
												}
											}
										}
									}

									//Completing Quizzes
									if ( $quiz_ids ) {
										foreach ( $quiz_ids as $quiz_id ) {
											self::mark_a_quiz_complete( $quiz_id, $course_id, $user_id );
										}
									}

									//Completing Lessons
									if ( $lesson_ids ) {
										foreach ( $lesson_ids as $lesson_id ) {
											self::mark_lesson_steps( $user_id, $lesson_id, $course_id, 'complete_post' );
											learndash_process_mark_complete( $user_id, $lesson_id, false, $course_id );
										}
									}
									//Marking Course Quizzes complete
									if ( key_exists( 'quizzes', $course ) && ! empty( $course->quizzes ) ) {
										foreach ( $course->quizzes as $c_q ) {
											self::mark_a_quiz_complete( $c_q->id, $course->id, $user_id );
										}
										learndash_process_mark_complete( $user_id, $course_id, false, $course_id );
									}
								}
							}

							$json_return->success = true;
							break;
						case 'uncomplete-course':

							learndash_delete_course_progress( $course_id, $user_id );

							$json_return->progress->completed  = 0;
							$json_return->progress->percentage = 0;
							$json_return->success              = true;

							// No need to do anything else not that $json_return->total will return NULL but we don't need it anyway
							return $json_return;

							break;
						case 'complete_post':


							$post = get_post( $post_id );

							self::$testing['case complete_post'] = [ $post, $type, $course_id, $post_id, $user_id ];

							if ( 'sfwd-lessons' === $post->post_type ) {
								self::mark_lesson_steps( $user_id, $post_id, $course_id, $type );
								learndash_process_mark_complete( $user_id, $post_id, false, $course_id );
							}

							//Check if lesson has to be completed?
							if ( 'sfwd-topic' === $post->post_type ) {
								learndash_process_mark_complete( $user_id, $post_id, false, $course_id );
								$lesson_id = learndash_get_lesson_id( $post_id );
								$topics    = learndash_get_topic_list( $lesson_id, $course_id );

								//If all topics completed
								$all_lesson_topics_completed = true;
								if ( $topics ) {
									foreach ( $topics as $t ) {
										$iid         = $t->ID;
										$is_complete = learndash_is_topic_complete( $user_id, $iid );
										if ( ! $is_complete ) {
											$all_lesson_topics_completed = false;
											break;
										}
									}
								}

								// if all quiz lessons are complete
								$quizzes                      = learndash_get_lesson_quiz_list( $lesson_id, $user_id, $course_id );
								$all_lesson_quizzes_completed = true;
								if ( $quizzes ) {
									foreach ( $quizzes as $q ) {
										$iid         = $q['post']->ID;
										$is_complete = learndash_is_quiz_complete( $user_id, $iid );
										if ( ! $is_complete ) {
											$all_lesson_quizzes_completed = false;
											break;
										}
									}
								}

								if ( $all_lesson_topics_completed && $all_lesson_quizzes_completed ) {
									learndash_process_mark_complete( $user_id, $lesson_id, false, $course_id );
								}
							}

							$json_return->success = true;
							break;
						case 'uncomplete_post':

							$post = get_post( $post_id );

							if ( 'sfwd-lessons' === $post->post_type ) {
								self::mark_lesson_steps( $user_id, $post_id, $course_id, $type );
								learndash_process_mark_incomplete( $user_id, $course_id, $step_id );
							}

							if ( 'sfwd-topic' === $post->post_type ) {
								learndash_process_mark_incomplete( $user_id, $course_id, $step_id );
							}

							delete_user_meta( $user_id, 'course_completed_' . $course_id );
							$json_return->success = true;
							break;
						case 'complete_quiz':
							self::$testing['case complete_quiz'] = [ $post_id, $course_id, $user_id ];
							self::mark_a_quiz_complete( $post_id, $course_id, $user_id );
							if ( isset( $_POST['lesson_id'] ) ) {
								learndash_process_mark_complete( $user_id, $_POST['lesson_id'], false, $course_id );
							} else {
								learndash_process_mark_complete( $user_id, $course_id, false, $course_id );
							}
							$json_return->success = true;
							break;
						case 'uncomplete_quiz':
							$usermeta       = get_user_meta( $user_id, '_sfwd-quizzes', true );
							$quizz_progress = empty( $usermeta ) ? array() : $usermeta;

							if ( ! empty( $quizz_progress ) ) {
								foreach ( $quizz_progress as $quiz_idx => $quiz_item ) {
									if ( ( $quiz_item['quiz'] == $post_id ) && ( $quiz_item['pass'] == true ) ) {
										$quizz_progress[ $quiz_idx ]['pass'] = false;

										// We need to update the activity database records for this quiz_id
										$activity_query_args = array(
											'post_ids'      => $post_id,
											'user_ids'      => $user_id,
											'activity_type' => 'quiz',
										);
										$quiz_activity       = learndash_reports_get_activity( $activity_query_args );
										if ( ( isset( $quiz_activity['results'] ) ) && ( ! empty( $quiz_activity['results'] ) ) ) {
											foreach ( $quiz_activity['results'] as $result ) {
												if ( ( isset( $result->activity_meta['pass'] ) ) && ( $result->activity_meta['pass'] == true ) ) {

													// If the activity meta 'pass' element is set to true we want to update it to false.
													learndash_update_user_activity_meta( $result->activity_id, 'pass', false );

													// Also we need to update the 'activity_status' for this record
													learndash_update_user_activity(
														array(
															'activity_id'     => $result->activity_id,
															'course_id'       => $course_id,
															'user_id'         => $user_id,
															'post_id'         => $post_id,
															'activity_type'   => 'quiz',
															'activity_action' => 'update',
															'activity_status' => false,
															// 'activity_started'        =>  $result->activity_started,
														)
													);
												}
											}
										}
									}

									/**
									 * Remove the quiz lock.
									 *
									 * @since 2.3.1
									 */
									if ( ( isset( $quiz_item['pro_quizid'] ) ) && ( ! empty( $quiz_item['pro_quizid'] ) ) ) {
										learndash_remove_user_quiz_locks( $user_id, $quiz_item['quiz'] );
									}
								}
							}
							update_user_meta( $user_id, '_sfwd-quizzes', $quizz_progress );
							if ( isset( $_POST['lesson_id'] ) ) {
								learndash_process_mark_incomplete( $user_id, $course_id, (int) $_POST['lesson_id'] );
							}

							delete_user_meta( $user_id, 'course_completed_' . $course_id );

							$json_return->success     = true;
							$mark_progress_incomplete = true;
							break;

					}
				}
			}
		}

		$user_progress = (array) learndash_course_progress( array(
			'course_id' => $course_id,
			'user_id'   => $user_id,
			'array'     => true,
		) );

		//Hack to send all completed ids back
		$course_progress = get_user_meta( $user_id, '_sfwd-course_progress', true );
		$course_children = [];
		if ( ( ! empty( $course_progress ) ) && ( isset( $course_progress[ $course_id ] ) ) && ( ! empty( $course_progress[ $course_id ] ) ) ) {
			$course_to_loop = $course_progress[ $course_id ];
			if ( $course_to_loop ) {
				foreach ( $course_to_loop as $key => $loop ) {
					if ( 'lessons' === $key && is_array( $loop ) ) {
						foreach ( $loop as $lesson_id => $completed ) {
							if ( 1 === (int) $completed ) {
								$course_children[] = (object) [
									'ID'        => $lesson_id,
									'post_type' => 'sfwd-lessons',
								];
							}
						}
					}

					if ( 'topics' === $key && is_array( $loop ) ) {
						foreach ( $loop as $lesson_id => $topics ) {
							if ( is_array( $topics ) ) {
								foreach ( $topics as $topic_id => $completed ) {
									if ( 1 === (int) $completed ) {
										$course_children[] = (object) [
											'ID'        => $topic_id,
											'post_type' => 'sfwd-topic',
										];
									}
								}
							}
						}
					}
				}
			}
		}

		$quiz_progress = get_user_meta( $user_id, '_sfwd-quizzes', true );

		$sort_quizzes = [];
		if ( $quiz_progress ) {
			//Raw
			foreach ( $quiz_progress as $q ) {
				$sort_quizzes[] = [
					'quiz_id'   => $q['quiz'],
					'completed' => ( isset( $q['m_edit_time'] ) ) ? $q['m_edit_time'] : 0,
					'pass'      => $q['pass']
				];
			}

			// as of PHP 5.5.0 you can use array_column() instead of the above code
			$quiz_idss      = array_column( $sort_quizzes, 'quiz_id' );
			$quiz_completed = array_column( $sort_quizzes, 'completed' );

			// Sort the data with volume descending, edition ascending
			// Add $data as the last parameter, to sort by the common key
			array_multisort( $quiz_idss, SORT_DESC, $quiz_completed, SORT_DESC, $sort_quizzes );

			$sorted = [];
			if ( $sort_quizzes ) {
				foreach ( $sort_quizzes as $qq ) {
					$sorted[ $qq['quiz_id'] ][] = $qq['completed'];
				}
			}

			foreach ( $quiz_progress as $q ) {
				if ( (int) $course_id === (int) $q['course'] && ! empty( $q['pass'] ) && 1 === (int) $q['pass'] && 0 !== (int) $q['quiz'] ) {

					$quiz_certificate = null;
					$c                = learndash_certificate_details( $q['quiz'], $user_id );
					if ( ! empty( $c['certificateLink'] ) ) {
						$quiz_certificate = $c['certificateLink'];
					}

					$course_children[] = (object) [
						'ID'              => $q['quiz'],
						'post_type'       => 'sfwd-quiz',
						'certificate_url' => $quiz_certificate,
						'meta' => get_post_meta( $q['quiz'], '_sfwd-quiz', true ),
					];
				}
			}
		}


		if ( learndash_course_completed( $user_id, $course_id ) ) {
			// Get Course certificate URL
			$course_certificate = learndash_get_course_certificate_link( $course_id, $user_id );
			if ( ! empty( $course_certificate ) ) {
				// Set course certificate URL
				$json_return->certificate_url = $course_certificate;
			}
		}


		// Collect all data and returne

//		$json_return->progress->completed                 = $user_progress['completed'];
//		$json_return->progress->total                     = $user_progress['total'];
//		$json_return->progress->percentage                = $user_progress['percentage'];

		$json_return->progress->completed                 = true === $mark_progress_incomplete ? $user_progress['completed'] - 1 : $user_progress['completed'];
		$json_return->progress->total                     = $user_progress['total'];
		$json_return->progress->percentage                = true === $mark_progress_incomplete ? ( ceil( ( $user_progress['completed'] - 1 ) / $user_progress['total']  * 100 ) ) : $user_progress['percentage'];

		$json_return->progress->course_completed_children = $course_children;

		$json_return->testing = self::$testing;

		return $json_return;
	}

	/**
	 * @param $quiz_id
	 * @param $course_id
	 * @param $user_id
	 */
	public static function mark_a_quiz_complete( $quiz_id, $course_id, $user_id ) {
		$usermeta       = get_user_meta( $user_id, '_sfwd-quizzes', true );
		$quizz_progress = empty( $usermeta ) ? array() : $usermeta;

		$quiz_meta = get_post_meta( $quiz_id, '_sfwd-quiz', true );

		// If the admin is marking the quiz complete AND the quiz is NOT already complete...
		// Then we add the minimal quiz data to the user profile.
		$quizdata = array(
			'quiz'             => $quiz_id,
			'score'            => 100,
			'count'            => 0,
			'pass'             => true,
			'rank'             => '-',
			'time'             => time(),
			'pro_quizid'       => $quiz_meta['sfwd-quiz_quiz_pro'],
			'course'           => $course_id,
			'points'           => 0,
			'total_points'     => 0,
			'percentage'       => 100,
			'timespent'        => 0,
			'has_graded'       => false,
			'statistic_ref_id' => 0,
			'm_edit_by'        => get_current_user_id(),  // Manual Edit By ID.
			'm_edit_time'      => time(),          // Manual Edit timestamp.
		);

		$quizz_progress[] = $quizdata;

		$quizdata_pass = true;

		// Then we add the quiz entry to the activity database.
		learndash_update_user_activity(
			array(
				'course_id'          => $course_id,
				'user_id'            => $user_id,
				'post_id'            => $quiz_id,
				'activity_type'      => 'quiz',
				'activity_action'    => 'insert',
				'activity_status'    => $quizdata_pass,
				'activity_started'   => $quizdata['time'],
				'activity_completed' => $quizdata['time'],
				'activity_meta'      => $quizdata,
			)
		);

		do_action( 'learndash_quiz_completed', $quizdata, get_user_by( 'ID', $user_id ) );
		update_user_meta( $user_id, '_sfwd-quizzes', $quizz_progress );
	}


	public static function add_dashboard_style() {

	}

	/**
	 * @param $atts
	 *
	 * @return string
	 */
	public static function uo_course_dashboard( $atts ) {

		ob_start();

		if ( ! empty( SharedFunctions::get_group_management_page_id() ) && ! empty( SharedFunctions::get_group_manage_progress_report_page_id() ) ) { ?>
			<div class="uo-groups uo-reports">
				<div class="uo-row uo-groups-section uo-groups-report-go-back">
					<div class="uo-groups-actions">
						<div class="group-management-buttons">
							<button class="ulgm-link uo-btn uo-left uo-btn-arrow-left"
							        onclick="location.href='<?php echo SharedFunctions::get_group_management_page_id( true ); ?>'"
							        type="button">
								<?php echo __( 'Back to Group Management', 'uncanny-learndash-groups' ); ?>
							</button>
						</div>
					</div>
				</div>
			</div>
			<br>
		<?php }

		if ( current_user_can( 'group_leader' ) || current_user_can( 'manage_options' ) ) {

		} else {
			return __( 'You must be a admin or group leader to access this page.', 'uncanny-learndash-groups' );
		}

		if ( ! isset( $_GET['user_id'] ) || 0 === absint( $_GET['user_id'] ) ) {
			echo do_shortcode( '[uo_ajax_search]' );

			return ob_get_clean();
		}

		if ( isset( $_GET['user_id'] ) ) {
			if ( get_current_user_id() === absint( $_GET['user_id'] ) ) {
				echo '<p><i>' . _e( 'You cannot manage your own course progress.', 'uncanny-learndash-groups' ) . '</i></p>';
				echo do_shortcode( '[uo_ajax_search]' );

				return ob_get_clean();
			}

			$user = get_userdata( absint( $_GET['user_id'] ) );
			if ( false === $user ) {
				echo '<p><i>' . __( 'This user no longer exists. Please select another user.', 'uncanny-learndash-groups' ) . '</i></p>';
				echo do_shortcode( '[uo_ajax_search]' );

				return ob_get_clean();
			}
		}

		if ( current_user_can( 'group_leader' ) && ! current_user_can( 'manage_options' ) ) {
			if ( ! learndash_is_group_leader_of_user( get_current_user_id(), absint( $_GET['user_id'] ) ) ) {
				echo '<p><i>' . __( 'Invalid user specified.', 'uncanny-learndash-groups' ) . '</i></p>';
				echo do_shortcode( '[uo_ajax_search]' );

				return ob_get_clean();
			}
		}


		if ( current_user_can( 'group_leader' ) || current_user_can( 'manage_options' ) ) {


			// Set theme as 3.0 for LD course theme 3.0+
			$course_theme = get_option( 'learndash_settings_courses_themes' );

			//if ( ! empty( $course_theme ) && isset( $course_theme['active_theme'] ) && 'ld30' === $course_theme['active_theme'] ) {
			return self::template_3_0( $atts );
			//}

			// TODO ADD SETTING
			/*$template = '';//self::get_settings_value( 'uo_dashboard_template', __CLASS__ );

			// Set Default template theme
			if ( empty( $template ) ) {
				return self::legacy_template( $atts );
			}

			if ( 'legacy' === $template ) {
				return self::legacy_template( $atts );
			}

			if ( '3_0' === $template ) {
				return self::template_3_0( $atts );
			}*/
		} else {
			return __( 'You must be a admin or group leader to access this page.', 'uncanny-learndash-groups' );
		}

		return __( 'Course dashboard template in settings not defined.', 'uncanny-learndash-groups' );

	}

	public static function can_manage_user_progress( $user_id = null ) {
		// Set default value
		$can_manage_progress = false;

		// Check if the option to manage progress is checked
		if ( get_option( 'allow_group_leaders_to_manage_progress', 'no' ) == 'yes' ) {
			// Check is $user_id is defined
			if ( isset( $user_id ) ) {
				// Check if the user is trying to edit his own progress
				if ( get_current_user_id() != absint( $user_id ) ) {
					// Check if the user exists
					// To do that, get user data
					$user = get_userdata( absint( $user_id ) );

					// Check if there is data
					if ( $user !== false ) {
						// Check if the user is an admin
						if ( current_user_can( 'manage_options' ) ) {
							// Set $can_manage_progress to true
							$can_manage_progress = true;
						} // Check if the user is a group leader
						else if ( current_user_can( 'group_leader' ) && ! current_user_can( 'manage_options' ) ) {
							// Check if it can edit the progress of this user
							if ( learndash_is_group_leader_of_user( get_current_user_id(), absint( $user_id ) ) ) {
								// Set $can_manage_progress to true
								$can_manage_progress = true;
							}
						}
					}
				}
			}
		}

		return $can_manage_progress;
	}

	/**
	 * @param $atts
	 *
	 * @return string
	 */
	public static function template_3_0( $atts ) {

		if ( is_string( $atts ) ) {
			$atts = [];
		}

		// Get user colors
		// TODO ADD SETTING
		$user_colors = (object) [
			'toggle'         => (object) [
				'expanded_bg'   => '',
				//self::get_settings_value( 'uo_dashboard_color_toggle_expanded_background', __CLASS__ ),
				'expanded_icon' => '',
				//self::get_settings_value( 'uo_dashboard_color_toggle_expanded_icon', __CLASS__ ),
				'disabled_bg'   => '',
				//self::get_settings_value( 'uo_dashboard_color_toggle_disabled_background', __CLASS__ ),
			],
			'quiz'           => (object) [
				'passed_bg' => '',//self::get_settings_value( 'uo_dashboard_color_quiz_passed_bg', __CLASS__ ),
				'failed_bg' => '',//self::get_settings_value( 'uo_dashboard_color_quiz_failed_bg', __CLASS__ )
			],
			'progress'       => '',//self::get_settings_value( 'uo_dashboard_color_progress', __CLASS__ ),
			'third_level_bg' => '',//self::get_settings_value( 'uo_dashboard_color_third_level', __CLASS__ )
		];

		// Check if it has custom colors
		$has_custom_colors = ! empty( $user_colors->toggle->expanded_bg ) || ! empty( $user_colors->toggle->expanded_icon ) || ! empty( $user_colors->toggle->disabled_bg ) || ! empty( $user_colors->quiz->passed_bg ) || ! empty( $user_colors->quiz->failed_bg ) || ! empty( $user_colors->progress ) || ! empty( $user_colors->third_level_bg );

		$user_id = self::set_user_id( $atts );

		$tax_query     = array();
		$ld_categories = array();
		$categories    = array();

		if ( ! isset( $atts['ld_category'] ) || '' === $atts['ld_category'] ) {
			$atts['ld_category'] = 'all';
		}
		if ( 'all' !== $atts['ld_category'] ) {
			$tax_query = array(
				'relation' => 'OR',
				array(
					'taxonomy' => 'ld_course_category',
					'field'    => 'slug',
					'terms'    => array( sanitize_text_field( $atts['ld_category'] ) ),
				),
			);
		}

		if ( ! isset( $atts['category'] ) || '' === $atts['category'] ) {
			$atts['category'] = 'all';
		}
		if ( 'all' !== $atts['category'] ) {
			$tax_query[] = array(
				'taxonomy' => 'category',
				'field'    => 'slug',
				'terms'    => array( sanitize_text_field( $atts['category'] ) ),
			);
		}

		if ( isset( $atts['categoryselector'] ) && 'hide' !== $atts['categoryselector'] ) {
			$get_categories_args = array(
				'taxonomy'   => 'category',
				'type'       => 'sfwd-courses',
				'orderby'    => 'name',
				'order'      => 'ASC',
				'hide_empty' => false,
			);

			$categories = get_categories( $get_categories_args );

			if ( ( isset( $_GET['catid'] ) ) && ( ! empty( $_GET['catid'] ) ) ) {
				$tax_query[] = array(
					'taxonomy' => 'category',
					'field'    => 'term_id',
					'terms'    => intval( $_GET['catid'] ),
				);
			}
		}
		if ( isset( $atts['course_categoryselector'] ) && 'hide' !== $atts['course_categoryselector'] ) {
			$get_categories_args = array(
				'taxonomy'   => 'ld_course_category',
				'type'       => 'sfwd-courses',
				'orderby'    => 'name',
				'order'      => 'ASC',
				'hide_empty' => false,
			);
			$ld_categories       = get_categories( $get_categories_args );

			if ( ( isset( $_GET['course_catid'] ) ) && ( ! empty( $_GET['course_catid'] ) ) ) {
				$tax_query[] = array(
					'taxonomy' => 'ld_course_category',
					'field'    => 'term_id',
					'terms'    => intval( $_GET['course_catid'] ),
				);
			}
		}

		// Format $categories
		$wp_categories = array_filter( $categories, function ( $category ) {
			// Get number of posts
			$posts = get_posts( 'post_type=sfwd-courses&category=' . $category->term_id );
			$count = count( $posts );

			// Check if it has posts
			return $count > 0;
		} );

		$wp_categories = array_map( function ( $category ) {
			// Check if it's selected
			$selected = false;

			if ( isset( $_GET['catid'] ) || isset( $_GET['course_catid'] ) ) {
				if ( isset( $_GET['catid'] ) && absint( $_GET['catid'] ) ) {
					if ( $category->term_id === absint( $_GET['catid'] ) ) {
						$selected = true;
					}
				}
			} else {
				if ( isset( $atts['category'] ) ) {
					if ( $atts['category'] === $category->slug ) {
						$selected = true;
					}
				}
			}

			return (object) [
				'id'                => $category->term_id,
				'title'             => $category->name,
				'number_of_courses' => $category->category_count,
				'has_courses'       => $category->category_count > 0,
				'is_selected'       => $selected
			];
		}, $wp_categories );

		// Format $ld_categories
		$ld_categories = array_filter( $ld_categories, function ( $category ) {
			// Get number of posts
			$args  = [
				'post_type'      => 'sfwd-courses',
				'post_status'    => 'publish',
				'posts_per_page' => 999,
				'tax_query'      => [
					[
						'taxonomy' => 'ld_course_category',
						'field'    => 'term_id',
						'terms'    => $category->term_id,
					]
				]
			];
			$posts = get_posts( $args );
			$count = count( $posts );

			// Check if it has posts
			return $count > 0;
		} );

		$ld_categories = array_map( function ( $category ) {
			// Check if it's selected
			$selected = false;

			if ( isset( $_GET['course_catid'] ) || isset( $_GET['catid'] ) ) {
				if ( isset( $_GET['course_catid'] ) && absint( $_GET['course_catid'] ) ) {
					if ( $category->term_id === absint( $_GET['course_catid'] ) ) {
						$selected = true;
					}
				}
			} else {
				if ( isset( $atts['ld_category'] ) ) {
					if ( $atts['ld_category'] === $category->slug ) {
						$selected = true;
					}
				}
			}

			return (object) [
				'id'                => $category->term_id,
				'title'             => $category->name,
				'number_of_courses' => $category->category_count,
				'has_courses'       => $category->category_count > 0,
				'is_selected'       => $selected
			];
		}, $ld_categories );

		$has_wp_category_dropdown = ! empty( $wp_categories );
		$has_ld_category_dropdown = ! empty( $ld_categories );

		if ( isset( $atts['orderby'] ) ) {

			// Make a correct order by value isset
			$allowed_order_by = array( 'ID', 'title', 'date', 'menu_order' );
			if ( in_array( $atts['orderby'], $allowed_order_by ) ) {
				$order_by = $atts['orderby'];
			} else {
				return 'The order by value is not of the type title, date, or menu_order.';
			}
		} else {
			$order_by = 'ID';
		}

		if ( isset( $atts['order'] ) ) {

			// Make a correct order value isset
			$allowed_order = array( "asc", "desc" );
			if ( in_array( $atts['order'], $allowed_order ) ) {
				$order = $atts['order'];
			} else {
				return 'The order value is not of the type asc, or desc';
			}
		} else {
			$order = 'desc';
		}

		// Set sorting
		$sort_atts = array(
			'order'   => $order,
			'orderby' => $order_by,
		);

		if ( ! empty( $tax_query ) ) {
			$sort_atts['tax_query'] = $tax_query;
		}

		if ( function_exists( 'ld_get_mycourses' ) ) {

			if ( 0 === $user_id ) {

				if ( isset( $atts['show'] ) ) {

					if ( 'open' === $atts['show'] ) {
						// Get open courses for logged out users
						$user_courses = learndash_get_open_courses();
						// Not filter available for open courses.
						$ld_categories = array();
						$categories    = array();
					} elseif ( 'all' === $atts['show'] ) {
						// Show all courses
						$course_query_args = [
							'post_type'      => 'sfwd-courses',
							'post_status'    => 'publish',
							'posts_per_page' => 999,
							'tax_query'      => []
						];
						if ( ! empty( $tax_query ) ) {
							$course_query_args['tax_query'] = $tax_query;
						}

						if ( ! empty( $sort_atts ) ) {
							$course_query_args['order']   = $sort_atts['order'];
							$course_query_args['orderby'] = $sort_atts['orderby'];
						}

						$courses      = get_posts( $course_query_args );
						$user_courses = wp_list_pluck( $courses, 'ID' );
					} else {
						return '';
					}

				} else {

					return '';

				}


			} else {
				$user_courses = ld_get_mycourses( $user_id, $sort_atts );
			}

		} else {
			return;
		}

		// Get all users attempted and completed quizzes
		$quiz_attempts = self::get_all_quiz_attemps( $user_id );

		$courses = self::set_up_course_object( $user_courses, $user_id, $quiz_attempts );

		if ( isset( $atts['expand_by_default'] ) && 'yes' === $atts['expand_by_default'] ) {
			$expanded_on_load = true;
		} else {
			$expanded_on_load = false;
		}

		// Check if the user can manage this user
		$can_manage_progress = self::can_manage_user_progress( $_GET['user_id'] );

		//Check to see if the file is in template to override default template.
		$file_path = get_stylesheet_directory() . '/uncanny-learndash-groups/templates/frontend-course-management/dashboard-template-3_0.php';

		if ( ! file_exists( $file_path ) ) {
			//$file_path = apply_filters( 'uo-dashboard-template-3-0', self::get_template( 'frontend-dashboard/dashboard-template-3_0.php', dirname( dirname( __FILE__ ) ) . '/src' ) );
			$file_path = apply_filters( 'uo-dashboard-template-3-0', Utilities::get_template( 'frontend-course-management/dashboard-template-3_0.php', dirname( dirname( __FILE__ ) ) . '/src' ) );
		}

		$level = ob_get_level();
		ob_start();

		// global $learndash_assets_loaded;

		// if ( isset( $learndash_assets_loaded['scripts']['learndash_template_script_js'] ) ) {
		// 	wp_dequeue_script( 'learndash_template_script_js' );

		// 	wp_enqueue_script( 'learndash_template_script_js_2', $asset_url, array( 'jquery' ), LEARNDASH_VERSION, true );

		// 	$user_info         = get_userdata( $user_id );
		// 	$nicename          = $user_info->user_nicename;
		// 	$data              = array();
		// 	$data['ajaxurl']   = admin_url( 'admin-ajax.php' );
		// 	$data['user_name'] = $nicename;
		// 	$data['root']      = esc_url_raw( rest_url() . 'uncanny_group_course_management/v2/' );
		// 	$data['nonce']     = \wp_create_nonce( 'wp_rest' );
		// 	$data              = array( 'json' => json_encode( $data ) );
		// 	wp_localize_script( 'learndash_template_script_js_2', 'sfwd_data', $data );
		// }

		if ( defined( 'LEARNDASH_LMS_PLUGIN_URL' ) && function_exists( 'learndash_is_active_theme' ) && learndash_is_active_theme( 'ld30' ) ) {
		}

		\LD_QuizPro::showModalWindow();

		echo do_shortcode( '[uo_ajax_search]' );
		include( $file_path );


		$contents = learndash_ob_get_clean( $level );

		return $contents;
	}

	public static function legacy_template( $atts ) {

		if ( is_string( $atts ) ) {
			$atts = [];
		}

		$tax_query     = array();
		$ld_categories = array();
		$categories    = array();
		if ( isset( $atts['user_id'] ) && '' !== $atts['user_id'] ) {
			$user_id = absint( $atts['user_id'] );
		} else {
			$current_user = wp_get_current_user();

			if ( empty( $current_user->ID ) ) {
				$user_id = 0;
			} else {
				$user_id = $current_user->ID;
			}
		}


		if ( ! isset( $atts['ld_category'] ) || '' === $atts['ld_category'] ) {
			$atts['ld_category'] = 'all';
		}
		if ( 'all' !== $atts['ld_category'] ) {
			$tax_query = array(
				'relation' => 'OR',
				array(
					'taxonomy' => 'ld_course_category',
					'field'    => 'slug',
					'terms'    => array( sanitize_text_field( $atts['ld_category'] ) ),
				),
			);
		}

		if ( ! isset( $atts['category'] ) || '' === $atts['category'] ) {
			$atts['category'] = 'all';
		}
		if ( 'all' !== $atts['category'] ) {
			$tax_query[] = array(
				'taxonomy' => 'category',
				'field'    => 'slug',
				'terms'    => array( sanitize_text_field( $atts['category'] ) ),
			);
		}

		if ( isset( $atts['categoryselector'] ) && 'hide' !== $atts['categoryselector'] ) {
			$get_categories_args = array(
				'taxonomy'   => 'category',
				'type'       => 'sfwd-courses',
				'orderby'    => 'name',
				'order'      => 'ASC',
				'hide_empty' => false,
			);
			$categories          = get_categories( $get_categories_args );

			if ( ( isset( $_GET['catid'] ) ) && ( ! empty( $_GET['catid'] ) ) ) {
				$tax_query[] = array(
					'taxonomy' => 'category',
					'field'    => 'term_id',
					'terms'    => intval( $_GET['catid'] ),
				);
			}
		}
		if ( isset( $atts['course_categoryselector'] ) && 'hide' !== $atts['course_categoryselector'] ) {
			$get_categories_args = array(
				'taxonomy'   => 'ld_course_category',
				'type'       => 'sfwd-courses',
				'orderby'    => 'name',
				'order'      => 'ASC',
				'hide_empty' => false,
			);
			$ld_categories       = get_categories( $get_categories_args );

			if ( ( isset( $_GET['course_catid'] ) ) && ( ! empty( $_GET['course_catid'] ) ) ) {
				$tax_query[] = array(
					'taxonomy' => 'ld_course_category',
					'field'    => 'term_id',
					'terms'    => intval( $_GET['course_catid'] ),
				);
			}
		}

		if ( isset( $atts['orderby'] ) ) {

			// Make a correct order by value isset
			$allowed_order_by = array( 'ID', 'title', 'date', 'menu_order' );
			if ( in_array( $atts['orderby'], $allowed_order_by ) ) {
				$order_by = $atts['orderby'];
			} else {
				return 'The order by value is not of the type title, date, or menu_order.';
			}
		} else {
			$order_by = 'ID';
		}

		if ( isset( $atts['order'] ) ) {

			// Make a correct order value isset
			$allowed_order = array( "asc", "desc" );
			if ( in_array( $atts['order'], $allowed_order ) ) {
				$order = $atts['order'];
			} else {
				return 'The order value is not of the type asc, or desc';
			}
		} else {
			$order = 'desc';
		}


		if ( empty( $current_user ) ) {
			$current_user = get_user_by( 'id', $user_id );
		}

		// Set sorting
		$sort_atts = array(
			'order'   => $order,
			'orderby' => $order_by,
		);
		if ( ! empty( $tax_query ) ) {
			$sort_atts['tax_query'] = $tax_query;
		}

		if ( function_exists( 'ld_get_mycourses' ) ) {

			if ( 0 === $user_id ) {

				if ( isset( $atts['show'] ) ) {

					if ( 'open' === $atts['show'] ) {
						// Get open courses for logged out users
						$user_courses = learndash_get_open_courses();
						// Not filter available for open courses.
						$ld_categories = array();
						$categories    = array();
					} elseif ( 'all' === $atts['show'] ) {
						// Show all courses
						$course_query_args = array(
							'post_type'   => 'sfwd-courses',
							'post_status' => 'publish'
						);

						if ( ! empty( $tax_query ) ) {
							$course_query_args['tax_query'] = $tax_query;
						}

						if ( ! empty( $sort_atts ) ) {
							$course_query_args['order']   = $sort_atts['order'];
							$course_query_args['orderby'] = $sort_atts['orderby'];
						}


						$courses      = get_posts( $course_query_args );
						$user_courses = wp_list_pluck( $courses, 'ID' );
					} else {
						return '';
					}

				} else {

					return '';

				}


			} else {
				$user_courses = ld_get_mycourses( $user_id, $sort_atts );
			}

		} else {
			return;
		}

		$usermeta           = get_user_meta( $user_id, '_sfwd-quizzes', true );
		$quiz_attempts_meta = empty( $usermeta ) ? false : $usermeta;
		$quiz_attempts      = array();

		if ( function_exists( 'learndash_certificate_details' ) ) {
			if ( ! empty( $quiz_attempts_meta ) ) {
				foreach ( $quiz_attempts_meta as $quiz_attempt ) {
					$c                          = learndash_certificate_details( $quiz_attempt['quiz'], $user_id );
					$quiz_attempt['post']       = get_post( $quiz_attempt['quiz'] );
					$quiz_attempt["percentage"] = ! empty( $quiz_attempt["percentage"] ) ? $quiz_attempt["percentage"] : ( ! empty( $quiz_attempt["count"] ) ? $quiz_attempt["score"] * 100 / $quiz_attempt["count"] : 0 );

					if ( $user_id == get_current_user_id() && ! empty( $c["certificateLink"] ) && ( ( isset( $quiz_attempt['percentage'] ) && $quiz_attempt['percentage'] >= $c["certificate_threshold"] * 100 ) ) ) {
						$quiz_attempt['certificate'] = $c;
					}
					$quiz_attempts[ learndash_get_course_id( $quiz_attempt['quiz'] ) ][] = $quiz_attempt;
				}
			}
		}
		$args = array(
			'user_id'       => $user_id,
			'quiz_attempts' => $quiz_attempts,
			'current_user'  => $current_user,
			'user_courses'  => $user_courses,
			'categories'    => $categories,
			'ld_categories' => $ld_categories,
			'settings'      => $atts,
		);

		//Check to see if the file is in template to override default template.
		$file_path = get_stylesheet_directory() . '/uncanny-learndash-groups/templates/frontend-dashboard/dashboard-template.php';

		if ( ! file_exists( $file_path ) ) {
			$file_path = apply_filters( 'uo-dashboard-template', 'uo_dashboard_get_template' );
		}

		extract( $args );
		$level = ob_get_level();
		ob_start();
		echo do_shortcode( '[uo_ajax_search]' );
		include( $file_path );

		$contents = learndash_ob_get_clean( $level );
		/**
		 * @since 2.4.2
		 */
		if ( isset( $atts['expand_by_default'] ) && 'yes' === $atts['expand_by_default'] ) {
			$contents = '<script>(function($){$(document).ready(function(){flip_expand_all("#course_list");});})(jQuery);</script>' . $contents;
		}

		return $contents;

	}


	/**
	 * Set the user id
	 *
	 * @param $atts
	 *
	 * @return int
	 */
	public static function set_user_id( $atts ) {

		if ( isset( $_GET['user_id'] ) ) {
			$user_id         = absint( $_GET['user_id'] );
			$atts['user_id'] = $user_id;
		}

		if ( isset( $atts['user_id'] ) && '' !== $atts['user_id'] ) {
			$user_id = absint( $atts['user_id'] );
		} else {
			$current_user = wp_get_current_user();

			if ( empty( $current_user->ID ) ) {
				$user_id = 0;
			} else {
				$user_id = $current_user->ID;
			}
		}

		return $user_id;
	}

	/**
	 * Get a list on all quiz quiz attempts for each module
	 *
	 * @param $user_id
	 *
	 * @return array
	 */
	public static function get_all_quiz_attemps( $user_id ) {

		$usermeta           = get_user_meta( $user_id, '_sfwd-quizzes', true );
		$quiz_attempts_meta = empty( $usermeta ) ? false : $usermeta;
		$quiz_attempts      = array();

		if ( function_exists( 'learndash_certificate_details' ) ) {
			if ( ! empty( $quiz_attempts_meta ) ) {
				foreach ( $quiz_attempts_meta as $quiz_attempt ) {
					$c                          = learndash_certificate_details( $quiz_attempt['quiz'], $user_id );
					$quiz_attempt["percentage"] = ! empty( $quiz_attempt["percentage"] ) ? $quiz_attempt["percentage"] : ( ! empty( $quiz_attempt["count"] ) ? $quiz_attempt["score"] * 100 / $quiz_attempt["count"] : 0 );

					if ( $user_id == get_current_user_id() && ! empty( $c["certificateLink"] ) && ( ( isset( $quiz_attempt['percentage'] ) && $quiz_attempt['percentage'] >= $c["certificate_threshold"] * 100 ) ) ) {
						$quiz_attempt['certificate'] = $c;
					}

					$parent_post = null;
					if ( ! empty( $quiz_attempt['topic'] ) ) {
						$parent_post = $quiz_attempt['topic'];
					} elseif ( ! empty( $quiz_attempt['lesson'] ) ) {
						$parent_post = $quiz_attempt['lesson'];
					} elseif ( ! empty( $quiz_attempt['course'] ) ) {
						$parent_post = $quiz_attempt['course'];
					}


					if ( ! empty( $parent_post ) ) {
//						if ( isset( $quiz_attempts[ $parent_post ][ $quiz_attempt['quiz'] ] ) ) {
//							if ( $quiz_attempt['percentage'] >= $quiz_attempts[ $parent_post ][ $quiz_attempt['quiz'] ]['percentage'] ) {
//								if ( $quiz_attempt['completed'] >= $quiz_attempts[ $parent_post ][ $quiz_attempt['quiz'] ]['completed'] ) {
//									$quiz_attempts[ $parent_post ][ $quiz_attempt['quiz'] ] = $quiz_attempt;
//								}
//							}
//						} else {
						$quiz_attempts[ $parent_post ][ $quiz_attempt['quiz'] ][] = $quiz_attempt;
//						}
					}
				}
			}
		}

		return $quiz_attempts;
	}

	/**
	 * Create an hierachal object of course lessons, topics, and quiz assocatd user data
	 *
	 * @param $user_courses
	 * @param $user_id
	 * @param $quiz_attempts
	 *
	 * @return array
	 */
	public static function set_up_course_object( $user_courses, $user_id, $quiz_attempts ) {
		$courses = [];

		foreach ( $user_courses as $course_id ) {

			$course          = get_post( $course_id );
			$course_progress = learndash_course_progress( [
				'user_id'   => $user_id,
				'course_id' => $course_id,
				'array'     => true,
			] );
			$course_status   = learndash_course_status( $course_id, $user_id, true );

			$course_certificate = learndash_get_course_certificate_link( $course_id, $user_id );
			$has_certificate    = true;
			if ( empty( $course_certificate ) ) {
				$course_certificate = null;
				$has_certificate    = false;
			}


			$last_know_step = get_user_meta( $user_id, 'learndash_last_known_course_' . $course_id, true );
			$resume_url     = null;
			$has_resume_url = false;

			// User has not hit a LD module yet
			if ( ! empty( $last_know_step ) && absint( $last_know_step ) ) {
				$step_id               = $last_know_step;
				$last_know_post_object = get_post( (int) $step_id );

				if ( null !== $last_know_post_object ) {
					$has_resume_url = true;
					if ( function_exists( 'learndash_get_step_permalink' ) ) {
						$resume_url = learndash_get_step_permalink( $step_id, $course_id );
					} else {
						$resume_url = get_permalink( $step_id );
					}
				}
			}

			$course_progress['total']      = learndash_get_course_steps_count( $course_id );
			$course_progress['percentage'] = 0;
			if ( absint( $course_progress['completed'] ) && absint( $course_progress['total'] ) ) {
				$course_progress['percentage'] = number_format( ( ( $course_progress['completed'] / $course_progress['total'] ) * 100 ), 0 );
			}

			$courses[ $course_id ] = (object) [
				'id'       => $course_id,
				'title'    => $course->post_title, // string
				'url'      => get_permalink( $course ), // string
				'progress' => $course_progress['percentage'],

				'status'          => $course_status,
				'has_lessons'     => false, // boolean
				'has_quizzes'     => false, // boolean
				'quizzes'         => [], // array
				'has_certificate' => $has_certificate, // boolean
				'has_resume_url'  => $has_resume_url, // boolean

				'certificate_url' => $course_certificate, // string or null
				'resume_url'      => $resume_url, // string or null
			];


			$quizzes = learndash_get_course_quiz_list( $course_id );

			if ( ! empty( $quizzes ) ) {
				foreach ( $quizzes as $key => $quiz ) {

					if ( function_exists( 'learndash_get_step_permalink' ) ) {
						$quiz_url = learndash_get_step_permalink( $quiz['post']->ID, $course_id );
					} else {
						$quiz_url = get_permalink( $quiz['post']->ID );
					}

					$quiz_completed                     = learndash_is_quiz_complete( $user_id, $quiz['post']->ID, $course_id );
					$courses[ $course_id ]->has_quizzes = true;


					$has_certificate = false;
					$certificate_url = '';
					$c               = learndash_certificate_details( $quiz['post']->ID, $user_id );
					if ( ! empty( $c['certificateLink'] ) ) {
						$has_certificate = true;
						$certificate_url = $c['certificateLink'];
					}


					$courses[ $course_id ]->quizzes[] = // array of objects
						(object) [
							'id'    => $quiz['post']->ID, // int
							'title' => $quiz['post']->post_title, // string
							'url'   => $quiz_url, // string

							'taken_on' => 0, // timestamp null

							'score'  => 0, // int null
							'passed' => false, // boolean

							'is_completed' => $quiz_completed, // boolean

							'has_certificate' => $has_certificate, // boolean
							'has_statistics'  => false, // boolean

							'certificate_url'  => $certificate_url, // string
							'statistics_url'   => '#', // string
							'pro_quizid'       => '',
							'statistic_ref_id' => '',
							'statistics_nonce' => ''
						];

					if ( 1 === 0 && isset( $quiz_attempts[ $course_id ][ $quiz['post']->ID ] ) &&
					     ! empty( $quiz_attempts[ $course_id ][ $quiz['post']->ID ] )
					) {
						$courses[ $course_id ]->has_quizzes = true;
						$module_quiz_attempts               = $quiz_attempts[ $course_id ][ $quiz['post']->ID ];
						foreach ( $module_quiz_attempts as $attempt ) {

							$statistic_ref_id = $attempt['statistic_ref_id'];
							$pro_quizid       = $attempt['pro_quizid'];
							$is_completed     = true;
							$taken_on         = $attempt['completed'];
							$score            = $attempt['percentage'];
							$statistics_nonce = wp_create_nonce( 'statistic_nonce_' . $statistic_ref_id . '_' . get_current_user_id() . '_' . $user_id );

							if ( 1 === $attempt['pass'] ) {
								$passed = true;
							} else {
								$passed = false;
							}

							$has_certificate = false;
							$certificate_url = '';
							if ( isset( $attempt['certificate'] ) ) {
								$has_certificate = true;
								$certificate_url = $attempt['certificate']['certificateLink'];
							}

							$courses[ $course_id ]->quizzes[] = // array of objects
								(object) [
									'id'    => $quiz['post']->ID, // int
									'title' => $quiz['post']->post_title, // string
									'url'   => $quiz_url, // string

									'taken_on' => $taken_on, // timestamp null

									'score'  => $score, // int null
									'passed' => $passed, // boolean

									'is_completed' => $is_completed, // boolean

									'has_certificate' => $has_certificate, // boolean
									'has_statistics'  => true, // boolean

									'certificate_url'  => $certificate_url, // string
									'statistics_url'   => '#', // string
									'pro_quizid'       => $pro_quizid,
									'statistic_ref_id' => $statistic_ref_id,
									'statistics_nonce' => $statistics_nonce
								];
						}
					}
				}
			}


			$lessons = learndash_get_course_lessons_list( $course, $user_id, [
				'num' => - 1
			] );

			if ( ! empty( $lessons ) ) {
				$courses[ $course_id ]->has_lessons = true;
				foreach ( $lessons as $lesson ) {

					$is_completed = false;
					if ( 'completed' === $lesson['status'] ) {
						$is_completed = true;
					}

					$is_available = true;
					$available_on = null;
					if ( ! empty( $lesson['lesson_access_from'] ) ) {
						$is_available = false;
						$available_on = $lesson['lesson_access_from'];
					}

					$courses[ $course_id ]->lessons[ $lesson['post']->ID ] =
						(object) [
							'id'          => $lesson['post']->ID, // int
							'title'       => $lesson['post']->post_title, // string
							'url'         => $lesson['permalink'], // string
							'has_quizzes' => false, // boolean

							'is_completed' => $is_completed, // boolean

							'is_available' => $is_available, // boolean
							'available_on' => $available_on, // timestamp || null

							'quizzes' => []
						];

					$topics = learndash_topic_dots( $lesson['post']->ID, false, 'array', $user_id, $course_id );

					$courses[ $course_id ]->lessons[ $lesson['post']->ID ]->has_topics = false;
					if ( ! empty( $topics ) ) {
						$courses[ $course_id ]->lessons[ $lesson['post']->ID ]->has_topics = true;
						foreach ( $topics as $key => $topic ) {

							if ( function_exists( 'learndash_get_step_permalink' ) ) {
								$topic_url = learndash_get_step_permalink( $topic->ID, $course_id );
							} else {
								$topic_url = get_permalink( $topic->ID );
							}

							$courses[ $course_id ]->lessons[ $lesson['post']->ID ]->topics[ $topic->ID ] = // array of objects
								(object) [
									'id'    => $topic->ID, // int
									'title' => $topic->post_title, // string
									'url'   => $topic_url, // string

									'is_completed' => ! empty( $topic->completed ) ? true : false, // boolean
								];
						}
					}

					$quizzes = learndash_get_lesson_quiz_list( $lesson['post']->ID, $user_id, $course_id );

					$courses[ $course_id ]->lessons[ $lesson['post']->ID ]->has_quizzes = false;
					if ( ! empty( $quizzes ) ) {
						foreach ( $quizzes as $key => $quiz ) {

							if ( function_exists( 'learndash_get_step_permalink' ) ) {
								$quiz_url = learndash_get_step_permalink( $quiz['post']->ID, $course_id );
							} else {
								$quiz_url = get_permalink( $quiz['post']->ID );
							}

							$quiz_completed                                                     = learndash_is_quiz_complete( $user_id, $quiz['post']->ID, $course_id );
							$courses[ $course_id ]->lessons[ $lesson['post']->ID ]->has_quizzes = true;

							$has_certificate = false;
							$certificate_url = '';
							$c               = learndash_certificate_details( $quiz['post']->ID, $user_id );
							if ( ! empty( $c['certificateLink'] ) ) {
								$has_certificate = true;
								$certificate_url = $c['certificateLink'];
							}

							$courses[ $course_id ]->lessons[ $lesson['post']->ID ]->quizzes[] = // array of objects
								(object) [
									'id'    => $quiz['post']->ID, // int
									'title' => $quiz['post']->post_title, // string
									'url'   => $quiz_url, // string

									'taken_on' => 0, // timestamp null

									'score'  => 0, // int null
									'passed' => false, // boolean

									'is_completed' => $quiz_completed, // boolean

									'has_certificate' => $has_certificate, // boolean
									'has_statistics'  => false, // boolean

									'certificate_url'  => $certificate_url, // string
									'statistics_url'   => '#', // string
									'pro_quizid'       => '',
									'statistic_ref_id' => '',
									'statistics_nonce' => ''
								];

							if ( 0 == 1 &&
							     isset( $quiz_attempts[ $lesson['post']->ID ][ $quiz['post']->ID ] ) &&
							     ! empty( $quiz_attempts[ $lesson['post']->ID ][ $quiz['post']->ID ] )
							) {
								$courses[ $course_id ]->lessons[ $lesson['post']->ID ]->has_quizzes = true;

								$module_quiz_attempts = $quiz_attempts[ $lesson['post']->ID ][ $quiz['post']->ID ];
								foreach ( $module_quiz_attempts as $attempt ) {

									$statistic_ref_id = $attempt['statistic_ref_id'];
									$pro_quizid       = $attempt['pro_quizid'];
									$is_completed     = true;
									$taken_on         = $attempt['completed'];
									$score            = $attempt['percentage'];
									$statistics_nonce = wp_create_nonce( 'statistic_nonce_' . $statistic_ref_id . '_' . get_current_user_id() . '_' . $user_id );

									if ( 1 === $attempt['pass'] ) {
										$passed = true;
									}

									$has_certificate = false;
									$certificate_url = '';
									if ( isset( $attempt['certificate'] ) ) {
										$has_certificate = true;
										$certificate_url = $attempt['certificate']['certificateLink'];
									}

									$courses[ $course_id ]->lessons[ $lesson['post']->ID ]->quizzes[] = // array of objects
										(object) [
											'id'    => $quiz['post']->ID, // int
											'title' => $quiz['post']->post_title, // string
											'url'   => $quiz_url, // string

											'taken_on' => $taken_on, // timestamp null

											'score'  => $score, // int null
											'passed' => $passed, // boolean

											'is_completed' => $is_completed, // boolean

											'has_certificate' => $has_certificate, // boolean
											'has_statistics'  => true, // boolean

											'certificate_url'  => $certificate_url, // string
											'statistics_url'   => '#', // string
											'pro_quizid'       => $pro_quizid,
											'statistic_ref_id' => $statistic_ref_id,
											'statistics_nonce' => $statistics_nonce
										];
								}
							}
						}
					}
				}
			}
		}

		return $courses;
	}

	/**
	 * @return string
	 */
	public
	static function uo_dashboard_get_template() {
		$filepath = Utilities::get_template( 'frontend-dashboard/dashboard-template-3_0.php', dirname( dirname( __FILE__ ) ) . '/src' );
		$filepath = apply_filters( 'uo_dashboard_template', $filepath );

		return $filepath;
	}

	public static function enqueue_scripts_func() {
		global $post;

		if ( ! empty( $post ) ) {
			if ( has_shortcode( $post->post_content, 'uo_groups_manage_progress' ) ) {

				wp_enqueue_style( 'ulgm-font-awesome', Utilities::get_vendor( 'fontawesome/css/font-awesome.min.css' ), [], Utilities::get_version() );

				wp_enqueue_style( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.css' ), array(), Utilities::get_version() );

				wp_register_script( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.js' ), array(), Utilities::get_version() );

				// Check if the user can manage progress
				if ( current_user_can( 'group_leader' ) || current_user_can( 'manage_options' ) ) {

				}

				// Get user id parameter
				$user_id = isset( $_GET['user_id'] ) ? $_GET['user_id'] : null;

				wp_localize_script( 'ulgm-frontend', 'ULGM_ManageProgress', [
					'restUrl'           => esc_url_raw( rest_url() . 'uncanny_group_course_management/v2/' ),
					'nonce'             => \wp_create_nonce( 'wp_rest' ),
					'userId'            => isset( $_GET['user_id'] ) ? (int) $_GET['user_id'] : 'undefined',
					'canManageProgress' => self::can_manage_user_progress( $user_id ) ? 1 : 0,
					'i18n'              => [
						'certificate' => __( 'Certificate', 'uncanny-learndash-groups' )
					]
				] );

				wp_enqueue_script( 'ulgm-frontend' );

				/**
				 * Autocomplete
				 */

				wp_enqueue_style( 'jquery-ui-autocomplete', '//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css' );
				wp_enqueue_script( 'jquery-ui-autocomplete' );
				wp_register_script( 'user-autocomplete', plugins_url( 'src/assets/legacy/frontend/js/autocomplete.js', Utilities::get_plugin_file() ), '', '1.0.2', true );
				wp_localize_script( 'user-autocomplete', 'ajax_url', array( 'url' => admin_url( 'admin-ajax.php' ) ) );
				wp_localize_script( 'user-autocomplete', 'redirect_url', array( 'url' => get_permalink( $post->ID ) ) );
				wp_enqueue_script( 'user-autocomplete' );
			}
		}
	}

	public static function handle_shortcode( $atts ) {
		global $post;
		ob_start();

		if ( is_user_logged_in() ) {

			$user_name = '';
			if ( isset( $_GET['user_id'] ) ) {
				$user = get_userdata( absint( $_GET['user_id'] ) );
				if ( $user ) {

					$can_manage_progress = false;

					// Check if the user is an admin
					if ( current_user_can( 'manage_options' ) ) {
						// Set $can_manage_progress to true
						$can_manage_progress = true;
					} // Check if the user is a group leader
					else if ( current_user_can( 'group_leader' ) && ! current_user_can( 'manage_options' ) ) {
						// Check if it can edit the progress of this user
						if ( learndash_is_group_leader_of_user( get_current_user_id(), absint( $user->ID ) ) ) {
							// Set $can_manage_progress to true
							$can_manage_progress = true;
						}
					}

					if ( $can_manage_progress ) {
						$user_name = $user->last_name . ', ' . $user->first_name . ' [' . $user->user_email . ']';
					}

				}
			}
			?>

			<div class="ulg-manage-progress">
				<form method="GET" id="ulg-manage-progress-user-search">
					<label>
						<div class="ulg-manage-progress__title">
							<?php _e( 'Search users', 'uncanny-learndash-groups' ); ?>
						</div>
						<div class="ulg-manage-progress__search">
							<input type="hidden" name="page" value="<?php echo $post->ID ?>"/>
							<input type="text" id="ulg-manage-progress-user-search-field"
							       placeholder="<?php _e( 'Search by user ID, name or email address', 'uncanny-learndash-groups' ); ?>"
							       value="<?php echo $user_name; ?>"/>
						</div>
					</label>
				</form>
			</div>

			<?php
		}

		return ob_get_clean();
	}

	/**
	 *
	 */
	public static function search_user() {

		if ( ! is_user_logged_in() ) {
			echo wp_json_encode( [ __( 'You are not allowed to search.', 'uncanny-learndash-groups' ) ] );
		}

		$allowed = false;
		if ( in_array( 'administrator', wp_get_current_user()->roles ) ) {
			$allowed = true;
		} elseif ( in_array( 'group_leader', wp_get_current_user()->roles ) ) {
			$allowed = true;
		}

		if ( ! $allowed ) {
			echo wp_json_encode( [ __( 'You are not allowed to search.', 'uncanny-learndash-groups' ) ] );
		}

		if ( isset( $_GET['term'] ) && ! empty( $_GET['term'] ) ) {
			$term = strtolower( $_GET['term'] );
		} elseif ( isset( $_GET['name'] ) && ! empty( $_GET['name'] ) ) {
			$term = strtolower( $_GET['name'] );
		} else {
			echo wp_json_encode( array() );
			die();
		}
		$suggestions = array();

		$loop = get_users( array( 'search' => "*{$term}*" ) );

		if ( $loop ) {
			foreach ( $loop as $user ) {
				$suggestions[ $user->ID ] = array(
					'user_id'    => $user->ID,
					'label'      => $user->last_name . ', ' . $user->first_name . ' [' . $user->user_email . ']',
					'first_name' => $user->first_name,
					'last_name'  => $user->last_name,
					'user_email' => $user->user_email,
				);
			}
		}

		$meta_users = get_users( array(
			'meta_query' => array(
				array( 'key' => 'last_name', 'value' => $term, 'compare' => 'LIKE' ),
			),
		) );


		if ( $meta_users ) {
			foreach ( $meta_users as $user ) {
				$suggestions[ $user->ID ] = array(
					'user_id'    => $user->ID,
					'label'      => $user->last_name . ', ' . $user->first_name . ' [' . $user->user_email . ']',
					'first_name' => $user->first_name,
					'last_name'  => $user->last_name,
					'user_email' => $user->user_email,
				);
			}
		}

		if ( in_array( 'administrator', wp_get_current_user()->roles ) ) {
		} elseif ( in_array( 'group_leader', wp_get_current_user()->roles ) ) {
			//Limit results to group users only
			$group_users = learndash_get_group_leader_groups_users( wp_get_current_user()->ID );
			if ( empty( $group_users ) ) {
				$suggestions = [ 'No matching users found.' ];
			} else {

				foreach ( $suggestions as $user_id => $val ) {
					if ( ! in_array( $user_id, $group_users ) ) {
						unset( $suggestions[ $user_id ] );
					}
				}

				if ( empty( $suggestions ) ) {
					$suggestions = [ 0 => 'No user found matching criteria.' ];
				}
			}

		}

		$response = wp_json_encode( $suggestions );
		echo $response;
		die();
	}

	/**
	 * @param $user_id
	 * @param $lesson_id
	 * @param $course_id
	 * @param $type
	 */
	public static function mark_lesson_steps( $user_id, $lesson_id, $course_id, $type ) {

		$topic_list = learndash_get_topic_list( $lesson_id, $course_id );
		$quiz_list  = [];

		if ( ! empty( $topic_list ) ) {
			foreach ( $topic_list as $topic ) {

				if ( 'uncomplete_post' === $type ) {

					learndash_process_mark_incomplete( $user_id, $course_id, $topic->ID );
				}

				if ( 'complete_post' === $type ) {
					learndash_process_mark_complete( $user_id, $topic->ID, false, $course_id );
				}

				$topic_quiz_list = learndash_get_lesson_quiz_list( $topic->ID, $user_id, $course_id );
				if ( $topic_quiz_list ) {
					foreach ( $topic_quiz_list as $ql ) {
						$quiz_list[ $ql['post']->ID ] = 0;
					}
				}
			}
		}

		$lesson_quiz_list = learndash_get_lesson_quiz_list( $lesson_id, $user_id, $course_id );

		if ( $lesson_quiz_list ) {
			foreach ( $lesson_quiz_list as $ql ) {
				$quiz_list[ $ql['post']->ID ] = 0;
			}
		}

		self::mark_quiz( $user_id, $course_id, $quiz_list, $type );
	}

	/**
	 * @param      $user_id
	 * @param null $course_id
	 * @param      $type
	 */
	public static function mark_quiz( $user_id, $course_id = null, $quiz_list, $type ) {

		$quizz_progress = [];

		if ( ! empty( $quiz_list ) ) {

			$usermeta       = get_user_meta( $user_id, '_sfwd-quizzes', true );
			$quizz_progress = empty( $usermeta ) ? array() : $usermeta;

//			foreach ( $quizz_progress as $quiz ) {
//				if ( isset( $quiz['course'] ) && isset( $quiz['course'] ) ) {
//					if ( $course_id == $quiz['course'] ) {
//						if ( in_array() ) {
//
//						}
//					}
//				}
//			}
		}

		foreach ( $quiz_list as $quiz_id => $quiz ) {

			if ( 'uncomplete_post' === $type ) {

				if ( ! learndash_is_quiz_complete( $user_id, $quiz_id, $course_id ) ) {
					continue;
				}

				learndash_delete_quiz_progress( (int) $user_id, (int) $quiz_id );

			} else {

				if ( learndash_is_quiz_complete( $user_id, $quiz_id, $course_id ) ) {
					continue;
				}
				$quiz_meta = get_post_meta( $quiz_id, '_sfwd-quiz', true );

				$quizdata = array(
					'quiz'             => $quiz_id,
					'score'            => 100,
					'count'            => 0,
					'pass'             => true,
					'rank'             => '-',
					'time'             => time(),
					'pro_quizid'       => $quiz_meta['sfwd-quiz_quiz_pro'],
					'course'           => $course_id,
					'points'           => 0,
					'total_points'     => 0,
					'percentage'       => 100,
					'timespent'        => 0,
					'has_graded'       => false,
					'statistic_ref_id' => 0,
					'm_edit_by'        => 9999999,  // Manual Edit By ID.
					'm_edit_time'      => time(),          // Manual Edit timestamp.
				);

				$quizdata['pass'] = true;
				$quizdata_pass    = true;

				$quizz_progress[] = $quizdata;


				// Then we add the quiz entry to the activity database.
				learndash_update_user_activity(
					array(
						'course_id'          => $course_id,
						'user_id'            => $user_id,
						'post_id'            => $quiz_id,
						'activity_type'      => 'quiz',
						'activity_action'    => 'insert',
						'activity_status'    => $quizdata_pass,
						'activity_started'   => $quizdata['time'],
						'activity_completed' => $quizdata['time'],
						'activity_meta'      => $quizdata,
					)
				);
			}
		}
		if ( ! empty( $quizz_progress ) && 'complete_post' === $type ) {
			update_user_meta( $user_id, '_sfwd-quizzes', $quizz_progress );
		}
	}
}
