import {
    UncannyOwlIconColor
} from '../components/icons';

import {
    ToolkitPlaceholder
} from '../components/editor';

const {__} = wp.i18n;
const {registerBlockType} = wp.blocks;


registerBlockType('uncanny-learndash-groups/uo-groups-essays-report', {
    title: __('Essay Management', 'uncanny-learndash-groups'),

    description: __('Allows Group Leaders to manage essays posted by their group members', 'uncanny-learndash-groups'),

    icon: UncannyOwlIconColor,

    category: 'uncanny-learndash-groups',

    keywords: [
        __('Uncanny Owl - Groups Plugin', 'uncanny-learndash-groups'),
    ],

    supports: {
        html: false
    },

    attributes: {},

    edit({className, attributes, setAttributes}) {
        return (
            <div className={className}>
                <ToolkitPlaceholder>
                    {__('Group Essay Management', 'uncanny-learndash-groups')}
                </ToolkitPlaceholder>
            </div>
        );
    },

    save({className, attributes}) {
        // We're going to render this block using PHP
        // Return null
        return null;
    },
});
