(function ($) { // Self Executing function with $ alias for jQuery

    /**
     *  Initialization  similar to include once but since all js is loaded by the browser automatically the all
     *   we have to do is call our functions to initialize them, his is only run in the main configuration file
     */
    $(document).ready(function () {

        if ($('#uo-group-essays-table').length > 0 ){
            window.ulgmGroupManagement.Essays.constructor();

            jQuery('form#uo-groups-essays-management-form').on('click', 'button.essay_approve_single,a.essay_approve_single', function (e) {
                e.preventDefault();
                var essay_id = jQuery(this).attr('id').replace('essay_approve_', '');
                essay_id = essay_id.replace('a_', '');
                if ((typeof essay_id !== 'undefined') && (essay_id != '')) {
                    if (jQuery('form#uo-groups-essays-management-form input#bulk-post-selector-top').length) {
                        jQuery('form#uo-groups-essays-management-form input#bulk-post-selector-top').val(essay_id);
                    }
                    if (jQuery('form#uo-groups-essays-management-form input#bulk-action-selector-top').length) {
                        jQuery('form#uo-groups-essays-management-form input#bulk-action-selector-top').val('graded');
                    }
                    //jQuery('form#uo-groups-essays-management-form').submit();
                    var dataVars = $('form#uo-groups-essays-management-form').serialize();
                    window.ulgmGroupManagement.Essays.actionsEssays(dataVars);
                }
            });
            jQuery('form#uo-groups-essays-management-form').on('click','a.delete_essay_single',function(e) {
                e.preventDefault();
                var essay_id = jQuery(this).attr('id').replace('a_essay_trash_', '');

                if ( ( typeof essay_id !== 'undefined' ) && ( essay_id != '' ) ) {
                    if (jQuery('form#uo-groups-essays-management-form input#bulk-post-selector-top').length) {
                        jQuery('form#uo-groups-essays-management-form input#bulk-post-selector-top').val(essay_id);
                    }
                    if (jQuery('form#uo-groups-essays-management-form input#bulk-action-selector-top').length) {
                        jQuery('form#uo-groups-essays-management-form input#bulk-action-selector-top').val('trash_essay');
                    }
                    var dataVars = $('form#uo-groups-essays-management-form').serialize();
                    window.ulgmGroupManagement.Essays.actionsEssays(dataVars);
                }
            });


            $('#uo-group-essays-table').on('click','a.edit_essay_single',function(){
                var post_id = $(this).data('essay-id');
                window.ulgmGroupManagement.Essays.editEssaysData(post_id);
            });
            $('body').on('click','button#uo-essay-edit-button',function(){
                window.ulgmGroupManagement.Essays.saveEssaysData();
            });
            $('body').on('click','#uo-essay-update-button',function(){
                window.ulgmGroupManagement.Essays.saveEssaysData();
            });

            var transitionTimeout;
            $( '#uo-group-essays-table tbody' ).on({
                mouseenter: function() {
                    clearTimeout( transitionTimeout );
                    focusedRowActions = $( this ).find( '.row-actions' );
                    // transitionTimeout is necessary for Firefox, but Chrome won't remove the CSS class without a little help.
                    $( '.row-actions' ).not( this ).removeClass( 'visible' );
                    focusedRowActions.addClass( 'visible' );
                },
                mouseleave: function() {
                    // Tabbing between post title and .row-actions links needs a brief pause, otherwise
                    // the .row-actions div gets hidden in transit in some browsers (ahem, Firefox).
                    transitionTimeout = setTimeout( function() {
                        focusedRowActions.removeClass( 'visible' );
                    }, 30 );
                }
            }, 'tr' );
        }
    });


    window.ulgmGroupManagement.Essays = {

        uoTable: null,

        uoTableHidden: null,

        lessonId: 0,

        groupId: 0,

        courseId: 0,

        quizId: 0,

        elements: {
            select: {
                group: {
                    element: null,
                    options: null
                },
                course: {
                    element: null,
                    options: null,
                    no_element: null
                },
                lesson: {
                    element: null,
                    options: null,
                    no_element: null
                },
                quiz: {
                    element: null,
                    options: null,
                    no_element: null
                },
            }
        },

        constructor: function () {
            this.elements.select.group.element = $('#uo-group-report-group');
            this.elements.select.course.element = $('#uo-group-report-courses');
            this.elements.select.lesson.element = $('#uo-group-report-lessons');
            this.elements.select.quiz.element = $('#uo-group-report-quizzes');
            this.elements.select.course.no_element = $('#uo-group-report-nocourses');
            this.elements.select.lesson.no_element = $('#uo-group-report-nolessons');
            this.elements.select.quiz.no_element = $('#uo-group-report-noquizzes');

            this.elements.select.group.options  = $('#uo-group-report-group option');
            this.elements.select.course.options = $('#uo-group-report-courses option');
            this.elements.select.lesson.options   = $('#uo-group-report-lessons option');
            this.elements.select.quiz.options   = $('#uo-group-report-quizzes option');

            this.createTable();
            this.createTableHidden();
            this.addEvents();
            // Request data
            window.ulgmGroupManagement.Essays.getEssaysData( 0, 0, window.ulgmGroupManagement.Essays.groupId, 0 );
        },

        createTable: function (data) {

            var columns = [
                {title: 'select'},
                {title: groupEssays.localized.title},
                {title: groupEssays.localized.author},
                {title: groupEssays.localized.status},
                {title: groupEssays.localized.points},
                {title: groupEssays.localized.assignedCourse},
                {title: groupEssays.localized.assignedlesson},
                {title: groupEssays.localized.assignedquiz},
                {title: groupEssays.localized.comments},
                {title: groupEssays.localized.date}
            ];

            var tableVars = {
                aLengthMenu: [
                    [15, 30, 60, -1],
                    [15, 30, 60, groupEssays.localized.all]
                ],
                responsive: false,
                iDisplayLength: 30,
                columns: columns,
                columnDefs: [{
                    "targets": 0,
                    "orderable": false,
                    "searchable": false,
                    'render': function (data, type, full, meta){
                        return '<input type="checkbox" name="post[]" value="' + $('<div/>').text(data).html() + '">';
                    },
                    'checkboxes': {
                        'selectRow': true
                    }
                }],
                select: {
                    style: 'multi',
                    selector: 'td:first-child'
                },
                stateSave: true,
            };

            if (null !== this.uoTable) {

                this.uoTable.destroy();

                tableVars.data = data;

                tableVars.columnDefs = [{
                    className: 'uo-groups__cell-checkbox',
                    targets:   [0]
                }];

                tableVars.columns = [
                    {title: groupEssays.localized.idColumn, data: 'id'},
                    {title: groupEssays.localized.title, data: 'title'},
                    {title: groupEssays.localized.author, data: 'author'},
                    {title: groupEssays.localized.status, data: 'status'},
                    {title: groupEssays.localized.points, data: 'points'},
                    {title: groupEssays.localized.assignedCourse, data: 'assignedCourse'},
                    {title: groupEssays.localized.assignedlesson, data: 'assignedlesson'},
                    {title: groupEssays.localized.assignedquiz, data: 'assignedquiz'},
                    {title: groupEssays.localized.comments, data: 'comments'},
                    {title: groupEssays.localized.date, data: 'date'},
                ];

            }
            tableVars.language = {
                "lengthMenu": groupEssays.localized.lengthMenu,
                "zeroRecords": groupEssays.localized.zeroRecords,
                "info": groupEssays.localized.info,
                "infoEmpty": groupEssays.localized.infoEmpty,
                "infoFiltered": groupEssays.localized.infoFiltered,
                "loadingRecords": groupEssays.localized.loadingRecords,
                "emptyTable": groupEssays.localized.emptyTable,
                "sSearch": groupEssays.localized.sSearch,
                "searchPlaceholder": groupEssays.localized.searchPlaceholder
            };

            this.uoTable = jQuery('#uo-group-essays-table');

            if ( jQuery('#uo-group-essays-table').length > 0 ){
                this.uoTable = jQuery('#uo-group-essays-table').DataTable(tableVars);
            }


        },

        createTableHidden: function (data) {

            var columns = [
                {title: groupEssays.localized.title, data: 'title'},
                {title: groupEssays.localized.author, data: 'author'},
                {title: groupEssays.localized.status, data: 'status',orderable: false,},
                {title: groupEssays.localized.points, data: 'points',orderable: false,},
                {title: groupEssays.localized.assignedCourse, data: 'assignedCourse',orderable: false,},
                {title: groupEssays.localized.assignedlesson, data: 'assignedlesson',orderable: false,},
                {title: groupEssays.localized.assignedquiz, data: 'assignedquiz',orderable: false,},
                {title: groupEssays.localized.comments, data: 'comments'},
                {title: groupEssays.localized.date, data: 'date'},
            ];

            /*var language = [
                "lengthMenu": groupEssays.localized.lengthMenu,
                "zeroRecords": groupEssays.localized.zeroRecords,
                "info": groupEssays.localized.info,
                "infoEmpty": groupEssays.localized.infoEmpty,
                "infoFiltered": groupEssays.localized.infoFiltered,
                "loadingRecords": groupEssays.localized.loadingRecords,
                "emptyTable": groupEssays.localized.emptyTable
            ];*/

            var tableVars = {
                iDisplayLength: -1,
                columns: columns,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'csv',
                        text: groupEssays.localized.csvExport,
                        title: 'lesson-report'
                    }
                ],
                stateSave: true,
            };

            if ( $.fn.DataTable.isDataTable( '#uo-lesson-report-table-hidden' ) ){

                $( '#uo-lesson-report-table-hidden' ).DataTable().destroy();

                tableVars.data = data;

                tableVars.columns = [
                    {title: groupEssays.localized.title, data: 'title'},
                    {title: groupEssays.localized.author, data: 'author'},
                    {title: groupEssays.localized.status, data: 'status',orderable: false,},
                    {title: groupEssays.localized.points, data: 'points',orderable: false,},
                    {title: groupEssays.localized.assignedCourse, data: 'assignedCourse',orderable: false,},
                    {title: groupEssays.localized.assignedlesson, data: 'assignedlesson',orderable: false,},
                    {title: groupEssays.localized.assignedquiz, data: 'assignedquiz',orderable: false,},
                    {title: groupEssays.localized.comments, data: 'comments'},
                    {title: groupEssays.localized.date, data: 'date'},
                ];

            }

            tableVars.language = {
                "lengthMenu": groupEssays.localized.lengthMenu,
                "zeroRecords": groupEssays.localized.zeroRecords,
                "info": groupEssays.localized.info,
                "infoEmpty": groupEssays.localized.infoEmpty,
                "infoFiltered": groupEssays.localized.infoFiltered,
                "loadingRecords": groupEssays.localized.loadingRecords,
                "emptyTable": groupEssays.localized.emptyTable
            };

            this.uoTableHidden = jQuery('#uo-lesson-report-table-hidden');

            if ( jQuery('#uo-lesson-report-table-hidden').length > 0 ){
                this.uoTableHidden = jQuery('#uo-lesson-report-table-hidden').DataTable(tableVars);
            }

            $('.buttons-csv').show();

        },

        flattenArray: function (array, remove_stats) {

            var flatArray = [];

            jQuery.each(array, function (key, value) {

                var lesson_name = value;
                jQuery.each(value.question, function (key2, value2) {
                    flatArray.push({
                        "title": value.title,
                        "author": value.author,
                        "status": value.status,
                        "points": value.points,
                        "assignedCourse": value.assignedCourse,
                        "assignedlesson": value.assignedlesson,
                        "assignedquiz": value.assignedquiz,
                        "comments": value.comments,
                        "date": value.date,
                    })
                });

            });

            return flatArray;

        },

        create_options: function( source, ids ){
            /*
            * @param source string, values "group", "course", "lesson"
            * @param ids    array,  ids of options that have to be shown
            *
            * @return array of jQuery DOM elements with the option elements
            */

            let options = [];

            // Convert parameters to int
            ids = ids.map( Number );

            // Add empty option
            // if there are more then one option
            if( ids.length > 1 ){
                ids.push(0);
            }


            // Get options by ID
            this.elements.select[source].options.each(function(){
                let $this   = $(this),
                    id      = parseInt( $this.val() );
                $this.show();
                if ( ids.indexOf( id ) != -1 ){
                    options.push( $this );
                }
            });

            // Return options
            return options;
        },

        select_option: function( $select, value ){
            /*
            * @param select  dom element
            * @param value   string, value of the option that has to be selected
            */

            // Remove selected property
            $select.find( 'option' ).prop( 'selected', false );

            // Select option with value = @param value
            $select.find( 'option[value="' + value + '"]' ).prop( 'selected', true );
        },
        __select_option: function( $select, index ){
            /*
            * @param select  dom element
            * @param value   string, value of the option that has to be selected
            */

            // Remove selected property
            $select.find( 'option' ).prop( 'selected', false );

            // Select option with value = @param value
            $select.find( 'option[' + index + ']' ).prop( 'selected', true );
        },
        addEvents: function (){
            var _this = this;

            // Handle click on "Select all" control
            $('#uo-groups-essays-management').on('click',' #uo-essays-select-all', function(){
                // Check/uncheck checkboxes for all rows in the table
                $('input[name="post[]"]').prop('checked', this.checked);
                if ($('input[name="post[]"]').is(':checked')) {
                    $('.group-essays-buttons').show();
                } else {
                    $('.group-essays-buttons').hide();
                    $('#uo-essays-select-all').prop('checked', false);
                }
            });

            // Handle click on checkbox to set state of "Select all" control
            $('#uo-group-essays-table tbody').on('change', 'input[name="post[]"]', function(){
                // If checkbox is not checked
                if(!this.checked){
                    var el = $('#uo-essays-select-all').get(0);
                    // If "Select all" control is checked and has 'indeterminate' property
                    if(el && el.checked && ('indeterminate' in el)){
                        // Set visual state of "Select all" control
                        // as 'indeterminate'
                        el.indeterminate = true;
                    }
                }
                if ($('input[name="post[]"]').is(':checked')) {
                    $('.group-essays-buttons').show();
                } else {
                    $('.group-essays-buttons').hide();
                    $('#uo-essays-select-all').prop('checked', false);
                }
            });

            $('#uo-groups-essays-management').on('click','#group-approve-essays-button',function(){
                if (jQuery('form#uo-groups-essays-management-form input#bulk-action-selector-top').length) {
                    jQuery('form#uo-groups-essays-management-form input#bulk-action-selector-top').val('approve_essay');
                }
                jQuery('form#uo-groups-essays-management-form').submit();
            });

            $('#uo-groups-essays-management').on('click','#group-trash-essays-button',function(){
                if (jQuery('form#uo-groups-essays-management-form input#bulk-action-selector-top').length) {
                    jQuery('form#uo-groups-essays-management-form input#bulk-action-selector-top').val('trash_essay');
                }
                jQuery('form#uo-groups-essays-management-form').submit();
            });

            this.elements.select.group.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // Hide lesson select
                _this.elements.select.course.element.show();

                // Group ID
                let group_id = $this.val();
                // Return if course id is 0
                if( group_id == 0){
                    _this.elements.select.course.element.empty();
                    let options_course = _this.create_options( 'course', [0] );
                    _this.elements.select.course.element.html(options_course);
                    _this.elements.select.lesson.element.empty();
                    let options = _this.create_options( 'lesson', [0] );
                    _this.elements.select.lesson.element.html(options);
                    let options_quiz = _this.create_options( 'quiz', [0] );
                    _this.elements.select.quiz.element.html(options_quiz);
                    window.ulgmGroupManagement.Essays.createTable([]);
                    window.ulgmGroupManagement.Essays.createTableHidden([]);
                    return;
                }
                // Get relationships
                let courses_to_show = groupEssays.courseGrouplessons[ group_id ];
                courses_to_show = courses_to_show === undefined ? [] : courses_to_show;


                // Create options
                let options = _this.create_options( 'course', courses_to_show );

                if ( options.length > 0 ){
                     // Show "Select course" dropdown
                    _this.elements.select.course.element.show();
                    _this.elements.select.course.element.html( options );
                    _this.elements.select.course.no_element.hide();
                    _this.elements.select.course.element.html(_this.elements.select.course.element.find('option').sort(function(x, y) {
                        // to change to descending order switch "<" for ">"
                        return $(x).text() > $(y).text() ? 1 : -1;
                    }));
                    // Select empty option

                    _this.__select_option( _this.elements.select.course.element, 0 );

                    // Save data in main object
                    window.ulgmGroupManagement.Essays.groupId = group_id;
                    // trigger change after value set on load
                    _this.elements.select.course.element.trigger('change');
                }
                else {
                    // Hide "Select course" dropdown, the empty option was selected
                    _this.elements.select.course.element.empty();
                    let options_course = _this.create_options( 'course', [0] );
                    _this.elements.select.course.element.html(options_course);
                    _this.elements.select.lesson.element.empty();
                    let options = _this.create_options( 'lesson', [0] );
                    _this.elements.select.lesson.element.html(options);
                    let options_quiz = _this.create_options( 'quiz', [0] );
                    _this.elements.select.quiz.element.html(options_quiz);
                    window.ulgmGroupManagement.Essays.createTable([]);
                    window.ulgmGroupManagement.Essays.createTableHidden([]);
                    // Save data in main object
                    window.ulgmGroupManagement.Essays.groupId = group_id;
                }
                // Request data
                window.ulgmGroupManagement.Essays.getEssaysData( 0, 0, window.ulgmGroupManagement.Essays.groupId, 0 );
            });

            this.elements.select.course.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // Course ID
                let course_id = $this.val();
                // Return if course id is 0
                if( course_id == 0){
                    _this.elements.select.lesson.element.empty();
                    let options = _this.create_options( 'lesson', [0] );
                    _this.elements.select.lesson.element.html(options);
                    let options_quiz = _this.create_options( 'quiz', [0] );
                    _this.elements.select.quiz.element.html(options_quiz);
                    window.ulgmGroupManagement.Essays.createTable([]);
                    window.ulgmGroupManagement.Essays.createTableHidden([]);
                    return;
                }

                // Get relationships
                let lessons_to_show = groupEssays.relationships[ window.ulgmGroupManagement.Essays.groupId ][ course_id ];
                lessons_to_show = lessons_to_show === undefined ? [] : lessons_to_show;

                // Create options
                let options = _this.create_options( 'lesson', lessons_to_show );

                if ( options.length > 0 ) {
                    // Show "Select lesson" dropdown
                    _this.elements.select.lesson.element.show();
                    _this.elements.select.lesson.element.html(options);
                    jQuery('#uo-group-report-lessons option').show();
                    _this.elements.select.lesson.no_element.hide();

                    // Select empty option
                    _this.__select_option( _this.elements.select.lesson.element, 0 );

                    // Save data in main object
                    window.ulgmGroupManagement.Essays.courseId = course_id;
                    // trigger change after value set on load
                    _this.elements.select.lesson.element.trigger('change');
                }else{
                    // Hide "Select course" dropdown, the empty option was selected
                    _this.elements.select.lesson.element.empty();
                    let options = _this.create_options( 'lesson', [0] );
                    _this.elements.select.lesson.element.html(options);
                    window.ulgmGroupManagement.Essays.createTable([]);
                    window.ulgmGroupManagement.Essays.createTableHidden([]);
                    // Save data in main object
                    window.ulgmGroupManagement.Essays.courseId = course_id;
                    // Request data
                    window.ulgmGroupManagement.Essays.getEssaysData( 0, window.ulgmGroupManagement.Essays.courseId, window.ulgmGroupManagement.Essays.groupId, 0 );
                }

                // Get relationships
                let quizzes_to_show = groupEssays.quiz_relationships[ window.ulgmGroupManagement.Essays.groupId ][ course_id ];
                quizzes_to_show = quizzes_to_show === undefined ? [] : quizzes_to_show;

                // Create options
                let options_quizzes = _this.create_options( 'quiz', quizzes_to_show );

                if ( options_quizzes.length > 0 ) {
                    // Show "Select lesson" dropdown
                    _this.elements.select.quiz.element.show();
                    _this.elements.select.quiz.element.html(options_quizzes);
                    jQuery('#uo-group-report-quizzes option').show();
                    _this.elements.select.quiz.no_element.hide();

                    // Select empty option
                    _this.__select_option( _this.elements.select.quiz.element, 0 );

                    // Save data in main object
                    window.ulgmGroupManagement.Essays.courseId = course_id;
                    // trigger change after value set on load
                    _this.elements.select.quiz.element.trigger('change');
                }else{
                    // Hide "Select course" dropdown, the empty option was selected
                    _this.elements.select.quiz.element.empty();
                    let options = _this.create_options( 'quiz', [0] );
                    _this.elements.select.quiz.element.html(options);
                    window.ulgmGroupManagement.Essays.createTable([]);
                    window.ulgmGroupManagement.Essays.createTableHidden([]);
                    // Save data in main object
                    window.ulgmGroupManagement.Essays.courseId = course_id;
                    // Request data
                    window.ulgmGroupManagement.Essays.getEssaysData( 0, window.ulgmGroupManagement.Essays.courseId, window.ulgmGroupManagement.Essays.groupId, 0 );
                }

            });

            this.elements.select.lesson.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // lesson ID
                let lesson_id = $this.val();
                // Save data in main object
                window.ulgmGroupManagement.Essays.lessonId = lesson_id;

                // Request data
                window.ulgmGroupManagement.Essays.getEssaysData( lesson_id, window.ulgmGroupManagement.Essays.courseId, window.ulgmGroupManagement.Essays.groupId, 0 );
            });

            this.elements.select.quiz.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);
                // lesson ID
                let quiz_id = $this.val();
                // Save data in main object
                window.ulgmGroupManagement.Essays.quizId = quiz_id;

                // Request data
                window.ulgmGroupManagement.Essays.getEssaysData( 0, window.ulgmGroupManagement.Essays.courseId, window.ulgmGroupManagement.Essays.groupId, window.ulgmGroupManagement.Essays.quizId );
            });

            // Add event listener for opening and closing details
            $('#uo-lesson-report-table').on('click', 'td.details-control', function () {

                var tr = $(this).closest('tr');
                var row = window.ulgmGroupManagement.Essays.uoTable.row(tr);

                if (row.child.isShown()) {
                    // This row is already open - close it
                    row.child.hide();
                    tr.removeClass('shown');
                }
                else {
                    // Open this row
                    row.child(window.ulgmGroupManagement.Essays.format(row.data())).show();
                    tr.addClass('shown');
                }
            });

        },

        format: function (d) {

            var rows = '';
            $.each(d.answer, function (key, value) {
                rows +=
                    '<tr>' +
                    '<td>' + d.question[key] + '</td>' +
                    '<td>' + value + '</td>' +
                    '</tr>';
            });
            // `d` is the original data object for the row
            return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">' + rows + '</table>';
        },
        isNormalInteger: function (str) {
            var n = ~~Number(str);
            return String(n) === str && n > 0;
        },

        getEssaysData: function (lessonId, courseId, groupId, quizId) {

            var i = 0;

            var loading = setInterval(function () {
                i = ++i % 4;
                $("#uo-group-essays-table tbody").html("<div id='group-loader'>" + groupEssays.localized.loadingRecords + new Array(i + 1).join(".") + "</div>");
            }, 500);


            var dataVars = {
                groupId: groupId,
                lessonId: lessonId,
                quizId: quizId,
                courseId: courseId
            };

            $.ajax({

                method: "POST",
                data: dataVars,
                url: groupEssays.root + 'get_essays_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupEssays.nonce);
                },
                success: function (response) {

                    clearInterval(loading);
                    $('#group-loader').remove();

                    window.ulgmGroupManagement.Essays.createTable(response);
                    window.ulgmGroupManagement.Essays.createTableHidden(response);


                },
                fail: function (response) {
                    alert('Rest Call Failed');
                }

            });

        },
        editEssaysData: function (postId) {
            var spinner = $('.uo-modal-spinner');
            spinner.show();
            var dataVars = {
                essay_id: postId,
                action: 'edit_essays',
                post_type:'sfwd-essay',
                security:groupEssays.ajax_nonce
            };

            $.ajax({
                method: "POST",
                data: dataVars,
                url: groupEssays.root + 'edit_essays_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupEssays.nonce);
                },
                success: function (response) {
                    spinner.hide();
                    $(".modal").remove();
                    $(response.html).appendTo('body').modal();
                },
                fail: function (response) {
                    spinner.hide();
                    alert('Rest Call Failed');
                }
            });
        },
        saveEssaysData: function () {
            if (typeof tinymce !== 'undefined') {
                for (edId in tinyMCE.editors) {
                    tinyMCE.editors[edId].save();
                }

            }
            var dataVars = $('#edit_essay_form').serialize();
            var spinner = $('.uo-modal-spinner');
            //$('#group-management-message').hide();
            $('.uo-groups-message-ok').hide();
            spinner.show();
            $.ajax({
                method: "POST",
                data: dataVars,
                url: groupEssays.root + 'save_essays_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupEssays.nonce);
                },
                success: function (response) {
                    spinner.hide();
                    window.ulgmGroupManagement.Essays.elements.select.lesson.element.trigger('change');
                    //$('#group-management-message').html(response.message).show();
                    $('.uo-groups-message-ok').html(response.message).show();
                },
                fail: function (response) {
                    spinner.hide();
                    alert('Rest Call Failed');
                }
            });
        },
        actionsEssays: function ( dataVars ) {
            var spinner = $('.uo-modal-spinner');
            spinner.show();
            $.ajax({
                method: "POST",
                data: dataVars,
                url: groupEssays.root + 'save_essays_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupEssays.nonce);
                },
                success: function (response) {
                    spinner.hide();
                    window.ulgmGroupManagement.Essays.elements.select.lesson.element.trigger('change');
                },
                fail: function (response) {
                    spinner.hide();
                    alert('Rest Call Failed');
                }
            });
        }
    };


})(jQuery);