<?php
/**
 * The Settings Tab for LearnDash Slack
 * This applies to only LearnDash installs below version 2.4
 *
 * @since		1.1.0
 *
 * @package LearnDash_Slack
 * @subpackage LearnDash_Slack/core/admin/settings-tabs
 */

defined( 'ABSPATH' ) || die();

final class LearnDash_Slack_Legacy_Settings_Tabs {

	/**
	 * LearnDash_Slack_Legacy_Settings_Tabs constructor.
	 * 
	 * @since		1.0.0
	 */
	function __construct() {
			
		// Creates a Settings Tab at an Index we'll hope no one overrides
		add_filter( 'learndash_admin_tabs', array( $this, 'add_settings_tab' ) );

		// Add our Settings Tab to a "Tab Group" within a Settings Page
		add_filter( 'learndash_admin_tabs_on_page', array( $this, 'add_tab_to_page' ), 10, 3 );
			
		// Fakes the Current Menu Item
		add_filter( 'parent_file', array( $this, 'fix_parent_file' ) );

		// Fakes the current Submenu Item
		add_filter( 'submenu_file', array( $this, 'fix_submenu_file' ), 10, 2 );

	}
	
	/**
	 * Create a Custom Settings Tab
	 * 
	 * @param		array $admin_tabs LearnDash Admin Tabs Array
	 *													 
	 * @access		public
	 * @since		1.0.0
	 * @return		array Modified Array
	 */
	public function add_settings_tab( $admin_tabs ) {
		
		$admin_tabs[7331] = array(
			'link'	=> 'options-general.php?page=learndash_slack',
			'name'	=> _x( 'Slack', 'Slack Tab Label', 'learndash-slack' ),
			'id'	=> 'settings_page_learndash_slack',
			'menu_link'	=> 'edit.php?post_type=sfwd-courses&page=sfwd-lms_sfwd_lms.php_post_type_sfwd-courses',
		);
		
		return $admin_tabs;
		
	}
	
	/**
	 * Add our Custom Settings Tab to each Settings Page that should show it
	 * 
	 * @param		array $admin_tabs_on_page	LearnDash Admin Tabs on Page Array
	 * @param		array $admin_tabs			LearnDash Admin Tabs Array
	 * @param		string $current_page_id		Current Page ID
	 *
	 * @access		public
	 * @since		1.0.0
	 * @return		array Modified Array
	 */
	public function add_tab_to_page( $admin_tabs_on_page, $admin_tabs, $current_page_id ) {
		
		// Add the Slack Tab to the main Settings Admin Tab Group
		// admin_page_learndash_support is the primary Settings Tab, so we'll grab Indexes from there
		foreach( $admin_tabs_on_page['admin_page_learndash_support'] as $index ) {
			
			// Page ID of the current Index
			$page_id = $admin_tabs[ $index ]['id'];
			
			// Add our Index to its Admin Tabs Array
			$admin_tabs_on_page[ $page_id ][] = 7331;
			
		}
		
		// Give the Slack Tab its own copy of the main Settings Admin Tab Group
		$admin_tabs_on_page['settings_page_learndash_slack'] = $admin_tabs_on_page['admin_page_learndash_custom_label'];
		
		return $admin_tabs_on_page;
		
	}
	
	/**
	 * Fakes the Current Menu Item
	 * 
	 * @param		string $parent_file Parent Menu Item
	 *														
	 * @access		public
	 * @since		1.0.0
	 * @return		string Modified String
	 */
	public function fix_parent_file( $parent_file ) {
	
		global $current_screen;
		global $self;

		if ( $current_screen->base == 'settings_page_learndash_slack' ) {

			// Render this as the Active Page Menu
			$parent_file = 'edit.php?post_type=sfwd-courses';

			// Ensure the top-level "Settings" doesn't show as active
			$self = 'edit.php?post_type=sfwd-courses';

		}

		return $parent_file;

	}
	
	/**
	 * Fakes the current Submenu Item
	 * 
	 * @param		string $submenu_file Current Menu Item
	 * @param		string $parent_file  Parent Menu Item
	 *
	 * @access		public
	 * @since		1.0.0
	 * @return		string Modified String
	 */
	public function fix_submenu_file( $submenu_file, $parent_file ) {

		global $current_screen;

		if ( $current_screen->base == 'settings_page_learndash_slack' ) {

			$submenu_file = 'edit.php?post_type=sfwd-courses&page=sfwd-lms_sfwd_lms.php_post_type_sfwd-courses';

		}

		return $submenu_file;

	}

}

$instance = new LearnDash_Slack_Legacy_Settings_Tabs();