<?php
/**
 * Shows user subscription status when subscribed.
 *
 * @since 1.1.0
 *
 * @var array $subscriber
 */

defined( 'ABSPATH' ) || die();
?>

<div class="ld-convertkit-user-subscription-status">

    <table class="form-table">
        <tr>
            <th>
				<?php _e( 'LearnDash ConvertKit Subscription', 'learndash-convertkit' ); ?>
            </th>

            <td>
                <span class="ld-convertkit-subscription-status ld-convertkit-subscription-status-subscribed">
                    <?php _e( 'Subscribed', 'learndash-convertkit' ); ?>
                </span>

                <table class="ld-convertkit-subscription-details">
                    <tr>
                        <th>
							<?php _e( 'Subscriber ID:', 'learndash-convertkit' ); ?>
                        </th>
                        <td>
							<?php echo esc_html( $subscriber['id'] ); ?>
                        </td>
                    </tr>
                    <tr>
                        <th>
							<?php _e( 'Created At:', 'learndash-convertkit' ); ?>
                        </th>
                        <td>
							<?php
							echo date(
								get_option( 'date_format', 'm/d/Y' ) . ' ' . get_option( 'time_format', 'h:i:s A' ),
								strtotime( $subscriber['created_at'] ) );
							?>
                        </td>
                    </tr>
                    <tr>
                        <th>
							<?php _e( 'Status:', 'learndash-convertkit' ); ?>
                        </th>
                        <td>
							<?php echo esc_html( $subscriber['state'] ); ?>
                        </td>
                    </tr>
                    <tr>
                        <th>
							<?php _e( 'View Subscriber:', 'learndash-convertkit' ); ?>
                        </th>
                        <td>
                            <a href="https://app.convertkit.com/subscribers/<?php echo esc_attr( $subscriber['id'] ); ?>"
                               target="_blank">
								<?php _e( 'View', 'learndash-convertkit' ); ?>
                            </a>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

</div>