<?php
/**
 * Share Course Metabox Template
 *
 * @since 3.2.0
 */
?>
<?php if ($course->post_author == get_current_user_id() || current_user_can('manage_options')) :?>
    <div class="ir-share-course-metabox-div">
        <p><?php _e('Select the list of instructors you wish to share this course with', 'wdm_instructor_role')?></p>
        <select name="shared_instructors[]" id="ir-shared-instructors" style="width: 100%;" multiple>
            <?php foreach($all_instructors as $instructor) : ?>
                <option
                    value="<?php echo $instructor->ID; ?>"
                    data-avatar="<?php echo get_avatar_url($instructor->ID, array('size' => 32)); ?>"
                    <?php echo in_array($instructor->ID, $shared_instructor_ids)? 'selected' : ''; ?>>
                    <?php echo $instructor->display_name; ?>
                </option>
            <?php endforeach ?>
        </select>
    </div>
<?php else :?>
    <div class="ir-course-shared-message">
        <?php _e(
            apply_filters(
                'ir_filter_share_course_restriction_message',
                sprintf('<p>Sorry, but you cannot share this course with anyone.</p><p>Contact <b>%s</b>, the author of this course.</p>', get_the_author_meta('display_name', $course->post_author)),
                $course
            )
        ); ?>
    </div>
<?php endif; ?>