<?php
/* Available Variables
 *
 * $user_id;
 * $course_progress;
 * $courses_registered;
 * $quizzes;
 *
 * */
$user_id            = get_current_user_id();
$course_progress    = learndash_course_progress( array(
	'course_id' => 0,
	'user_id'   => $user_id,
	'array'     => true,
) );
$courses_registered = learndash_user_get_enrolled_courses( $user_id, array(), true );
$quizzes            = [];
?>
	<div id='ld_course_info'>
		<!-- Course info shortcode -->
		<?php if ( 1 === 1 ) { ?>
			<?php if ( $courses_registered ) : ?>
				<div id='ld_course_info_mycourses_list'>
					<h4><?php echo sprintf( _x( 'You are registered for the following %s', 'You are registered for the following courses', 'learndash' ), LearnDash_Custom_Label::label_to_lower( 'courses' ) ); ?></h4>
					<?php foreach ( $courses_registered as $c ) : ?>
						<div class='ld-course-info-my-courses'><?php echo get_the_post_thumbnail( $c ); ?>
							<?php echo '<h2 class="ld-entry-title entry-title"><a href="' . get_permalink( $c ) . '"  rel="bookmark">' . get_the_title( $c ) . '</a></h2>'; ?>
						</div>
					<?php endforeach; ?>
					<br/>
				</div>
			<?php endif; ?>
		<?php } ?>

		<?php
		// TODO REMOVE
		if ( is_admin() ) {
			if ( 1 === 1 ) {
				echo do_shortcode( '[ld_user_course_points user_id="' . $user_id . '" context="profile"]' );

				if ( ( learndash_is_admin_user() ) || ( learndash_is_group_leader_user() ) ) {
					?><p>
					<label for="learndash-course-points-user"><strong><?php printf( _x( 'Extra %s points', 'placeholders: Course Label', 'learndash' ), LearnDash_Custom_Label::get_label( 'course' ) ); ?></strong></label>
					<input id="learndash-course-points-user" name="learndash_course_points" type="number" min="0"
						   step="any"
						   value="<?php echo learndash_format_course_points( get_user_meta( $user_id, 'course_points', true ) ) ?>" /><?php } ?>
				</p>
				<?php
			}
		}
		?>

		<?php /* Course progress */ ?>
		<?php if ( ! empty( $courses_registered ) ) : ?>
			<?php
			global $wpdb;
			/////////////////
			$how_many     = count( $courses_registered );
			$placeholders = array_fill( 0, $how_many, '%d' );
			$format       = implode( ', ', $placeholders );
			/// /////////////////////
			$comma_courses = join( ',', $courses_registered );

			$results_course_details = $wpdb->get_results( $wpdb->prepare( 'SELECT ID, post_title, post_status, post_type FROM ' . $wpdb->posts . ' WHERE ID IN (' . $format . ') ORDER BY menu_order ASC', $courses_registered ) );
			////
			$sql = "SELECT p.ID, pm.meta_value AS course_id, p.post_type, p.post_title, p.menu_order FROM {$wpdb->postmeta} pm
															LEFT JOIN {$wpdb->posts} p
															ON p.ID = pm.post_id
															WHERE p.post_type IN ('sfwd-topic', 'sfwd-lessons')
															AND meta_key = 'course_id'
															AND meta_value IN ($format)
															ORDER BY p.post_type, p.menu_order ASC";
			//echo $wpdb->prepare( $sql, $courses_registered );
			$results_course_steps = $wpdb->get_results( $wpdb->prepare( $sql, $courses_registered ) );

			////
			$results_user_meta = $wpdb->get_results( $wpdb->prepare( "SELECT meta_key, meta_value FROM {$wpdb->usermeta} WHERE user_id = %d", $user_id ) );

			////
			$sql                   = "SELECT pm.post_id AS topic_id, p.post_title, p.post_type, pm.meta_key AS course_meta_key, pm.meta_value AS course_id, pm1.meta_key AS lesson_meta_key, pm1.meta_value as lesson_id
																	FROM {$wpdb->postmeta} pm
																	LEFT JOIN {$wpdb->posts} p
																	ON p.ID = pm.post_id
																	LEFT JOIN {$wpdb->postmeta} pm1
																	ON p.ID = pm1.post_id
																	WHERE pm.meta_key = 'course_id' 
																	AND pm.meta_value IN ($format) 
																	AND p.post_type = 'sfwd-topic' 
																	AND pm1.meta_key LIKE 'lesson_id'
																	ORDER BY p.menu_order ASC
																	LIMIT 0, 9000";
			$results_lesson_topics = $wpdb->get_results( $wpdb->prepare( $sql, $courses_registered ) );

			/////
			$results_quizzes = $wpdb->get_results( $wpdb->prepare( "SELECT pm.post_id AS quiz_id, p.post_title, p.post_type, pm.meta_key AS course_meta_key, pm.meta_value AS course_id, pm1.meta_key AS lesson_meta_key, pm1.meta_value as lesson_id 
															FROM {$wpdb->postmeta} pm 
															LEFT JOIN {$wpdb->posts} p 
															ON p.ID = pm.post_id 
															LEFT JOIN {$wpdb->postmeta} pm1 
															ON p.ID = pm1.post_id 
															WHERE pm.meta_key = 'course_id' AND pm.meta_value IN ($format)
															AND p.post_type = 'sfwd-quiz'
															AND pm1.meta_key LIKE 'lesson_id' 
															ORDER BY p.menu_order ASC LIMIT 0, 9000", $courses_registered ) );

			$course_lesson_topics_combination = array();
			if ( $results_lesson_topics ) {
				foreach ( $results_lesson_topics as $r ) {
					$course_id   = $r->course_id;
					$lesson_id   = $r->lesson_id;
					$topic_id    = $r->topic_id;
					$topic_title = $r->post_title;

					$course_lesson_topics_combination[ $course_id ][ $lesson_id ][ $topic_id ] = array(
						'ID'         => $topic_id,
						'post_title' => $topic_title,
					);
				}
			}

			$quiz_progress       = maybe_unserialize( $results_user_meta[ find_in_user_meta( $results_user_meta, '_sfwd-quizzes' ) ]->meta_value );
			$quiz_progress_array = array();
			if ( $quiz_progress ) {
				foreach ( $quiz_progress as $quiz ) {
					$quiz_progress[ $quiz['quiz'] ][] = $quiz;
				}
			}

			$course_lesson_quizzes = array();
			if ( $results_quizzes ) {
				foreach ( $results_quizzes as $q ) {

					$course_id  = $q->course_id;
					$lesson_id  = $q->lesson_id;
					$quiz_id    = $q->quiz_id;
					$quiz_title = $q->post_title;

					$course_lesson_quizzes[ $course_id ][ $lesson_id ][ $quiz_id ] = array(
						'lesson_id'  => $lesson_id,
						'course_id'  => $course_id,
						'ID'         => $quiz_id,
						'post_title' => $quiz_title,
					);

					if ( isset( $quiz_progress[ $quiz_id ] ) ) {
						$course_lesson_quizzes[ $course_id ][ $lesson_id ][ $quiz_id ]['progress'] = $quiz_progress[ (int) $quiz_id ];
					}
				}
			}

			$master_data = array();
			foreach ( $results_course_details as $details ) {
				$master_data[ $details->ID ] = array(
					'ID'          => $details->ID,
					'post_title'  => $details->post_title,
					'post_status' => $details->post_status,
					'post_type'   => $details->post_type,
				);
				$meta_value                  = 'course_' . $details->ID . '_access_from';
				$course_access_meta_key      = find_in_user_meta( $results_user_meta, $meta_value );

				if ( $course_access_meta_key ) {
					$master_data[ $details->ID ]['access_from'] = learndash_adjust_date_time_display( $results_user_meta[ $course_access_meta_key ]->meta_value );
				}
				$course_completed_meta_key = find_in_user_meta( $results_user_meta, 'course_completed_' . $details->ID );
				if ( $course_completed_meta_key ) {
					$master_data[ $details->ID ]['course_completed'] = learndash_adjust_date_time_display( $results_user_meta[ $course_completed_meta_key ]->meta_value );
				}
			}

			foreach ( $results_course_steps as $details ) {
				if ( key_exists( 'total_steps', $master_data[ $details->course_id ] ) ) {
					if ( 'sfwd-quiz' !== $details->post_type ) {
						$master_data[ $details->course_id ]['total_steps'] = $master_data[ $details->course_id ]['total_steps'] + 1;
					}
				} else {
					$master_data[ $details->course_id ]['total_steps'] = 1;
				}
			}

			$course_progress = maybe_unserialize( $results_user_meta[ find_in_user_meta( $results_user_meta, '_sfwd-course_progress' ) ]->meta_value );
			if ( $course_progress ) {
				foreach ( $courses_registered as $course_id ) {
					if ( key_exists( $course_id, $course_progress ) ) {
						$master_data[ $course_id ]['steps_completed'] = $course_progress[ $course_id ]['completed'];
					} else {
						$master_data[ $course_id ]['steps_completed'] = 0;
					}
				}
			}

			foreach ( $results_course_steps as $details ) {

				if ( 'sfwd-lessons' === $details->post_type ) {
					$master_data[ $details->course_id ]['lessons'][ $details->ID ] = array(
						'ID'         => $details->ID,
						'post_title' => $details->post_title,
					);

					if ( isset( $course_lesson_topics_combination[ $details->course_id ] ) && isset( $course_lesson_topics_combination[ $details->course_id ][ $details->ID ] ) ) {
						$master_data[ $details->course_id ]['lessons'][ $details->ID ]['topics'] = $course_lesson_topics_combination[ $details->course_id ][ $details->ID ];
					}

					if ( isset( $course_lesson_quizzes[ $details->course_id ] ) &&
						 isset( $course_lesson_quizzes[ $details->course_id ][ $details->ID ] ) ) {
						$master_data[ $details->course_id ]['lessons'][ $details->ID ]['quizzes'] = $course_lesson_quizzes[ $details->course_id ][ $details->ID ];
					}
				}
			}
			$master_data['course_progress'] = $course_progress;
			$master_data['user_id']         = $user_id;
			?>
			<?php $learndash_show_user_course_complete = learndash_show_user_course_complete( $user_id ); ?>
			<?php $master_data['learndash_show_user_course_complete'] = $learndash_show_user_course_complete; ?>
			<?php
			$master_data = json_decode( wp_json_encode( $master_data ), false );
			/*$key = 32580;
			echo '<pre>';
			print_r( $master_data->$key );
			echo '</pre>';*/
			//if ( ! get_transient( 'course_navigation_admin_' . $user_id ) ) {
			set_transient( 'course_navigation_admin_' . $user_id, $master_data, 0.075 * HOUR_IN_SECONDS );
			//} else {
			//	$master_data = get_transient( 'course_navigation_admin_' . $user_id );
			//}

			?>
			<div id='course_progress_details'>
				<h4><?php printf( _x( '%s progress details:', 'Course progress details Label', 'learndash' ), LearnDash_Custom_Label::get_label( 'course' ) ); ?></h4>
				<?php
				//TODO GROUP LEADER ONLY
				if ( 1 == 1 || $learndash_show_user_course_complete ) {
					?>
					<input type="hidden" id="user-progress-<?php echo $user_id ?>"
						   name="user_progress[<?php echo $user_id ?>]"
						   value="<?php echo htmlspecialchars( json_encode( array(
							   'course' => array(),
							   'quiz'   => array()
						   ), JSON_FORCE_OBJECT ) ); ?>"/>
					<input type="hidden" name="user_progress-<?php echo $user_id ?>-nonce"
						   value="<?php echo wp_create_nonce( 'user_progress-' . $user_id ) ?>"/>
					<?php
				}


				echo '<pre>';
				var_dump( 'before' );
				echo '</pre>';

				foreach ( $courses_registered as $course_id ) {

					echo '<pre>';
					var_dump( 'after' );
					echo '</pre>';


					?>
					<div class="course-parent"> <span class="learndash-profile-course-title">
					<strong><a href="javascript:;" class="learndash-main-course-click"
							   style="text-decoration: none;"><?php echo $master_data->$course_id->post_title ?></a></strong>
					</span>
					<?php

					$steps_total     = learndash_get_course_steps_count( $master_data->$course_id->ID );
					$steps_completed = learndash_course_get_completed_steps( $user_id, $master_data->$course_id->ID );

					if ( absint( $steps_total ) === absint( $steps_completed ) ) {
						$course_status = 'Completed';
					} elseif ( 0 === absint( $steps_completed ) ) {
						$course_status = 'Not Started';
					} else {
						$course_status = 'In Progress';
					}
					/*echo '<pre>';
					print_r( $master_data->$course_id );
					echo '</pre>';*/


					if ( isset( $course_progress[ $course_id ] ) ) {
						$coursep = $course_progress[ $course_id ];
						if ( key_exists( 'course_completed', $master_data->$course_id ) ) {
							$completed_on = $steps_completed;
						} else {
							$completed_on = '';
						}
						if ( ! empty( $completed_on ) ) {

							$coursep['total']     = $steps_total;
							$coursep['completed'] = $steps_completed;

						} else {
							$coursep['total']     = $steps_total;
							$coursep['completed'] = $steps_completed;

							/*if ( $coursep['completed'] > $coursep['total'] ) {
								$coursep['completed'] = $coursep['total'];
							}*/
						}
					} else {
						$coursep = array();
					}

					?>
					<strong><?php _e( 'Status:', 'learndash' ) ?></strong>
					<span class="leardash-course-status leardash-course-status-<?php echo sanitize_title_with_dashes( $course_status ) ?>"><?php echo $course_status ?></span>
					<?php
					if ( 'Completed' !== $course_status ) {
						echo sprintf( __( ' <strong>Completed:</strong> <i>%d</i> out of <i>%d</i> steps', 'learndash' ), $steps_completed, $steps_total );

						if ( isset( $master_data->$course_id->access_from ) ) {
							$since = $master_data->$course_id->access_from;
							if ( ! empty( $since ) ) {
								echo '<span class="learndash-profile-course-access-label">' . sprintf( __( ' <strong>Since:</strong> %s', 'learndash' ), $since ) . '</span>';
							} else {

							}
						}


					} else {
						$completed_on = $master_data->$course_id->course_completed;
						if ( ! empty( $completed_on ) ) {
							echo '<span class="learndash-profile-course-access-label">' . sprintf( __( ' <strong>Completed on:</strong> %s', 'learndash' ), $completed_on ) . '</span>';
						}
					}

					/*else {
						$since = learndash_user_group_enrolled_to_course_from( $user_id, $course->ID );
						if ( ! empty( $since ) ) {
							echo ' <span class="learndash-profile-course-access-label">' . sprintf( __( 'Since: %s (Group Access)', 'learndash' ), learndash_adjust_date_time_display( $since ) ) . '</span>';
						}
					}*/

					if ( ( learndash_is_admin_user() ) || ( learndash_is_group_leader_user() ) ) {
						$certificateLink = learndash_get_course_certificate_link( $course_id, $user_id );
						if ( ! empty( $certificateLink ) ) { ?>
							<a class="learndash-profile-course-certificate-link" href="<?php echo $certificateLink ?>"
							   target="_blank"><?php echo __( 'Certificate', 'learndash' ); ?></a>--><?php
						}
					}

					echo '<pre>';
					var_dump( "a" );
					echo '</pre>';

					//if ( current_user_can( 'edit_courses', intval( $course_id ) ) ) {
					//$edit_post_link = get_edit_post_link( intval( $course_id ) );
					//$edit_post_link = 'javascript:;';
					?>
					<a href="#" id="learndash-profile-course-details-link-<?php echo $course_id ?>"
					   class="learndash-profile-course-details-link"><?php echo _x( '(Details)', 'Course progress details link', 'learndash' ) ?></a>
					<!--<a class="learndash-profile-edit-course-link" href="<?php /*echo $edit_post_link; */ ?>"><?php /*echo _x( '(edit)', 'profile edit course link label', 'learndash' ) */ ?></a>--><?php
					//}

					// TODO GROUP LEADERS ONLY
					if ( 1 == 1 || $learndash_show_user_course_complete ) {


						if ( isset( $master_data->$course_id->lessons ) ) {
							$lessons = $master_data->$course_id->lessons;
						} else {
							$lessons = [];
						}

						if ( isset( $master_data->$course_id->quizzes ) ) {
							$course_quiz_list = $master_data->$course_id->quizzes;
						} else {
							$course_quiz_list = [];
						}
						if ( isset( $master_data->$course_id->quizzes ) ) {
							$course_topics = $master_data->$course_id->topics;
						} else {
							$course_topics = [];
						}
						echo '<pre>';
						var_dump( 'b' );
						echo '</pre>';


						if ( ( ! empty( $lessons ) ) || ( ! empty( $course_quiz_list ) ) ) {
							echo '<pre>';
							var_dump( 'c' );
							echo '</pre>';
							$user_course_progress                = array();
							$user_course_progress['user_id']     = $user_id;
							$user_course_progress['course_id']   = $course_id;
							$user_course_progress['course_data'] = $coursep;

							if ( __( 'Completed', 'learndash' ) === $course_status ) {
								$course_checked                  = ' checked="checked" ';
								$user_course_progress['checked'] = true;
							} else {
								$course_checked                  = '';
								$user_course_progress['checked'] = false;
							}

							echo '<pre>';
							var_dump( 'pop' );
							var_dump( $course_id );
							var_dump( $course_checked );
							var_dump( $user_course_progress );
							echo '</pre>';
							?>
							<div id="learndash-profile-course-details-container-<?php echo $course_id ?>"
								 class="learndash-profile-course-details-container" style="display:block">
								<input id="learndash-mark-course-complete-<?php echo $course_id ?>"
									   type="checkbox" <?php echo $course_checked; ?>
									   class="learndash-mark-course-complete"
									   data-name="<?php echo htmlspecialchars( json_encode( $user_course_progress, JSON_FORCE_OBJECT ) ) ?>"
									   data-title-checked="<?php echo htmlspecialchars( sprintf( _x( 'Are you sure you want to set all %s, %s and %s complete for this %s?', 'Are you sure you want to set all Lessons, Topics and Quizzes complete for this Course?', 'learndash' ), \LearnDash_Custom_Label::get_label( 'lessons' ), \LearnDash_Custom_Label::get_label( 'topics' ), \LearnDash_Custom_Label::get_label( 'quizzes' ), \LearnDash_Custom_Label::get_label( 'course' ) ), ENT_QUOTES ) ?>"/><label
										for="learndash-mark-course-complete-<?php echo $course_id ?>"><?php echo sprintf( _x( '%s All Complete', 'Course All Complete', 'learndash' ), \LearnDash_Custom_Label::get_label( 'course' ) ) ?></label><br/>
								<?php
								echo '<pre>';
								var_dump( 'd' );
								echo '</pre>';
								/*if ( ! get_transient( 'course_navigation_admin_' . $user_id . '_course_id_' . $course_id ) ) {
									set_transient( 'course_navigation_admin_' . $user_id . '_course_id_' . $course_id, $master_data[ $course_id ], 0.25 * HOUR_IN_SECONDS );
								}*/
								/*include(
								SFWD_LMS::get_template(
									'course_navigation_admin',
									array(
										'course_id' 		=> 	$course_id,
										'course' 			=> 	$course,
										'course_progress' 	=> 	$course_progress,
										'lessons' 			=> 	$lessons,
										'course_quiz_list'	=>	$course_quiz_list,
										'user_id'			=>	$user_id
									),
									null,
									true
								)
								);*/

								$template = 'legacy';
								if ( class_exists( 'LearnDash_Theme_Register' ) ) {
									$template = \LearnDash_Theme_Register::get_active_theme_key();
								}
								echo '<pre>';
								var_dump('_______________');
								var_dump($master_data->$course_id->lessons);
								echo '</pre>';
								$__LESSONS = [];
								foreach($master_data->$course_id->lessons as $lesson){
									$__LESSONS[$course_id]['post'] = $lesson;
								}
								if ( 'legacy' === $template ) {
									include(
									\SFWD_LMS::get_template(
										'course_navigation_admin',
										array(
											'course_id'        => $course_id,
											'course'           => $master_data->$course_id,
											'course_progress'  => $course_progress,
											'lessons'          => $__LESSONS,
											'course_quiz_list' => $course_quiz_list,
											'user_id'          => $user_id
										),
										true,
										true
									)
									);
								} else {
									echo 'NOT NOT';
								}


								?>
							</div>
							<?php
						}
					}

					?><br/></div><?php
				}
				?>
			</div>
			<br>
		<?php endif; ?>


		<?php /* Quizzes */ ?>
		<?php if ( $quizzes ) : ?>
			<div id="quiz_progress_details">
				<?php
				global $learndash_assets_loaded;

				if ( ! isset( $learndash_assets_loaded['scripts']['learndash_template_script_js'] ) ) {

					$filepath = SFWD_LMS::get_template( 'learndash_template_script.js', null, null, true );
					if ( ! empty( $filepath ) ) {
						wp_enqueue_script( 'learndash_template_script_js', learndash_template_url_from_path( $filepath ), array( 'jquery' ), LEARNDASH_SCRIPT_VERSION_TOKEN, true );
						$learndash_assets_loaded['scripts']['learndash_template_script_js'] = __FUNCTION__;

						$data            = array();
						$data['ajaxurl'] = admin_url( 'admin-ajax.php' );
						$data            = array( 'json' => json_encode( $data ) );
						wp_localize_script( 'learndash_template_script_js', 'sfwd_data', $data );
					}
				}
				LD_QuizPro::showModalWindow();
				?>
				<h4><?php echo sprintf( _x( 'You have taken the following %s:', 'You have taken the following quizzes:', 'learndash' ), LearnDash_Custom_Label::label_to_lower( 'quizzes' ) ); ?></h4>

				<?php /* The confirm delete quiz message should not contain HTML. Use \r\n for line breaks */ ?>
				<div id="ld-confirm-quiz-delete-message"
					 style="display:none"><?php echo sprintf( _x( 'Are you sure that you want to remove this %s item?', 'placeholder: Quiz', 'learndash' ), LearnDash_Custom_Label::label_to_lower( 'quiz' ) ) ?></div>

				<?php foreach ( $quizzes as $k => $v ) : ?>
					<?php $quiz = get_post( $v['quiz'] ); ?>
					<?php
					if ( ( ! ( $quiz instanceof WP_Post ) ) || ( 'sfwd-quiz' !== $quiz->post_type ) ) {
						if ( ( isset( $v['pro_quizid'] ) ) && ( ! empty( $v['pro_quizid'] ) ) ) {
							$quiz_post_id = learndash_get_quiz_id_by_pro_quiz_id( intval( $v['pro_quizid'] ) );
							if ( ! empty( $quiz_post_id ) ) {
								$quiz = get_post( $quiz_post_id );
							}
						}
					}

					if ( ( ! ( $quiz instanceof WP_Post ) ) || ( 'sfwd-quiz' !== $quiz->post_type ) ) {
						continue;
					}

					$certificateLink       = '';
					$certificate_threshold = 0;

					if ( ! isset( $v['has_graded'] ) ) {
						$v['has_graded'] = false;
					}

					if ( true === $v['has_graded'] && true === LD_QuizPro::quiz_attempt_has_ungraded_question( $v ) ) {
						$certificateLink       = '';
						$certificate_threshold = 0;
						$passstatus            = 'red';
					} else {
						$c = learndash_certificate_details( $v['quiz'], $user_id );
						if ( ( isset( $c['certificateLink'] ) ) && ( ! empty( $c['certificateLink'] ) ) ) {
							$certificateLink = $c['certificateLink'];
						}

						if ( ( isset( $c['certificate_threshold'] ) ) && ( ! empty( $c['certificate_threshold'] ) ) ) {
							$certificate_threshold = $c['certificate_threshold'];
						}

						$passstatus = isset( $v['pass'] ) ? ( ( 1 === $v['pass'] ) ? 'green' : 'red' ) : '';
					}
					?>

					<?php //$passstatus = isset( $v['pass'] ) ? ( ( $v['pass'] == 1 ) ? 'green' : 'red' ) : ''; ?>
					<?php //$c = learndash_certificate_details( $v['quiz'], $user_id ); ?>
					<?php //$certificateLink = $c['certificateLink']; ?>
					<?php // $certificate_threshold = $c['certificate_threshold']; ?>
					<?php $quiz_title = ! empty( $quiz->post_title ) ? $quiz->post_title : $v['quiz_title']; ?>
					<?php
					$quiz_course_id = 0;
					if ( isset( $v['course'] ) ) {
						$quiz_course_id = intval( $v['course'] );
					} else {
						$quiz_course_id = learndash_get_course_id( $quiz, true );
					}
					?>
					<?php if ( ! empty( $quiz_title ) ) : ?>
						<p>
							<strong><a href="<?php echo get_permalink( $quiz->ID ) ?>"><?php echo $quiz_title ?></a></strong>
							<?php echo isset( $v['percentage'] ) ? " - <span style='color:" . $passstatus . "'>" . $v['percentage'] . "%</span>" : '' ?>
							<?php if ( ( ( $user_id === get_current_user_id() ) || ( learndash_is_admin_user() ) || ( learndash_is_group_leader_user() ) ) && ( ! empty( $certificateLink ) ) ) {
								if ( ( ( isset( $v['pass'] ) ) && ( $v['pass'] === 1 ) )
									 && ( ( isset( $v['percentage'] ) && $v['percentage'] >= $certificate_threshold * 100 ) )
									 || ( ( isset( $v['count'] ) ) && ( intval( $v['count'] ) )
										  && ( isset( $v['score'] ) ) && ( intval( $v['score'] ) )
										  && ( ( intval( $v['score'] ) / intval( $v['count'] ) ) >= $certificate_threshold ) )
								) {
									?> -
									<a
									href='<?php echo add_query_arg( array( 'time' => $v['time'] ), $certificateLink ) ?>'
									target='_blank'><?php echo __( 'Certificate', 'learndash' ); ?></a><?php } ?>
								<?php
							}

							if ( ( $user_id === get_current_user_id() ) || ( learndash_is_admin_user() ) || ( learndash_is_group_leader_user() ) ) {
								if ( ( ! isset( $v['statistic_ref_id'] ) ) || ( empty( $v['statistic_ref_id'] ) ) ) {
									$v['statistic_ref_id'] = learndash_get_quiz_statistics_ref_for_quiz_attempt( $user_id, $v );
								}

								if ( ( isset( $v['statistic_ref_id'] ) ) && ( ! empty( $v['statistic_ref_id'] ) ) ) {
									/**
									 * @since 2.3
									 * See snippet on use of this filter https://bitbucket.org/snippets/learndash/5o78q
									 */
									if ( apply_filters( 'show_user_profile_quiz_statistics',
										get_post_meta( $v['quiz'], '_viewProfileStatistics', true ), $user_id, $v, basename( __FILE__ ) ) ) {
										?>
										<a class="user_statistic"
										   data-statistic_nonce="<?php echo wp_create_nonce( 'statistic_nonce_' . $v['statistic_ref_id'] . '_' . get_current_user_id() . '_' . $user_id ); ?>"
										   data-user_id="<?php echo $user_id ?>"
										   data-quiz_id="<?php echo $v['pro_quizid'] ?>"
										   data-ref_id="<?php echo intval( $v['statistic_ref_id'] ) ?>"
										   href="#"><?php _e( 'Statistics', 'learndash' ); ?></a><?php
									}
								}
							}
							?>
							<?php
							if ( isset( $v['m_edit_by'] ) ) {
								$manual_edit_user = get_user_by( 'id', $v['m_edit_by'] );
								if ( $manual_edit_user instanceof WP_User ) {
									$manual_edit_str = sprintf( __( 'Manual Edit by: %s on %s', 'learndash' ),
										$manual_edit_user->display_name,
										date_i18n( apply_filters( 'learndash_date_time_formats', get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) ), $v['m_edit_time'] + get_option( 'gmt_offset' ) * 3600 ) );

									?>
									<abbr
									title="<?php echo $manual_edit_str ?>"><?php _e( '(m)', 'learndash' ); ?></abbr><?php
								}
							}
							?>
							<?php
							if ( current_user_can( 'wpProQuiz_edit_quiz' ) ) {
								?>
								<a href="<?php echo add_query_arg( 'course_id', $quiz_course_id, get_edit_post_link( $quiz->ID ) ) ?>"><?php echo _x( '(edit)', 'profile edit quiz link label', 'learndash' ) ?></a>
								<?php if ( learndash_show_user_course_complete( $user_id ) ) { ?>
									<<<<<<< HEAD
									<!--<a class="remove-quiz" data-quiz-user-id="<?php /*echo $user_id */ ?>" data-quiz-nonce="<?php /*echo wp_create_nonce( 'remove_quiz_'. $user_id .'_'. $v['quiz'] .'_'. $v['time'] ) */ ?>" href="#" title="<?php /*echo sprintf( _x('remove this %s item', 'placeholder: quiz', 'learndash'), LearnDash_Custom_Label::label_to_lower( 'quiz' ) ) */ ?>"><?php /*echo _x('(remove)', 'profile remove quiz link label', 'learndash') */ ?></a>-->
									=======
									<a class="remove-quiz" data-quiz-user-id="<?php echo $user_id ?>"
									   data-quiz-nonce="<?php echo wp_create_nonce( 'remove_quiz_' . $user_id . '_' . $v['quiz'] . '_' . $v['time'] ) ?>"
									   href="#"
									   title="<?php echo sprintf( _x( 'remove this %s item', 'placeholder: quiz', 'learndash' ), LearnDash_Custom_Label::label_to_lower( 'quiz' ) ) ?>"><?php echo _x( '(remove)', 'profile remove quiz link label', 'learndash' ) ?></a>
									>>>>>>> 94057a4d289f12cd805269b00f855ce729fbc638
									<?php
								}
							}
							?>
							<br/>

							<?php
							if ( ( true === $v['has_graded'] ) && ( isset( $v['graded'] ) ) && ( is_array( $v['graded'] ) ) && ( ! empty( $v['graded'] ) ) ) {
								foreach ( $v['graded'] as $quiz_question_id => $graded ) {

									if ( isset( $graded['post_id'] ) ) {

										$graded_post = get_post( $graded['post_id'] );
										if ( $graded_post instanceof WP_Post ) {

											if ( 'graded' === $graded['status'] ) {
												$graded_color = ' color: green;';
											} else {
												$graded_color = ' color: red;';
											}

											$post_status_object_label = get_post_status_object( $graded['status'] )->label;

											//$post_type_object_label_name = get_post_type_object( $graded_post->post_type )->labels->name;

											echo /* $post_type_object_label_name .': '. */
												get_the_title( $graded['post_id'] ) . ', ' . __( 'Status', 'learndash' ) . ': <span style="' . $graded_color . '">' . $post_status_object_label . '</span>, ' . __( 'Points', 'learndash' ) . ': ' . $graded['points_awarded'];

											if ( current_user_can( 'edit_essays' ) ) {
												echo ' <a target="_blank" href="' . get_edit_post_link( $graded['post_id'] ) . '">' . __( 'edit', 'learndash' ) . '</a>';
											}
											echo ' <a target="_blank" href="' . get_permalink( $graded['post_id'] ) . '">' . __( 'view', 'learndash' ) . '</a>';

											echo ' <a target="_blank" href="' . get_permalink( $graded['post_id'] ) . '#comments">' . __( 'comments', 'learndash' ) . ' ' . get_comments_number( $graded['post_id'] ) . '</a>';
											echo '<br />';
										}
									}
								}
							}
							?>


							<?php if ( isset( $v['rank'] ) && is_numeric( $v['rank'] ) ) : ?>
								<?php echo __( 'Rank: ', 'learndash' ); ?><?php echo $v['rank']; ?>,
							<?php endif; ?>

							<?php echo __( 'Score ', 'learndash' ); ?><?php echo $v['score']; ?> <?php echo __( ' out of ', 'learndash' ); ?> <?php
							if ( ( isset( $v['question_show_count'] ) ) && ( ! empty( $v['question_show_count'] ) ) ) {
								echo $v['question_show_count'];
							} else {
								echo $v['count'];
							} ?> <?php echo __( ' question(s)', 'learndash' ); ?>

							<?php if ( isset( $v['points'] ) && isset( $v['total_points'] ) ) : ?>
								<?php echo __( ' . Points: ', 'learndash' ); ?><?php echo $v['points']; ?>/<?php echo $v['total_points']; ?>
							<?php endif; ?>

							<?php echo __( ' on ', 'learndash' ); ?> <?php echo date_i18n( apply_filters( 'learndash_date_time_formats', get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) ), $v['time'] + get_option( 'gmt_offset' ) * 3600 ) //date_i18n( DATE_RSS, $v['time'] ); ?>

							<?php
							/**
							 * 'course_info_shortcode_after_item' filter
							 *
							 * @todo  filter doesn't make sense, change to action?
							 *
							 * @since 2.1.0
							 */
							?>
							<?php echo apply_filters( 'course_info_shortcode_after_item', '', $quiz, $v, $user_id ); ?>
						</p>
					<?php endif; ?>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>

	</div>
<?php
/**
 * @param $user_meta
 * @param $value
 *
 * @return bool|int|string
 */
function find_in_user_meta( $user_meta, $value ) {
	foreach ( $user_meta as $key => $meta ) {
		if ( $meta->meta_key === $value ) {
			return $key;
		}
	}

	return false;
}