<?php

namespace uncanny_learndash_groups;

$atts = $GLOBALS['atts'];
if ( isset( $_GET['registered'] ) ) { ?>
	<div class="registered">
		<h2><?php _e( 'Congratulations! Your registration was successful.', 'uncanny-learndash-groups' ); ?></h2>
	</div>
	<?php
} else {
	$default = array(
		'redirect'      => '',
		'code_optional' => 'no',
		'auto_login'    => 'yes',
		'role'          => 'subscriber',
		'enable_terms'  => 'yes',
	);
	$options = get_option( 'ulgm-custom-registration-atts', $default );
	?>

	<form id="ulgm_registration_form" class="uncanny-learndash-groups uo-groups-registration" action="" method="POST">
		<fieldset>
			<table class="table table-form form-table clr">
				<tr>
					<td class="label"><label
								for="ulgm_user_first"><?php esc_html_e( 'First Name', 'uncanny-learndash-groups' ); ?></label>
					</td>
					<td class="input"><input name="ulgm_user_first"
                                             id="ulgm_user_first"
                                             placeholder="<?php esc_html_e( 'First Name', 'uncanny-learndash-groups' ); ?>"
                                             required="required"
                                             value="<?php if ( isset( $_POST['ulgm_user_first'] ) ) {
						                         echo $_POST['ulgm_user_first'];
					                         } ?>"
							                 type="text"/></td>
				</tr>
				<tr>
					<td class="label"><label
								for="ulgm_user_last"><?php esc_html_e( 'Last Name', 'uncanny-learndash-groups' ); ?></label>
					</td>
					<td class="input"><input name="ulgm_user_last"
                                             id="ulgm_user_last"
                                             required="required"
                                             placeholder="<?php esc_html_e( 'Last Name', 'uncanny-learndash-groups' ); ?>"
                                             value="<?php if ( isset( $_POST['ulgm_user_last'] ) ) {
						                         echo $_POST['ulgm_user_last'];
					                         } ?>"
							                 type="text"/></td>
				</tr>
				<tr>
					<td class="label"><label
								for="ulgm_user_email"><?php esc_html_e( 'Email / Username', 'uncanny-learndash-groups' ); ?></label>
					</td>
					<td class="input"><input name="ulgm_user_email"
                                             id="ulgm_user_email"
                                             required="required"
                                             placeholder="<?php esc_html_e( 'Email / Username', 'uncanny-learndash-groups' ); ?>"
                                             value="<?php if ( isset( $_POST['ulgm_user_email'] ) ) {
						                         echo $_POST['ulgm_user_email'];
					                         } ?>"
							                 class="required" type="email"/></td>
				</tr>
				<tr>
					<td class="label"><label
								for="password"><?php esc_html_e( 'Password', 'uncanny-learndash-groups' ); ?></label>
					</td>
					<td class="input"><input name="ulgm_user_pass" id="password"
                                             required="required"
                                             minlength="6"
                                             class="required"
                                             placeholder="<?php esc_html_e( 'Password', 'uncanny-learndash-groups' ); ?>"
							                 type="password"/></td>
				</tr>
				<tr>
					<td class="label"><label
								for="password_again"><?php esc_html_e( 'Confirm Password', 'uncanny-learndash-groups' ); ?></label>
					</td>
					<td class="input"><input name="ulgm_user_pass_confirm" id="password_again"
                                             required="required"
                                             minlength="6"
                                             oninput="check(this)"
                                             class="required"
                                             placeholder="<?php esc_html_e( 'Confirm Password', 'uncanny-learndash-groups' ); ?>"
							                 type="password"/></td>
				</tr>
				<tr>
					<td class="label"><label
								for="code_registration"><?php esc_html_e( 'Enrollment Key', 'uncanny-learndash-groups' ); ?></label>
					</td>
					<td class="input"><input name="ulgm_code_registration" id="code_registration"
					                         <?php if ( 'no' === $options['code_optional'] ){ ?>required="required"
                                             class="required"<?php } ?>
                                             value="<?php if ( isset( $_POST['ulgm_code_registration'] ) ) {
						                         echo $_POST['ulgm_code_registration'];
					                         } ?>"
                                             placeholder="<?php esc_html_e( 'Enrollment Key', 'uncanny-learndash-groups' ); ?>"
							                 type="text"/></td>
				</tr>
				<?php
				if ( ! empty( SharedVariables::ulgm_term_condition() ) && 'yes' === $options['enable_terms'] ) {
					?>
					<tr>
						<td class="label"><label
									for="terms_conditions"><?php esc_html_e( 'Terms & Conditions', 'uncanny-learndash-groups' ); ?></label>
						</td>
						<td class="input"><input name="ulgm_terms_conditions" id="terms_conditions"
						                         required="required"
						                         class="required"
						                         value="<?php if ( isset( $_POST['ulgm_terms_conditions'] ) ) {
							                         echo $_POST['ulgm_terms_conditions'];
						                         } ?>"
						                         type="checkbox"/><?php echo SharedVariables::ulgm_term_condition(); ?>
						</td>
					</tr>
				<?php } ?>
				<tr>
					<td class="input"><input type="submit" class="btn btn-default"
					                         value="<?php esc_html_e( 'Register Your Account' ); ?>"/>
						<input type="hidden" name="_ulgm_nonce"
						       value="<?php echo wp_create_nonce( Utilities::get_prefix() ); ?>"/>
						<input type="hidden" name="redirect_to"
						       value="<?php echo $atts['redirect'];
						       ?>"/>
						<input type="hidden" name="key"
						       value="<?php echo crypt( get_the_ID(), 'uncanny-learndash-groups' ); ?>"/>
					</td>
				</tr>
			</table>
		</fieldset>
	</form>
	<script language='javascript' type='text/javascript'>
      function check (input) {
        if (input.value != document.getElementById('password').value) {
          input.setCustomValidity('<?php _e( 'Password Must be Matching.', 'uncanny-learndash-groups' ) ?>')
        } else {
          // input is valid -- reset the error message
          input.setCustomValidity('')
        }
      }
	</script>
	<?php
} ?>