<?php
/**
 * Storyline Controller
 *
 * @package    Tin Canny LearnDash Reporting
 * @subpackage Embed Articulate Storyline and Adobe Captivate
 * @author     Uncanny Owl
 * @since      1.0.0
 */

namespace TINCANNYSNC\FileSystem\Module;

if ( !defined( 'UO_ABS_PATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

class Presenter360 extends \TINCANNYSNC\FileSystem\absModule {
	/**
	 * Constructor
	 *
	 * @access public
	 * @return void
	 * @since  1.0.0
	 */
	public function __construct( $item_id ) {
		parent::__construct( $item_id );
		$this->set_type( 'Presenter360' );
	}

	protected function get_registering_url() {
		return $this->get_target_url() . '/presentation.html';
	}
	protected function add_tincan_support() {
		$this->add_nonce_block_code();
	}

	public function add_nonce_block_code() {
		$target = $this->get_target_dir();
/*
		$target = explode( '/wp-content/uploads', $target );
		$entry = $target[0] . $this->get_url();

		$is_html = substr( $entry, (- strlen( '.html' ) ) ) === '.html' || substr( $entry, (- strlen( '.html5' ) ) ) === '.html5';

		if ( file_exists( $entry ) && $is_html ) {
			$contents = file_get_contents( $entry );
			$contents = $contents . '<script>' . self::NONCE_BLOCK . '</script>';

			file_put_contents( $entry, $contents );
		}
	}
*/
		$scormdriver = $target . '/presentation.html';
		if ( file_exists( $scormdriver ) ) {
			$contents = file_get_contents( $scormdriver );
			$contents = str_replace( '<head>', '<head><script>' . self::NONCE_BLOCK . '</script>', $contents );
			file_put_contents( $scormdriver, $contents );
		}

	}
}
