<?php
/**
 * Post Edit Screen additions for LearnDash ConvertKit
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || die();

/**
 * Class LD_ConvertKit_PostEditCourse
 *
 * Post Edit Screen additions for LearnDash ConvertKit
 *
 * @since 1.0.0
 */
class LD_ConvertKit_PostEditCourse {

	/**
	 * LD_ConvertKit_PostEditCourse constructor.
	 *
	 * @since 1.0.0
	 */
	function __construct() {

		add_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
		add_action( 'post_updated', array( $this, 'sync_course_tag' ), 10, 3 );
		add_action( 'wp_ajax_ld_convertkit_get_tag_data', array( $this, 'ajax_get_tag_data' ) );
	}

	/**
	 * Add the Metabox to the Course Edit Page
	 *
	 * @since 1.0.0
	 */
	public function add_meta_boxes() {

		add_meta_box(
			'ld_convertkit_course_metabox',
			__( 'ConvertKit', 'learndash-convertkit' ),
			array( $this, 'course_metabox_content' ),
			'sfwd-courses',
			'side'
		);

		add_meta_box(
			'ld_convertkit_tag_meta',
			__( 'ConvertKit Tag', 'learndash-convertkit' ),
			array( $this, 'tag_meta_metabox_content' ),
			array( 'sfwd-lessons', 'sfwd-topic', 'sfwd-quiz' ),
			'side'
		);
	}

	/**
	 * Metabox content for Course.
	 *
	 * @since 1.0.0
	 * @access private
	 */
	function course_metabox_content() {

	    if ( ld_convertkit_get_option_field( 'auto_subscribe' ) !== '1' ) {

		    ld_convertkit_do_field_toggle( array(
			    'name'            => 'disable_subscription_form',
			    'group'           => 'course_options',
			    'label'           => __( 'Show Subscribe Form', 'learndash-convertkit' ),
			    'unchecked_value' => '1',
			    'checked_value'   => '0',
			    'default'         => '0',
		    ) );
        }

		$this->display_tag_info();

		ld_convertkit_init_field_group( 'course_options' );
	}

	/**
	 * Metabox content for Tag Meta.
	 *
	 * @since 1.0.0
	 * @access private
	 */
	function tag_meta_metabox_content() {

		$this->display_tag_info();
	}

	/**
	 * Displays tag info for the current resource.
	 *
	 * @since 1.0.0
	 * @access private
	 */
	private function display_tag_info() {

		$tag_id = ld_convertkit_get_resource_tag( get_the_ID(), true );

		if ( $tag_id !== 0 ) : ?>
            <div id="ld-convertkit-tag-info" data-tag-id="<?php echo $tag_id; ?>">
                <h3>
                    <?php _e( 'Tag Info', 'learndash-convertkit' ); ?>
                </h3>

                <table>
                    <tr>
                        <th>
							<?php _e( 'Name: ', 'learndash-convertkit' ); ?>
                        </th>
                        <td class="ld-convertkit-tag-info-name">
                            <span class="spinner is-active"></span>
                        </td>
                    </tr>
                    <tr>
                        <th>
							<?php _e( 'ID: ', 'learndash-convertkit' ); ?>
                        </th>
                        <td class="ld-convertkit-tag-info-id">
                            <span class="spinner is-active"></span>
                        </td>
                    </tr>
                    <tr>
                        <th>
							<?php _e( 'Created At: ', 'learndash-convertkit' ); ?>
                        </th>
                        <td class="ld-convertkit-tag-info-created-date">
                            <span class="spinner is-active"></span>
                        </td>
                    </tr>
                    <tr>
                        <th>
							<?php _e( 'Link: ', 'learndash-convertkit' ); ?>
                        </th>
                        <td class="ld-convertkit-tag-info-link">
                            <span class="spinner is-active"></span>
                        </td>
                    </tr>
                </table>
            </div>

		<?php else : ?>

            <p>
				<?php _e( 'No Tag Created', 'learndash-convertkit' ); ?>
            </p>

		<?php endif;
	}

	/**
	 * Add Course Tag to ConvertKit if it does not yet exist.
	 *
	 * @since 1.0.0
	 *
	 * @param integer $post_id WP_Post ID
	 * @param object $post_after WP_Post Object after changes
	 * @param object $post_before WP_Post Object before changes
	 */
	function sync_course_tag( $post_id, $post_after, $post_before ) {

		if ( get_post_type( $post_id ) !== 'sfwd-courses' ) {

			return;
		}

		ld_convertkit_ensure_resource_tag( $post_id );
	}

	/**
	 * Ajax callback for getting tag data.
	 *
	 * @since 1.0.0
	 * @access private
	 */
	function ajax_get_tag_data() {

		if ( ! LD_ConvertKit_API() ) {

			wp_send_json_error( array(
				'message' => __( 'Could not get tag data.', 'learndash-convertkit' ),
			) );
		}

		$tag_id = $_REQUEST['tag_id'];

		$tag_data = LD_ConvertKit_API()->get_tag( $tag_id );

		if ( $tag_data === 0 ) {

			wp_send_json_error( array(
				'message' => __( 'Could not get tag data.', 'learndash-convertkit' ),
			) );

		} else {

			wp_send_json_success( $tag_data );
		}
	}
}