<?php

namespace Uncanny_Automator_Pro;

/**
 * Class LD_USERENROLLEDCOURSE
 * @package Uncanny_Automator_Pro
 */
class LD_USERENROLLEDCOURSE {
	
	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LD';
	
	private $trigger_code;
	private $trigger_meta;
	
	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'LD_USERENROLLEDCOURSE';
		$this->trigger_meta = 'LDCOURSE';
		$this->define_trigger();
	}
	
	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Topics 2:Number of times*///User submits
			'sentence'            => sprintf( __( 'User is enrolled in {{a course:%1$s}}', 'uncanny-automator' ), $this->trigger_meta ),
			'select_option_name'  => __( 'User is enrolled in {{a course}}', 'uncanny-automator' ),
			'action'              => 'learndash_update_course_access',
			'priority'            => 10,
			'accepted_args'       => 4,
			'validation_function' => array( $this, 'update_course_access' ),
			'options'             => [
				$uncanny_automator->options->all_ld_courses( NULL, $this->trigger_meta ),
			],
		);

		$uncanny_automator->register_trigger( $trigger );
		
		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_id
	 * @param $course_id
	 * @param $access_list
	 * @param $remove
	 */
	public function update_course_access( $user_id, $course_id, $access_list, $remove ) {

		if ( ! empty( $remove ) ) {
			return;
		}

		global $uncanny_automator;

		$args = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => $course_id,
			'user_id' => $user_id,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}
}
