<?php

namespace Uncanny_Automator_Pro;


/**
 * Class H5P_CONTENTTYPECOMPLETED
 * @package Uncanny_Automator_Pro
 */
class H5P_CONTENTTYPECOMPLETED {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'H5P';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * SetAutomatorTriggers constructor.
	 */
	public function __construct() {
		$this->trigger_code        = 'H5PCONTENTTYPECOMPLETED';
		$this->trigger_meta        = 'H5P_CONTENTTYPE';
		$this->define_trigger();
	}

	/**
	 *
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'sentence'            => sprintf( __( 'User completes any H5P content of {{a specific type:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User completes any H5P content of {{a specific type}}', 'uncanny-automator' ),
			'action'              => 'h5p_alter_user_result',
			'priority'                    => 20,
			'accepted_args'               => 4,
			'validation_function' => array( $this, 'h5p_content_type_completed' ),
			'options'                     => [
				$uncanny_automator->options->all_h5p_content_types(),
				$uncanny_automator->options->number_of_times(),
			]
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
        * @param object    &$data      Has the following properties score,max_score,opened,finished,time
        * @param int       $result_id  Only set if updating result
        * @param int       $content_id Identifier of the H5P Content
        * @param int       $user_id    Identifier of the User
        */
	public function h5p_content_type_completed( $data, $result_id, $content_id, $user_id ) {
		if( ! $user_id ) {
                    $user_id = get_current_user_id();
                }
		if ( empty ( $user_id ) ) {
			return;
		}                
                
		global $uncanny_automator;
                global $wpdb;
                
                // Get the library content type
                $content_type_id = $wpdb->get_col( $wpdb->prepare(
                    "SELECT l.id
                    FROM {$wpdb->prefix}h5p_contents c
                    JOIN {$wpdb->prefix}h5p_libraries l ON l.id = c.library_id
                    WHERE c.id = %d",
                    $content_id
                ) );
                
		$args = [
			'code' => $this->trigger_code,
			'meta' => $this->trigger_meta,
			'post_id'      => intval($content_type_id[0]),
			'user_id'      => $user_id,
		];
                
		$uncanny_automator->maybe_add_trigger_entry( $args );
	}
}