<?php

namespace Uncanny_Automator_Pro;

/**
 * Class GF_MATCH_FIELD_VALUE
 * @package Uncanny_Automator_Pro
 */
class GF_SUBFIELD {
	
	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'GF';
	
	private $trigger_code;
	private $trigger_meta;
	
	/**
	 * SetAutomatorTriggers constructor.
	 */
	public function __construct() {
		$this->trigger_code        = 'SUBFIELD';
		$this->trigger_meta        = 'GFFORMS';
		$this->define_trigger();
		
		add_action( 'wp_ajax_select_form_fields_GFFORMS', array( $this, 'select_form_fields_func' ) );
	}
	
	/**
	 *
	 */
	public function define_trigger() {
		
		global $uncanny_automator;
		
		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'sentence'            => sprintf( __( 'User submits {{a form:%1$s}} with {{a specific value:%2$s}} in {{a specific field:%3$s}}', 'uncanny-automator' ), $this->trigger_meta, 'SUBVALUE', $this->trigger_code ),
			'select_option_name'  => __( 'User submits {{a form}} with {{a specific value}} in {{a specific field}}', 'uncanny-automator' ),
			'action'              => 'gform_after_submission',
			'priority'            => 20,
			'accepted_args'       => 2,
			'validation_function' => array( $this, 'gform_submit' ),
			'options'             => [],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->list_gravity_forms( null, $this->trigger_meta, [
						'token'        => false,
						'is_ajax'      => true,
						'target_field' => $this->trigger_code,
						'endpoint'     => 'select_form_fields_GFFORMS',
					] ),
					$uncanny_automator->options->select_field( $this->trigger_code, __( 'Select a field', 'uncanny-automator' ) ),
					$uncanny_automator->options->text_field( 'SUBVALUE' ),
				],
			],
		);
		
		$uncanny_automator->register_trigger( $trigger );
		
		return;
	}
	
	/**
	 * @param $entry
	 * @param $form
	 */
	public function gform_submit( $entry, $form ) {
		global $uncanny_automator;
		$recipes = $uncanny_automator->get->recipes_from_trigger_code( $this->trigger_code );
		
		if ( empty( $entry ) ) {
			return;
		}
		
		$conditions = $this->match_condition( $entry, $recipes, $this->trigger_meta, $this->trigger_code, 'SUBVALUE', $form );
		
		if ( ! $conditions ) {
			return;
		}
		
		$user_id = get_current_user_id();
		if ( ! empty( $conditions ) ) {
			foreach ( $conditions['recipe_ids'] as $recipe_id ) {
				if ( ! $uncanny_automator->is_recipe_completed( $recipe_id, $user_id ) ) {
					$args = [
						'code'            => $this->trigger_code,
						'meta'            => $this->trigger_meta,
						'recipe_to_match' => $recipe_id,
						'ignore_post_id'  => true,
						'user_id'         => $user_id,
					];
					
					$uncanny_automator->maybe_add_trigger_entry( $args );
				}
			}
		}
	}
	
	
	/**
	 *
	 *
	 *
	 * @param $entry
	 * @param null $recipes
	 * @param null $trigger_meta
	 * @param null $trigger_code
	 * @param null $trigger_second_code
	 *
	 * @return array|bool
	 */
	public function match_condition( $entry, $recipes = null, $trigger_meta = null, $trigger_code = null, $trigger_second_code = null, $form ) {
		if ( null === $recipes ) {
			return false;
		}
		
		$matches        = [];
		$recipe_ids     = [];
		$entry_to_match = $entry['form_id'];
		foreach ( $recipes as $recipe ) {
			foreach ( $recipe['triggers'] as $trigger ) {
				if ( key_exists( $trigger_meta, $trigger['meta'] ) && $trigger['meta'][ $trigger_meta ] === $entry_to_match ) {
					$matches[ $recipe['ID'] ]    = [
						'field' => $trigger['meta'][ $trigger_code ],
						'value' => $trigger['meta'][ $trigger_second_code ],
					];
					$recipe_ids[ $recipe['ID'] ] = $recipe['ID'];
					break;
				}
			}
		}
		
		if ( ! empty( $matches ) ) {
			foreach ( $matches as $recipe_id => $match ) {
				// check form field type
				// Passing the form object with the field id.
				$gf_field = \GFAPI::get_field( $form, $match['field'] );
				if ( 'multiselect' === $gf_field->type ) {
					// convert string to array.
					$user_submission = json_decode( $entry[ $match['field'] ], true );
					$trigger_match   = explode( ',', $match['value'] );
					if ( count( $trigger_match ) !== count( $user_submission ) ) {
						unset( $recipe_ids[ $recipe_id ] );
					} elseif ( ! empty( array_diff( $trigger_match, $user_submission ) ) ) {
						unset( $recipe_ids[ $recipe_id ] );
					}
				} else {
					if ( $entry[ $match['field'] ] !== $match['value'] ) {
						unset( $recipe_ids[ $recipe_id ] );
					}
				}
			}
		}

		if ( ! empty( $recipe_ids ) ) {
			return [ 'recipe_ids' => $recipe_ids, 'result' => true ];
		}

		return false;
	}
	
	
	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_form_fields_func() {
		
		global $uncanny_automator;
		
		$uncanny_automator->utilities->ajax_auth_check( $_POST );
		
		$fields = [];
		if ( isset( $_POST ) ) {
			$form_id     = $_POST['value'];
			$integration = $_POST['integration'];
			$form        = \RGFormsModel::get_form_meta( $form_id );
			
			if ( is_array( $form['fields'] ) ) {
				foreach ( $form['fields'] as $field ) {
					if ( isset( $field['inputs'] ) && is_array( $field['inputs'] ) ) {
						foreach ( $field['inputs'] as $input ) {
							$fields[] = array(
								'value' => $input['id'],
								'text'  => $input['id'] . ' - ' . \GFCommon::get_label( $field, $input['id'] ),
							);
						}
					} else if ( ! rgar( $field, 'displayOnly' ) ) {
						$fields[] = array(
							'value' => $field['id'],
							'text'  => $field['id'] . ' - ' . \GFCommon::get_label( $field ),
						);
					}
				}
			}
		}
		echo wp_json_encode( $fields );
		die();
	}
}