<?php

namespace uncanny_automator;
/**
 * Class GEN_USERROLE
 * @package uncanny_automator
 */
class WP_SENDEMAIL {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WP';

	private $action_code;
	private $action_meta;
	private $key_generated;
	private $key;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code   = 'SENDEMAIL';
		$this->action_meta   = 'EMAILTO';
		$this->key_generated = false;
		$this->key           = null;
		$this->define_action();
	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;

		$action = array(
			'author'             => $uncanny_automator->get_author_name( $this->action_code ),
			'support_link'       => $uncanny_automator->get_author_support_link( $this->action_code ),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Email Address*/
			'sentence'           => sprintf( __( 'Send an email to {{email address:%1$s}}', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Send an {{email}}', 'uncanny-automator' ),
			'priority'           => 10,
			'accepted_args'      => 1,
			'execution_function' => array( $this, 'send_email' ),
			// very last call in WP, we need to make sure they viewed the page and didn't skip before is was fully viewable
			'options_group'      => [
				$this->action_meta => [
					$uncanny_automator->options->text_field( 'EMAILFROM', __( 'From:', 'uncanny-automator' ), true, 'email', '{{admin_email}}' ),
					$uncanny_automator->options->text_field( 'EMAILTO', __( 'To:', 'uncanny-automator' ), true, 'email', '{{user_email}}', true, __( 'Separate multiple email addresses with a comma', 'uncanny-automator' ) ),
					$uncanny_automator->options->text_field( 'EMAILCC', __( 'CC:', 'uncanny-automator' ), true, 'email', '', false ),
					$uncanny_automator->options->text_field( 'EMAILBCC', __( 'BCC:', 'uncanny-automator' ), true, 'email', '', false ),
					$uncanny_automator->options->text_field( 'EMAILSUBJECT', __( 'Subject:', 'uncanny-automator' ), true ),
					$uncanny_automator->options->text_field( 'EMAILBODY', __( 'Body:', 'uncanny-automator' ), true, 'textarea' ),
				],
			],
		);

		$uncanny_automator->register_action( $action );
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 * @param $args
	 */
	public function send_email( $user_id, $action_data, $recipe_id, $args ) {

		global $uncanny_automator;
		$to         = $uncanny_automator->parse->text( $action_data['meta']['EMAILTO'], $recipe_id, $user_id, $args );
		$from       = $uncanny_automator->parse->text( $action_data['meta']['EMAILFROM'], $recipe_id, $user_id, $args );
		$cc         = $uncanny_automator->parse->text( $action_data['meta']['EMAILCC'], $recipe_id, $user_id, $args );
		$bcc        = $uncanny_automator->parse->text( $action_data['meta']['EMAILBCC'], $recipe_id, $user_id, $args );
		$subject    = $uncanny_automator->parse->text( $action_data['meta']['EMAILSUBJECT'], $recipe_id, $user_id, $args );
		$body_text  = $action_data['meta']['EMAILBODY'];
		$reset_pass = ! is_null( $this->key ) ? $this->key : $this->generate_reset_token( $user_id );
		$body       = str_replace( '{{reset_pass_link}}', $reset_pass, $body_text );
		$body       = $uncanny_automator->parse->text( $body, $recipe_id, $user_id, $args );

		$headers[] = 'From: <' . $from . '>';

		if ( ! empty( $cc ) ) {
			$headers[] = 'Cc: ' . $cc;
		}

		if ( ! empty( $bcc ) ) {
			$headers[] = 'Bcc: ' . $bcc;
		}

		$headers[] = 'Content-Type: text/html; charset=UTF-8';

		$body = wpautop( $body );

		$mailed = wp_mail( $to, $subject, $body, $headers );

		if ( ! $mailed ) {
			$error_message = $uncanny_automator->error_message->get( 'email-failed' );
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id, $error_message );

			return;
		}

		$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
	}

	/**
	 * @param $user_id
	 *
	 * @return bool|string
	 */
	public function generate_reset_token( $user_id ) {
		if ( ! $this->key_generated ) {
			$user       = get_user_by( 'ID', $user_id );
			$adt_rp_key = get_password_reset_key( $user );
			$user_login = $user->user_login;
			$url        = network_site_url( "wp-login.php?action=rp&key=$adt_rp_key&login=" . rawurlencode( $user_login ), 'login' );
			$text       = __( 'Click here to reset password.', 'uncanny-automator' );
			$rp_link    = sprintf( '<a href="%s">%s</a>', $url, $text );

			$this->key_generated = true;
			$this->key           = $rp_link;

			return $rp_link;
		}

		return false;

	}

}
