<?php

namespace uncanny_automator;

/**
 * Class WPCW_USERENROLLED
 * @package uncanny_automator
 */
class WPCW_USERENROLLED {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WPCW';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'WPCWUSERENROLLED';
		$this->trigger_meta = 'WPCW_ENROLLCOURSE';
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Courses 2:Number of times*/
			'sentence'            => sprintf( __( 'User is enrolled in {{a course:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User is enrolled in {{a course}}', 'uncanny-automator' ),
			'action'              => 'wpcw_enroll_user',
			'priority'            => 20,
			'accepted_args'       => 2,
			'validation_function' => array( $this, 'wpcw_user_enrolled' ),
			'options'             => [
				$uncanny_automator->options->all_wpcw_courses( __( 'Select a course', 'uncanny-automator' ), $this->trigger_meta ),
				$uncanny_automator->options->number_of_times(),
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_id
	 * @param $courses_enrolled   AssociatedParentData
	 */
	public function wpcw_user_enrolled( $user_id, $courses_enrolled ) {

		if ( empty( $user_id ) ) {
			return;
		}

		global $uncanny_automator;

		foreach ( $courses_enrolled as $course_key ) {

			$course_detail = WPCW_courses_getCourseDetails( $course_key );

			$args = [
				'code'    => $this->trigger_code,
				'meta'    => $this->trigger_meta,
				'post_id' => intval( $course_detail->course_post_id ),
				'user_id' => $user_id,
			];

			$uncanny_automator->maybe_add_trigger_entry( $args );
		}
	}
}
