//
//  RedAlert.swift
//  Orbis
//
//  Created by KALSI on 5/26/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import AudioToolbox
import MessageUI


class RedAlert: UIViewController,MFMessageComposeViewControllerDelegate {

    @IBOutlet weak var alertTitle: UILabel!
    @IBOutlet weak var AlertBtn: UIView!
    @IBOutlet weak var cancelBtn: UIView!
    @IBOutlet weak var baseButtonView: UIView!
    @IBOutlet weak var ripple1: UIImageView!
    @IBOutlet weak var ripple2: UIImageView!
    @IBOutlet weak var ripple3: UIImageView!
    
    var Rippler = Timer()
    var RippleBack = Timer()
    var cancelCheck = Bool()
    // MARK: -
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        //Web service

       // self.perform(#selector(hitRedSign), with: nil, afterDelay: 0.3)
        
        //Check if Red alert is active
        
     //   appDelegate.messagePopup = false
        
        }
    
    func hitRedSign()  {
        Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sRedAlertAlarm)

    }
    override func viewDidLoad() {
        super.viewDidLoad()
        
        Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sRedAlertAlarm)
        
        RedAlertRemoteActivation()
        if UserDefaults.standard.bool(forKey: "code_amber"){
            NotificationCenter.default.post(name: NSNotification.Name("stop_amber"), object: nil)
        }
        CallRed()
        

        cancelCheck = false
        UserDefaults.standard.set("RedAlert", forKey: "screen?")
        UserDefaults.standard.synchronize()
        
        self.SetRipplesAlpha(value: 0)
        
        let longCancel = UILongPressGestureRecognizer(target: self, action: #selector(self.DeactivateAlert(_:)))
        longCancel.minimumPressDuration = 1
        cancelBtn.addGestureRecognizer(longCancel)
        
        //Notifications
        NotificationCenter.default.addObserver(self, selector: #selector(self.RedAlertRemoteActivation), name: NSNotification.Name("red_alert"), object: nil)
        
        
           NotificationCenter.default.addObserver(self, selector: #selector(self.stopRedAmber), name: NSNotification.Name("stopRedAmber"), object: nil)
        
        NotificationCenter.default.addObserver(self, selector: #selector(self.RedBegan), name: NSNotification.Name("RedBegan"), object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(self.RedEnded), name: NSNotification.Name("RedEnded"), object: nil)
        
        NotificationCenter.default.addObserver(self, selector: #selector(self.startViberating), name: NSNotification.Name("startViberating"), object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(self.stopViberating), name: NSNotification.Name("stopViberating"), object: nil)
        
        NotificationCenter.default.addObserver(self, selector: #selector(self.CallRed), name: NSNotification.Name("CallRed"), object: nil)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(true)
        appDelegate.blinker.invalidate()
        
        print("Orbis in background")
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
 @objc   func CallRed() {
        print("two times")
//        guard let number = URL(string: "tel://01513432846") else { return }
        guard let number = URL(string: "tel://\(AppConfiguration.sharedInstance.redAlertNo)") else { return }

        UIApplication.shared.open(number)
    }
    override func viewWillLayoutSubviews() {
        baseButtonView.frame = CGRect(x: baseButtonView.frame.origin.x, y: baseButtonView.frame.origin.y, width: baseButtonView.frame.size.width, height: baseButtonView.frame.size.width)
        baseButtonView.layer.cornerRadius = baseButtonView.frame.size.width/2
    }
    
    // MARK: - Functions -
    func BigScale()  {
        self.ripple1.transform = CGAffineTransform(scaleX: 8, y: 8)
        self.ripple2.transform = CGAffineTransform(scaleX: 8, y: 8)
        self.ripple3.transform = CGAffineTransform(scaleX: 8, y: 8)
    }
    func SmallScale() {
        self.ripple1.transform = CGAffineTransform(scaleX: 1.1, y: 1.1)
        self.ripple2.transform = CGAffineTransform(scaleX: 1.1, y: 1.1)
        self.ripple3.transform = CGAffineTransform(scaleX: 1.1, y: 1.1)
    }
    func MakeRipplesVisible() {
        Globals.animations().fadeIn(view: self.ripple1)
        Globals.animations().fadeIn(view: self.ripple2)
        Globals.animations().fadeIn(view: self.ripple3)
    }
    func MakeRipplesInVisible() {
        Globals.animations().fadeOut(view: self.ripple1)
        Globals.animations().fadeOut(view: self.ripple2)
        Globals.animations().fadeOut(view: self.ripple3)
    }
    func SetRipplesAlpha(value : CGFloat) {
        self.ripple1.alpha = value
        self.ripple2.alpha = value
        self.ripple3.alpha = value
    }
    func StartRipples() {
        MakeRipplesVisible()
        UIView.animate(withDuration: 2.5, animations: {
            self.BigScale()
        })
        
        Rippler = Timer.scheduledTimer(withTimeInterval: 2.4, repeats: true, block: { (blinker) in
           
             self.SmallScale()
            self.SetRipplesAlpha(value: 0)
            self.MakeRipplesVisible()
            
            UIView.animate(withDuration: 3.7, animations: {
                self.BigScale()
                self.MakeRipplesInVisible()
            })
            
        })
    }
    
    // MARK: - Gestures -
   @objc func RedAlertRemoteActivation() {
        AudioServicesPlayAlertSound(SystemSoundID(kSystemSoundID_Vibrate))
        self.perform(#selector(self.ViberateAgain), with: nil, afterDelay: 0.8)
        
        NotificationCenter.default.post(name: NSNotification.Name("tabColorShiftRed"), object: nil)
        UserDefaults.standard.set(true, forKey: "code_red")
        UserDefaults.standard.synchronize()
        alertTitle.text = "Press and Hold to deactivate"
        AlertBtn.isHidden = true
        cancelBtn.isHidden = false
        
        
        
        self.StartRipples()
        self.startViberating()
    }
  @objc  func startViberating() {
        if !appDelegate.blinker.isValid{
            appDelegate.blinker = Timer.scheduledTimer(withTimeInterval: 4.2, repeats: true, block: { (blinker) in
                AudioServicesPlayAlertSound(SystemSoundID(kSystemSoundID_Vibrate))
                self.perform(#selector(self.ViberateAgain), with: nil, afterDelay: 0.8)
            })
        }
    }
 @objc   func ViberateAgain() {
        AudioServicesPlayAlertSound(SystemSoundID(kSystemSoundID_Vibrate))
    }
 @objc   func stopViberating() {
        appDelegate.blinker.invalidate()
    }
    
    @IBAction func ActivateRed(_ sender: UILongPressGestureRecognizer) {
        if sender.state == UIGestureRecognizerState.began {
            RedAlertRemoteActivation()
            Globals().addPrompt(message: "Emergency Message and Location sent to ARC", view: self, completion: {  })
        }
    }
    
 @objc   func stopRedAmber(){
//        var x = 0

        
//        RippleBack = Timer.scheduledTimer(withTimeInterval: 1, repeats: true, block: { (timer) in
//            x += 1
//            
//            if x >= 3 {
//                self.RippleBack.invalidate()
                appDelegate.blinker.invalidate()
                UserDefaults.standard.set(false, forKey: "code_red")
                UserDefaults.standard.synchronize()
                self.alertTitle.text = "Press and Hold to activate"
                self.AlertBtn.isHidden = false
                self.cancelBtn.isHidden = true
                NotificationCenter.default.post(name: NSNotification.Name("tabColorShiftReset"), object: nil)
                
                //Web service
                //   let dashboard = self.storyboard?.instantiateViewController(withIdentifier: "Dashboard")
                appDelegate.isRedForAmber = false
                Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sRedAlertUserCancel)
     //       }
       // })

    }
  @objc  func RedBegan() {
        self.SetRipplesAlpha(value: 1)
        if !cancelCheck{
            cancelCheck = true
            var x = 0
            self.Rippler.invalidate()
            UIView.animate(withDuration: 2.5, animations: {
                self.SmallScale()
                self.SetRipplesAlpha(value: 0.3)
            })
            
            RippleBack = Timer.scheduledTimer(withTimeInterval: 1, repeats: true, block: { (timer) in
                x += 1
                
                if x >= 3 {
                    self.RippleBack.invalidate()
                    appDelegate.blinker.invalidate()
                    UserDefaults.standard.set(false, forKey: "code_red")
                    UserDefaults.standard.synchronize()
                    self.alertTitle.text = "Press and Hold to activate"
                    self.AlertBtn.isHidden = false
                    self.cancelBtn.isHidden = true
                    NotificationCenter.default.post(name: NSNotification.Name("tabColorShiftReset"), object: nil)
                    
                    //Web service
                 //   let dashboard = self.storyboard?.instantiateViewController(withIdentifier: "Dashboard")
appDelegate.isRedForAmber = false
                    SingletonTimer.sharedInstance.stop30SecTimer()

                    Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sRedAlertUserCancel)
                    
                }
            })
        }
    }
 @objc   func RedEnded() {
        print("RedEnded")
        cancelCheck = false
        self.RippleBack.invalidate()
        StartRipples()
    }
    
    @objc func DeactivateAlert(_ sender: UILongPressGestureRecognizer) {
            if sender.state == UIGestureRecognizerState.began {
                RedBegan()
            }
            if sender.state == .ended {
                RedEnded()
            }
    }
    
    func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
        controller.dismiss(animated: true, completion: nil)
    }
    
    
}


