<?php

Class Trackings extends CI_Model
{

	private $mysql;

	function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql', true);
	}

	function get_tracking_list()
	{
		return $this->mysql->select("*")->from('report_trigger')->order_by('create_date', 'desc')->limit('100')->get()->result_array();
	}

	function get_tracking_list_search($number)
	{
		return $this->mysql->select("*")->from('report_trigger')->where( 'number', $number )->order_by('create_date', 'desc')->limit('100')->get()->result_array();
	}

	function get_asm_tracking_list()
	{
		return $this->mysql->select("*")->from('report_trigger')->order_by('create_date', 'desc')->limit('100')->get()->result_array();
	}

	function get_asm_tracking_list_search($number)
	{
		return $this->mysql->select("*")->from('report_trigger')->where( 'number', $number )->order_by('create_date', 'desc')->limit('100')->get()->result_array();
	}

	function getBlockNumber($data){
		return $this->mysql->select('*')->from('block_number')->where('number',$data)->get()->first_row();
	}

	function insertBlockNumber($number){
		$data['number'] = $number;
		return $this->mysql->insert('block_number',$data);
	}

	function getBlockNumberList(){
		return $this->mysql->select('*')->from('block_number')->order_by('create_at','desc')->get()->result_array();
	}

	function removeBlockNumber($number_id){
		return $this->mysql->where('id',$number_id)->delete('block_number');
	}

}