<?php
/*--- Model class for Office ---*/

Class Offices extends CI_Model
{
	private $mysql;
	public $contractarea_id;
	public $office_name;
	public $admin_name;
	public $contact_number;
	public $password;
	public $email_address;
	public $office_id;
	public $status;

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->mysql = $this->load->database('mysql', true);
	}
	
	function get_user_login($email,$password){
		
		$array = array('emailaddress' => $email, 'loginpassword' => md5($password));
		
		$result = $this->mysql->select('*')->from('web_userlogin')->where($array)->get()->result_array();
		//debug($result,1);
		if(!empty($result)) {
			
			if($result[0]['logintype']=="admin") {
				
				$this->session->set_userdata('type', 'admin');
				$this->session->set_userdata('login_id', 1);
				$this->session->set_userdata('login_name', $result[0]['fullname']);
				return "admin";
				
			}else{
				$this->session->set_userdata('login_id', 1);
				$this->session->set_userdata('office_id', $result[0]['loginref']);
				$this->session->set_userdata('contractarea_id', $result[0]['contractarea']);
				$this->session->set_userdata('type', 'office');
				$this->session->set_userdata('login_name', $result[0]['fullname']);
				return "office";
			}
		}else{
			
			return "wronguser";
			
		}
			
	}

	function office_list()
	{
		return $this->mysql->select('*')->from('newoffices')->where(['logintype' => 'office'])->get()->result_array();
	}
	
	function get_all_offices(){
		
		return $this->mysql->select('*')->from('newoffices')->get()->result_array();
	}
	
	function filter_office_list($contractid) {
		
		return $this->mysql->select('*')->from('newoffices')->where(['parent' => $contractid])->get()->result_array();
	}
	
	function office_filter_lwd_list($officeid) {
		
		return $this->mysql->select('*')->from('newoffices')->where(['parent' => $officeid])->get()->result_array();
		//echo $this->mysql->last_query();
	}
	
	function contract_area_list($costcenterid)
	{
		return $this->mysql->select('*')->from('newcontractareas')->where(['parent'=>$costcenterid])->get()->result_array();
	}
	
	function get_contract()
	{
		return $query = $this->mysql->select('*')->from('newcontractareas')->where([ 'lindex' => $this->contractarea_id ])->get()->result_array();
	}

	function get_costcenter()
	{
		return $this->mysql->select('*')->from('newcostcentres')->where([ 'lindex' => $this->costcenterid ])->get()->result_array();
	}

	function contract_costcenter()
	{
		return $this->mysql->select('*')->from('newcostcentres')->join('newcontractareas', 'newcontractareas.parent = newcostcentres.lindex')->get()->result_array();
	}

	function add_offices()
	{
		/*for( $i=0; $i<count( $this->email_address ); $i++ )
		{*/
			$data2['parent'] = $this->contractarea_id;
			$data2['description'] = ucwords($this->office_name);
			$data2['email'] = $this->email_address;
			$data2['office_name'] = $this->office_name;
			$data2['admin_name'] = $this->admin_name;
			$data2['contact_no'] = $this->contact_number;
			$data2['password'] = $this->password;
			$data2['create_date'] = date('Y-m-d H:i:s');
			$this->mysql->insert('newoffices', $data2);
		/*}*/
		$insert_id2 = $this->mysql->insert_id();
		if($insert_id2 > 0 )
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}
	}

	function office_edit()
	{
		$data2['description'] = ucwords($this->office_name);
		$data2['email'] = $this->email_address;
		$data2['office_name'] = $this->office_name;
		$data2['admin_name'] = $this->admin_name;
		$data2['contact_no'] = $this->contact_number;
		$data2['password'] = $this->password;
		$data2['create_date'] = date('Y-m-d H:i:s');
		return $this->mysql->where('lindex', $this->office_id)->update('newoffices', $data2);
	}


	function office_status()
	{
		$data['status'] = $this->status;
		$query = $this->mysql->where([ 'lindex' => $this->office_id ])->update('newoffices', $data);
		if($query)
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}
	}

	function get_edit_office($id)
	{
		return $this->mysql->select('*')->from('newoffices')->where('lindex', $id)->get()->first_row('array');
	}

	function get_contract_area_office($id)
	{
		return $this->mysql->select('*')->from('newcontractareas')->where('lindex', $id)->get()->first_row('array');
	}

	function get_costcentre_office($id)
	{
		return $this->mysql->select('*')->from('newcostcentres')->where('lindex', $id)->get()->first_row('array');
	}
}
