
<?php

Class Signals extends CI_Controller
{	

	function __construct() 
	{
		parent::__construct();
		$this->load->model('users');
		$this->load->library('jwt');
		$this->load->library('jres');
		$this->load->library('sms');
		$this->load->model('signal');
	}


	function index()
	{
		//echo json_encode([ 'msg' => 'asm' ]);exit;
		//echo "<pre>"; print_r( $this->input->get()  );
		$DateTime = $this->input->get_post('datetime', true);
		$IMEI = $this->input->get_post('imei', true);
		$number = $this->input->get_post('number', true);
		$messageType = $this->input->get_post('messageType', true);
		$lat = $this->input->get_post('lat', true);
		$long = $this->input->get_post('long', true);
		$posdatatime = $this->input->get_post('posdatatime', true);
		$postype = $this->input->get_post('postype', true);
		$status = $this->input->get_post('status', true);
		$interval = $this->input->get_post('interval', true);
		$speed = $this->input->get_post('speed', true);

		if( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{

			$checkNumberBlock = $this->signal->checkNumberBlock($number);
			if( empty($checkNumberBlock->id) ){

				if( empty($interval) ){
					$interval = 0;
				}

				if( empty($status) ){
					$status = 0;
				}

			if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Couldn't create socket: [$errorcode] $errormsg \n");
				    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
				    exit;
				}

				if(!socket_connect($sock , '46.255.118.104' , 5055))
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
					if( $errormsg == 'Connection timed out' )
				    {
				    	socket_close($sock);
				    }
				    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
				    exit;
				}
				$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

				$checksum = md5($signals);
				
				$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
				
				
				/* sending values in database */
				/*$this->signal->DateTime = $DateTime;
				$this->signal->IMEI = $IMEI;
				$this->signal->number = $number;
				$this->signal->messageType = $messageType;
				$this->signal->lat = $lat;
				$this->signal->long = $long;
				$this->signal->posdatatime = $posdatatime;
				$this->signal->postype = $postype;
				$this->signal->status = $status;
				$this->signal->interval = $interval;
				$this->signal->speed = $speed;
				$this->signal->checksum = $checksum;

				$this->signal->send_signals();*/			

				//Send the message to the server
				if( ! socket_send ( $sock , $message , strlen($message) , 0))
				 {
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Could not send data: [$errorcode] $errormsg \n");
				    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
				    exit;
				}
				else
				{
					$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
					$data['DateTime'] = $DateTime;
					$data['IMEI'] = $IMEI;
					$data['number'] = $number;
					$data['messageType'] = $messageType;
					$data['lat'] = $lat;
					$data['long'] = $long;
					$data['posdatatime'] = $posdatatime;
					$data['postype'] = $postype;
					$data['status'] = $status;
					$data['interval'] = $interval;
					$data['speed'] = $speed;
					$data['checksum'] = $checksum;
					$report_trigger = $this->signal->asm_trigger($data);
				}
				$this->jres->success_message('Signals send successfully');
				socket_close($sock);
			}
		}

	}

	function sentinal(){
		$DateTime = $this->input->get_post('datetime', true);
		$IMEI = $this->input->get_post('imei', true);
		$number = $this->input->get_post('number', true);
		$messageType = $this->input->get_post('messageType', true);
		$lat = $this->input->get_post('lat', true);
		$long = $this->input->get_post('long', true);
		$posdatatime = $this->input->get_post('posdatatime', true);
		$postype = $this->input->get_post('postype', true);
		$status = $this->input->get_post('status', true);
		$interval = $this->input->get_post('interval', true);
		$speed = $this->input->get_post('speed', true);

		if( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{

			$checkNumberBlock = $this->signal->checkNumberBlock($number);
			if( empty($checkNumberBlock->id) ){

				if( empty($interval) ){
					$interval = 0;
				}

			if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Couldn't create socket: [$errorcode] $errormsg \n");
				    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
				    exit;
				}

				if(!socket_connect($sock , '89.197.154.25' , 5051))
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Could not connect: [$errorcode] $errormsg \n");
				    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
				    exit;
				}
				$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

				$checksum = md5($signals);
				
				$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
				
				
				/* sending values in database */
				/*$this->signal->DateTime = $DateTime;
				$this->signal->IMEI = $IMEI;
				$this->signal->number = $number;
				$this->signal->messageType = $messageType;
				$this->signal->lat = $lat;
				$this->signal->long = $long;
				$this->signal->posdatatime = $posdatatime;
				$this->signal->postype = $postype;
				$this->signal->status = $status;
				$this->signal->interval = $interval;
				$this->signal->speed = $speed;
				$this->signal->checksum = $checksum;

				$this->signal->send_signals();*/			

				//Send the message to the server
				if( ! socket_send ( $sock , $message , strlen($message) , 0))
				 {
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Could not send data: [$errorcode] $errormsg \n");
				    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
				    exit;
				}
				else
				{
					$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
					$data['DateTime'] = $DateTime;
					$data['IMEI'] = $IMEI;
					$data['number'] = $number;
					$data['messageType'] = $messageType;
					$data['lat'] = $lat;
					$data['long'] = $long;
					$data['posdatatime'] = $posdatatime;
					$data['postype'] = $postype;
					$data['status'] = $status;
					$data['interval'] = $interval;
					$data['speed'] = $speed;
					$data['checksum'] = $checksum;
					$report_trigger = $this->signal->asm_trigger($data);
				}
				$this->jres->success_message('Signals send successfully');
				socket_close($sock);
			}
		}
	}

	function check_date()
	{
		echo date('Y-m-d H:i:s');
	}

	function new_signal()
	{
		//echo json_encode([ 'msg' => 'sentinel' ]);exit;
		$DateTime = $this->input->get_post('datetime', true);
		$IMEI = $this->input->get_post('imei', true);
		$number = $this->input->get_post('number', true);
		$messageType = $this->input->get_post('messageType', true);
		$lat = $this->input->get_post('lat', true);
		$long = $this->input->get_post('long', true);
		$posdatatime = $this->input->get_post('posdatatime', true);
		$postype = $this->input->get_post('postype', true);
		$status = $this->input->get_post('status', true);
		$interval = $this->input->get_post('interval', true);
		$speed = $this->input->get_post('speed', true);

		if( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{

			if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Couldn't create socket: [$errorcode] $errormsg \n");
				    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
				    exit;
				}

				if(!socket_connect($sock , '81.142.251.60' , 8731))
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Could not connect: [$errorcode] $errormsg \n");
				    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
				    exit;
				}
				$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

				$checksum = md5($signals);
				
				$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;

				//Send the message to the server
				if( ! socket_send ( $sock , $message , strlen($message) , 0))
				 {
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Could not send data: [$errorcode] $errormsg \n");
				    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
				    exit;
				}
				else
				{
					$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
					$data['DateTime'] = $DateTime;
					$data['IMEI'] = $IMEI;
					$data['number'] = $number;
					$data['messageType'] = $messageType;
					$data['lat'] = $lat;
					$data['long'] = $long;
					$data['posdatatime'] = $posdatatime;
					$data['postype'] = $postype;
					$data['status'] = $status;
					$data['interval'] = $interval;
					$data['speed'] = $speed;
					$data['checksum'] = $checksum;
					$report_trigger = $this->signal->asm_trigger($data);
				}
				 //$this->jres->success_message('Signals send successfully');
				socket_close($sock);
			}
	}

	function receive_signal($string)
	{
		if( base64_decode($string) === "orbisarcsignalfromserver" )
		{
			
			if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Couldn't create socket: [$errorcode] $errormsg \n");
				    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
				    exit;
				}

				if(!socket_connect($sock , '46.255.118.104' , 5055))
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    //die("Could not connect: [$errorcode] $errormsg \n");
				    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
				    exit;
				}
				/*$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

				$checksum = md5($signals);
				
				$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;*/
				
				//Now receive reply from server
				if(socket_recv ( $sock , $buf , 2045 , MSG_WAITALL ) === FALSE)
				{
				    $errorcode = socket_last_error();
				    $errormsg = socket_strerror($errorcode);
				     
				    die("Could not receive data: [$errorcode] $errormsg \n");
				}
				 
				//print the received message
				$this->jres->success_message($buf);
				socket_close($sock);
			}
			else
			{
				$this->jres->failure("Wrong KEy");
		    	exit;
			}
	}


	function check_trigger()
	{
		//debug($this->input->post(),1);
		$ref_id = $this->input->post('ref_id',true);
		if( empty($ref_id) )
		{
			$ref_id = '0';
		}
		$lat = $this->input->post('lat',true);
		if( empty($lat) )
		{
			$lat = '0';
		}
		$long = $this->input->post('long',true);
		if( empty($long) )
		{
			$long = '0';
		}
		$DateTime = $this->input->post('datetime', true);
		if( empty($DateTime) )
		{
			$DateTime = '0';
		}
		$IMEI = $this->input->post('imei', true);
		if( empty($IMEI) )
		{
			$IMEI = '0';
		}
		$number = $this->input->post('number', true);
		if( empty($number) )
		{
			$number = '0';
		}
		$messageType = $this->input->post('messageType', true);
		if( empty($messageType) )
		{
			$messageType = '0';
		}
		$posdatatime = $this->input->post('posdatatime', true);
		if( empty($posdatatime) )
		{
			$posdatatime = '0';
		}
		$postype = $this->input->post('postype', true);
		if( empty($postype) )
		{
			$postype = '0';
		}
		$status = $this->input->post('status', true);
		if( empty($status) )
		{
			$status = '0';
		}
		$interval = $this->input->post('interval', true);
		if( empty($interval) )
		{
			$interval = '0';
		}
		$speed = $this->input->post('speed', true);
		if( empty($speed) )
		{
			$speed = '0';
		}
		$trigger_from = $this->input->post('trigger_from', true);
		if( empty($trigger_from) )
		{
			$trigger_from = 'no log';
		}

		if(  !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{

			$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;
		
			$checksum = md5($signals);

			/* sending values in database */
				$this->signal->ref_id = $ref_id;
				$this->signal->DateTime = $DateTime;
				$this->signal->IMEI = $IMEI;
				$this->signal->number = $number;
				$this->signal->messageType = $messageType;
				$this->signal->lat = $lat;
				$this->signal->long = $long;
				$this->signal->posdatatime = $posdatatime;
				$this->signal->postype = $postype;
				$this->signal->status = $status;
				$this->signal->interval = $interval;
				$this->signal->speed = $speed;
				$this->signal->checksum = $checksum;
				$this->signal->trigger_from = $trigger_from;

				$report_trigger = $this->signal->trigger_event();
				if( $report_trigger )
				{
					$data['status']= '1';
					$this->jres->success_message( 'trigger save');
				}
				else
				{
					$this->jres->failure('trigger fail');
				}
		}

	}
}