<?php
/*--- Model class for Office ---*/

Class Offices extends CI_Model
{
	private $mysql;
	public $contractarea_id;
	public $office_name;
	public $admin_name;
	public $contact_number;
	public $password;
	public $email_address;
	public $office_id;
	public $status;

	function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql', true);
	}

	function office_list()
	{
		return $this->mysql->select('*')->from('offices')->get()->result_array();
	}
	
	function filter_office_list($contractid) {
		
		return $this->mysql->select('*')->from('offices')->where(['contractarea_id' => $contractid])->get()->result_array();
	}
	
	function office_filter_lwd_list($officeid) {
		
		return $this->mysql->select('*')->from('offices')->where(['office_id' => $officeid])->get()->result_array();
	}
	
	function contract_area_list($costcenterid)
	{
		return $this->mysql->select('*')->from('contractarea')->where(['costcenter_id'=>$costcenterid])->get()->result_array();
	}
	
	function get_contract()
	{
		return $query = $this->mysql->select('*')->from('contractarea')->where([ 'contractarea_id' => $this->contractarea_id ])->get()->result_array();
	}

	function get_costcenter()
	{
		return $this->mysql->select('*')->from('costcenter')->where([ 'costcenter_id' => $this->costcenterid ])->get()->result_array();
	}

	function contract_costcenter()
	{
		return $this->mysql->select('*')->from('costcenter')->join('contractarea', 'contractarea.costcenter_id = costcenter.costcenter_id')->get()->result_array();
	}

	function add_offices()
	{
		for( $i=0; $i<count( $this->email_address ); $i++ )
		{
			$data2['contractarea_id'] = $this->contractarea_id;
			$data2['email'] = $this->email_address[$i];
			$data2['office_name'] = $this->office_name[$i];
			$data2['admin_name'] = $this->admin_name[$i];
			$data2['contact_no'] = $this->contact_number[$i];
			$data2['password'] = $this->password[$i];
			$data2['create_date'] = date('Y-m-d H:i:s');
			$this->mysql->insert('offices', $data2);
		}
		$insert_id2 = $this->mysql->insert_id();
		if($insert_id2 > 0 )
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}
	}


	function office_status()
	{
		$data['status'] = $this->status;
		$query = $this->mysql->where([ 'office_id' => $this->office_id ])->update('offices', $data);
		if($query)
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}
	}
}
