<?php

/*

	Controller For Lwd..

*/

Class Lwd extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->model('lwds');
		$this->load->model('cost_center');
		$this->load->model('contractareas');
		$this->load->model('offices');
		$this->load->library('session');
		$this->load->library('pagination');
		
		if( $this->session->userdata('login_id') !=1 )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('user/index');
		}
	}

	function index()
	{
		//echo $this->uri->segment(2); exit;
	  /* if(isset($_POST['costcenterlwd']) && !empty($_POST['costcenterlwd']) && isset($_POST['contractarealwd']) && !empty($_POST['contractarealwd']) && isset($_POST['officelwd']) && !empty($_POST['officelwd'])){
		    $this->session->set_userdata('costcenterlwd',$_POST['costcenterlwd']);
			$this->session->set_userdata('contractarealwd',$_POST['contractarealwd']);
			$this->session->set_userdata('officelwd',$_POST['officelwd']);
		    $data['costcenter'] = $this->cost_center->cc_list();
			$data['contract_areas'] = $this->contractareas->get_all();
			$data['contract_costcenter'] = $this->offices->contract_costcenter();
			$contractarea_detail = [];
			$office_list = $this->offices->office_list();
			
			$limit = 25;
			$result = $this->lwds->get_filter_lwd_list($limit, $offset, $_POST['officelwd']);
			$data['detail'] = $result['rows'];
			$data['num_results'] = $result['num_rows'];
			$config = array();
			$config['base_url'] = site_url("lwd");
			$config['total_rows'] = $data['num_results'];
			$config['per_page'] = $limit;
			debug($config,1);
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$this->load->view('lwd/lwd', $data);
			
	   }else{*/
		   
		    $this->session->set_userdata('costcenterlwd',"");
			$this->session->set_userdata('contractarealwd',"");
			$this->session->set_userdata('officelwd',"");
			$data['costcenter'] = $this->cost_center->cc_list();
			$data['contract_areas'] = $this->contractareas->get_all();
			$data['contract_costcenter'] = $this->offices->contract_costcenter();
			$contractarea_detail = [];
			$office_list = $this->offices->office_list();

			if( $this->input->post('select_limit') !="" )
			{
				$data['current_limit'] = $this->input->post('select_limit');
			}
			else
			{
				$data['current_limit'] = 25;
			}

			$config = [

				'base_url' 			=> site_url("lwd/index"),
				'total_rows'		=> $this->lwds->get_count_lwd(),
				'per_page'			=> $data['current_limit'],
				'full_tag_open'		=> '<ul class="pagination pull-right">',
				'full_tag_close'	=> '</ul>',
				'first_tag_open'	=> '<li>',
				'first_tag_close'	=> '</li>',
				'last_tag_open'		=> '<li>',
				'last_tag_close'	=> '</li>',
				'cur_tag_open'		=> '<li class="active"><a>',
				'cur_tag_close'		=> '</a></li>',
				'num_tag_open'		=> '<li>',
				'num_tag_close'		=> '</li>',
				'next_tag_open'		=> '<li>',
				'next_tag_close'	=> '</li>',
				'prev_tag_open'		=> '<li>',
				'prev_tag_close'	=> '</li>'
			];

			//debug($config,1);
			$data['detail'] = $this->lwds->get_lwd_list($config['per_page'], $this->uri->segment(3));
			$this->pagination->initialize($config);
			//debug($data["links"],1);
			$this->load->view('lwd/lwd', $data);
			
			//debug($data);
			/*for( $i=0; $i<count($office_list); $i++ )
			{
				$this->offices->contractarea_id = $office_list[$i]['contractarea_id'];
				$contractarea_detail = $this->offices->get_contract();
				$office_list[$i]['contractarea_detail'] = $contractarea_detail;
				for ($m=0; $m <count($contractarea_detail) ; $m++)
				{ 
					$this->offices->costcenterid = $contractarea_detail[$m]['costcenter_id'];
					$office_list[$i]['costcenter_detail'] = $this->offices->get_costcenter();
				}
				$data['detail'] = $office_list;
			}*/
				
	   //}
	}

	function login_name()
	{
		$this->lwds->login_name = $this->input->get('login_name', true);
		$login_name = $this->lwds->login_name();
		if($login_name['ref'] > 0)
		{
			echo "already";
		}
		else
		{
			echo "free";
		}
	}

	function email_address()
	{
		$this->lwds->email_address = $this->input->get('email_address');
		$email_address = $this->lwds->email_address();
		if($email_address['ref'] > 0)
		{
			echo "already";
		}
		else
		{
			echo "free";
		}	
	}

	/* change signal kill status */
	function change_signal_kill()
	{
		$this->lwds->lwd_id = $this->input->post('lwd_id');
		$this->lwds->signal_kill = $this->input->post('signal_kill');
		$signal_status = $this->lwds->signal_status();
		echo ($signal_status)? 'done' : 'fail';
	}

	function add_lwd()
	{
		$this->lwds->costcenter = trim( $this->input->post( 'costcenter',true ) ) ;
		$this->lwds->fname = trim( $this->input->post( 'fname',true ) ) ;
		$this->lwds->login_name = trim( $this->input->post( 'login_name',true ) ) ;
		$this->lwds->email_address = trim( $this->input->post( 'email',true ) ) ;
		$this->lwds->password = trim( $this->input->post( 'password',true ) ) ;
		$this->lwds->gender = trim( $this->input->post( 'gender',true ) ) ;
		$this->lwds->dob = trim( $this->input->post( 'dob',true ) ) ;
		$this->lwds->number = trim( $this->input->post( 'number',true ) ) ;
		$this->lwds->imei = trim( $this->input->post( 'imei',true ) ) ;
		$this->lwds->address = trim( $this->input->post( 'address',true ) ) ;
		$this->lwds->costcenter = trim( $this->input->post( 'costcenter',true ) ) ;
		$this->lwds->contractarea = trim( $this->input->post( 'contractarea',true ) ) ;
		$this->lwds->office = trim( $this->input->post( 'office',true ) ) ;
		
		$add_lwd_db = $this->lwds->add_lwd_db(); 
		if($add_lwd_db > 0)
		{
			echo "done";
		}
		else
		{
			echo "fail";
		}

	}

	public function profile_view()
	{
		$this->load->view('lwd/lwd_profile');
	}
	
	function get_office($contractareaid)
	{
		$office = $this->lwds->office_list($contractareaid);
        echo json_encode($office);
		
	}

	function get_map_location()
	{
		$this->lwds->lwd_id = $this->input->post('lwd_id');
		$map_location_lwd = $this->lwds->map_location_lwd();
		echo json_encode($map_location_lwd);
	}
}