<?php

Class Users extends CI_Model
{
	public $username;
	public $password;
	public $number;
	public $device_id;
	public $device_token;
	public $device_type;
	public $ref;
	public $ref_id;
	public $lat;
	public $long;
	public $token;
	public $status;
	public $otp;
	public $app_type;

	function __construct() 
	{
		parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->mysql = $this->load->database('mysql',true);
		$this->odbc = $this->load->database('odbc',true);
	}


	function get_login_asm()
	{
		return $this->odbc->query("select * from CREATEAPPLOGIN('".$this->number."','".$this->otp."')")->result_array();	
	}

	function get_login()
	{
		$query_mysql =  $this->mysql->select('*')->from('operators')->where([ 'number' => trim($this->number) ])->get()->first_row('array');
		if(  $query_mysql['ref']!="" )
		{
			return $this->mysql->select('ref, loginname,fullname, accesslevel,number,imei_no, otp, is_verified, lastin, lastout, custref, depot,type, logintype, costcentre , contractarea, office, emailaddress, createdate, termsagree')->from('operators')->where([ 'number' => trim($this->number)])->get()->first_row('array');
		}
	}

	// Update OTP
	function update_otp()
	{
		$data['otp'] = $this->otp;
		$this->mysql->where('ref', $this->ref);
		$this->mysql->update('operators', $data);
	}


	function verified_otp_asm()
	{
		return $this->odbc->query("select * from VERIFYAPPUSER('".$this->number."', '".$this->device_type."', '".$this->device_token."', '".$this->device_id."', '".$this->otp."', '".$this->app_type."') ")->result_array();
	}

	function verified_otp()
	{
		$get_result = $this->mysql->select('ref')->from('operators')->where([ 'number' => trim($this->number), 'otp' => $this->otp ])->get()->first_row('array');
		if( $get_result['ref'] )
		{
			$data['device_token'] = $this->device_token;
			$data['device_type'] = $this->device_type;
			$data['is_verified'] = '1';
			$data['lastin'] = date( 'Y-m-d H:i:s' );
			$this->mysql->where('ref', $get_result['ref'])->update('operators', $data);
		}

		return $get_result;
	}

	// update token of logged in user
	function update_user_token()
	{
		$data['token'] = $this->token;
		$data['lastin'] = date( 'Y-m-d H:i:s' );
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);
	}

	function user_logout()
	{
		$data['token'] = " ";
		$data['lastout'] = date('Y-m-d H:i:s');
		$data['otp'] = "0";
		$data['is_verified'] = "0";
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);

	}

	function update_location()
	{
		$data['ref_id'] = $this->ref_id;
		$data['lat'] = $this->lat;
		$data['long'] = $this->long;
		$data['status'] = $this->status;
		$data['create_date'] = date('Y-m-d h:i:s');
		$this->mysql->insert('location', $data);
		return $insert_id = $this->mysql->insert_id();
	}


	

}