<?php

Class User extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->model('users');
		$this->load->model('offices');
		
	}

	function index()
	{
		/*if( $this->session->userdata('type') == "" )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('user/index');
		}*/
		$this->load->view('common/newlogin');
	}


	function newLogin()
	{
		$user_email = trim($this->input->post('user_email'));
		$user_pass = trim($this->input->post('user_pass'));
		echo $logintype = $this->offices->get_user_login($user_email,$user_pass);
		$this->session->set_userdata('admin_name', $logintype);
	}

	function system_user()
	{
		$this->session->set_userdata('type', 'system');
		$this->session->set_userdata('login_id', 1);
		$this->session->set_userdata('login_name', 'Super User');
		$this->session->set_userdata('office_id', '23');
		$this->offices->event_log();
		if($this->session->userdata('type') && $this->session->userdata('login_id') )
		{
			echo 'done';
		}
		else
		{
			echo 'fail';
		}
	}

	function check_login()
	{

		$user_email = trim($this->input->post('user_email'));
		$user_pass = trim($this->input->post('user_pass'));
		$logintype = $this->offices->get_user_login($user_email,$user_pass);

		$this->session->set_userdata('admin_name', $logintype);
		if($logintype=="admin") {

			redirect('user/dashboard');

		}
		if($logintype=="office") {
			redirect('lwd');
		}
		if($logintype=="wronguser") {

			$this->session->set_flashdata('error_msg', 'Wrong Username / Password');
			redirect('/');
		}

	}

	function dashboard()
	{
		if( $this->session->has_userdata('login_id') != 1 )
		{
			$this->session->set_flashdata('error_msg', 'Not Login Yet');
			redirect('/');
		}
		else
		{
			$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListSites";

			$xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
			<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
				 <soap:Body>
					<ListSites xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
						<listSitesRequestKey>
							<UserName>jack@iivo.io</UserName>
							<Password>Password1</Password>
							<ServiceVersion>Version_1_104_1</ServiceVersion>
						</listSitesRequestKey>
					</ListSites>
					 </soap:Body>
				</soap:Envelope>';
				// get curl response
				$curl_send = $this->curl->curl_send($xml_post_string, $url);
				// convert xml into array
				$xmlToArray = $this->curl->xmlToArray($curl_send);
				//count of lone worker
				$data['lenght_lone_worker'] = count($xmlToArray['ListSitesResponse']['ListSitesResult']['ListOfSites']['SiteListItem']);
				// load data on view
				$this->load->view('common/dashboard', $data);
		}
	}

	function logout()
	{
		$this->session->unset_userdata('login_id');
		$this->session->unset_userdata('office_id');
		$this->session->unset_userdata('contractarea_id');
		$this->session->unset_userdata('type');
		$this->session->set_flashdata('error_msg', 'Logout Successful');
		redirect('/');
	}

	function cost_center()
	{
		$this->load->view('cost_center');
	}
	function contract_area()
	{
		$this->load->view('contract_area');
	}
	function lwd()
	{
		$this->load->view('lwd');
	}
	function office()
	{
		$this->load->view('office');
	}

	function lwd_list()
	{
		$this->load->view('lwd_list');
	}

	function lwd_profile()
	{
		$this->load->view('lwd_profile');
	}
}
