<?php

/*

	Controller For Sytem..

*/

Class Systems extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->model('lwds');
		$this->load->model('cost_center');
		$this->load->model('contractareas');
		$this->load->model('offices');
		$this->load->model('event');
		$this->load->model('users');
		$this->load->library('session');
		$this->load->library('pagination');
		if( $this->session->userdata('login_id') != 1 )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('/');
			//echo "no login"; exit;
		}

	}

	function index()
	{
		$this->load->view('system/dashboard');
	}


	function device()
	{
		$lone_worker_url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListSites";

		// list site (lone worker)
		$lone_worker = '<?xml version="1.0" encoding="utf-8"?>
		<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
			 <soap:Body>
				<ListSites xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
					<listSitesRequestKey>
						<UserName>jack@iivo.io</UserName>
						<Password>Password1</Password>
						<ServiceVersion>Version_1_104_1</ServiceVersion>
					</listSitesRequestKey>
				</ListSites>
				 </soap:Body>
			</soap:Envelope>';
			// get curl response
			$curl_send = $this->curl->curl_send($lone_worker, $lone_worker_url);
			// convert xml into array
			$xmlToArray = $this->curl->xmlToArray($curl_send);
			$data['lenght_lone_worker'] = $xmlToArray['ListSitesResponse']['ListSitesResult']['ListOfSites']['SiteListItem'];

			// get transmitter
			$transmitter_url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListTransmitters";

			$get_transmitter = '<?xml version="1.0" encoding="utf-8"?>
			<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
			  <soap:Body>
			    <ListTransmitters xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
			      <listTransmittersRequestKey>
			      	<UserName>jack@iivo.io</UserName>
			        <Password>Password1</Password>
							<SerialNumber>1574</SerialNumber>
			      </listTransmittersRequestKey>
			    </ListTransmitters>
			  </soap:Body>
			</soap:Envelope>';

			$curl_send_transmitter = $this->curl->curl_send($get_transmitter, $transmitter_url);
			// convert xml into array
			$xmlToArray1 = $this->curl->xmlToArray($curl_send_transmitter);
			$data['transmitter'] = $xmlToArray1['ListTransmittersResponse']['ListTransmittersResult']['ListOfTransmitters']['TransmitterListItem'];
			//$data['list_data'] = array_merge($lenght_lone_worker,$transmitter  );



		$this->load->view('system/device_list', $data);
	}

	function members()
	{
		if(isset($_POST['costcenterlwd']) && !empty($_POST['costcenterlwd']) && isset($_POST['contractarealwd']) && !empty($_POST['contractarealwd']) && isset($_POST['officelwd']) && !empty($_POST['officelwd'])){

		    $this->session->set_userdata('costcenterlwd',$_POST['costcenterlwd']);
			$this->session->set_userdata('contractarealwd',$_POST['contractarealwd']);
			$this->session->set_userdata('officelwd',$_POST['officelwd']);
			$data['costcenter'] = $this->cost_center->cc_list();
			$data['contract_areas'] = $this->contractareas->get_all();

			$data['contract_costcenter'] = $this->offices->contract_costcenter();
			$data['office_list'] = $this->offices->get_all_offices();
			$office_list = $this->offices->office_list();

			$contractarea_detail = [];

			if( $this->input->post('select_limit') !="" )
			{
				$data['current_limit'] = $this->input->post('select_limit');
			}
			else
			{
				$data['current_limit'] = 25;
			}

			$config = [

				'base_url' 			=> site_url("lwd/index"),
				'total_rows'		=> $this->lwds->get_count_lwd(),
				'per_page'			=> $data['current_limit'],
				'full_tag_open'		=> '<ul class="pagination pull-right">',
				'full_tag_close'	=> '</ul>',
				'first_tag_open'	=> '<li>',
				'first_tag_close'	=> '</li>',
				'last_tag_open'		=> '<li>',
				'last_tag_close'	=> '</li>',
				'cur_tag_open'		=> '<li class="active"><a>',
				'cur_tag_close'		=> '</a></li>',
				'num_tag_open'		=> '<li>',
				'num_tag_close'		=> '</li>',
				'next_tag_open'		=> '<li>',
				'next_tag_close'	=> '</li>',
				'prev_tag_open'		=> '<li>',
				'prev_tag_close'	=> '</li>'
			];



			if($this->session->userdata('type')=="office") {

				if( $this->input->get('searchbar') )
				{
					$data['detail'] = $this->lwds->office_list_search_lwd($this->session->userdata('office_id'),$this->input->get('searchbar'));
				}
				else
				{
					$data['detail'] = $this->lwds->get_lwd_office_list($this->session->userdata('office_id'),$config['per_page'], $this->uri->segment(3));
				}


				$contractareaname         = $this->lwds->getcontractareaname($this->session->userdata('contractarea_id'));
				$costcentername           = $this->lwds->getcostcentername($contractareaname[0]->costcenter_id);
				$data['contractareaname'] = $contractareaname[0]->contractarea_name;
				$data['costcentername']   = $costcentername[0]->costcenter_name;


			}else{

				if( $this->input->get('searchbar') )
				{
					$this->lwds->search_term = $this->input->get('searchbar');
					$data['detail'] = $this->lwds->office_list_search();
				}
				else
				{
					$data['detail'] = $this->lwds->get_lwd_list_filter($_POST['officelwd'], $config['per_page'], $this->uri->segment(3));
				}


			}



			$this->pagination->initialize($config);

			$this->load->view('system/members', $data);

	   }else{

	      	//echo '1 ==>'.$this->session->userdata('office_id').'====>'.$this->uri->segment(3);
		    $this->session->set_userdata('costcenterlwd',"");
			$this->session->set_userdata('contractarealwd',"");
			$this->session->set_userdata('officelwd',"");
			$data['costcenter'] = $this->cost_center->cc_list();
			$data['contract_areas'] = $this->contractareas->get_all();
			$data['contract_costcenter'] = $this->offices->contract_costcenter();
			$data['office_list'] = $this->lwds->get_office_lwd_sys();
			$office_list = $this->lwds->get_office_lwd_sys();

			$contractarea_detail = [];

			if( $this->input->post('select_limit') !="" )
			{
				$data['current_limit'] = $this->input->post('select_limit');
			}
			else
			{
				$data['current_limit'] = 25;
			}

			$config = [

				'base_url' 			=> site_url("systems/members"),
				'total_rows'		=> $this->lwds->get_office_lwd_sys(),
				'per_page'			=> $data['current_limit'],
				'full_tag_open'		=> '<ul class="pagination pull-right">',
				'full_tag_close'	=> '</ul>',
				'first_tag_open'	=> '<li>',
				'first_tag_close'	=> '</li>',
				'last_tag_open'		=> '<li>',
				'last_tag_close'	=> '</li>',
				'cur_tag_open'		=> '<li class="active"><a>',
				'cur_tag_close'		=> '</a></li>',
				'num_tag_open'		=> '<li>',
				'num_tag_close'		=> '</li>',
				'next_tag_open'		=> '<li>',
				'next_tag_close'	=> '</li>',
				'prev_tag_open'		=> '<li>',
				'prev_tag_close'	=> '</li>'
			];

			//debug($config,1);

			if($this->session->userdata('type')=="office") {
				//echo '2';
				if( $this->input->get('searchbar') )
				{
					$data['detail'] = $this->lwds->office_list_search_lwd($this->session->userdata('office_id'),$this->input->get('searchbar'));
				}
				else
				{
					$data['detail'] = $this->lwds->get_lwd_office_list($this->session->userdata('office_id'),$config['per_page'], $this->uri->segment(3));
				}


				$contractareaname         = $this->lwds->getcontractareaname($this->session->userdata('contractarea_id'));
				$costcentername           = $this->lwds->getcostcentername($contractareaname[0]->costcenter_id);
				//debug($costcentername,1);
				$data['contractareaname'] = $contractareaname[0]->contractarea_name;
				$data['costcentername']   = $costcentername[0]->costcenter_name;


			}else{
					//echo '3';
				if( $this->input->get('searchbar') )
				{
					//echo '4';
					$this->lwds->search_term = $this->input->get('searchbar');
					$data['detail'] = $this->lwds->office_list_search_sys();
				}
				else
				{	//echo '-->'.$this->uri->segment(2);
					//echo $config['per_page'];
					$data['detail'] = $this->lwds->get_lwd_list_sys($config['per_page'], $this->uri->segment(3));
				}


			}
			//debug($data,1);
			$data["links_up"] = $this->pagination->initialize($config);
			$data["links_footer"] = $this->pagination->initialize($config);
			//debug($data["links"],1);
			$this->load->view('system/members', $data);

	   }
	}

	function notification()
	{
		$this->load->view('system/notification');
	}

	function viewevent()
	{
		$this->load->view('system/eventlist');
	}

	function edituser()
	{
		$this->load->view('system/edituser');
	}

	function escalation_detail()
	{
		$this->load->view('system/escalation');
	}

	function view_user()
	{

		if( $this->input->post('select_limit') !="" )
		{
			$data['current_limit'] = $this->input->post('select_limit');
		}
		else
		{
			$data['current_limit'] = 25;
		}

		$config = [
			'base_url' 			=> site_url("systems/view_user"),
			'total_rows'		=> count($this->users->count_lwd()),
			'per_page'			=> $data['current_limit'],
			'full_tag_open'		=> '<ul class="pagination pull-right">',
			'full_tag_close'	=> '</ul>',
			'first_tag_open'	=> '<li>',
			'first_tag_close'	=> '</li>',
			'last_tag_open'		=> '<li>',
			'last_tag_close'	=> '</li>',
			'cur_tag_open'		=> '<li class="active"><a>',
			'cur_tag_close'		=> '</a></li>',
			'num_tag_open'		=> '<li>',
			'num_tag_close'		=> '</li>',
			'next_tag_open'		=> '<li>',
			'next_tag_close'	=> '</li>',
			'prev_tag_open'		=> '<li>',
			'prev_tag_close'	=> '</li>'
		];

		$data['user_list'] = $this->users->get_system_users_list($config['per_page'], $this->uri->segment(3));
		$this->pagination->initialize($config);
		$data['links'] = $this->pagination->create_links();
		$this->load->view('system/user_list',$data);
	}

	function user_add($id = null)
	{
		if( $id != null )
		{
			$data['user_data'] = $this->users->get_user_data($id);
			$this->load->view('system/add_user', $data);
		}
		else {
			$this->load->view('system/add_user');
		}
	}

	function add_new()
	{

		if(!empty( $this->input->post('edit_user_id') ))
		{
			$add_system_user = $this->users->edit_system_user($this->input->post(),$this->input->post('edit_user_id'));
		}
		else {
			$add_system_user = $this->users->add_system_user($this->input->post());
		}
		if($add_system_user > 0)
		{
			echo 'done';
		}
		else {
			echo 'fail';
		}
		//debug( $this->input->post() );
	}

	function logs()
	{
		//echo $this->event->get_total_log();
		$config = [

			'base_url' 			=> site_url("systems/logs"),
			'total_rows'		=> count($this->event->get_total_log()),
			'per_page'			=> '5',
			'full_tag_open'		=> '<ul class="pagination pull-right">',
			'full_tag_close'	=> '</ul>',
			'first_tag_open'	=> '<li>',
			'first_tag_close'	=> '</li>',
			'last_tag_open'		=> '<li>',
			'last_tag_close'	=> '</li>',
			'cur_tag_open'		=> '<li class="active"><a>',
			'cur_tag_close'		=> '</a></li>',
			'num_tag_open'		=> '<li>',
			'num_tag_close'		=> '</li>',
			'next_tag_open'		=> '<li>',
			'next_tag_close'	=> '</li>',
			'prev_tag_open'		=> '<li>',
			'prev_tag_close'	=> '</li>'
		];

		$data['detail'] = $this->event->list_log($config['per_page'], $this->uri->segment(3));
		$this->pagination->initialize($config);
		$data['links'] = $this->pagination->create_links();
		$this->load->view('system/log_list',$data);
	}

} //class end
