<?php
/*
	Controller for Office
*/

Class Office extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('cost_center');
		$this->load->model('contractareas');
		$this->load->model('offices');
		$this->load->model('users');
		$this->load->library('session');
		$this->load->library('pagination');
		if( $this->session->userdata('type') == "" )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('user/index');
		}
	}

	function index()
	{
		if( $this->input->post('select_limit') !="" )
		{
			$data['current_limit'] = $this->input->post('select_limit');
		}
		else
		{
			$data['current_limit'] = 5;
		}

		$config = [
			'base_url' 			=> site_url("office/index/"),
			'total_rows'		=> count($this->users->count_lwd()),
			'per_page'			=> $data['current_limit'],
			'full_tag_open'		=> '<ul class="pagination pull-right">',
			'full_tag_close'	=> '</ul>',
			'first_tag_open'	=> '<li>',
			'first_tag_close'	=> '</li>',
			'last_tag_open'		=> '<li>',
			'last_tag_close'	=> '</li>',
			'cur_tag_open'		=> '<li class="active"><a>',
			'cur_tag_close'		=> '</a></li>',
			'num_tag_open'		=> '<li>',
			'num_tag_close'		=> '</li>',
			'next_tag_open'		=> '<li>',
			'next_tag_close'	=> '</li>',
			'prev_tag_open'		=> '<li>',
			'prev_tag_close'	=> '</li>'
		];

		$data['user_list'] = $this->users->get_system_users_list($config['per_page'], $this->uri->segment(3));
		$this->pagination->initialize($config);
		$data['links'] = $this->pagination->create_links();


			$this->load->view('office/user_list',$data);
	   //}
	}

	function add_user($id = null)
	{
		if( $id != null )
		{
			$data['user_data'] = $this->users->get_user_data($id);
			$this->load->view('office/office_list', $data);
		}
		else {
			$this->load->view('office/office_list');
		}

	}

	function get_office_by_contract($id)
	{
		$this->offices->contractarea_id = $id;
		$filter_office_list = $this->offices->filter_office_list();
		if( !empty($filter_office_list) )
		{
			echo json_encode($filter_office_list);
		}
		else
		{
			$data['LINDEX'] = '0';
			$data['DESCRIPTION'] = ' No row found';
			echo json_encode($data);
		}
	}

	function get_contract_area($costcenterid) {
		$contractarea = $this->offices->contract_area_list($costcenterid);
		if($contractarea){
		        echo json_encode($contractarea);
		}else
		{
			$data['msg'] = 'fail';
			echo json_encode($data);
		}
	}


	function add_Office()
	{
		//debug( $this->input->post() );

		if( !empty(trim($this->input->post('office_id'))) )
		{
			$this->offices->office_id = trim($this->input->post('office_id', true));
			$this->offices->office_name = trim($this->input->post('office_name', true));
			echo $add_offices = $this->offices->office_edit();
		}
		else
		{
			$this->offices->costcenter_id = trim($this->input->post('costcenter', true));
			$this->offices->contractarea_id = trim($this->input->post('contractarea', true));
			$this->offices->office_name = trim($this->input->post('office_name', true));
			echo $add_offices = $this->offices->add_offices();
		}



	}

	function edit_offce()
	{
		$this->offices->office_id = $this->input->post('officeID', true);
		$this->offices->office_name = $this->input->post('office_name', true);
		$this->offices->admin_name = $this->input->post('admin_name', true);
		$this->offices->email_address = $this->input->post('email_address', true);
		$this->offices->contact_number = $this->input->post('contact_number', true);
		$this->offices->password = $this->input->post('password', true);
		$this->offices->password = $this->input->post('cpassword', true);
		$add_offices = $this->offices->office_edit();
		if($add_offices)
		{
			echo 'update';
		}
	}

	function change_status()
	{
		$this->offices->office_id = $this->input->post('id',true);
		$this->offices->status = $this->input->post('status', true);
		echo $office_status = $this->offices->office_status();
	}

	function get_office_edit($id)
	{
		$get_edit_office = $this->offices->get_edit_office($id);
		$get_contract_area_office = $this->offices->get_contract_area_office($get_edit_office['parent']);
		$get_edit_office['contractarea_name'] = $get_contract_area_office['description'] ;

		$get_costcentre_office = $this->offices->get_costcentre_office($get_contract_area_office['parent']);
		$get_edit_office['costcentre_name'] = $get_costcentre_office['description'];
		echo json_encode($get_edit_office);
	}
}
