<?php

Class Users extends CI_Model
{
	public $table = 'user';
	public $commission = 'user_commission';

	public function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql', true);
	}

	function get_user_team($team_id)
	{
		return $this->mysql->select('*')->from($this->table)->where([ 'team_id' => $team_id ])->get()->result_array();
		//echo $this->mysql->last_query();
	}

	function team_via_id($team_id)
	{
		return $this->mysql->select('*')->from($this->table)->where([ 'team_id' => $team_id ])->get()->result_array();
	}

	function check_user_email($email)
	{
		return $this->mysql->select('*')->from($this->table)->where(['email' => $email])->get()->first_row();
	}

	function check_user_username($username)
	{
		return $this->mysql->select('*')->from($this->table)->where(['username' => $username])->get()->first_row();
	}

	function get_user_detail($user_id)
	{
		return $this->mysql->select('*')->from($this->table)->where([ 'user_id' => $user_id ])->get()->first_row('array');
	}

	function get_user_commission($user_id)
	{
		$query = $this->mysql->select_sum('commission_earned')->from($this->commission)->where([ 'user_id' => $user_id ])->get();
		foreach ($query->result() as $row)
		{
        	return $row->commission_earned;
		}
	}
}
