<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends MY_Controller {

  function __construct(){
    parent::__construct();
  }

  function signup()
  {
    //debug( $this->session->userdata('signup_detail') );
    $data['signup_info'] = $this->session->userdata('signup_detail');
    $this->load->view('layout/signup',$data);
  }

  function testpage(){
    $this->load->view('layout/theme_contact');
  }

  function enroll_customer(){
    // debug($this->input->post());
    // echo "---------------";
    // debug();
    $session_detail = $this->session->userdata('signup_detail');

    $parameter = [
        'senderReference' => 'WEBPORTAL',
        'reference' => 'WEBPORTAL-1',
        'billingEntityCode' => 'FOOBAR-RS',
        'marketingOptOutFl' => false,
        'submittedSource' => 'Tele',
        'changeOfTenancyFl' => false,
        'contacts' => [
          [
          'title' => $this->input->post('customer_title'),
          'forename' => $this->input->post('fname'),
          'surname' => $this->input->post('lname'),
          'billingMethod' => $session_detail['quotation_pay_energy'],
          'email' => $this->input->post('email'),
          'phone1' => $this->input->post('telephone'),
          'phone2' => $this->input->post('customer_phone'),
          'dateOfBirth' => $this->input->post('customer_dob'),
          'primaryContact' => true,
          'address' => [
            'careOf' => $this->input->post('fname').' '.$this->input->post('lname'),
            'address1' => $this->input->post('customer_address'),
            'postcode' =>  $session_detail['postcode'],
            'countryCode' => 'GB'
          ],
        ]
      ],
      'supplyAddress' => [
        'careOf' => $this->input->post('fname').' '.$this->input->post('lname'),
        'address1' => $this->input->post('customer_address'),
        'postcode' =>  $session_detail['postcode'],
        'countryCode' => 'GB'
      ],
      'directDebitInfo' => [
        'bankAccountSortCode' => $this->input->post('sort_code'),
        'bankAccountNumber' => $this->input->post('account_number'),
        'bankAccountName' =>  $this->input->post('account_name')
      ],
      'electricityProduct' => [
        "reference" =>  "WEBPORTAL-PRODUCT-1",
        "previousSupplier"=> $session_detail['quotation_supplier'],
        "previousTariff"=> $session_detail['existingTariffNameElec'],
        "productCode"=>"ELE-VAR-1",
        "mpans" => [
          [ 'mpanCore' => $session_detail['quotation_mpan'] ]
        ]
      ],
      'gasProduct' => [
        "reference" =>  "WEBPORTAL-PRODUCT-2",
        "productCode"=>"GAS-VAR",
        "mprns" => [
          [ 'mprn' => "3204159108" ]
        ]
      ],
    ];

    //sign up customer
    $response = $this->curl->junifer_request('/rest/v1/customers/enrolCustomer',$parameter, 'post');
    $signup_response = json_decode($response,true);
  //debug($signup_response);
    if($signup_response['customerId'] > 0){
      $parameter_account = [ 'email' => $this->input->post('email') ];
      $get_account_id = $this->curl->junifer_request('/rest/v1/accounts/');
      $get_account_id = json_decode($get_account_id,true);
      //debug($get_account_id);
      // register web user
      if( !empty($get_account_id) ){
        for( $var=0; $var<count($get_account_id); $var++ ){
          $data = [
            "username" => $this->input->post('email'),
            "password" => $this->input->post('customer_password'),
            "customers" => [
              [ "id" => $signup_response['customerId'] ]
            ],
            "accounts" => [
              [ "id" => $get_account_id['results'][$var]['id'] ]
            ],
            "expiryDttm" => date('Y-m-d H:i:s')
          ];
          //debug(json_encode($data));
          $request_for_register_user = $this->curl->junifer_request('/rest/v1/webUsers/',$data,'post');
          $request_for_register_user = json_decode($request_for_register_user,true);
          if( !empty($request_for_register_user) )
          {

            $email_data['email_info'] = [ 'token' => $request_for_register_user['token'], 'name' => $this->input->post('fname') ];

            $template = $this->load->view( 'layout/email_template', $email_data , true);

            $this->load->library('email');
            $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
            $this->email->to('jatin@iivo.io');
            $this->email->subject('Signup Comfirmation');
            $this->email->message($template);
            $this->email->send();

            echo json_encode( [ 'error' => '0', 'token' => $request_for_register_user['token'], 'msg' => 'signup successful' ] );
          }else {
            echo json_encode( [ 'error' => '1', 'token' => null, 'msg' => 'error while signup' ] );
          }
        }
      }
    }

  } // end enroll customer

  function confirmation(){
    $this->load->view('layout/confirmation_template');
  }
}
