<?php
defined('BASEPATH') OR exit('No direct script access allowed');

Class Api extends CI_Controller{

  function __construct()
  {
    parent::__construct();
    $this->load->model('api_modal');
    if( !empty($_SERVER['HTTP_HOST'] == 'localhost') )
		{
			$this->upload_path = 'E:\server\htdocs\eversmartnew';
		}
		else
		{
			$this->upload_path = '/var/www/html/eversmartnew';
		}
  }

  function image_upload(){
      $customer_id = $this->input->post('customer_id');
      $meterIdentifier = $this->input->post('meterIdentifier');
      if(!isset($meterIdentifier) || $meterIdentifier=='' )
      {
        $this->jres->failure('meterIdentifier required');
      }
      else if( !isset($customer_id) || $customer_id=='' ){
        $this->jres->failure('customer_id required');
      }
      else if( !isset($_FILES) || $_FILES=='' ){
        $this->jres->failure('meter_image required');
      }else{
        $target_dir = $this->upload_path.'/upload/meter';
        $temp_path = $_FILES['meter_image']['tmp_name'];
        $image_name = $_FILES['meter_image']['name'];
        $new_file_name = date('Y_m_d').'_'.$image_name;
        $new_path = $target_dir.'/'.$new_file_name;
        if (move_uploaded_file($temp_path, $new_path)) {
              $row = [
                'meterIdentifier' => $meterIdentifier,
                'customer_id' => $customer_id,
                'image_path' => '/upload/meter/'.$new_file_name,
                'create_at' => date('Y-m-d H:i:s')
              ];
            $upload_meter_image = $this->api_modal->upload_meter_image($row);
            if( $upload_meter_image > 0 ){
              $this->jres->success([],'image uploaded');
            }else{
                $this->jres->failure('database error');
            }
          }else{
              $this->jres->failure('image upload fail');
          }
      }
  }

  function get_meter_image(){
    $customer_id = $this->input->post('customer_id');
    if(!isset($customer_id) || $customer_id=='' )
    {
      $this->jres->failure('customer_id required');
    }else{
      $get_list = $this->api_modal->get_customer_meter_image($customer_id);
      if( !empty($get_list) ){
        for( $m=0; $m<count($get_list); $m++ ){
          $get_list[$m]['image_path'] = base_url().$get_list[$m]['image_path'];
        }
        $this->jres->success($get_list,'image uploaded');
      }else{
        $this->jres->failure('no data available');
      }
    }

  }

}

 ?>
