package com.orbisalert.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;


import com.orbisalert.Activity.GlobalConstants;
import com.orbisalert.Model.KillSignalBeans;
import com.orbisalert.Model.KillSignalDataBeans;
import com.orbisalert.Model.UserDataBeans;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Admin on 30-08-2017.
 */

public class KillSignalAPICall {

    private static String refId;
    private static WebRequest mWebrequest;
    private static SharedPreferences preferences;
    static Call<KillSignalBeans> killResponseCall;
    static KillSignalBeans killResponse;


    public static void getKillSignal(Context context){

        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        refId = preferences.getString("REF_ID", "");
        killResponseCall = mWebrequest.apiInterface.killSignal(refId);
        getkillSignalResponse(killResponseCall);
    }

    //Kill Signal API Response
    private static void getkillSignalResponse(Call<KillSignalBeans> killResp)
    {
        //showProgressDialog(LoginScreen.this,"Login...");
        killResp.enqueue(new Callback<KillSignalBeans>()
        {
            @Override
            public void onResponse(Call<KillSignalBeans> call, Response<KillSignalBeans> response) {
                //showLog(response.body().getMessage().toString());

                if (response.isSuccessful()) {
                    killResponse = response.body();
                    String status = response.body().getStatus().toString();
                    Log.e("=======KILLSTATUS=====",status);
                    if (status.equalsIgnoreCase("1")){


                        String  message = response.body().getMessage().toString();


                            KillSignalDataBeans userdata = killResponse.getData();
                            String signalstatus = userdata.getSignal_status().toString();
                        Log.e("In condition", signalstatus);
                         SharedPreferences.Editor editor = preferences.edit();

                        editor.putString("FCMSignalStatus", signalstatus);
                            editor.commit();




                    }else
                    {
                        Log.e("In Kill Signal condition","Failed");
                    }
                }
            }
            @Override
            public void onFailure(Call<KillSignalBeans> call, Throwable t)
            {
                //dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }
}
