package com.orbisalert.net;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.PowerManager;
import android.util.Log;

import com.orbisalert.Util.LocationHandler;
import com.orbisalert.notifications.AmberWakeLock;

/**
 * Created by nancy on 15/9/17.
 */

public class AmberIntentService extends IntentService {

    Context context;
    PowerManager powerManager;
    PowerManager.WakeLock wakeLock;
    private int lastInteractionTime;
    private Boolean isScreenOff = false;
    public final static int INTERVAL = 10000;
    boolean isInForeGrnd;
    boolean mStatus = true;
    PowerManager.WakeLock wl;
    static Handler mHandler;

    public AmberIntentService() {
        super("");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        mHandler = LocationHandler.getMainLocationInstance();
        PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
       // wl = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "Screen OFF");
       // wl = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP );

         wl = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.ON_AFTER_RELEASE, "Screen OFF");
       // PowerManager.WakeLock TempWakeLock = TempPowerManager.newWakeLock(PowerManager.FULL_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP |
        try {

            if (isScreenOff || getLastInteractionTime() > INTERVAL || !isInForeGrnd) {

                Log.e("*******", ")))))))");

                wl.acquire();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }




        //startRepeatingTask();


    }


    Runnable mHandlerTask = new Runnable() {
        @Override
        public void run() {

            try {

                if (isScreenOff || getLastInteractionTime() > INTERVAL || !isInForeGrnd) {

                    Log.e("PPP", ")))))))");

                    wl.acquire();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }


            mHandler.postDelayed(mHandlerTask, 10000);

        }
    };

    void startRepeatingTask() {

        mHandlerTask.run();

    }

    void stopRepeatingTask() {

        try {
            wl.release();
            mHandler = LocationHandler.getMainLocationInstance();

            mHandler.removeCallbacks(mHandlerTask);
            LocationHandler.clearInstance();
            mHandler=null;
        } catch (Exception e) {
            e.printStackTrace();
        }


    }


    public long getLastInteractionTime() {
        return lastInteractionTime;
    }


    public long setLastInteractionTime(int lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
        return lastInteractionTime;
    }


    @Override
    public void onDestroy() {
        super.onDestroy();


       // stopRepeatingTask();

        try{
            Log.e("Wakelock", "******");
            if(wl.isHeld()){
                wl.release();
            }
            wl = null;

            mHandler.removeCallbacksAndMessages(mHandlerTask);
            mHandler.removeCallbacks(mHandlerTask);
        }
        catch (Exception e){

        }


    }

    private void stopWakeLock() {
        if (wakeLock != null) {
            wakeLock.release();
            // do something

            AmberWakeLock.release();
            Log.d("StopWakelock", "WakeLock released");
        }
    }


}