package com.orbisalert.Util;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.IBinder;
import android.provider.Settings;
import android.support.v4.app.NotificationCompat;
import android.util.Log;

import com.orbisalert.Activity.FallMoveDetectActivity;
import com.orbisalert.Activity.GlobalConstants;
import com.orbisalert.Activity.TabHostActivity;
import com.orbisalert.R;


public class MyService extends Service implements SensorEventListener {

	SensorManager sensorMgr;
	float last_x,last_y,last_z;
	float x,y,z;
	long lastUpdate;
	Context context;
	Intent callIntent;
	String spinnerSelection;
	String redalertnumber="";

	String fcmstatus="" , fcmmessage ="";
	//new code
	private float lastX, lastY, lastZ;
	private Sensor accelerometer;
	private float deltaXMax = 0;
	private float deltaYMax = 0;
	private float deltaZMax = 0;

	private float deltaX = 0;
	private float deltaY = 0;
	private float deltaZ = 0;
	int selection=0;
	Boolean serverCall=false;



	@Override
	public IBinder onBind(Intent intent)
	{
		return null;
	}

	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		//sensorMgr = (SensorManager) getSystemService(SENSOR_SERVICE);
		sensorMgr = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		if (sensorMgr.getDefaultSensor(Sensor.TYPE_ACCELEROMETER) != null) {
			// success! we have an accelerometer
			accelerometer = sensorMgr.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
			sensorMgr.registerListener(this, accelerometer, SensorManager.SENSOR_DELAY_GAME);
		}
		context=MyService.this;
		SharedPreferences preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
		fcmstatus = preferences.getString("FCMSignalStatus","");
		fcmmessage = preferences.getString("FCMSignalmessage","");
		try {
			spinnerSelection = String.valueOf(preferences.getInt("spinnerSelection", 0));

			redalertnumber = preferences.getString("redalertnumber", "");
		}catch(Exception e){
			e.printStackTrace();
		}
		return START_STICKY;
	}


	@Override
	public void onDestroy(){
		super.onDestroy();
		//Toast.makeText(this, "fallDetect Servive stoped", Toast.LENGTH_LONG).show();
		sensorMgr.unregisterListener(this);
	}



	private void showNotification(String message, boolean sensorStatus) {
		final NotificationManager mgr = (NotificationManager) this
				.getSystemService(Context.NOTIFICATION_SERVICE);
		NotificationCompat.Builder note = new NotificationCompat.Builder(this);
		note.setContentTitle("Device Fall Detected Notification");
		///note.setContentText(message);

		note.setAutoCancel(true);
		// to set default sound/light/vibrate or all
		note.setDefaults(Notification.DEFAULT_ALL);
		// Icon to be set on Notification
		note.setSmallIcon(R.drawable.app_icon);

		//API call
		if (sensorStatus=true) {
			sensorStatus=false;
			ServiceCall.sendSignal(MyService.this);

		}else{
			sensorStatus= false;
		}
		// This pending intent will open after notification click
		PendingIntent pi = PendingIntent.getActivity(this, 0, new Intent(this,
				TabHostActivity.class), 0);
		// set pending intent to notification builder
		note.setContentIntent(pi);
		mgr.notify(101, note.build());
	}

	@Override
	public void onSensorChanged(SensorEvent event) {
		//saved
		//if ((System.currentTimeMillis() - lastSaved) > ACCE_FILTER_DATA_MIN_TIME) {
			//lastSaved = System.currentTimeMillis();
		//static int ACCE_FILTER_DATA_MIN_TIME = 1000; // 1000ms
		//long lastSaved = System.currentTimeMillis();

		long curTime = System.currentTimeMillis();
		//lastUpdate= System.currentTimeMillis();
		//if (curTime- 600 > lastUpdate){

		if ((curTime - lastUpdate) > 1000) {
			long diffTime = (curTime - lastUpdate);
			lastUpdate = System.currentTimeMillis();
			// get the change of the x,y,z values of the accelerometer
			deltaX = Math.abs(lastX - event.values[0]);
			deltaY = Math.abs(lastY - event.values[1]);
			deltaZ = Math.abs(lastZ - event.values[2]);
			selection = Integer.parseInt(spinnerSelection) + 1;


			if (selection == 1) {
				Log.e("Spinner Selection", String.valueOf(selection));
				selection = 27;
				if (deltaY>= selection || deltaX >= selection || deltaZ >= selection) {

					callIntent = new Intent(Intent.ACTION_CALL);
					callIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
					callIntent.setData(Uri.parse("tel:01513432846"));
					startActivity(callIntent);

					showNotification(String.valueOf(selection),true);



				}

			} else if (selection == 2) {
				Log.e("Spinner Selection", String.valueOf(selection));
				selection = 22;
				if (deltaY>= selection || deltaX >= selection || deltaZ >= selection) {

					callIntent = new Intent(Intent.ACTION_CALL);
					callIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
					callIntent.setData(Uri.parse("tel:01513432846"));
					startActivity(callIntent);

					showNotification(String.valueOf(selection),true);



				}
			}
			else if (selection == 3) {
				Log.e("Spinner Selection", String.valueOf(selection));

				selection = 22;//22
				if (deltaY >= selection || deltaX>= selection || deltaZ >= selection) {

					callIntent = new Intent(Intent.ACTION_CALL);
					callIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
					callIntent.setData(Uri.parse("tel:01513432846"));
					startActivity(callIntent);

					showNotification(String.valueOf(selection),true);



				}

			}
			else if (selection == 4) {
				Log.e("Spinner Selection", String.valueOf(selection));

				selection = 20;

				if (deltaY >= selection || deltaX >= selection || deltaZ >= selection) {

					callIntent = new Intent(Intent.ACTION_CALL);
					callIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
					callIntent.setData(Uri.parse("tel:01513432846"));
					startActivity(callIntent);

					showNotification(String.valueOf(selection),true);


				}

			}
			else if (selection == 5) {
				Log.e("Spinner Selection", String.valueOf(selection));
				selection = 18;

				if (deltaY >= selection || deltaX >= selection || deltaZ >= selection) {


						callIntent = new Intent(Intent.ACTION_CALL);
						callIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
						callIntent.setData(Uri.parse("tel:01513432846"));
						startActivity(callIntent);
						showNotification(String.valueOf(selection), true);


				}
			}
			else {
				Log.e("Nothing Called","++++++++");
			}


			// if the change is below 2, it is just plain noise
			if (deltaX < 2)
				deltaX = 0;
			if (deltaY < 2)
				deltaY = 0;
			if (deltaZ < 2)
				deltaZ = 0;


			// set the last know values of x,y,z
			lastX = event.values[0];
			lastY = event.values[1];
			lastZ = event.values[2];
		}

	}

	@Override
	public void onAccuracyChanged(Sensor sensor, int accuracy) {

	}
}
