package com.orbisalert.Activity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import com.orbisalert.R;
import com.orbisalert.Util.Utility;

import java.util.Set;


public class EscalationScreen extends OrbisActivity implements View.OnClickListener {
    TextView contact_name1, contact_name2, contact_name3;
    ImageView iv_back;
    EditText contact1, contact2, contact3;
    String name1 = "", phone_number1 = "", name2 = "", phone_number2 = "", name3 = "", phone_number3 = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_esclation_screen);
        Utility.status_bar_color_change(this);
        intialize_ID();
    }

    private void intialize_ID() {

        contact_name1 = (TextView) findViewById(R.id.tv_contact_name);
        contact1 = (EditText) findViewById(R.id.et_contact_name);
        contact_name2 = (TextView) findViewById(R.id.tv_contact_name2);
        contact2 = (EditText) findViewById(R.id.et_contact_name2);
        contact_name3 = (TextView) findViewById(R.id.tv_contact_name3);
        contact3 = (EditText) findViewById(R.id.et_contact_name3);

        try {
            name1 = preferences.getString("name1", "");
            phone_number1 = preferences.getString("phone_number1", "");
            name2 = preferences.getString("name2", "");
            phone_number2 = preferences.getString("phone_number2", "");
            name3 = preferences.getString("name3", "");
            phone_number3 = preferences.getString("phone_number3", "");

            /**
             * Set Server data
             */
            contact_name1.setText(name1);
            contact1.setText(phone_number1);
            contact_name2.setText(name2);
            contact2.setText(phone_number2);
            contact_name3.setText(name3);
            contact3.setText(phone_number3);

        } catch (Exception e) {
            e.printStackTrace();
        }

        iv_back = (ImageView) findViewById(R.id.iv_back);
        iv_back.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_back:
                Intent intent = new Intent(EscalationScreen.this, SettingScreen.class);
                startActivity(intent);
                finish();
                break;
            default:
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();

    }
}
