package com.orbis.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.SettingBeans;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by admin on 24/8/17.
 */

public class SettingsAPICall {

    private static String refId;
    private static WebRequest mWebrequest;
    private static SharedPreferences preferences;
    static Call<SettingBeans> settingResponseCall;
    static SettingBeans settingResponse;


    public static void getSettings(Context context) {

        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        refId = preferences.getString("REF_ID", "");
        settingResponseCall = mWebrequest.apiInterface.setting(refId);
        getsettingResponse(settingResponseCall);
    }


    //Setting API Response
    private static void getsettingResponse(Call<SettingBeans> settingResp) {
        //showProgressDialog(LoginScreen.this,"Login...");
        settingResp.enqueue(new Callback<SettingBeans>() {
            @Override
            public void onResponse(Call<SettingBeans> call, Response<SettingBeans> response) {
                //showLog(response.body().getMessage().toString());

                if (response.isSuccessful()) {
                    settingResponse = response.body();
                    String status = response.body().getStatus().toString();
                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In Setting condition", "Success");

                        try {

                            String message = response.body().getMessage().toString();
                            String falldetcetenabled = response.body().getData().getFalldetectenabled().toString();
                            String falldetectedsensitivity = response.body().getData().getFalldetectedsensitivity().toString();


                            SharedPreferences.Editor editor = preferences.edit();
                            editor.putString("id", response.body().getData().getId().toString());
                            editor.putString("redalertnumber", response.body().getData().getRedalertnumber());
                            editor.putString("amberalertnumber", response.body().getData().getAmberalertnumber());
                            editor.putString("ipaddress", response.body().getData().getIpaddress());
                            editor.putString("port", response.body().getData().getPort());
                            editor.putString("redalertsmsnumber", response.body().getData().getRedalertsmsnumber());
                            editor.putString("silentdial", response.body().getData().getSilentdial());
                            editor.putString("positionupdateinterval", response.body().getData().getPositionupdateinterval());
                            editor.putString("falldetectenabled", response.body().getData().getFalldetectenabled());
                            editor.putString("limitamber", response.body().getData().getLimitamber());
                            editor.putString("fixedambertime", response.body().getData().getFixedambertime());
                            editor.putString("allow_user", response.body().getData().getAllow_user());
                            editor.putString("falldetectedsensitivity", response.body().getData().getFalldetectedsensitivity());
                            editor.putString("create_date", response.body().getData().getCreate_date());
                            editor.commit();

                            if (falldetcetenabled.equalsIgnoreCase("1")) {
                                //on
                                SharedPreferences.Editor editorr = preferences.edit();
                                editorr.putString("FallDetection", "Activated");
                                editorr.putString("fallDetected", "1");
                                editorr.commit();
                            } else {
                                SharedPreferences.Editor editorr = preferences.edit();
                                editorr.putString("FallDetection", "Deactivated");
                                editorr.putString("fallDetected", "0");
                                editorr.commit();
                            }


                        } catch (Exception e) {
                            e.printStackTrace();
                        }


                    } else {
                        Log.e("In Setting condition", "Failed");

                    }
                }
            }

            @Override
            public void onFailure(Call<SettingBeans> call, Throwable t) {
                //dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }
}
