package com.orbis.Util;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.PowerManager;
import android.util.Log;

/**
 * Created by nancy on 2/9/17.
 */

public class ScreenSaverService extends Service {

    private int lastInteractionTime;
    private Boolean isScreenOff = false;
    public final static int INTERVAL = 40000;
    boolean isAmberInForeGrnd;
    private static PowerManager.WakeLock wakeLock;

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        // amberrelease();
        stopWakeLock();
        Log.e("RUNNING TIMER", "++++++++++=");

    }


    @Override
    public void onStart(Intent intent, int startid) {

        startUserInactivityDetectThread();
    }

    public void onStop(Intent intent) {
        stopWakeLock();
    }

    public void startUserInactivityDetectThread() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(15000); //15000 checks every 15sec for inactivity

                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }

                    if (isScreenOff || getLastInteractionTime() > INTERVAL || !isAmberInForeGrnd) {

                        try {
                            amberacquire(getApplicationContext());
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                }
            }
        }).start();
    }

    public long getLastInteractionTime() {
        return lastInteractionTime;
    }


    public long setLastInteractionTime(int lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
        return lastInteractionTime;
    }


    public void amberacquire(Context context) {
        if (wakeLock != null) {
            try {
                wakeLock.release();

                PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
                wakeLock = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK |
                        PowerManager.ACQUIRE_CAUSES_WAKEUP |
                        PowerManager.ON_AFTER_RELEASE, "WakeLock");
             //   wakeLock.acquire();
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {

        }

        Log.e("Timer WAKEUP LOCKER ", ">>>>");
    }

    private void stopWakeLock() {
        if (wakeLock != null) {
            wakeLock.release();
            Log.d("===", "WakeLock released");
        }
    }

    public static void amberrelease() {
        if (wakeLock != null) wakeLock.release();
        wakeLock = null;
    }


}