package com.orbis.Util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;
import com.orbis.Activity.RedAlertActivate;


public class SOSBroadcastReceiver extends BroadcastReceiver {

    private static long lastTriggerTime = 0;
    private static final int ONE_MILLI = 1000;
    protected static final long ONE_SEC = 1 * ONE_MILLI;
    protected static final long TWO_SEC = 2 * ONE_MILLI;
    protected static final long THREE_SEC = 3 * ONE_MILLI;
    protected static final int TRIGGER_THRESHOLD = 5;

    protected static boolean triggerInProgress = false;

    protected static int triggerCounter = 0;
    SharedPreferences preferences;
    int detectstatus;
    int count1 = 0;
    int screen = 0;
    int timeer=2000;

    @Override
    public void onReceive(Context context, Intent intent) {


        try {
            preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
            detectstatus = Integer.parseInt(preferences.getString("pressdetectedlevel", ""));
            if (detectstatus == 0) {
                count1 = 3;
            } else {
                count1 = 5;
            }
            Log.e("detectstatus**********", String.valueOf(detectstatus));
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (intent.getAction().contains(Intent.ACTION_SCREEN_ON)) {

                if (!triggerInProgress) {
                    Log.e("ACTION_SCREEN_ON", "ACTION_SCREEN_ON");
                    checkAndCreateAlert(context);
                    screen = 1;
                }


        } else if (intent.getAction().contains(Intent.ACTION_SCREEN_OFF)) {

                if (!triggerInProgress) {
                    Log.e("ACTION_SCREEN_OFF", "ACTION_SCREEN_OFF");
                    checkAndCreateAlert(context);
                    screen = 2;
                }

        }
    }

    private void checkAndCreateAlert(Context context) {
        long time = System.currentTimeMillis();
        //if it is the first time, or if it has been more than 3 seconds since the first tap ( so it is like a new try), we reset everything
        Log.e("checkAndCreateAlert", "" + (time - lastTriggerTime));
        Log.e("time", "" + time);
        if (lastTriggerTime == 0 || (time - lastTriggerTime >= timeer)) {
            lastTriggerTime = time;
            triggerCounter = 0;
        } else {
            triggerCounter++;
            Log.e("trigger count", String.valueOf(triggerCounter));
        }
        if (triggerCounter == count1) {
            String receivedstate = preferences.getString("receivedstate", "");
            if (receivedstate.equalsIgnoreCase("1")) {
                Log.e("IF RECIVERRRR ", "Recieved Status******");
            } else {
                triggerInProgress = true;
                SharedPreferences preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
                SharedPreferences.Editor editorr = preferences.edit();
                editorr.putString("redalert", "2");
                editorr.putString("Triggerfrom", "SOS");
                editorr.commit();
                Intent intent = new Intent(context, RedAlertActivate.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.putExtra("timer", true);
                context.startActivity(intent);
                triggerInProgress = false;
                triggerCounter = 0;
            }


        }

    }
}