package com.orbis.Activity;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.orbis.Model.EscalationDetailDataBeans;
import com.orbis.Model.escalation.EscalationMain;
import com.orbis.R;
import com.orbis.Util.Utility;
import com.orbis.net.WebRequest;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class EscalationEditActivity extends OrbisActivity implements View.OnClickListener, View.OnFocusChangeListener {

    TextView tvInstruction, tv_cancel;
    EditText et_PhoneNo, et_officeNo, et_Name, et_homeNo, et_EmailAddress, et_Description, et_Others, et_Pager;
    String name, officeNo, phoneNo, homeNo, emailAddress, description, pager, others;
    ImageView iv_back;
    String get;
    int position;
    EscalationDetailDataBeans getData;
    boolean change = false;
    boolean edit = false;
    FrameLayout llButtons;
    Button btnSave, btnReset;
    ArrayList<EscalationDetailDataBeans> dataList;
    int focuse = 0;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_escalation_edit);
        intialize_ID();
        Utility.status_bar_color_change(this);
        try {
            if (getIntent().hasExtra("pos")) {
                focuse = 0;
                edit = true;
                get = getIntent().getExtras().getString("dashescalation");
                getData = (EscalationDetailDataBeans) getIntent().getExtras().get("data");
                position = getIntent().getExtras().getInt("pos");
                Log.e("*******NEGET", get);
                et_Name.setText(getData.getFULLNAME().replace("<strong>", "").replace("</strong>", ""));
                et_PhoneNo.setText(getData.getMOBILE().replace("<strong>", "").replace("</strong>", ""));
                et_officeNo.setText(getData.getBUSINESSTELEPHONE().replace("<strong>", "").replace("</strong>", ""));
                et_homeNo.setText(getData.getHOMETELEPHONE().replace("<strong>", "").replace("</strong>", ""));
                et_EmailAddress.setText(getData.getEMAIL().replace("<strong>", "").replace("</strong>", ""));
                et_Name.clearFocus();
                et_PhoneNo.clearFocus();
                et_officeNo.clearFocus();
                et_homeNo.clearFocus();
                et_EmailAddress.clearFocus();
                et_Name.setOnClickListener(this);
                et_Name.setOnFocusChangeListener(this);
                et_PhoneNo.setOnFocusChangeListener(this);
                et_officeNo.setOnFocusChangeListener(this);
                et_homeNo.setOnFocusChangeListener(this);
                et_EmailAddress.setOnFocusChangeListener(this);
            } else {
                dataList = new ArrayList<>();
                Intent intent = getIntent();
                Bundle args = intent.getBundleExtra("BUNDLE");
                dataList = (ArrayList<EscalationDetailDataBeans>) args.getSerializable("ARRAYLIST");
                get = getIntent().getExtras().getString("dashescalation");
                getData = new EscalationDetailDataBeans();
                llButtons.setVisibility(View.VISIBLE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEmailValid(String email) {
        boolean isValid = false;

        String expression = "^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$";
        CharSequence inputStr = email;

        Pattern pattern = Pattern.compile(expression, Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(inputStr);
        if (matcher.matches()) {
            isValid = true;
        }
        return isValid;
    }

    private void intialize_ID() {
        tvInstruction = (TextView) findViewById(R.id.tvInstruction);
        tv_cancel = (TextView) findViewById(R.id.tv_cancel);
        et_Name = (EditText) findViewById(R.id.et_Name);
        et_PhoneNo = (EditText) findViewById(R.id.et_PhoneNo);
        et_officeNo = (EditText) findViewById(R.id.et_officeNo);
        et_homeNo = (EditText) findViewById(R.id.et_homeNo);
        et_EmailAddress = (EditText) findViewById(R.id.et_EmailAddress);
        et_Description = (EditText) findViewById(R.id.et_Description);
        et_Others = (EditText) findViewById(R.id.et_Others);
        et_Pager = (EditText) findViewById(R.id.et_Pager);
        iv_back = (ImageView) findViewById(R.id.iv_back);
        llButtons = (FrameLayout) findViewById(R.id.llButtons);
        btnSave = (Button) findViewById(R.id.btnSave);
        btnReset = (Button) findViewById(R.id.btnReset);
        iv_back.setOnClickListener(this);
        btnSave.setOnClickListener(this);
        btnReset.setOnClickListener(this);
        tv_cancel.setOnClickListener(this);
    }

    @Override
    public void onBackPressed() {

        if (edit) {
            name = et_Name.getText().toString();
            officeNo = et_officeNo.getText().toString();
            phoneNo = et_PhoneNo.getText().toString();
            homeNo = et_homeNo.getText().toString();
            emailAddress = et_EmailAddress.getText().toString();
            description = et_Description.getText().toString();
            others = et_Others.getText().toString();
            pager = et_Pager.getText().toString();

            if (!emailAddress.equals("")) {
                if (!isEmailValid(emailAddress)) {
                    Utility.alertDialog(EscalationEditActivity.this, "Email is Invalid.");
                    return;
                }
            }
            if (name.equals("")) {
                Utility.alertDialog(EscalationEditActivity.this, "Name is mandatory.");

            } else if (phoneNo.equals("")) {
                Utility.alertDialog(EscalationEditActivity.this, "Mobile number is mandatory.");
            } else if (phoneNo.length() < 10) {
                Utility.alertDialog(EscalationEditActivity.this, "Mobile number not valid.");
            } else {

                Intent intent = new Intent();

                if (!name.equals(getData.getFULLNAME())) {
                    change = true;
                    getData.setFULLNAME("<strong>" + name + "</strong>");
                }
                if (!emailAddress.equals(getData.getEMAIL())) {
                    change = true;
                    getData.setEMAIL("<strong>" + emailAddress + "</strong>");
                }
                if (!phoneNo.equals(getData.getMOBILE())) {
                    change = true;
                    getData.setMOBILE("<strong>" + phoneNo + "</strong>");
                }
                if (!officeNo.equals(getData.getBUSINESSTELEPHONE())) {
                    change = true;
                    getData.setBUSINESSTELEPHONE("<strong>" + officeNo + "</strong>");
                }
                if (!homeNo.equals(getData.getHOMETELEPHONE())) {
                    change = true;
                    getData.setHOMETELEPHONE("<strong>" + homeNo + "</strong>");
                }
                intent.putExtra("pos", position);
                intent.putExtra("change", change);
                intent.putExtra("data", getData);
                setResult(200, intent);
                finish();
            }
        } else {
            getData.setFULLNAME(name);
            getData.setEMAIL(emailAddress);
            getData.setMOBILE(phoneNo);
            getData.setBUSINESSTELEPHONE(officeNo);
            getData.setHOMETELEPHONE(homeNo);
            Intent intent1 = new Intent(EscalationEditActivity.this, EscalationScreen.class);
            intent1.putExtra("edit", "1");
            if (get.equalsIgnoreCase("1")) {
                intent1.putExtra("dashescalation", "1");
            } else {
                intent1.putExtra("dashescalation", "0");
            }
            startActivity(intent1);
            finish();
        }


    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.tv_cancel:
                AlertDialog.Builder builder;
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    builder = new AlertDialog.Builder(EscalationEditActivity.this, android.R.style.Theme_Material_Dialog_Alert);
                } else {
                    builder = new AlertDialog.Builder(EscalationEditActivity.this);
                }
                builder.setTitle("Orbis")
                        .setMessage("Your updates will not be saved. So you wish to continue?")
                        .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int which) {
                                // continue with delete
                                Intent intent = new Intent();
                                setResult(RESULT_CANCELED, intent);
                                finish();
                            }
                        }).setNegativeButton("No", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                    }
                })
                        .setIcon(android.R.drawable.ic_dialog_alert)
                        .show();

                break;
            case R.id.et_Name:
                tvInstruction.setVisibility(View.VISIBLE);
                break;
            case R.id.btnSave:
                name = et_Name.getText().toString();
                officeNo = et_officeNo.getText().toString();
                phoneNo = et_PhoneNo.getText().toString();
                homeNo = et_homeNo.getText().toString();
                emailAddress = et_EmailAddress.getText().toString();
                description = et_Description.getText().toString();
                others = et_Others.getText().toString();
                pager = et_Pager.getText().toString();
                if (!emailAddress.equals("")) {
                    if (!isEmailValid(emailAddress)) {
                        Utility.alertDialog(EscalationEditActivity.this, "Email is Invalid.");
                        return;
                    }
                }
                if (name.equals("")) {
                    Utility.alertDialog(EscalationEditActivity.this, "Name is mandatory.");
                } else if (phoneNo.equals("")) {
                    Utility.alertDialog(EscalationEditActivity.this, "Mobile number is mandatory.");
                } else if (phoneNo.length() < 10) {
                    Utility.alertDialog(EscalationEditActivity.this, "Mobile number not valid.");
                } else {
                    getData.setFULLNAME(name);
                    getData.setEMAIL(emailAddress);
                    getData.setMOBILE(phoneNo);
                    getData.setBUSINESSTELEPHONE(officeNo);
                    getData.setHOMETELEPHONE(homeNo);
                    dataList.add(getData);
                    WebRequest mWebrequest;
                    mWebrequest = WebRequest.getSingleton(EscalationEditActivity.this);
                    JsonArray array = new JsonArray();
                    JsonObject object = null;
                    for (int i = 0; i < dataList.size(); i++) {
                        int j = 0;
                        j = i;
                        object = new JsonObject();
                        object.addProperty("FULLNAME", dataList.get(i).getFULLNAME());
                        object.addProperty("EMAIL", dataList.get(i).getEMAIL());
                        object.addProperty("MOBILE", dataList.get(i).getMOBILE());
                        object.addProperty("BUSINESSTELEPHONE", dataList.get(i).getBUSINESSTELEPHONE());
                        object.addProperty("HOMETELEPHONE", dataList.get(i).getHOMETELEPHONE());
                        object.addProperty("SITEINDEX", dataList.get(i).getSITEINDEX());
                        object.addProperty("PRIORITY", "" + ++j);
                        array.add(object);
                    }

                    String name = "" + array;
                    Call<EscalationMain> esclationResponseCall = mWebrequest.apiInterface.escalationMail(name, "New Escalation Detail Added.");
                    showProgressDialog(EscalationEditActivity.this, "Processing...");
                    esclationResponseCall.enqueue(new Callback<EscalationMain>() {
                        @Override
                        public void onResponse(Call<EscalationMain> call, Response<EscalationMain> response) {
                            dismissProgressDialog();
                            if (response.isSuccessful()) {
                                AlertDialog.Builder builder;
                                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                                    builder = new AlertDialog.Builder(EscalationEditActivity.this, android.R.style.Theme_Material_Dialog_Alert);
                                } else {
                                    builder = new AlertDialog.Builder(EscalationEditActivity.this);
                                }
                                builder.setTitle("Orbis")
                                        .setMessage("Escalation details updated successfully! Escalation Details updates take up to 24 hours to be completed.")
                                        .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
                                            public void onClick(DialogInterface dialog, int which) {
                                                // continue with delete
                                                dialog.dismiss();
                                                if (get.equalsIgnoreCase("1")) {
                                                    Intent intent1 = new Intent(EscalationEditActivity.this, EscalationScreen.class);
                                                    intent1.putExtra("dashescalation", "1");
                                                    startActivity(intent1);
                                                    finish();
                                                } else {
                                                    Intent intent1 = new Intent(EscalationEditActivity.this, EscalationScreen.class);
                                                    intent1.putExtra("dashescalation", "0");
                                                    startActivity(intent1);
                                                    finish();
                                                }
                                            }
                                        })
                                        .setIcon(android.R.drawable.ic_dialog_alert)
                                        .show();

                                dismissProgressDialog();
                            }
                        }

                        @Override
                        public void onFailure(Call<EscalationMain> call, Throwable t) {
                            dismissProgressDialog();
                            t.printStackTrace();
                            Log.e("ERROE***", t.getMessage());
                        }
                    });
                }
                break;
            case R.id.iv_back:
                onBackPressed();
                break;
            case R.id.btnReset:
                et_Name.setText("");
                et_officeNo.setText("");
                et_PhoneNo.setText("");
                et_homeNo.setText("");
                et_EmailAddress.setText("");
                et_Description.setText("");
                et_Others.setText("");
                et_Pager.setText("");
                break;
        }
    }

    @Override
    public void onFocusChange(View view, boolean b) {
        if (focuse == 1) {
            if (b) {
                tvInstruction.setVisibility(View.VISIBLE);
            }
            focuse = 1;
        } else {
            focuse = 1;
        }
    }
}
